/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.sortmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.calx.algox.sortmodel.Graph;
import kd.fi.calx.algox.sortmodel.Node;

public class GraphNodeManager<K> {
    private Map<K, Node<K>> nodeMap = new HashMap<K, Node<K>>();

    public Map<K, Node<K>> getNodeMap() {
        return this.nodeMap;
    }

    public boolean addVector(K beforeK, K afterK) {
        if (beforeK.equals(afterK)) {
            return true;
        }
        Node<K> beforeNode = this.getNode(beforeK);
        Node<K> afterNode = this.getNode(afterK);
        return beforeNode.appendNext(afterNode);
    }

    private Node<K> getNode(K k) {
        return this.nodeMap.computeIfAbsent(k, a -> new Node<Object>(a));
    }

    public Map<Integer, List<K>> groupSort() {
        ArrayList<Node<K>> nodeList = new ArrayList<Node<K>>(this.nodeMap.values());
        HashMap<Integer, List<Integer>> listMap = new HashMap<Integer, List<Integer>>(1024);
        int groupNo = 1;
        while (nodeList.size() > 0) {
            Node node = (Node)nodeList.get(0);
            Set<Node<K>> nodeSet = this.roundNodeAndSplitGraph(node);
            Graph<K> graph = new Graph<K>(nodeSet);
            List<K> list = graph.sort();
            listMap.put(groupNo, list);
            nodeList.removeAll(nodeSet);
            ++groupNo;
        }
        return listMap;
    }

    public List<K> linearSort2List() {
        ArrayList<Node<K>> nodeList = new ArrayList<Node<K>>(this.nodeMap.values());
        ArrayList<K> list = new ArrayList<K>();
        while (nodeList.size() > 0) {
            Node node = (Node)nodeList.get(0);
            Set<Node<K>> nodeSet = this.roundNodeAndSplitGraph(node);
            Graph<K> graph = new Graph<K>(nodeSet);
            list.addAll(graph.sort());
            nodeList.removeAll(nodeSet);
        }
        return list;
    }

    public Map<K, Integer> linearSort2Map() {
        ArrayList<Node<K>> nodeList = new ArrayList<Node<K>>(this.nodeMap.values());
        ArrayList<K> list = new ArrayList<K>(256);
        while (nodeList.size() > 0) {
            Node node = (Node)nodeList.get(0);
            Set<Node<K>> nodeSet = this.roundNodeAndSplitGraph(node);
            Graph<K> graph = new Graph<K>(nodeSet);
            list.addAll(graph.sort());
            nodeList.removeAll(nodeSet);
        }
        HashMap map = new HashMap(list.size());
        for (int i = 0; i < list.size(); ++i) {
            map.put(list.get(i), i + 1);
        }
        return map;
    }

    public Set<Node<K>> roundNodeAndSplitGraph(Node<K> node) {
        HashSet<Node<K>> nodeSet = new HashSet<Node<K>>();
        this.roundNode(node, nodeSet);
        return nodeSet;
    }

    public void roundNode(Node<K> node, Set<Node<K>> nodeSet) {
        if (nodeSet.contains(node)) {
            return;
        }
        nodeSet.add(node);
        for (Node<K> newNode : node.getAllConnectedNodes()) {
            if (newNode.equals(node)) continue;
            this.roundNode(newNode, nodeSet);
        }
    }

    public boolean isEmpty() {
        return this.nodeMap.isEmpty();
    }

    public static void main(String[] args) {
        GraphNodeManager<String> graphM = new GraphNodeManager<String>();
        graphM.addVector("779583408610242560_01", "779583408643798016_01");
        graphM.addVector("779583408610242560_01", "779583408836736000_01");
        graphM.addVector("779583408610242560_20191231", "779583408836736000_20191231");
        graphM.addVector("779583408836736000_01", "779583408836736000_20191231");
        graphM.addVector("779583408836736000_20200101JBBF", "779583408836736000_20191231");
        graphM.addVector("779583408610242560_20200101JBBF", "779583408836736000_20200101JBBF");
        graphM.addVector("779583408610242560_20200201JBBF", "779583408836736000_20200201JBBF");
        graphM.addVector("779583408836736000_01", "779583408836736000_20200201JBBF");
        graphM.addVector("779583408836736000_01", "833102316792993792_01");
        graphM.groupSort();
    }
}

