/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.log.api.AppLogInfo;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;

public class CalLogUtils {
    public static void addBatchLog(List<CalLogInfo> logInfos) {
        LogServiceHelper.addBatchLog(CalLogUtils.convertLogs(logInfos));
    }

    public static void addLog(CalLogInfo logInfo) {
        LogServiceHelper.addLog((AppLogInfo)CalLogUtils.convertLog(logInfo));
    }

    private static List<AppLogInfo> convertLogs(List<CalLogInfo> logInfos) {
        ArrayList<AppLogInfo> list = new ArrayList<AppLogInfo>(128);
        for (CalLogInfo info : logInfos) {
            list.add(CalLogUtils.convertLog(info));
        }
        return list;
    }

    private static AppLogInfo convertLog(CalLogInfo logInfo) {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID(logInfo.getBizAppID());
        appLogInfo.setBizObjID(logInfo.getBizObjID());
        appLogInfo.setOpDescription(logInfo.getOpDescription());
        appLogInfo.setOpName(logInfo.getOpName());
        appLogInfo.setOpTime(logInfo.getOpTime());
        appLogInfo.setOrgID(logInfo.getOrgID());
        appLogInfo.setUserID(logInfo.getUserID());
        appLogInfo.setClientIP(logInfo.getClientIP());
        appLogInfo.setClientName(logInfo.getClientName());
        appLogInfo.setClientType(logInfo.getClientType());
        return appLogInfo;
    }

    public static CalLogInfo buildCalAppLog(boolean isError, String bizEntityNumber, String OpName, long orgId) {
        CalLogInfo logInfo = new CalLogInfo();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        logInfo.setBizAppID("/KIUHEXROK3D");
        logInfo.setBizObjID(bizEntityNumber);
        logInfo.setOpName(OpName);
        logInfo.setOpDescription(ResManager.loadKDString((String)"\u6210\u529f", (String)"CalLogUtils_0", (String)"fi-cal-common", (Object[])new Object[0]));
        if (isError) {
            logInfo.setOpDescription(ResManager.loadKDString((String)"\u5931\u8d25", (String)"CalLogUtils_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setUserID(userId);
        logInfo.setOrgID(orgId);
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        return logInfo;
    }

    public static CalLogInfo buildCalAppLog(String bizEntityNumber, String OpName, String description, long orgId) {
        CalLogInfo logInfo = new CalLogInfo();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        logInfo.setBizAppID("/KIUHEXROK3D");
        logInfo.setBizObjID(bizEntityNumber);
        logInfo.setOpName(OpName);
        logInfo.setOpDescription(description);
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setUserID(userId);
        logInfo.setOrgID(orgId);
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        return logInfo;
    }

    public static class CalLogInfo
    implements Serializable {
        private static final long serialVersionUID = 6500534269834623634L;
        private Long userID;
        private String bizAppID;
        private String bizObjID;
        private Long orgID;
        private Date opTime;
        private String clientType;
        private String clientIP;
        private String clientName;
        private String opName;
        private String opDescription;

        public Long getUserID() {
            return this.userID;
        }

        public void setUserID(Long userID) {
            this.userID = userID;
        }

        public String getBizAppID() {
            return this.bizAppID;
        }

        public void setBizAppID(String bizAppID) {
            this.bizAppID = bizAppID;
        }

        public String getBizObjID() {
            return this.bizObjID;
        }

        public void setBizObjID(String bizObjID) {
            this.bizObjID = bizObjID;
        }

        public Long getOrgID() {
            return this.orgID;
        }

        public void setOrgID(Long orgID) {
            this.orgID = orgID;
        }

        public Date getOpTime() {
            return this.opTime;
        }

        public void setOpTime(Date opTime) {
            this.opTime = opTime;
        }

        public String getClientType() {
            return this.clientType;
        }

        public void setClientType(String clientType) {
            this.clientType = clientType;
        }

        public String getClientIP() {
            return this.clientIP;
        }

        public void setClientIP(String clientIP) {
            this.clientIP = clientIP;
        }

        public String getClientName() {
            return this.clientName;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public String getOpName() {
            return this.opName;
        }

        public void setOpName(String opName) {
            this.opName = opName;
        }

        public String getOpDescription() {
            return this.opDescription;
        }

        public void setOpDescription(String opDescription) {
            this.opDescription = opDescription;
        }
    }
}

