/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;

public class CommonUtils {
    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String createEXPBillNo(int seqno) {
        return "EXP-" + String.valueOf(System.currentTimeMillis()).substring(2) + seqno;
    }

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).size() == 0) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).size() == 0) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    public static String getCodeErrorMessage(ErrorCode errorCode) {
        KDException kde = new KDException(errorCode, new Object[0]);
        return kde.getMessage();
    }

    public static String getCodeErrorMessage(ErrorCode errorCode, Object ... args) {
        KDException kde = new KDException(errorCode, args);
        return kde.getMessage();
    }

    public static String serializerDynamicObjectList(List<DynamicObject> list, IDataEntityType dt) {
        if (CommonUtils.isNull(list)) {
            return null;
        }
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        String[] ss = DataEntitySerializer.serializerToListString((IDataEntityType)dt, list, (DataEntitySerializerOption)option);
        return SerializationUtils.toJsonString((Object)ss);
    }

    public static List<DynamicObject> deserializerDynamicObjectList(List<DynamicObject> list, IDataEntityType dt, String s) {
        String[] ss = (String[])SerializationUtils.fromJsonString((String)s, String[].class);
        DataEntitySerializer.deserializerFromListString(list, (IDataEntityType)dt, (String[])ss);
        return list;
    }

    public static List<Long> getIdList(DynamicObjectCollection colls) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject obj : colls) {
            idList.add(obj.getLong("id"));
        }
        return idList;
    }

    public static DBRoute getCalDBRouteKey() {
        return new DBRoute("cal");
    }

    public static boolean isSetEqual(Set set1, Set set2) {
        if (set1 == null && set2 == null) {
            return true;
        }
        if (set1 == null || set2 == null || set1.size() != set2.size() || set1.size() == 0 || set2.size() == 0) {
            return false;
        }
        Iterator ite2 = set2.iterator();
        boolean isFullEqual = true;
        while (ite2.hasNext()) {
            if (set1.contains(ite2.next())) continue;
            isFullEqual = false;
        }
        return isFullEqual;
    }

    public static String trimComma(String dividebasis) {
        if (dividebasis.startsWith(",")) {
            dividebasis = dividebasis.substring(1, dividebasis.length());
        }
        if (dividebasis.endsWith(",")) {
            dividebasis = dividebasis.substring(0, dividebasis.length() - 1);
        }
        return dividebasis;
    }

    public static String getLogMessage(Throwable e) {
        String message = "";
        if (e instanceof KDBizException) {
            message = !StringUtils.isEmpty((String)e.getMessage()) ? e.getMessage() : ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)e));
        }
        if (StringUtils.isEmpty((String)message)) {
            message = ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e));
        }
        return message;
    }

    public static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(String.format("getSHA256Base64Str:[%s] args:[%s]", e.getMessage(), message));
        }
    }

    public static String getFieldPath(String entity, String field) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        IDataEntityProperty property = entityType.findProperty(field);
        if (property == null) {
            String msg = ResManager.loadKDString((String)"\u201c%1$s(%2$s)\u201d\u672a\u6269\u5c55\u201c%3$s\u201d\u5b57\u6bb5\uff0c\u8bf7\u53c2\u8003\u793e\u533a\u6587\u6863\u201c\u6838\u7b97\u589e\u52a0\u4e8c\u5f00\u5b57\u6bb5\u201d\u5904\u7406\u3002", (String)"BalanceDimFieldParser_0", (String)"fi-cal-business", (Object[])new Object[0]);
            msg = String.format(msg, entityType.getDisplayName(), entityType.getName(), field);
            throw new KDBizException(msg);
        }
        return CommonUtils.getFieldPath(field, property.getParent());
    }

    public static String getFieldPath(String field, IDataEntityType parentProp) {
        if (parentProp instanceof EntryType) {
            field = parentProp.getName() + "." + field;
            return CommonUtils.getFieldPath(field, parentProp.getParent());
        }
        return field;
    }
}

