/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.formplugin.calculate.out;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.calx.algox.CalCulateOutParamEntry;
import kd.fi.calx.algox.CalCulateOutParams;

public class CalTaskListPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(CalTaskListPlugin.class);

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals("progress_progress")) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Object pkId = billList.getFocusRowPkId();
            args.setCancel(true);
            String entityName = ((ListView)this.getView()).getBillFormId();
            DynamicObject selectRowEntry = QueryServiceHelper.queryOne((String)entityName, (String)"progress", (QFilter[])new QFilter("id", "=", pkId).toArray());
            Long progress = selectRowEntry.getLong("progress");
            if (progress == null) {
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("cal_progress");
            showParameter.setPkId((Object)progress);
            showParameter.setCustomParam("taskId", (Object)String.valueOf(pkId));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        String key = e.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if ("bar_checkresult".equals(key)) {
            if (ids.length > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4ec5\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u8054\u67e5\u7ed3\u679c\u3002", (String)"CalculateReStartOP_16", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            if (ids.length != 1) {
                return;
            }
            Long taskId = (Long)ids[0];
            QFilter q = new QFilter("checkplan", "=", (Object)taskId);
            DataSet checkResultDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_datacheck_result", (String)"id,entryentity.entrystatus", (QFilter[])q.toArray(), null);
            if (checkResultDataSet.isEmpty()) {
                DynamicObject selectTask = QueryServiceHelper.queryOne((String)"cal_task", (String)"calnumber,ismaintask", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
                String calNum = selectTask.getString("calnumber");
                boolean isMainTask = selectTask.getBoolean("ismaintask");
                DynamicObjectCollection tasks = QueryServiceHelper.query((String)"cal_task", (String)"id", (QFilter[])new QFilter("calnumber", "=", (Object)calNum).toArray());
                if (tasks.size() > 1 && !isMainTask) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u4e3b\u4efb\u52a1\u8fdb\u884c\u8054\u67e5\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CalculateReStartOP_17", (String)"fi-calx-algox", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CalculateReStartOP_18", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            HashSet<Long> resultIds = new HashSet<Long>(2);
            for (Row result : checkResultDataSet) {
                resultIds.add(result.getLong("id"));
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("cal_datacheck_result");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("id", "in", resultIds));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("bar_material".equals(key)) {
            if (ids.length > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4ec5\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u8054\u67e5\u7ed3\u679c\u3002", (String)"CalculateReStartOP_16", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            if (ids.length != 1) {
                return;
            }
            Long taskId = (Long)ids[0];
            DynamicObject taskInfo = QueryServiceHelper.queryOne((String)"cal_task", (String)"params_tag", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
            String params_tag = taskInfo.getString("params_tag");
            CalCulateOutParams params = null;
            try {
                params = (CalCulateOutParams)JSONUtils.cast((String)params_tag, CalCulateOutParams.class);
            }
            catch (IOException e1) {
                logger.error("\u8054\u67e5\u7269\u6599\u53cd\u5e8f\u5217\u5316\u62a5\u9519", (Throwable)e1);
            }
            if (params == null) {
                return;
            }
            Collection<CalCulateOutParamEntry> paramsEntry = params.getEntrys().values();
            HashSet<Object> materialIds = new HashSet<Object>(16);
            for (CalCulateOutParamEntry calCulateOutParamEntry : paramsEntry) {
                Set<Object> set = calCulateOutParamEntry.getMaterialIdSet();
                if (set == null) continue;
                materialIds.addAll(set);
            }
            if (materialIds.isEmpty()) {
                return;
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("bd_material");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("id", "in", materialIds));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParams().get("pageType");
        if ("A".equals(pageType)) {
            QFilter filter = new QFilter("tasktype", "=", (Object)"A");
            e.getQFilters().add(filter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filtergridview = (FilterContainer)this.getView().getControl("filtercontainerap");
        filtergridview.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if (fieldName.contains("queryscheme")) {
            QFilter entityFilter = new QFilter("formid", "=", (Object)this.getEntity());
            args.getQFilters().add(entityFilter);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent e) {
        String fieldName = e.getFieldName();
        if (fieldName.contains("queryscheme")) {
            QFilter entityFilter = new QFilter("formid", "=", (Object)this.getEntity());
            e.getQfilters().add(entityFilter);
            e.getCustomParams().put("nosplituser", "true");
        }
    }

    private String getEntity() {
        return "cal_out_calculate";
    }
}

