/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.formplugin.calculate.out;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.helper.PermissionHelper;
import kd.fi.calx.formplugin.calculate.out.CalculateOutCostTaskDispatcher;
import kd.fi.calx.formplugin.calculate.out.QuerySchemeHolder;

public class CalculateOutCostPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private String CAL_RANGE = "calrange";

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String opKey = event.getOperateKey();
        if ("distributcal".equals(opKey)) {
            DynamicObject calOutDyc = this.getModel().getDataEntity(true);
            CalculateOutCostTaskDispatcher dispatcher = new CalculateOutCostTaskDispatcher(calOutDyc);
            Long querySchemeId = new QuerySchemeHolder(this.getView()).getCurSchemeId();
            dispatcher.setQuerySchemeId(querySchemeId);
            dispatcher.dispatch();
            Boolean isConcurrency = (Boolean)this.getModel().getValue("isconcurrency");
            if (isConcurrency == null || !isConcurrency.booleanValue()) {
                List<String> calTaskIds = dispatcher.getCalTaskIds();
                String calTaskId = calTaskIds.get(0);
                this.getPageCache().put("taskid", calTaskId);
                this.showProgress(calTaskId, "0");
            } else {
                Long timestamp = dispatcher.getTimestamp();
                this.getPageCache().put("timestamp", timestamp.toString());
            }
            OperationResult result = event.getOperationResult();
            result.setMessage(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u5df2\u8fdb\u5165\u540e\u53f0\u8fd0\u7b97\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u8ba1\u7b97\u7ed3\u679c\u3002", (String)"CalculateOutCostPlugin_7", (String)"fi-calx-algox", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_viewprogress"});
        }
    }

    public void afterBindData(EventObject e) {
        Boolean costatenddateenable;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_viewprogress"});
        this.getView().getModel().setDataChanged(false);
        Boolean desigoutweightedavgat = (Boolean)this.getModel().getValue("desigoutweightedavgat");
        Boolean coverdesigoutcost = (Boolean)this.getModel().getValue("coverdesigoutcost");
        if (desigoutweightedavgat.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"coverdesigoutcost"});
        }
        if (coverdesigoutcost.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"desigoutweightedavgat"});
        }
        if (!(costatenddateenable = (Boolean)this.getModel().getValue("costatenddateenable")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"costatenddate"});
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit calRange = (BasedataEdit)this.getControl(this.CAL_RANGE);
        calRange.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialfrom = (BasedataEdit)this.getControl("materialfrom");
        materialfrom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialto = (BasedataEdit)this.getControl("materialto");
        materialto.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialgroup = (BasedataEdit)this.getControl("materialgroup");
        materialgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"itemsbar"});
        this.addClickListeners(new String[]{"billnofilter"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String filter;
        String opKey = e.getProperty().getName();
        if (opKey.equals("costaccount")) {
            ChangeData[] est = e.getChangeSet();
            int rowIndex = est[0].getRowIndex();
            DynamicObject costaccountInfo = this.getModel().getEntryRowEntity("entry", rowIndex).getDynamicObject("costaccount");
            this.getModel().beginInit();
            if (costaccountInfo == null) {
                this.getModel().setValue("period", null, rowIndex);
                this.getModel().setValue("calorg", null, rowIndex);
            } else {
                DynamicObject currentInfo = PeriodHelper.getCurrentPeriod(costaccountInfo.getLong("id"));
                if (currentInfo == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5c1a\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u53c2\u4e0e\u51fa\u5e93\u6838\u7b97\u3002", (String)"CalculateOutCostPlugin_17", (String)"fi-calx-algox", (Object[])new Object[0]), costaccountInfo.getString("name"));
                    throw new KDBizException(msg);
                }
                this.getModel().setValue("period", (Object)currentInfo.getLong("id"), rowIndex);
                this.getModel().setValue("calorg", (Object)costaccountInfo.getDynamicObject("calorg"), rowIndex);
            }
            this.getModel().setValue("calrange", null, rowIndex);
            this.getView().updateView("calrange", rowIndex);
            this.getView().updateView("period", rowIndex);
            this.getView().updateView("begindate", rowIndex);
            this.getView().updateView("enddate", rowIndex);
            this.getView().updateView("calorg", rowIndex);
            if (this.needCheckPreCost()) {
                this.setCheckItemEnable();
            }
            this.getModel().endInit();
        } else if (opKey.equals("cbxwriterpt")) {
            boolean cbxwriterpt = this.getModel().getDataEntity().getBoolean("cbxwriterpt");
            this.getModel().beginInit();
            if (cbxwriterpt) {
                this.getModel().getDataEntity().set("cbxwriteerrrpt", (Object)Boolean.TRUE);
                this.getView().setEnable(Boolean.TRUE, new String[]{"cbxwriteerrrpt"});
            } else {
                this.getModel().getDataEntity().set("cbxwriteerrrpt", (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"cbxwriteerrrpt"});
            }
            this.getModel().endInit();
            this.getView().updateView("cbxwriteerrrpt");
        } else if (opKey.equals("materialfrom")) {
            ChangeData[] changeSet = e.getChangeSet();
            if (changeSet != null && changeSet.length > 0) {
                this.materialFromChange(changeSet[0].getRowIndex());
            }
        } else if (opKey.equals("materialgroup")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().beginInit();
            this.getModel().setValue("materialfrom", null, rowIndex);
            this.getModel().setValue("materialto", null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("materialfrom", rowIndex);
            this.getView().updateView("materialto", rowIndex);
        } else if (opKey.equals("materialto")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().beginInit();
            this.getModel().setValue("materialgroup", null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("materialgroup", rowIndex);
        } else if (opKey.equals("desigoutweightedavgat")) {
            boolean desigoutweightedavgat = this.getModel().getDataEntity().getBoolean("desigoutweightedavgat");
            this.getModel().beginInit();
            if (desigoutweightedavgat) {
                this.getModel().getDataEntity().set("coverdesigoutcost", (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"coverdesigoutcost"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"coverdesigoutcost"});
            }
            this.getModel().endInit();
            this.getView().updateView("coverdesigoutcost");
        } else if (opKey.equals("coverdesigoutcost")) {
            boolean desigoutweightedavgat = this.getModel().getDataEntity().getBoolean("coverdesigoutcost");
            this.getModel().beginInit();
            if (desigoutweightedavgat) {
                this.getModel().getDataEntity().set("desigoutweightedavgat", (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"desigoutweightedavgat"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"desigoutweightedavgat"});
            }
            this.getModel().endInit();
            this.getView().updateView("desigoutweightedavgat");
        } else if (opKey.equals("costatenddateenable")) {
            boolean costatenddateenable = this.getModel().getDataEntity().getBoolean("costatenddateenable");
            this.getModel().beginInit();
            if (costatenddateenable) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"costatenddate"});
                Object costatenddate = this.getModel().getValue("costatenddate");
                if (costatenddate == null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(5, -1);
                    Date previousDay = calendar.getTime();
                    this.getModel().setValue("costatenddate", (Object)previousDay);
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"costatenddate"});
                this.getModel().getDataEntity().set("costatenddate", null);
            }
            this.getModel().endInit();
            this.getView().updateView("costatenddate");
        } else if ("billnofilter".equals(opKey) && StringUtils.isEmpty((CharSequence)(filter = (String)this.getModel().getValue(opKey)))) {
            this.getModel().setValue("billnofilterjson_tag", null);
        }
    }

    private void materialFromChange(int rowIndex) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entry").get(rowIndex);
        DynamicObjectCollection materialFrom = entry.getDynamicObjectCollection("materialfrom");
        int size = materialFrom.size();
        this.getModel().beginInit();
        this.getModel().setValue("materialgroup", null, rowIndex);
        if (size > 1) {
            this.getModel().setValue("materialto", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialto"});
        } else {
            if (materialFrom.size() == 1) {
                this.getModel().setValue("materialto", ((DynamicObject)materialFrom.get(0)).getDynamicObject("fbasedataid").getPkValue());
            } else {
                this.getModel().setValue("materialto", null);
            }
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialto"});
        }
        this.getModel().endInit();
        this.getView().updateView("materialto", rowIndex);
        this.getView().updateView("materialgroup", rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        int rowIndex = event.getRow();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (this.CAL_RANGE.equals(sourceID)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
            if (costAccount == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalculateOutCostPlugin_6", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            QFilter qf = new QFilter("costaccount.id", "=", costAccount.getPkValue());
            qf.and(new QFilter("status", "=", (Object)"C"));
            qf.and(new QFilter("enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(qf);
        } else if ("costaccount".equals(sourceID)) {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List<Long> list = PermissionHelper.getUserPermOrgs(userId, "cal_out_calculate", "47150e89000000ac");
            QFilter q = new QFilter("entry.costaccount.enable", "=", (Object)"1");
            q.and("entry.isenabled", "=", (Object)true);
            if (list != null) {
                q.and(new QFilter("org", "in", list));
            }
            DynamicObjectCollection sysEntitys = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount", (QFilter[])q.toArray());
            HashSet<Long> endInitCostAccountIds = new HashSet<Long>(16);
            for (DynamicObject info : sysEntitys) {
                endInitCostAccountIds.add(info.getLong("entry.costaccount"));
            }
            QFilter qf = new QFilter("id", "=", (Object)-1L);
            if (!endInitCostAccountIds.isEmpty()) {
                qf = new QFilter("id", "in", endInitCostAccountIds);
            }
            showParameter.getListFilterParameter().setFilter(qf);
        } else if ("materialfrom".equals(sourceID) || "materialto".equals(sourceID)) {
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter();
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        if ("bar_viewprogress".equals(e.getItemKey())) {
            this.viewProgress();
        } else if ("openall".equals(e.getItemKey())) {
            this.changeCheckEntryStatus(true);
            this.setCheckItemEnable();
        } else if ("closeall".equals(e.getItemKey())) {
            this.changeCheckEntryStatus(false);
            this.setCheckItemEnable();
        }
    }

    private void viewProgress() {
        Boolean isConcurrency = (Boolean)this.getModel().getValue("isconcurrency");
        if (isConcurrency.booleanValue()) {
            this.showProgressList();
        } else {
            String taskId = this.getPageCache().get("taskid");
            this.showProgress(taskId, "1");
        }
    }

    private void showProgressList() {
        String timestamp = this.getPageCache().get("timestamp");
        if (timestamp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8ba1\u7b97\u4efb\u52a1\u3002", (String)"CalculateOutCostPlugin_13", (String)"fi-calx-algox", (Object[])new Object[0]));
            return;
        }
        QFilter calTaskFilter = new QFilter("calnumber", "=", (Object)timestamp);
        calTaskFilter.and("tasktype", "=", (Object)"A");
        DynamicObjectCollection progressInfo = QueryServiceHelper.query((String)"cal_task", (String)"id", (QFilter[])calTaskFilter.toArray());
        if (progressInfo == null || progressInfo.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8ba1\u7b97\u4efb\u52a1\u3002", (String)"CalculateOutCostPlugin_13", (String)"fi-calx-algox", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_task");
        showParameter.getListFilterParameter().setFilter(calTaskFilter);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showProgress(String taskId, String type) {
        if (taskId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8ba1\u7b97\u4efb\u52a1\u3002", (String)"CalculateOutCostPlugin_13", (String)"fi-calx-algox", (Object[])new Object[0]));
            return;
        }
        DynamicObject progressInfo = QueryServiceHelper.queryOne((String)"cal_progress", (String)"id", (QFilter[])new QFilter("taskid", "=", (Object)Long.valueOf(taskId)).toArray());
        if (progressInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8ba1\u7b97\u4efb\u52a1\u3002", (String)"CalculateOutCostPlugin_13", (String)"fi-calx-algox", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("cal_progress");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPkId(progressInfo.get("id"));
        showParameter.setCustomParam("type", (Object)type);
        showParameter.setCustomParam("taskId", (Object)taskId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void changeCheckEntryStatus(boolean isOpen) {
        DynamicObjectCollection checkEntry = this.getModel().getEntryEntity("checkentry");
        for (DynamicObject item : checkEntry) {
            String number = item.getString("checkitem.number");
            if (!StringUtils.isEmpty((CharSequence)number) && !"CALOUT-ITEM-06".equals(number)) {
                item.set("ischeck", (Object)isOpen);
                continue;
            }
            if (this.needCheckPreCost()) continue;
            item.set("ischeck", (Object)isOpen);
        }
        this.getView().updateView("checkentry");
    }

    private boolean needCheckPreCost() {
        boolean needCheckPreCost = false;
        int mainRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < mainRowCount; ++i) {
            AppParam appParam;
            Boolean deleteprecostadj;
            Long calOrgId;
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entry").get(i);
            Long l = calOrgId = entry.getDynamicObject("calorg") == null ? null : Long.valueOf(entry.getDynamicObject("calorg").getLong("id"));
            if (calOrgId == null || (deleteprecostadj = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)(appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L))), (String)"deleteprecostadj")) != null && !deleteprecostadj.booleanValue()) continue;
            needCheckPreCost = true;
            break;
        }
        return needCheckPreCost;
    }

    private void setCheckItemEnable() {
        int entryRowCount = this.getModel().getEntryRowCount("checkentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("checkentry").get(i);
            String checkItemNumber = entry.getDynamicObject("checkitem") == null ? null : entry.getDynamicObject("checkitem").getString("number");
            this.getModel().beginInit();
            if (checkItemNumber != null && checkItemNumber.length() != 0 && "CALOUT-ITEM-06".equals(checkItemNumber)) {
                if (this.needCheckPreCost()) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"ischeck"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"ischeck"});
                }
            }
            this.getModel().endInit();
            this.getView().updateView("ischeck", i);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if (source instanceof TextEdit && "billnofilter".equals(fieldKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cal_billfilter");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            String filterstr = (String)this.getModel().getValue(fieldKey + "json_tag");
            showParameter.getCustomParams().put("entityNumber", "cal_costrecord_subentity");
            showParameter.getCustomParams().put("billfilterstr", filterstr);
            showParameter.getCustomParams().put("filtertype", "billnofilter");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String fieldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("billnofilter".equals(fieldKey)) {
            Map returnDataMap = (Map)returnData;
            if (returnData == null || StringUtils.isEmpty((CharSequence)((String)returnDataMap.get("filter")))) {
                this.getModel().setValue(fieldKey, (Object)"");
                this.getModel().setValue(fieldKey + "json_tag", (Object)"");
            } else {
                String filter = (String)returnDataMap.get("filter");
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
                CRCondition condition = new CRCondition();
                condition.setFilterCondition(filterCondition);
                String exprTran = this.tranFormula((CRFormula)condition, "cal_costrecord_subentity");
                exprTran = exprTran.length() > 500 ? exprTran.substring(0, 500) + "..." : exprTran;
                this.getModel().setValue(fieldKey, (Object)exprTran);
                this.getModel().setValue(fieldKey + "json_tag", (Object)filter);
            }
        }
    }

    private String tranFormula(CRFormula formulaObj, String entityNumber) {
        MainEntityType mainType = null;
        mainType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            return String.join((CharSequence)ResManager.loadKDString((String)"\u4e14", (String)"CalculateOutCostPlugin_27", (String)"fi-calx-algox", (Object[])new Object[0]), descs);
        }
        return "";
    }
}

