/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.formplugin.calculate.out;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalculateOutService;
import kd.fi.calx.algox.MoveAvgIntimeCalculateOutService;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CalculateParamHelper;

public class CalculateOutCostTaskDispatcher {
    private final DynamicObject calOutDyc;
    private Long timestamp;
    private List<String> calTaskIds = new ArrayList<String>(16);
    private Long querySchemeId = 0L;

    public CalculateOutCostTaskDispatcher(DynamicObject calOutDyc) {
        this.calOutDyc = calOutDyc;
    }

    public void dispatch() {
        this.timestamp = TimeServiceHelper.now().getTime();
        Boolean isConcurrency = this.calOutDyc.getBoolean("isconcurrency");
        if (isConcurrency.booleanValue()) {
            this.dispatchConcurrencyTask();
        } else {
            this.dispatchSingleTask();
        }
    }

    private void dispatchSingleTask() {
        String sysTaskId;
        Object service;
        CalCulateOutParams param = CalculateParamHelper.buildDistributedParam(false, false, this.calOutDyc, this.getQuerySchemeId());
        DynamicObject taskInfo = this.createTask(this.timestamp, param);
        String calTaskId = taskInfo.getString("id");
        Object progressId = this.createProgress(calTaskId);
        String calModel = CalDbParamServiceHelper.getString(CalDbParamConstant.CALC_MODEL, null);
        if ("B".equals(calModel) && 0 != param.getRunningModeMap().get(AccountTypeEnum.MOVEDAVG_INTIME.getValue())) {
            service = new MoveAvgIntimeCalculateOutService(calTaskId);
            sysTaskId = ((MoveAvgIntimeCalculateOutService)service).calCulateOutAsync(param);
        } else {
            service = new CalculateOutService(calTaskId);
            sysTaskId = ((CalculateOutService)service).calCulateOutAsync(param);
        }
        this.calTaskIds.add(calTaskId);
        DynamicObject schTask = QueryServiceHelper.queryOne((String)"sch_task", (String)"id,runat", (QFilter[])new QFilter("id", "=", (Object)sysTaskId).toArray());
        taskInfo.set("taskid", (Object)sysTaskId);
        taskInfo.set("runat", (Object)schTask.getString("runat"));
        taskInfo.set("progress", progressId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
    }

    private void dispatchConcurrencyTask() {
        CalCulateOutParams param = CalculateParamHelper.buildDistributedParam(false, true, this.calOutDyc, this.getQuerySchemeId());
        CalCulateOutParams oldParam = CalculateParamHelper.buildDistributedParam(false, false, this.calOutDyc, this.getQuerySchemeId());
        Integer concurrency = this.calOutDyc.getInt("concurrency");
        Integer batchmatsize = this.calOutDyc.getInt("batchmatsize");
        Integer batchrowsize = this.calOutDyc.getInt("batchrowsize");
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        try {
            jobParams.put("params", JSONUtils.toString((Object)param));
            jobParams.put("oldparams", JSONUtils.toString((Object)oldParam));
            jobParams.put("concurrency", concurrency.toString());
            jobParams.put("batchmatsize", batchmatsize.toString());
            jobParams.put("batchrowsize", batchrowsize.toString());
            jobParams.put("timestamp", this.timestamp);
            jobParams.put("calnumber", this.timestamp.toString());
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        JobInfo job = new JobInfo();
        String OpName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u4e3b\u4efb\u52a1\u201c%1$s\u201d\uff0c\u64cd\u4f5c\u4eba\u201c%2$s\u201d\u3002", (String)"CalculateOutCostPlugin_21", (String)"fi-calx-algox", (Object[])new Object[0]);
        OpName = String.format(OpName, this.timestamp.toString(), RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId("2TEFFDM0LS74");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("calx");
        job.setTaskClassname("kd.fi.calx.formplugin.calculate.out.CalculateOutPartitionTask");
        job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        job.setRunByLang(Lang.get());
        JobClient.dispatch((JobInfo)job);
    }

    private DynamicObject createTask(Long timestamp, CalCulateOutParams param) {
        DynamicObject taskInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_task");
        taskInfo.set("name", (Object)ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97", (String)"CalculateOutCostPlugin_14", (String)"fi-calx-algox", (Object[])new Object[0]));
        taskInfo.set("starttime", (Object)TimeServiceHelper.now());
        taskInfo.set("creator_id", (Object)RequestContext.get().getUserId());
        taskInfo.set("status", (Object)"C");
        taskInfo.set("tasktype", (Object)"A");
        taskInfo.set("calnumber", (Object)timestamp);
        taskInfo.set("queryscheme", (Object)param.getQuerySchemeId());
        try {
            taskInfo.set("params_tag", (Object)JSONUtils.toString((Object)param));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        taskInfo = ((DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo}))[0];
        taskInfo = BusinessDataServiceHelper.loadSingle((Object)taskInfo.getPkValue(), (String)"cal_task");
        return taskInfo;
    }

    private Object createProgress(String taskId) {
        DynamicObject progressInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_progress");
        QFilter q = new QFilter("source", "=", (Object)"A");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_step", (String)"id,number", (QFilter[])q.toArray(), (String)"number asc");){
            int i = 1;
            for (Row row : dataSet) {
                DynamicObject entry = progressInfo.getDynamicObjectCollection("entry").addNew();
                entry.set("step", (Object)row.getLong("id"));
                entry.set("seq", (Object)i);
                entry.set("status", (Object)"D");
                ++i;
            }
        }
        progressInfo.set("taskid", (Object)taskId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{progressInfo});
        return progressInfo.getPkValue();
    }

    public List<String> getCalTaskIds() {
        return this.calTaskIds;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setQuerySchemeId(Long querySchemeId) {
        this.querySchemeId = querySchemeId;
    }

    public Long getQuerySchemeId() {
        return this.querySchemeId;
    }
}

