/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.formplugin.calculate.out;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalOutDataRangeHolder;

public class CalculateOutDataCheckTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CalculateOutDataCheckTask.class);
    private static final Long CHECKBEFORETASK_ID = 1228995490352290816L;
    private static final Long CHECKAFTERTASK_ID = 1234050040448761856L;

    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        try {
            Map<Long, String> checkItems;
            Long checkTaskid;
            CalCulateOutParams originParam = (CalCulateOutParams)JSONUtils.cast((String)((String)paramMap.get("params")), CalCulateOutParams.class);
            Long mainTaskId = (Long)paramMap.get("maintaskid");
            String checkTaskType = (String)paramMap.get("checktasktype");
            if ("A".equals(checkTaskType)) {
                checkTaskid = CHECKBEFORETASK_ID;
                checkItems = originParam.getCheckItems().get("D");
            } else {
                checkTaskid = CHECKAFTERTASK_ID;
                checkItems = originParam.getCheckItems().get("E");
            }
            CalOutDataRangeHolder holder = new CalOutDataRangeHolder(originParam);
            Map<String, Map<Integer, Object>> calOutRangeMap = this.getCalOutRangeMap(holder, originParam);
            Object[] obj = new Object[]{calOutRangeMap, checkItems, mainTaskId.toString(), checkTaskid};
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalOutDataCheckService", (String)"doCalOutDataCheck", (Object[])obj);
        }
        catch (Exception e) {
            logger.info("\u51fa\u5e93\u6838\u7b97\u4e3b\u4efb\u52a1\u8c03\u7528\u68c0\u67e5\u9879\u5fae\u670d\u52a1\u51fa\u9519:", (Object)e);
            return;
        }
    }

    private Map<String, Map<Integer, Object>> getCalOutRangeMap(CalOutDataRangeHolder holder, CalCulateOutParams originParam) {
        HashMap<String, Map<Integer, Object>> calOutRangeMap = new HashMap<String, Map<Integer, Object>>(16);
        int index = 0;
        boolean isNeedCalculatedLater = holder.isNeedCalculatedLater();
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            List<Set<Object>> materialSetList = range.getMaterialSetList();
            Long calOrgId = range.getCalOrgId();
            Long calRangeId = range.getCalRangeId();
            Long costAccountId = range.getCostAccountId();
            Date startDate = range.getStartDate();
            Date endDate = range.getEndDate();
            Integer period = range.getPeriod();
            Long periodId = range.getPeriodId();
            boolean isAllMaterial = range.isAllMaterial();
            this.setRangeMapValue(calOutRangeMap, "materialSetListMap", materialSetList, index);
            this.setRangeMapValue(calOutRangeMap, "calOrgIdMap", calOrgId, index);
            this.setRangeMapValue(calOutRangeMap, "calRangeIdMap", calRangeId, index);
            this.setRangeMapValue(calOutRangeMap, "costAccountIdMap", costAccountId, index);
            this.setRangeMapValue(calOutRangeMap, "startDateMap", startDate, index);
            this.setRangeMapValue(calOutRangeMap, "endDateMap", endDate, index);
            this.setRangeMapValue(calOutRangeMap, "periodMap", period, index);
            this.setRangeMapValue(calOutRangeMap, "periodIdMap", periodId, index);
            this.setRangeMapValue(calOutRangeMap, "isAllMaterialMap", isAllMaterial, index);
            this.setRangeMapValue(calOutRangeMap, "isNeedCalculatedLaterMap", isNeedCalculatedLater, index);
            this.setRangeMapValue(calOutRangeMap, "voucherdutweightedavgat", originParam.isVoucherdutweightedavgat(), index);
            ++index;
        }
        return calOutRangeMap;
    }

    private void setRangeMapValue(Map<String, Map<Integer, Object>> calOutRangeMap, String key, Object value, int index) {
        Map<Object, Object> dimMap;
        if (calOutRangeMap.get(key) == null) {
            dimMap = new HashMap(16);
            dimMap.put(index, value);
        } else {
            dimMap = calOutRangeMap.get(key);
            dimMap.put(index, value);
        }
        calOutRangeMap.put(key, dimMap);
    }
}

