/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.formplugin.calculate.out;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.calx.algox.CalCulateOutParamEntry;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.CalculateOutService;
import kd.fi.calx.algox.MoveAvgIntimeCalculateOutService;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CostAccountGroupRecordHelper;
import kd.fi.calx.algox.helper.FIFOPeriodDataCalculate;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.helper.StopSyncSettingModifyHelper;

public class CalculateOutPartitionTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CalculateOutPartitionTask.class);
    private static final String PARTITION_DLOCK_KEY = "calx_calculateoutpartition#";
    private static final String COSTACCOUNT_DLOCK_KEY = "calx_calculateout#";
    public static final int SAVE_SIZE = 2000;
    public int COUNT_ROW_SIZE = 50000;
    private int concurrency = 5;
    private String timestampStr = null;
    private static final Long CHECKBEFORETASK_ID = 1228995490352290816L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(Long.valueOf(ctx.getUserId()));
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        String isReStart = (String)paramMap.get("isReStart");
        this.timestampStr = (String)paramMap.get("calnumber");
        msgInfo.setTitle(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97", (String)"CalculateOutCostPlugin_14", (String)"fi-calx-algox", (Object[])new Object[0]));
        String isTimedTask = null;
        DLock partitionLock = null;
        DLock costAccountLock = null;
        Map<String, Integer> runningModeMap = null;
        CalOutDataRangeHolder holder = null;
        boolean checkSuccess = true;
        try {
            DynamicObject[] allMainTasks;
            CalCulateOutParams originParam = (CalCulateOutParams)JSONUtils.cast((String)((String)paramMap.get("params")), CalCulateOutParams.class);
            Long costAccountId = originParam.getEntrys().values().iterator().next().getCostAccountId();
            costAccountLock = DLock.create((String)(COSTACCOUNT_DLOCK_KEY + costAccountId));
            if (!costAccountLock.tryLock()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u4e00\u8d26\u7c3f\u4e0b\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u51fa\u5e93\u6838\u7b97\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalculateOutService_2", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            Calendar now = Calendar.getInstance();
            now.set(5, now.get(5) - 1);
            QFilter mainTaskFilter = new QFilter("ismaintask", "=", (Object)"1");
            mainTaskFilter.and("starttime", ">", (Object)now.getTime());
            mainTaskFilter.and("status", "=", (Object)"B");
            mainTaskFilter.and("calnumber", "!=", (Object)this.timestampStr);
            mainTaskFilter.and("tasktype", "=", (Object)"A");
            for (DynamicObject dynamicObject : allMainTasks = BusinessDataServiceHelper.load((String)"cal_task", (String)"id,calnumber,params_tag", (QFilter[])mainTaskFilter.toArray())) {
                String params = dynamicObject.getString("params_tag");
                CalCulateOutParams runningParam = (CalCulateOutParams)JSONUtils.cast((String)params, CalCulateOutParams.class);
                Long runnintCostAccountId = runningParam.getEntrys().values().iterator().next().getCostAccountId();
                if (!costAccountId.equals(runnintCostAccountId)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u4e00\u8d26\u7c3f\u4e0b\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u51fa\u5e93\u6838\u7b97\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalculateOutService_2", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            List<Object[]> tasks = null;
            if (isReStart != null && "true".equals(isReStart)) {
                void var20_34;
                isTimedTask = (String)paramMap.get("isTimedTask");
                String timesStr = (String)paramMap.get("times");
                String waitTimeOutMinStr = (String)paramMap.get("waitTimeOutMins");
                String string = (String)paramMap.get("runTimeOutMins");
                if (StringUtils.isEmpty((String)timesStr)) {
                    timesStr = "4";
                }
                if (StringUtils.isEmpty((String)waitTimeOutMinStr)) {
                    waitTimeOutMinStr = "180";
                }
                if (StringUtils.isEmpty((String)string)) {
                    String string2 = "60";
                }
                int times = Integer.parseInt(timesStr);
                int waitTimeOutMins = Integer.parseInt(waitTimeOutMinStr);
                int runTimeOutMins = Integer.parseInt((String)var20_34);
                tasks = this.getAndConstructorParams(this.timestampStr, times, runTimeOutMins, waitTimeOutMins);
            } else {
                String checkStatus;
                this.concurrency = Integer.parseInt((String)paramMap.get("concurrency"));
                int batchmatsize = Integer.parseInt((String)paramMap.get("batchmatsize"));
                this.COUNT_ROW_SIZE = Integer.parseInt((String)paramMap.get("batchrowsize"));
                Long timestamp = (Long)paramMap.get("timestamp");
                DynamicObject dynamicObject = this.buildMainTask(timestamp, originParam);
                long mainTaskId = dynamicObject.getLong("id");
                if (originParam.getCheckItems().get("D") != null) {
                    this.sendDataCheckJob(originParam, timestamp.toString(), mainTaskId, "A");
                }
                CostAccountGroupRecordHelper.refreshGroupRecordByTime();
                runningModeMap = originParam.getRunningModeMap();
                CalCulateOutParams oldParam = (CalCulateOutParams)JSONUtils.cast((String)((String)paramMap.get("oldparams")), CalCulateOutParams.class);
                holder = new CalOutDataRangeHolder(oldParam);
                this.addLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
                if (0 != originParam.getRunningModeMap().get(AccountTypeEnum.FIFO.getValue())) {
                    this.calFIFOBalBegin(holder);
                }
                if (0 != originParam.getRunningModeMap().get(AccountTypeEnum.FIN_FOUT_PERIOD.getValue())) {
                    this.calFIFOPeriodBalBegin(holder);
                }
                CommonInfo commonInfo = new CommonInfo();
                if (oldParam.isInvockCostprice4Rework() && commonInfo.enableRework()) {
                    commonInfo.invockCostprice4Rework(oldParam);
                }
                List<CalCulateOutParams> paramsList = this.analyseAndPartitionParams(originParam, batchmatsize);
                if (originParam.getCheckItems().get("D") != null && "B".equals(checkStatus = this.getCheckStatus(CHECKBEFORETASK_ID, mainTaskId))) {
                    dynamicObject.set("status", (Object)"D");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    checkSuccess = false;
                    throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u8bf7\u9009\u4e2d\u4e3b\u4efb\u52a1\uff0c\u8054\u67e5\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CalculateOutService_3", (String)"fi-calx-algox", (Object[])new Object[0]));
                }
                tasks = this.saveTaskAndProgress(timestamp, paramsList, originParam);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            if (tasks == null || tasks.isEmpty()) {
                return;
            }
            partitionLock = DLock.create((String)(PARTITION_DLOCK_KEY + this.timestampStr));
            if (!partitionLock.tryLock()) {
                if ("true".equals(isTimedTask)) {
                    return;
                }
                String msg = String.format(ResManager.loadKDString((String)"%1$s:\u9879\u76ee\u4efb\u52a1\u53f7\u6b63\u5728\u8fd0\u884c\u51fa\u5e93\u6838\u7b97\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalculateOutService_6", (String)"fi-calx-algox", (Object[])new Object[0]), this.timestampStr);
                throw new KDBizException(msg);
            }
            int curBatch = 0;
            int size = tasks.size();
            for (Object[] curTask : tasks) {
                String sysTaskId;
                Object service;
                ++curBatch;
                DynamicObject taskInfo = (DynamicObject)curTask[0];
                CalCulateOutParams curparam = (CalCulateOutParams)curTask[1];
                String calTaskId = taskInfo.getString("id");
                String calModel = CalDbParamServiceHelper.getString(CalDbParamConstant.CALC_MODEL, null);
                if ("B".equals(calModel) && 0 != curparam.getRunningModeMap().get(AccountTypeEnum.MOVEDAVG_INTIME.getValue())) {
                    service = new MoveAvgIntimeCalculateOutService(calTaskId);
                    sysTaskId = ((MoveAvgIntimeCalculateOutService)service).calCulateOutAsync(curparam);
                } else {
                    service = new CalculateOutService(calTaskId);
                    sysTaskId = ((CalculateOutService)service).calCulateOutAsync(curparam);
                }
                taskInfo.set("taskid", (Object)sysTaskId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
                int durSec = 2;
                try {
                    Thread.sleep(durSec * 100);
                }
                catch (InterruptedException e) {
                    logger.info("CalculateOutPartitionTask->execute error", (Object)e);
                }
            }
            String string3 = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u4e3b\u4efb\u52a1\u8fd0\u884c\u6210\u529f\uff0c\u5171\u6709%1$s\u6279\u5b50\u4efb\u52a1\uff0c\u8ba1\u7b97\u4efb\u52a1\u53f7\u4e3a\u201c%2$s\u201d\u3002", (String)"CalculateOutService_4", (String)"fi-calx-algox", (Object[])new Object[0]);
            string3 = String.format(string3, tasks.size(), this.timestampStr);
            msgInfo.setContent(string3);
        }
        catch (Throwable e) {
            String error = e.getLocalizedMessage();
            if (error != null && error.length() > 2000) {
                msgInfo.setContent(error.substring(1, 2000));
            } else {
                msgInfo.setContent(error);
            }
            if (holder != null && runningModeMap != null) {
                try {
                    this.releaseLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
                }
                catch (Exception excep) {
                    logger.error("\u51fa\u5e93\u6838\u7b97\u540e\u53f0\u4efb\u52a1\u542f\u52a8\u670d\u52a1\u5f02\u5e38", (Throwable)excep);
                }
            }
            logger.error("\u51fa\u5e93\u6838\u7b97\u540e\u53f0\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", e);
        }
        finally {
            if (partitionLock != null) {
                partitionLock.close();
            }
            if (costAccountLock != null) {
                costAccountLock.close();
            }
            if (isTimedTask == null || !"true".equals(isTimedTask)) {
                MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
            }
            if (!checkSuccess && holder != null && holder.getCalorgMapPeriod() != null && runningModeMap != null) {
                try {
                    this.releaseLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
                }
                catch (Exception excep) {
                    logger.error("\u51fa\u5e93\u6838\u7b97\u540e\u53f0\u4efb\u52a1\u542f\u52a8\u670d\u52a1\u5f02\u5e38", (Throwable)excep);
                }
            }
        }
    }

    private void releaseLock(Map<String, Integer> runningModeMap, Set<Long> calOrgIdSet) {
        if (runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.MOVEDAVG_INTIME.getValue(), null, new HashSet<Long>(), false);
        }
        if (runningModeMap.get(AccountTypeEnum.FIFO.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.FIFO.getValue(), null, new HashSet<Long>(), false);
        }
    }

    private void addLock(Map<String, Integer> runningModeMap, Set<Long> calOrgIdSet) {
        if (runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.MOVEDAVG_INTIME.getValue(), null, new HashSet<Long>(), true);
        }
        if (runningModeMap.get(AccountTypeEnum.FIFO.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.FIFO.getValue(), null, new HashSet<Long>(), true);
        }
    }

    private void calFIFOBalBegin(CalOutDataRangeHolder holder) {
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            long costAccountId = range.getCostAccountId();
            if (range.isAllMaterial()) {
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, null, new HashSet<Long>(1));
                cal.calculate();
                continue;
            }
            for (Set<Object> materialSet : range.getMaterialSetList()) {
                HashSet<Long> mSet = new HashSet<Long>(materialSet.size());
                for (Object id : materialSet) {
                    mSet.add(Long.valueOf(id.toString()));
                }
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, null, mSet);
                cal.calculate();
            }
        }
    }

    private void calFIFOPeriodBalBegin(CalOutDataRangeHolder holder) {
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            long costAccountId = range.getCostAccountId();
            if (range.isAllMaterial()) {
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, range.getCalRangeId(), new HashSet<Long>(1));
                cal.calFIFOPeriodBal();
                continue;
            }
            for (Set<Object> materialSet : range.getMaterialSetList()) {
                HashSet<Long> mSet = new HashSet<Long>(materialSet.size());
                for (Object id : materialSet) {
                    mSet.add(Long.valueOf(id.toString()));
                }
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, range.getCalRangeId(), mSet);
                cal.calFIFOPeriodBal();
            }
        }
    }

    private List<Object[]> getAndConstructorParams(String calNumber, int retrytimes, int runnTimeOutMin, int waitTimeOutMin) {
        DynamicObject[] progressInfos;
        QFilter filter = new QFilter("calnumber", "=", (Object)calNumber);
        filter.and("times", "<", (Object)retrytimes);
        filter.and("tasktype", "=", (Object)"A");
        filter.and("ismaintask", "=", (Object)"0");
        QFilter failFilter = new QFilter("status", "=", (Object)"D");
        QFilter runTimeOutMinFilter = new QFilter("status", "=", (Object)"B");
        Calendar now = Calendar.getInstance();
        now.set(12, now.get(12) - runnTimeOutMin);
        runTimeOutMinFilter.and("starttime", "<=", (Object)now.getTime());
        QFilter waitTimeOutMinFilter = new QFilter("status", "=", (Object)"C");
        now = Calendar.getInstance();
        now.set(12, now.get(12) - waitTimeOutMin);
        waitTimeOutMinFilter.and("starttime", "<=", (Object)now.getTime());
        filter.and(failFilter.or(runTimeOutMinFilter).or(waitTimeOutMinFilter));
        DynamicObject[] taskInfos = BusinessDataServiceHelper.load((String)"cal_task", (String)"id,calnumber,taskid,name,creator_id,status,starttime,times,progress_id,params_tag", (QFilter[])filter.toArray());
        if (taskInfos == null || taskInfos.length == 0) {
            return null;
        }
        ArrayList<Object[]> tasks = new ArrayList<Object[]>(taskInfos.length);
        HashSet<Long> progressIds = new HashSet<Long>(16);
        for (DynamicObject taskInfo : taskInfos) {
            String params_tag = taskInfo.getString("params_tag");
            Long progressId = taskInfo.getLong("progress_id");
            int times = taskInfo.getInt("times");
            progressIds.add(progressId);
            CalCulateOutParams params = null;
            try {
                params = (CalCulateOutParams)JSONUtils.cast((String)params_tag, CalCulateOutParams.class);
                this.concurrency = params.getConcurrency();
            }
            catch (IOException e) {
                logger.error("CalculateOutPartitionTask->getAndConstructorParams error", (Throwable)e);
            }
            taskInfo.set("times", (Object)(times + 1));
            taskInfo.set("status", (Object)"C");
            taskInfo.set("starttime", (Object)TimeServiceHelper.now());
            tasks.add(new Object[]{taskInfo, params});
        }
        SaveServiceHelper.save((DynamicObject[])taskInfos);
        for (DynamicObject progressInfo : progressInfos = BusinessDataServiceHelper.load((String)"cal_progress", (String)"progress,entry.status,entry.time", (QFilter[])new QFilter("id", "in", progressIds).toArray())) {
            progressInfo.set("progress", (Object)0);
            DynamicObjectCollection entry = progressInfo.getDynamicObjectCollection("entry");
            for (DynamicObject entryRow : entry) {
                entryRow.set("status", (Object)"D");
                entryRow.set("time", (Object)0);
            }
        }
        SaveServiceHelper.save((DynamicObject[])progressInfos);
        return tasks;
    }

    private List<Object[]> saveTaskAndProgress(Long timestamp, List<CalCulateOutParams> paramsList, CalCulateOutParams originParam) {
        int size = paramsList.size();
        int curBatch = 1;
        HashSet<DynamicObject> saveTasks = new HashSet<DynamicObject>(2000);
        HashSet<DynamicObject> saveProgresses = new HashSet<DynamicObject>(2000);
        ArrayList<Object[]> tasks = new ArrayList<Object[]>(size);
        QFilter q = new QFilter("source", "=", (Object)"A");
        DynamicObjectCollection steps = QueryServiceHelper.query((String)"cal_step", (String)"id,number", (QFilter[])q.toArray(), (String)"number asc");
        long[] calTaskIds = DB.genLongIds((String)"cal_task", (int)size);
        long[] progressIds = DB.genLongIds((String)"cal_progress", (int)size);
        for (CalCulateOutParams curparam : paramsList) {
            long curTaskId = calTaskIds[curBatch - 1];
            long progressId = progressIds[curBatch - 1];
            DynamicObject taskInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_task");
            String subJobName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u7b2c%1$s\u6279\uff0c\u5171%2$s\u4e2a\u7269\u6599", (String)"CalculateOutCostPlugin_22", (String)"fi-calx-algox", (Object[])new Object[0]);
            subJobName = String.format(subJobName, curBatch + "/" + size, curparam.getEntrys().values().iterator().next().getMaterialIdSet().size());
            taskInfo.set("id", (Object)curTaskId);
            taskInfo.set("calnumber", (Object)timestamp);
            taskInfo.set("name", (Object)subJobName);
            taskInfo.set("creator_id", (Object)RequestContext.get().getUserId());
            taskInfo.set("status", (Object)"C");
            taskInfo.set("starttime", (Object)TimeServiceHelper.now());
            taskInfo.set("tasktype", (Object)"A");
            taskInfo.set("progress", (Object)progressId);
            taskInfo.set("ismaintask", (Object)"0");
            taskInfo.set("times", (Object)0);
            taskInfo.set("queryscheme", (Object)curparam.getQuerySchemeId());
            try {
                taskInfo.set("params_tag", (Object)JSONUtils.toString((Object)curparam));
            }
            catch (IOException e) {
                logger.error("CalculateOutPartitionTask->saveTaskAndProgress error", (Throwable)e);
            }
            saveTasks.add(taskInfo);
            DynamicObject progressInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_progress");
            progressInfo.set("id", (Object)progressId);
            int i = 1;
            for (DynamicObject row : steps) {
                DynamicObject entry = progressInfo.getDynamicObjectCollection("entry").addNew();
                entry.set("step", (Object)row.getLong("id"));
                entry.set("seq", (Object)i);
                entry.set("status", (Object)"D");
                ++i;
            }
            progressInfo.set("taskid", (Object)curTaskId);
            saveProgresses.add(progressInfo);
            ++curBatch;
            tasks.add(new Object[]{taskInfo, curparam});
            if (saveTasks.size() >= 2000) {
                SaveServiceHelper.save((DynamicObject[])saveTasks.toArray(new DynamicObject[0]));
                saveTasks.clear();
            }
            if (saveProgresses.size() < 2000) continue;
            SaveServiceHelper.save((DynamicObject[])saveProgresses.toArray(new DynamicObject[0]));
            saveProgresses.clear();
        }
        if (!saveTasks.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveTasks.toArray(new DynamicObject[0]));
        }
        if (!saveProgresses.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveProgresses.toArray(new DynamicObject[0]));
        }
        return tasks;
    }

    private List<CalCulateOutParams> analyseAndPartitionParams(CalCulateOutParams param, int batchmatsize) {
        ArrayList<CalCulateOutParams> paramList = new ArrayList<CalCulateOutParams>();
        Boolean cbxWriteRpt = param.isWriteRpt();
        Boolean cbxWriteErrRpt = param.isWriteErrRpt();
        Integer weightavg = param.getRunningModeMap().get(AccountTypeEnum.WEIGHTAVG.getValue());
        Integer spprice = param.getRunningModeMap().get(AccountTypeEnum.SPPRICE.getValue());
        Integer movedavg = param.getRunningModeMap().get(AccountTypeEnum.MOVEDAVG_INTIME.getValue());
        Integer fifo = param.getRunningModeMap().get(AccountTypeEnum.FIFO.getValue());
        Integer fifoPeriod = param.getRunningModeMap().get(AccountTypeEnum.FIN_FOUT_PERIOD.getValue());
        Map<String, CalCulateOutParamEntry> entrys = param.getEntrys();
        for (CalCulateOutParamEntry entry : entrys.values()) {
            Long costAccountId = entry.getCostAccountId();
            Long calRangeId = entry.getCalrangeId();
            Date startDate = entry.getStartDate();
            Date endDate = entry.getEndDate();
            if (movedavg != null && movedavg > 0 || fifo != null && fifo > 0) {
                endDate = null;
            }
            Long periodId = entry.getPeriodId();
            Set<Object> matIds = entry.getMaterialIdSet();
            List<Set<Object>> partition = this.analyseAndPartitonMaterialSet(costAccountId, periodId, startDate, endDate, matIds, batchmatsize);
            QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
            filter = filter.and("status", "=", (Object)"C");
            filter = filter.and("enable", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection rangeCol = QueryServiceHelper.query((String)"cal_bd_calrange", (String)"id", (QFilter[])filter.toArray());
            DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)costAccountId, (String)"cal_bd_costaccount", (String)"name,calorg,calsystem,calpolicy");
            DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
            Iterator<Set<Object>> iterator = partition.iterator();
            while (iterator.hasNext()) {
                Set<Object> part;
                Set<Object> curmatIds = part = iterator.next();
                CalCulateOutParams curParam = new CalCulateOutParams();
                curParam.setConcurrency(this.concurrency);
                curParam.setWriteRpt(cbxWriteRpt);
                curParam.setWriteErrRpt(cbxWriteErrRpt);
                curParam.setWeightavgRunningMode(weightavg);
                curParam.setSppriceRunningMode(spprice);
                curParam.setMovedavgRunningMode(movedavg);
                curParam.setFifoRunningMode(fifo);
                curParam.setFifoPeriodRunningMode(fifoPeriod);
                curParam.setIsSubTask(true);
                curParam.setInvockCostprice4Rework(false);
                if (calRangeId == null) {
                    curParam.addEntry(costAccount, rangeCol, curmatIds, currentPeriod);
                } else {
                    curParam.addEntry(costAccountId, calRangeId, curmatIds);
                }
                curParam.setQuerySchemeId(param.getQuerySchemeId());
                curParam.setCostatenddateenable(param.isCostatenddateenable());
                curParam.setCostatenddate(param.getCostatenddate());
                curParam.setVoucherdutweightedavgat(param.isVoucherdutweightedavgat());
                curParam.setDesigoutweightedavgat(param.isDesigoutweightedavgat());
                curParam.setCoverdesigoutcost(param.isCoverdesigoutcost());
                curParam.setBillNoFilterStr(param.getBillNoFilterStr());
                boolean isMatrix = param.getMatrix();
                curParam.setMatrix(isMatrix);
                paramList.add(curParam);
            }
        }
        return paramList;
    }

    private List<Set<Object>> analyseAndPartitonMaterialSet(Long costAccountId, Long periodId, Date startDate, Date endDate, Set<Object> matIds, int batchmatsize) {
        Map<Object, Integer> materialRowMap = this.getMaterialRowCountMap(costAccountId, startDate, endDate, matIds);
        Map<Object, Set<Object>> gMaterialIdMapSet = this.getGroupMaterialsMap(costAccountId, periodId);
        List<Set<Object>> partitions = this.getPartitionMaterialList(batchmatsize, materialRowMap, gMaterialIdMapSet);
        return partitions;
    }

    private List<Set<Object>> getPartitionMaterialList(int batchmatsize, Map<Object, Integer> materialRowMap, Map<Object, Set<Object>> gMaterialIdMapSet) {
        HashSet<Object> hasGroupMaterials = new HashSet<Object>(16);
        ArrayList<Set<Object>> partitions = new ArrayList<Set<Object>>();
        HashSet<Object> materialIds = null;
        int sumCount = 0;
        for (Map.Entry<Object, Integer> materialRowCount : materialRowMap.entrySet()) {
            Object materialId = materialRowCount.getKey();
            if (hasGroupMaterials.contains(materialId)) continue;
            Set<Object> gMaterialIds = gMaterialIdMapSet.get(materialId);
            int curMatSize = 1;
            int curRowCount = materialRowCount.getValue();
            if (gMaterialIds != null) {
                curMatSize = gMaterialIdMapSet.size();
                curRowCount = 0;
                for (Object gMaterialId : gMaterialIds) {
                    Integer count = materialRowMap.get(gMaterialId);
                    count = count == null ? Integer.valueOf(0) : count;
                    curRowCount += count.intValue();
                }
                hasGroupMaterials.addAll(gMaterialIds);
            }
            if (materialIds == null || materialIds.size() + curMatSize >= batchmatsize || curRowCount + sumCount >= this.COUNT_ROW_SIZE) {
                logger.info("-----\u51fa\u5e93\u6838\u7b97\u5206\u6279\uff1a\u5171" + (materialIds == null ? 0 : materialIds.size()) + "\u4e2a\u7269\u6599\uff0c\u5171" + sumCount + "\u884c\u6570\u636e");
                materialIds = new HashSet<Object>(batchmatsize);
                partitions.add(materialIds);
                sumCount = 0;
            }
            if (gMaterialIds == null) {
                materialIds.add(materialId);
            } else {
                materialIds.addAll(gMaterialIds);
            }
            sumCount += curRowCount;
        }
        return partitions;
    }

    private Map<Object, Set<Object>> getGroupMaterialsMap(Long costAccountId, Long periodId) {
        QFilter sortResultFilter = new QFilter("groupno", ">", (Object)0);
        sortResultFilter.and("costaccount", "=", (Object)costAccountId);
        HashMap<Long, Set> groupMaterialSet = new HashMap<Long, Set>(16);
        Throwable object = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_sortresult", (String)"groupno,material", (QFilter[])sortResultFilter.toArray(), null).groupBy(new String[]{"groupno", "material"}).finish();){
            DataSet dataSet1 = dataSet.copy().groupBy(new String[]{"groupno"}).count("material").finish().where("material > 1").join(dataSet, JoinType.INNER).on("groupno", "groupno").select(new String[]{"groupno"}, new String[]{"material"}).finish();
            Iterator iterator = dataSet1.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long groupno = row.getLong("groupno");
                Object materialId = row.get("material");
                Set materialSet = groupMaterialSet.computeIfAbsent(groupno, k -> new HashSet(16));
                materialSet.add(materialId);
            }
        }
        catch (Throwable dataSet1) {
            Throwable throwable = dataSet1;
            throw dataSet1;
        }
        for (Map.Entry entry : groupMaterialSet.entrySet()) {
            for (Map.Entry entry2 : groupMaterialSet.entrySet()) {
                if (((Long)entry.getKey()).equals(entry2.getKey())) continue;
                HashSet srcValues = new HashSet((Collection)entry.getValue());
                srcValues.retainAll((Collection)entry2.getValue());
                if (srcValues.isEmpty()) continue;
                srcValues.addAll((Collection)entry.getValue());
                srcValues.addAll((Collection)entry2.getValue());
                entry.setValue(srcValues);
                entry2.setValue(srcValues);
            }
        }
        HashMap<Object, Set<Object>> gMaterialIdMapSet = new HashMap<Object, Set<Object>>(16);
        for (Set materialIds : groupMaterialSet.values()) {
            if (materialIds.size() <= 1) continue;
            for (Object materialId : materialIds) {
                gMaterialIdMapSet.put(materialId, materialIds);
            }
        }
        return gMaterialIdMapSet;
    }

    private Map<Object, Integer> getMaterialRowCountMap(Long costAccountId, Date startDate, Date endDate, Set<Object> matIds) {
        QFilter billFilter = new QFilter("costaccount", "=", (Object)costAccountId);
        billFilter.and("billstatus", "=", (Object)"C");
        billFilter.and("bookdate", ">=", (Object)startDate);
        if (endDate != null) {
            billFilter.and("bookdate", "<=", (Object)endDate);
        }
        QFilter costRecordFilter = null;
        QFilter costAdjustFilter = null;
        if (matIds != null && !matIds.isEmpty()) {
            costRecordFilter = new QFilter("entry.material", "in", matIds).and(billFilter);
            costAdjustFilter = new QFilter("entryentity.material", "in", matIds).and(billFilter);
        } else {
            costRecordFilter = billFilter;
            costAdjustFilter = billFilter;
        }
        HashMap<Object, Integer> materialRowMap = new HashMap<Object, Integer>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"costaccount,entry.material as material", (QFilter[])costRecordFilter.toArray(), null).union(QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjust_subentity", (String)"costaccount,entryentity.material as material", (QFilter[])costAdjustFilter.toArray(), null));){
            DataSet ds = dataSet.groupBy(new String[]{"material"}).count("count").finish();
            for (Row row : ds) {
                Object materialId = row.get("material");
                int count = row.getInteger("count");
                materialRowMap.put(materialId, count);
            }
        }
        return materialRowMap;
    }

    private void sendDataCheckJob(CalCulateOutParams originParam, String timestamp, Long mainTaskId, String checkTaskType) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        try {
            jobParams.put("params", JSONUtils.toString((Object)originParam));
            jobParams.put("maintaskid", mainTaskId);
            jobParams.put("checktasktype", checkTaskType);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        JobInfo job = new JobInfo();
        String OpName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u4e3b\u4efb\u52a1\u201c%1$s\u201d\u8c03\u7528\u51fa\u5e93\u6838\u7b97\uff08\u524d\uff09\u68c0\u67e5\uff0c\u64cd\u4f5c\u4eba\u201c%2$s\u201d\u3002", (String)"CalculateOutCostPlugin_23", (String)"fi-calx-algox", (Object[])new Object[0]);
        OpName = String.format(OpName, timestamp, RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId("2TEFJ=VTERCM");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("calx");
        job.setTaskClassname("kd.fi.calx.formplugin.calculate.out.CalculateOutDataCheckTask");
        job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        job.setRunByLang(Lang.get());
        JobClient.dispatch((JobInfo)job);
    }

    private DynamicObject buildMainTask(Long timestamp, CalCulateOutParams originParam) {
        DynamicObject taskInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_task");
        String subJobName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u4e3b\u4efb\u52a1", (String)"CalculateOutCostPlugin_26", (String)"fi-calx-algox", (Object[])new Object[0]);
        long mainTaskId = DB.genLongIds((String)"cal_task", (int)1)[0];
        taskInfo.set("id", (Object)mainTaskId);
        taskInfo.set("calnumber", (Object)timestamp);
        taskInfo.set("name", (Object)subJobName);
        taskInfo.set("creator_id", (Object)RequestContext.get().getUserId());
        taskInfo.set("status", (Object)"B");
        taskInfo.set("tasktype", (Object)"A");
        taskInfo.set("starttime", (Object)TimeServiceHelper.now());
        taskInfo.set("ismaintask", (Object)"1");
        taskInfo.set("queryscheme", (Object)originParam.getQuerySchemeId());
        try {
            taskInfo.set("params_tag", (Object)JSONUtils.toString((Object)originParam));
        }
        catch (IOException e) {
            logger.error("CalculateOutPartitionTask->buildMainTask error", (Throwable)e);
        }
        return taskInfo;
    }

    private String getCheckStatus(Long checkTaskId, Long mainTaskId) {
        DataSet checkResultDataSet;
        String checkStatus = "A";
        QFilter q = new QFilter("checkplan", "=", (Object)mainTaskId);
        q.and("checktask", "=", (Object)checkTaskId);
        q.and("status", "=", (Object)"B");
        do {
            if (!(checkResultDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_datacheck_result", (String)"id,entryentity.entrystatus", (QFilter[])q.toArray(), null)).isEmpty()) continue;
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                logger.error("\u7b49\u5f85\u51fa\u5e93\u6838\u7b97\u68c0\u67e5\u9879\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        } while (checkResultDataSet.isEmpty());
        for (Row row : checkResultDataSet) {
            String result = row.getString("entryentity.entrystatus");
            if (!"B".equals(result) && !"C".equals(result)) continue;
            checkStatus = "B";
            break;
        }
        return checkStatus;
    }
}

