/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.formplugin.calculate.out;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalculateOutService;
import kd.fi.calx.algox.MoveAvgIntimeCalculateOutService;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;

public class CalculateOutTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CalculateOutTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(Long.valueOf(ctx.getUserId()));
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setTitle(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97", (String)"CalculateOutCostPlugin_14", (String)"fi-calx-algox", (Object[])new Object[0]));
        String taskId = (String)paramMap.get("taskid");
        String calNumber = (String)paramMap.get("calnumber");
        DynamicObject calTaskInfo = BusinessDataServiceHelper.loadSingle((String)"cal_task", (String)"id,starttime,runat,taskid,status", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(taskId)).toArray());
        try {
            String status = calTaskInfo.getString("status");
            if ("A".equals(status) || "B".equals(status) || "E".equals(status)) {
                return;
            }
            CalCulateOutParams param = (CalCulateOutParams)JSONUtils.cast((String)((String)paramMap.get("param")), CalCulateOutParams.class);
            msgInfo.setContent(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u8ba1\u7b97\u6210\u529f\u3002", (String)"CalculateOutCostPlugin_15", (String)"fi-calx-algox", (Object[])new Object[0]));
            Long sysTaskId = calTaskInfo.getLong("taskid");
            DynamicObject schTask = QueryServiceHelper.queryOne((String)"sch_task", (String)"id,runat", (QFilter[])new QFilter("id", "=", (Object)sysTaskId.toString()).toArray());
            calTaskInfo.set("starttime", (Object)TimeServiceHelper.now());
            if (schTask != null) {
                calTaskInfo.set("runat", (Object)schTask.getString("runat"));
            }
            calTaskInfo.set("status", (Object)"B");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calTaskInfo});
            param.setCalNumber(calNumber);
            String calModel = CalDbParamServiceHelper.getString(CalDbParamConstant.CALC_MODEL, null);
            if ("B".equals(calModel) && 0 != param.getRunningModeMap().get(AccountTypeEnum.MOVEDAVG_INTIME.getValue())) {
                MoveAvgIntimeCalculateOutService service = new MoveAvgIntimeCalculateOutService(taskId);
                service.calCulateOut(param);
            } else {
                CalculateOutService service = new CalculateOutService(taskId);
                service.calCulateOut(param);
            }
        }
        catch (Throwable e) {
            String error = e.getLocalizedMessage();
            if (error != null && error.length() > 2000) {
                msgInfo.setContent(error.substring(1, 2000));
            } else {
                msgInfo.setContent(error);
            }
            logger.error("\u51fa\u5e93\u6838\u7b97\u540e\u53f0\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", e);
            calTaskInfo.set("status", (Object)"D");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calTaskInfo});
        }
        finally {
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
    }
}

