/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.formplugin.calculate.out;

import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.CalCulateOutParamEntry;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.StopSyncSettingModifyHelper;

public class CalculateOutTimedTask
extends AbstractTask {
    private String HOUR_PARAM = "hour";
    private String TIMES_PARAM = "times";
    private String WAITTIMEOUTMIN_PARAM = "waitTimeOutMins";
    private String RUNTIMEOUTMIN_PARAM = "runTimeOutMins";
    private Integer BALUPDATE_BATCHSIZE = CalDbParamServiceHelper.getInteger(CalDbParamConstant.BALUPDATE_BATCHSIZE);
    private static final Log logger = LogFactory.getLog(CalculateOutTimedTask.class);

    public void execute(RequestContext ctx, Map<String, Object> map) throws KDException {
        String hourStr;
        DataSet subTasks = null;
        int hour = 24;
        String waitTimeOutMinStr = (String)map.get(this.WAITTIMEOUTMIN_PARAM);
        String runTimeOutMinStr = (String)map.get(this.RUNTIMEOUTMIN_PARAM);
        String timesStr = (String)map.get(this.TIMES_PARAM);
        if (map != null && !StringUtils.isEmpty((String)(hourStr = (String)map.get(this.HOUR_PARAM)))) {
            hour = Integer.parseInt(hourStr);
        }
        try {
            String calNumber;
            Calendar now = Calendar.getInstance();
            now.set(11, now.get(11) - hour);
            QFilter mainTaskFilter = new QFilter("ismaintask", "=", (Object)"1");
            mainTaskFilter.and("starttime", ">", (Object)now.getTime());
            mainTaskFilter.and("status", "=", (Object)"B");
            mainTaskFilter.and("tasktype", "=", (Object)"A");
            DynamicObject[] allMainTasks = BusinessDataServiceHelper.load((String)"cal_task", (String)"id,calnumber,creator,status,endtime,params_tag", (QFilter[])mainTaskFilter.toArray());
            if (allMainTasks == null || allMainTasks.length == 0) {
                return;
            }
            HashMap<String, DynamicObject> allMainTaskMap = new HashMap<String, DynamicObject>(16);
            HashMap<String, String> calNumberParamMap = new HashMap<String, String>(16);
            for (DynamicObject info : allMainTasks) {
                calNumber = info.getString("calnumber");
                String params = info.getString("params_tag");
                calNumberParamMap.put(calNumber, params);
                allMainTaskMap.put(calNumber, info);
            }
            QFilter subTaskFilter = new QFilter("ismaintask", "=", (Object)"0");
            subTaskFilter.and("status", "!=", (Object)"A");
            subTaskFilter.and("status", "!=", (Object)"E");
            subTaskFilter.and("calnumber", "in", allMainTaskMap.keySet());
            subTaskFilter.and("tasktype", "=", (Object)"A");
            subTasks = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_task", (String)"calnumber", (QFilter[])subTaskFilter.toArray(), null).groupBy(new String[]{"calnumber"}).finish();
            HashSet<String> notSuccessCalNums = new HashSet<String>(16);
            for (Row row : subTasks) {
                calNumber = row.getString("calnumber");
                allMainTaskMap.remove(calNumber);
                notSuccessCalNums.add(calNumber);
            }
            this.updateCalBalance(allMainTaskMap);
            for (DynamicObject info : allMainTaskMap.values()) {
                info.set("status", (Object)"A");
                info.set("endtime", (Object)TimeServiceHelper.now());
            }
            if (!allMainTaskMap.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])allMainTaskMap.values().toArray(new DynamicObject[0]));
                for (DynamicObject info : allMainTaskMap.values()) {
                    String params = info.getString("params_tag");
                    CalCulateOutParams originParam = (CalCulateOutParams)JSONUtils.cast((String)params, CalCulateOutParams.class);
                    try {
                        Map<String, Integer> runningModeMap = originParam.getRunningModeMap();
                        CalOutDataRangeHolder holder = new CalOutDataRangeHolder(originParam);
                        this.releaseLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
                    }
                    catch (Exception excep) {
                        logger.error("\u51fa\u5e93\u6838\u7b97\u540e\u53f0\u4efb\u52a1\u542f\u52a8\u670d\u52a1\u5f02\u5e38", (Throwable)excep);
                    }
                    if (originParam.getCheckItems().get("E") == null) continue;
                    Long mainTaskId = info.getLong("id");
                    String timestamp = info.getString("calnumber");
                    Long creatorId = info.getLong("creator_id");
                    this.sendDataCheckJob(originParam, timestamp, mainTaskId, creatorId, "B");
                }
            }
            for (String calnumber : notSuccessCalNums) {
                HashMap<String, String> jobParams = new HashMap<String, String>();
                jobParams.put("isReStart", "true");
                jobParams.put("isTimedTask", "true");
                jobParams.put("calnumber", calnumber);
                jobParams.put(this.TIMES_PARAM, timesStr);
                jobParams.put(this.WAITTIMEOUTMIN_PARAM, waitTimeOutMinStr);
                jobParams.put(this.RUNTIMEOUTMIN_PARAM, runTimeOutMinStr);
                jobParams.put("params", (String)calNumberParamMap.get(calnumber));
                JobInfo job = new JobInfo();
                String OpName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u4e3b\u4efb\u52a1\u5b9a\u65f6\u91cd\u542f\u201c%1$s\u201d\uff0c\u64cd\u4f5c\u4eba\u201c%2$s\u201d\u3002", (String)"CalculateOutCostPlugin_24", (String)"fi-calx-algox", (Object[])new Object[0]);
                OpName = String.format(OpName, calnumber, RequestContext.get().getUserName());
                job.setName(OpName);
                job.setTaskDefineId("2TEFFDM0LS74");
                job.setJobType(JobType.BIZ);
                job.setParams(jobParams);
                job.setAppId("calx");
                job.setTaskClassname("kd.fi.calx.formplugin.calculate.out.CalculateOutPartitionTask");
                job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
                job.setRunByLang(Lang.get());
                JobClient.dispatch((JobInfo)job);
            }
        }
        catch (Throwable e) {
            logger.error("\u51fa\u5e93\u6838\u7b97\u5b9a\u65f6\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", e);
            throw new KDBizException(e, new ErrorCode("", ""), new Object[0]);
        }
        finally {
            if (subTasks != null) {
                subTasks.close();
            }
        }
    }

    private void updateCalBalance(Map<String, DynamicObject> allMainTaskMap) throws IOException {
        HashMap<String, Set> calNumberCostAccountIds = new HashMap<String, Set>(16);
        HashMap<String, Set> calNumberBillIdsMap = new HashMap<String, Set>(16);
        for (Map.Entry<String, DynamicObject> calNumberMainTaskEntry : allMainTaskMap.entrySet()) {
            String params = calNumberMainTaskEntry.getValue().getString("params_tag");
            CalCulateOutParams calCulateOutParams = (CalCulateOutParams)JSONUtils.cast((String)params, CalCulateOutParams.class);
            for (CalCulateOutParamEntry paramEntry : calCulateOutParams.getEntrys().values()) {
                Set accountIds = calNumberCostAccountIds.computeIfAbsent(calNumberMainTaskEntry.getKey(), k -> new HashSet(16));
                accountIds.add(paramEntry.getCostAccountId());
            }
        }
        if (!CalBalanceModelHelper.isNewBalance() || allMainTaskMap.isEmpty()) {
            return;
        }
        QFilter subTaskFilter = new QFilter("ismaintask", "=", (Object)"0");
        subTaskFilter.and("status", "=", (Object)"A");
        subTaskFilter.and("calnumber", "in", allMainTaskMap.keySet());
        subTaskFilter.and("tasktype", "=", (Object)"A");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_task", (String)"calnumber,resultparams_tag", (QFilter[])subTaskFilter.toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                String str = row.getString("resultparams_tag");
                if (StringUtils.isEmpty((String)str)) continue;
                Set set = (Set)JSONUtils.cast((String)str, Set.class);
                Set billIds = calNumberBillIdsMap.computeIfAbsent(row.getString("calnumber"), k -> new HashSet(16));
                billIds.addAll(set);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Set calNumberCostAccountIdSet = calNumberCostAccountIds.keySet();
        logger.info("\u4f59\u989d\u66f4\u65b0\u5171" + calNumberCostAccountIdSet.size() + "\u4e2a\u4e3b\u4efb\u52a1,\u5305\u542b\u4efb\u52a1\u53f7" + calNumberCostAccountIdSet);
        for (Map.Entry entry : calNumberCostAccountIds.entrySet()) {
            String calNumber = (String)entry.getKey();
            Set billIds = (Set)calNumberBillIdsMap.get(calNumber);
            if (billIds == null || billIds.isEmpty()) continue;
            HashSet<Object> partSet = new HashSet<Object>(this.BALUPDATE_BATCHSIZE);
            ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_bal", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, entry.getValue())});
            Throwable throwable = null;
            try {
                ctx.set();
                logger.info("\u4f59\u989d\u66f4\u65b0\u4efb\u52a1\u53f7" + calNumber + "\u5171" + billIds.size() / this.BALUPDATE_BATCHSIZE + "\u6279\u5355\u636e");
                int i = 0;
                for (Object id : billIds) {
                    partSet.add(id);
                    if (partSet.size() <= this.BALUPDATE_BATCHSIZE) continue;
                    logger.info("\u4f59\u989d\u66f4\u65b0\u4efb\u52a1\u53f7" + calNumber + "\u7b2c" + i++ + "\u6279");
                    this.updateNewBal(partSet);
                    partSet.clear();
                }
                if (partSet.isEmpty()) continue;
                this.updateNewBal(partSet);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctx.close();
            }
        }
    }

    private void releaseLock(Map<String, Integer> runningModeMap, Set<Long> calOrgIdSet) {
        if (runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.MOVEDAVG_INTIME.getValue(), null, new HashSet<Long>(), false);
        }
        if (runningModeMap.get(AccountTypeEnum.FIFO.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.FIFO.getValue(), null, new HashSet<Long>(), false);
        }
    }

    private void sendDataCheckJob(CalCulateOutParams originParam, String timestamp, Long mainTaskId, Long creatorId, String checkTaskType) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        try {
            jobParams.put("params", JSONUtils.toString((Object)originParam));
            jobParams.put("maintaskid", mainTaskId);
            jobParams.put("checktasktype", checkTaskType);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        JobInfo job = new JobInfo();
        String OpName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u4e3b\u4efb\u52a1\u201c%1$s\u201d\u8c03\u7528\u51fa\u5e93\u6838\u7b97\uff08\u540e\uff09\u68c0\u67e5\uff0c\u64cd\u4f5c\u4eba\u201c%2$s\u201d\u3002", (String)"CalculateOutCostPlugin_25", (String)"fi-calx-algox", (Object[])new Object[0]);
        OpName = String.format(OpName, timestamp, RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId("2TEFJ=VTERCM");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("calx");
        job.setTaskClassname("kd.fi.calx.formplugin.calculate.out.CalculateOutDataCheckTask");
        job.setRunByUserId(creatorId.longValue());
        job.setRunByLang(Lang.get());
        JobClient.dispatch((JobInfo)job);
    }

    private void updateNewBal(Set<Object> partSet) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"updatebal", (String)"cal_costrecord_subentity", (Object[])partSet.toArray(), (OperateOption)OperateOption.create());
        List errors = result.getAllErrorOrValidateInfo();
        StringBuilder msg = new StringBuilder();
        if (!errors.isEmpty()) {
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
        }
        if (!result.isSuccess()) {
            msg.append(result.getMessage()).append('\n');
        }
        if (msg.length() > 0) {
            throw new KDBizException(msg.toString());
        }
    }
}

