/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.formplugin.calculate.out;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class QuerySchemeHolder {
    private static final String SCHEME_ENTITY = "cal_query_scheme";
    private final String formId;
    private IFormView view;
    private boolean isAddScheme = false;
    private static final String IS_ADD_SCHEME_CACHE_KEY = "isAddSchemeCacheKey";
    private String schemeEntryKey = "scheme_entry";
    private String schemeIdField_entry = "schemeid_entry";
    private String schemeNameField_entry = "schemename_entry";
    private String schemeIsdefaultField_entry = "isdefaultscheme_entry";
    private String isDefaultField_set = "isdefault_set";
    private String schemeNameField_set = "schemename_set";
    private String filter_split = "filtersplit";
    private Set<String> removeEntities = new HashSet<String>(16);
    private static final String INIT_SCHEMESTR_CACHE = "initschemestr";
    private static final String CUST_FILTERS = "custfilters";
    private static final String CUST_SELECTROWS = "custselectrows";

    public QuerySchemeHolder(IFormView view) {
        this.view = view;
        DynamicObject dataEntityDyc = this.view.getModel().getDataEntity(true);
        this.formId = dataEntityDyc.getDataEntityType().getExtendName();
    }

    public void initSchemesList() {
        DynamicObjectCollection schemeDycs = this.getSchemeDycsByUser();
        if (schemeDycs.isEmpty()) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(this.schemeIdField_entry, new Object[0]);
        vs.addField(this.schemeNameField_entry, new Object[0]);
        vs.addField(this.schemeIsdefaultField_entry, new Object[0]);
        for (DynamicObject item : schemeDycs) {
            Long schemeId = item.getLong("id");
            String schemeName = item.getString("name");
            String isdefaultScheme = item.getString("isdefault");
            vs.addRow(new Object[]{schemeId, schemeName, isdefaultScheme});
        }
        this.view.getModel().beginInit();
        this.view.getModel().deleteEntryData(this.schemeEntryKey);
        int rowCount = vs.getCount();
        if (rowCount != 0) {
            ((AbstractFormDataModel)this.view.getModel()).batchCreateNewEntryRow(this.schemeEntryKey, vs);
        }
        this.view.getModel().endInit();
        this.view.updateView(this.schemeEntryKey);
    }

    public void setDefaultScheme() {
        String isInit = this.view.getPageCache().get("isinit");
        int entryRowCount = this.view.getModel().getEntryRowCount(this.schemeEntryKey);
        if (isInit != null || entryRowCount < 1) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.view.getControl(this.schemeEntryKey);
        entryGrid.selectRows(0);
        this.view.getPageCache().put("isinit", "");
        DynamicObject formDataEntityDyc = this.view.getModel().getDataEntity(true);
        String schemeStr = this.toJson(formDataEntityDyc);
        this.view.getPageCache().put(INIT_SCHEMESTR_CACHE, schemeStr);
    }

    public DynamicObject saveScheme() {
        int index;
        DynamicObjectCollection formSchemeDycs;
        Object entrySchemeName;
        DynamicObject formDataEntityDyc = this.view.getModel().getDataEntity(true);
        int currentRow = this.view.getModel().getEntryCurrentRowIndex(this.schemeEntryKey);
        Object selSchemeId = this.view.getModel().getValue(this.schemeIdField_entry, currentRow);
        boolean isNew = selSchemeId == null || selSchemeId.equals(0L) || this.view.getPageCache().get(IS_ADD_SCHEME_CACHE_KEY) != null;
        String setSchemeName = formDataEntityDyc.getString(this.schemeNameField_set);
        if (!setSchemeName.equals(entrySchemeName = this.view.getModel().getValue(this.schemeNameField_entry, currentRow))) {
            isNew = true;
        }
        DynamicObject schemeDyc = this.buildSchemeDyc(selSchemeId, isNew);
        String lockKey = this.formId + schemeDyc.getString("name");
        try (DLock lock = DLock.create((String)lockKey, (String)"fi-cal-QuerySchemeHolder");){
            lock.lock();
            this.checkHasSameNameScheme(schemeDyc);
            this.invokeSaveScheme(new DynamicObject[]{schemeDyc});
        }
        if (schemeDyc.getBoolean("isdefault")) {
            this.setOtherSchemeNotDefault(schemeDyc.getPkValue());
        }
        if (!isNew) {
            this.view.getModel().deleteEntryRow(this.schemeEntryKey, currentRow);
        }
        if ((formSchemeDycs = formDataEntityDyc.getDynamicObjectCollection(this.schemeEntryKey)).isEmpty()) {
            index = this.view.getModel().createNewEntryRow(this.schemeEntryKey);
        } else {
            index = !((DynamicObject)formSchemeDycs.get(0)).getBoolean(this.schemeIsdefaultField_entry) ? 0 : 1;
            this.view.getModel().insertEntryRow(this.schemeEntryKey, index);
        }
        this.view.getModel().setValue(this.schemeNameField_entry, schemeDyc.get("name"), index);
        this.view.getModel().setValue(this.schemeIsdefaultField_entry, schemeDyc.get("isdefault"), index);
        this.view.getModel().setValue(this.schemeIdField_entry, schemeDyc.getPkValue(), index);
        EntryGrid entryGrid = (EntryGrid)this.view.getControl(this.schemeEntryKey);
        entryGrid.selectRows(index);
        this.view.getPageCache().remove(IS_ADD_SCHEME_CACHE_KEY);
        this.view.getModel().setDataChanged(false);
        return schemeDyc;
    }

    private void checkHasSameNameScheme(DynamicObject schemeDyc) {
        QFilter formIdFilter = new QFilter("formid", "=", (Object)this.formId);
        QFilter nameFilter = new QFilter("name", "=", (Object)schemeDyc.getString("name"));
        QFilter idFilter = new QFilter("id", "!=", schemeDyc.getPkValue());
        boolean isHasSameNameScheme = QueryServiceHelper.exists((String)SCHEME_ENTITY, (QFilter[])new QFilter[]{formIdFilter, nameFilter, idFilter});
        if (isHasSameNameScheme) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\uff0c%s: \u201c\u540d\u79f0\u201d \u91cd\u590d\u6216\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4f7f\u7528\u3002", (String)"QuerySchemeHolder_2", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            msg = String.format(msg, schemeDyc.getString("name"));
            throw new KDBizException(msg);
        }
    }

    private void invokeSaveScheme(DynamicObject[] schemeDycs) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)SCHEME_ENTITY, (DynamicObject[])schemeDycs, (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\uff0c", (String)"QuerySchemeHolder_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            if (errors.isEmpty()) {
                msg.append(result.getMessage()).append('\n');
            }
            throw new KDBizException(msg.toString());
        }
        this.syncSchemeAutoOp(schemeDycs);
    }

    private void syncSchemeAutoOp(DynamicObject[] schemeDycs) {
        HashMap<Object, DynamicObject> schemeIdDycMap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject dynamicObject : schemeDycs) {
            schemeIdDycMap.put(dynamicObject.getPkValue(), dynamicObject);
        }
        HashSet<Object> hasAutoIds = new HashSet<Object>(16);
        QFilter schemeIdsf = new QFilter("queryscheme", "in", schemeIdDycMap.keySet());
        Throwable throwable = null;
        try (DataSet schemeAutoDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_query_scheme_autoop", (String)"queryscheme", (QFilter[])new QFilter[]{schemeIdsf}, null);){
            for (Row row : schemeAutoDs) {
                hasAutoIds.add(row.get("queryscheme"));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        this.updateAutoSchemeInfo(schemeIdDycMap, hasAutoIds);
        ArrayList<DynamicObject> newSchemeAutoDycs = new ArrayList<DynamicObject>(16);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cal_query_scheme_autoop");
        for (DynamicObject schemeDyc3 : schemeIdDycMap.values()) {
            if (hasAutoIds.contains(schemeDyc3.getPkValue())) continue;
            DynamicObject newSchemeAutoDyc = new DynamicObject((DynamicObjectType)mainEntityType);
            newSchemeAutoDyc.set("queryscheme", schemeDyc3.getPkValue());
            newSchemeAutoDyc.set("number", (Object)schemeDyc3.getString("name"));
            newSchemeAutoDyc.set("name", (Object)schemeDyc3.getString("name"));
            newSchemeAutoDycs.add(newSchemeAutoDyc);
        }
        if (newSchemeAutoDycs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newSchemeAutoDycs.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject buildSchemeDyc(Object selSchemeId, boolean isNew) {
        DynamicObject[] schemeDycs;
        DynamicObject formDataEntityDyc = this.view.getModel().getDataEntity(true);
        String name = formDataEntityDyc.getString(this.schemeNameField_set);
        DynamicObject schemeDyc = isNew ? this.createSchemeDyc(name) : ((schemeDycs = BusinessDataServiceHelper.load((Object[])new Object[]{selSchemeId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY))).length > 0 ? schemeDycs[0] : this.createSchemeDyc(name));
        String schemeStr = this.toJson(formDataEntityDyc);
        schemeDyc.set("name", (Object)name);
        schemeDyc.set("formid", (Object)this.formId);
        schemeDyc.set("org", (Object)RequestContext.get().getOrgId());
        schemeDyc.set("modifier", (Object)RequestContext.get().getCurrUserId());
        if (schemeDyc.getDataEntityState().getFromDatabase()) {
            schemeDyc.set("modifytime", (Object)new Date());
        }
        schemeDyc.set("schemestr_tag", (Object)schemeStr);
        if (!this.isDefaultField_set.isEmpty()) {
            schemeDyc.set("isdefault", (Object)formDataEntityDyc.getBoolean(this.isDefaultField_set));
        }
        return schemeDyc;
    }

    public void deleteScheme() {
        int[] selectRows = ((EntryGrid)this.view.getControl(this.schemeEntryKey)).getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        int currentRow = selectRows[0];
        Long schemeId = (Long)this.view.getModel().getValue(this.schemeIdField_entry, currentRow);
        this.view.getModel().deleteEntryRow(this.schemeEntryKey, currentRow);
        DeleteServiceHelper.delete((String)SCHEME_ENTITY, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        DeleteServiceHelper.delete((String)"cal_query_scheme_autoop", (QFilter[])new QFilter[]{new QFilter("queryscheme", "=", (Object)schemeId)});
    }

    public void addScheme() {
        this.isAddScheme = true;
        EntryGrid entryGrid = (EntryGrid)this.view.getControl(this.schemeEntryKey);
        entryGrid.selectRows(-1);
        this.resetScheme();
        this.view.getPageCache().put(IS_ADD_SCHEME_CACHE_KEY, "");
    }

    public void resetScheme() {
        this.isAddScheme = true;
        String filterSchemeStr = this.view.getPageCache().get(INIT_SCHEMESTR_CACHE);
        DynamicObject dbFormDataDyc = this.toDynamicObject(filterSchemeStr);
        this.setDbValue2FomValue(dbFormDataDyc);
        this.view.updateView(this.filter_split);
    }

    private DynamicObject createSchemeDyc(String name) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY);
        DynamicObject schemeDyc = new DynamicObject((DynamicObjectType)dataEntityType);
        Date now = new Date();
        schemeDyc.set("number", (Object)name);
        schemeDyc.set("creator", (Object)RequestContext.get().getCurrUserId());
        schemeDyc.set("createtime", (Object)now);
        schemeDyc.set("modifytime", (Object)now);
        schemeDyc.set("status", (Object)"C");
        schemeDyc.set("enable", (Object)"1");
        schemeDyc.set("id", (Object)DB.genLongId((String)dataEntityType.getAlias()));
        return schemeDyc;
    }

    private void setOtherSchemeNotDefault(Object selSchemeId) {
        DynamicObject[] otherSchemeDycs;
        int entryRowCount = this.view.getModel().getEntryRowCount(this.schemeEntryKey);
        HashSet<Object> schemeIds = new HashSet<Object>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            Object schemeId = this.view.getModel().getValue(this.schemeIdField_entry, i);
            if (!((Boolean)this.view.getModel().getValue(this.schemeIsdefaultField_entry, i)).booleanValue() || schemeId.equals(selSchemeId)) continue;
            schemeIds.add(schemeId);
            this.view.getModel().setValue(this.schemeIsdefaultField_entry, (Object)Boolean.FALSE, i);
            this.view.updateView(this.schemeIsdefaultField_entry, i);
        }
        for (DynamicObject ohterSchemeDyc : otherSchemeDycs = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY))) {
            ohterSchemeDyc.set("isdefault", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])otherSchemeDycs);
    }

    public DynamicObject getScheme(Long schemeId) {
        DynamicObject schemeDyc = null;
        QFilter idf = new QFilter("id", "=", (Object)schemeId);
        DynamicObjectCollection schemeDycs = QueryServiceHelper.query((String)this.getClass().getName(), (String)SCHEME_ENTITY, (String)"id,name,isdefault,schemestr_tag", (QFilter[])idf.toArray(), null);
        if (schemeDycs.size() > 0) {
            schemeDyc = (DynamicObject)schemeDycs.get(0);
        }
        return schemeDyc;
    }

    private DynamicObjectCollection getSchemeDycsByUser() {
        QFilter formIdf = new QFilter("formid", "=", (Object)this.formId);
        QFilter curUserf = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(formIdf);
        filters.add(curUserf);
        DynamicObjectCollection schemeDycs = QueryServiceHelper.query((String)this.getClass().getName(), (String)SCHEME_ENTITY, (String)"id,name,isdefault,schemestr", (QFilter[])filters.toArray(new QFilter[0]), (String)"isdefault desc,modifytime desc");
        return schemeDycs;
    }

    public void setScheme(int row) {
        Long schemeId = (Long)this.view.getModel().getValue(this.schemeIdField_entry, row);
        this.setScheme(schemeId);
        this.view.getModel().setDataChanged(false);
    }

    public void setScheme(Long schemeId) {
        if (schemeId == null || schemeId.equals(0L)) {
            return;
        }
        DynamicObject schemeDyc = this.getScheme(schemeId);
        if (schemeDyc == null) {
            return;
        }
        String filterSchemeStr = schemeDyc.getString("schemestr_tag");
        DynamicObject dbFormDataDyc = this.toDynamicObject(filterSchemeStr);
        this.setDbValue2FomValue(dbFormDataDyc);
        boolean desigoutweightedavgat = dbFormDataDyc.getBoolean("desigoutweightedavgat");
        boolean coverdesigoutcost = dbFormDataDyc.getBoolean("coverdesigoutcost");
        if (desigoutweightedavgat) {
            this.view.setEnable(Boolean.valueOf(true), new String[]{"desigoutweightedavgat"});
        }
        if (coverdesigoutcost) {
            this.view.setEnable(Boolean.valueOf(true), new String[]{"coverdesigoutcost"});
        }
        this.view.updateView(this.filter_split);
        this.view.getModel().setValue(this.schemeNameField_set, schemeDyc.get("name"));
        this.view.getModel().setValue(this.isDefaultField_set, schemeDyc.get("isdefault"));
        this.view.getPageCache().remove(IS_ADD_SCHEME_CACHE_KEY);
        this.selectEntryRows(filterSchemeStr);
    }

    public Long getCurSchemeId() {
        int currentRow = this.view.getModel().getEntryCurrentRowIndex(this.schemeEntryKey);
        Object curSchemeId = this.view.getModel().getValue(this.schemeIdField_entry, currentRow);
        if (curSchemeId == null) {
            curSchemeId = 0L;
        }
        return (Long)curSchemeId;
    }

    private void setDbValue2FomValue(DynamicObject dbFormDataDyc) {
        MainEntityType newFormDataEntityType = this.view.getModel().getDataEntityType();
        FormRoot rootControl = (FormRoot)this.view.getRootControl();
        this.setDbValue2FomValue((Container)rootControl, dbFormDataDyc, (DynamicObjectType)newFormDataEntityType, 0);
        this.view.getModel().beginInit();
        Map allEntities = newFormDataEntityType.getAllEntities();
        this.removeEntities.add(this.formId);
        this.removeEntities.add(this.schemeEntryKey);
        for (Map.Entry item : allEntities.entrySet()) {
            if (this.removeEntities.contains(item.getKey())) continue;
            DynamicObjectCollection dbEntryDycs = dbFormDataDyc.getDynamicObjectCollection((String)item.getKey());
            this.view.getModel().deleteEntryData((String)item.getKey());
            if (dbEntryDycs.isEmpty()) continue;
            this.view.getModel().batchCreateNewEntryRow((String)item.getKey(), dbEntryDycs.size());
            for (int i = 0; i < dbEntryDycs.size(); ++i) {
                this.setDbValue2FomValue((Container)this.view.getControl((String)item.getKey()), (DynamicObject)dbEntryDycs.get(i), (DynamicObjectType)item.getValue(), i);
            }
        }
        this.view.getModel().endInit();
    }

    private void setDbValue2FomValue(Container container, DynamicObject dbFormDataDyc, DynamicObjectType newFormDataEntityType, int index) {
        HashSet<String> keySet = new HashSet<String>(16);
        this.initFilterFieldKeySet(keySet, container);
        DataEntityPropertyCollection dbProps = dbFormDataDyc.getDynamicObjectType().getProperties();
        for (IDataEntityProperty formProps : newFormDataEntityType.getProperties()) {
            boolean isContainsKeyTag;
            String replaceTag = formProps.getName();
            if (!StringUtils.isEmpty((CharSequence)replaceTag) && replaceTag.contains("_tag")) {
                replaceTag = formProps.getName().replace("_tag", "");
            }
            if (!(isContainsKeyTag = keySet.contains(replaceTag) && dbProps.containsKey((Object)replaceTag))) continue;
            Object val = dbFormDataDyc.get(formProps.getName());
            if (this.isAddScheme && formProps instanceof FieldProp) {
                val = ((FieldProp)formProps).getDefValue();
            }
            this.view.getModel().setValue(formProps.getName(), val, index);
        }
    }

    private String toJson(DynamicObject filterObj) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(filterObj.getDynamicObjectType());
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        String filterStr = jser.serializeToString((Object)filterObj, null);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put(CUST_FILTERS, filterStr);
        Map entityEntitypeMap = EntityMetadataCache.getDataEntityType((String)filterObj.getDataEntityType().getName()).getAllEntities();
        HashMap entrySelRowsMap = new HashMap(16);
        for (Map.Entry entityTypeEntry : entityEntitypeMap.entrySet()) {
            if (!(entityTypeEntry.getValue() instanceof EntryType) || this.schemeEntryKey.equals(entityTypeEntry.getKey())) continue;
            int[] selectRows = ((EntryGrid)this.view.getControl((String)entityTypeEntry.getKey())).getSelectRows();
            entrySelRowsMap.put(entityTypeEntry.getKey(), selectRows);
        }
        param.put(CUST_SELECTROWS, entrySelRowsMap);
        return SerializationUtils.toJsonString(param);
    }

    private DynamicObject toDynamicObject(String schemeJson) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.formId);
        if (StringUtils.isEmpty((CharSequence)schemeJson)) {
            return new DynamicObject((DynamicObjectType)type);
        }
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String custfilters = (String)filterMap.get(CUST_FILTERS);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject fromDataDyc = (DynamicObject)jser.deserializeFromString(custfilters, null);
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{fromDataDyc}, (IDataEntityType)type);
        return fromDataDyc;
    }

    private void initFilterFieldKeySet(Set<String> keySet, Container container) {
        for (Control control : container.getItems()) {
            if (control instanceof DateRangeEdit) {
                DateRangeEdit rangeEdit = (DateRangeEdit)control;
                keySet.add(rangeEdit.getStartDateFieldKey());
                keySet.add(rangeEdit.getEndDateFieldKey());
                continue;
            }
            if (control instanceof FieldEdit) {
                keySet.add(control.getKey());
                continue;
            }
            if (!(control instanceof Container)) continue;
            this.initFilterFieldKeySet(keySet, (Container)control);
        }
    }

    public void setIsDefaultField_set(String isDefaultField_set) {
        this.isDefaultField_set = isDefaultField_set;
    }

    public void setSchemeNameField_set(String schemeNameField_set) {
        this.schemeNameField_set = schemeNameField_set;
    }

    public void setSchemeEntryKey(String schemeEntryKey) {
        this.schemeEntryKey = schemeEntryKey;
    }

    public void setSchemeIdField_entry(String schemeId) {
        this.schemeIdField_entry = schemeId;
    }

    public void setSchemeNameField_entry(String schemeNameField_entry) {
        this.schemeNameField_entry = schemeNameField_entry;
    }

    public void setSchemeIsdefaultField_entry(String schemeIsdefaultField_entry) {
        this.schemeIsdefaultField_entry = schemeIsdefaultField_entry;
    }

    public void removeEntities(Collection<String> entities) {
        this.removeEntities.removeAll(entities);
    }

    public void removeEntities(String entity) {
        this.removeEntities.remove(entity);
    }

    public void setFilter_split(String filter_split) {
        this.filter_split = filter_split;
    }

    private void selectEntryRows(String filterSchemeStr) {
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)filterSchemeStr, HashMap.class);
        Map entrySelRowsMap = (Map)filterMap.get(CUST_SELECTROWS);
        if (entrySelRowsMap != null) {
            for (Map.Entry entrySelRowsEntry : entrySelRowsMap.entrySet()) {
                List selectRowIndexs;
                Control entryGrid = this.view.getControl((String)entrySelRowsEntry.getKey());
                if (!(entryGrid instanceof EntryGrid) || (selectRowIndexs = (List)entrySelRowsEntry.getValue()).isEmpty()) continue;
                int[] selectRowIndexArrays = new int[selectRowIndexs.size()];
                for (int i = 0; i < selectRowIndexs.size(); ++i) {
                    selectRowIndexArrays[i] = (Integer)selectRowIndexs.get(i);
                }
                ((EntryGrid)entryGrid).selectRows(selectRowIndexArrays, 0);
            }
        }
    }

    private void updateAutoSchemeInfo(Map<Object, DynamicObject> schemeIdDycMap, Set<Object> hasAutoIds) {
        DynamicObject[] autoSchemeDycs;
        for (DynamicObject autoSchemeDyc : autoSchemeDycs = BusinessDataServiceHelper.load((String)"cal_query_scheme_autoop", (String)"number,name,queryscheme.id", (QFilter[])new QFilter[]{new QFilter("queryscheme.id", "in", hasAutoIds)})) {
            DynamicObject querySchemeDyc = autoSchemeDyc.getDynamicObject("queryscheme");
            if (querySchemeDyc == null) continue;
            Object querySchemeId = querySchemeDyc.getPkValue();
            DynamicObject schemeDyc = schemeIdDycMap.get(querySchemeId);
            autoSchemeDyc.set("number", (Object)schemeDyc.getString("name"));
            autoSchemeDyc.set("name", (Object)schemeDyc.getString("name"));
        }
        SaveServiceHelper.save((DynamicObject[])autoSchemeDycs);
    }
}

