/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.formplugin.calculate.out;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.formplugin.calculate.out.QuerySchemeHolder;

public class SchemeSettingPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String SAVE_SCHEME_OP_KEY = "savescheme";
    private static final String DELETE_SCHEME_OP_KEY = "deletescheme";
    private static final String ADD_SCHEME_OP_KEY = "addscheme";
    private static final String RESET_SCHEME_OP_KEY = "resetcheme";
    private String schemeEntryKey = "scheme_entry";
    private static final String BUTTONAP_KEY = "buttonap";
    private static final Long[] CHECKTASK_ID = new Long[]{1228995490352290816L, 1234050040448761856L};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
        holder.initSchemesList();
        this.reloadCheckItemList();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
        holder.setDefaultScheme();
        this.afterSelScheme();
        this.getView().getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.schemeEntryKey);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Button defaultBtn = (Button)this.getView().getControl(BUTTONAP_KEY);
        defaultBtn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (BUTTONAP_KEY.equals(source.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.schemeEntryKey);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            entryGrid.selectRows(selectRows[0]);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        if (event.getOperationResult() == null || !event.getOperationResult().isSuccess()) {
            return;
        }
        String opKey = event.getOperateKey();
        if (SAVE_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.saveScheme();
        } else if (DELETE_SCHEME_OP_KEY.equals(opKey)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(this.schemeEntryKey)).getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"QuerySchemeHolder_0", (String)"fi-calx-algox", (Object[])new Object[0]));
                event.getOperationResult().setShowMessage(false);
                return;
            }
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.deleteScheme();
        } else if (ADD_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.addScheme();
            this.reloadCheckItemList();
        } else if (RESET_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.resetScheme();
            this.reloadCheckItemList();
        }
    }

    public void entryRowClick(RowClickEvent e) {
        String key = ((EntryGrid)e.getSource()).getKey();
        if (this.schemeEntryKey.equals(key)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.setScheme(e.getRow());
            this.afterSelScheme();
            this.setCheckItem();
            this.getView().getModel().setDataChanged(false);
            this.setCheckItemEnable();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        if (e.getCallBackId().equals("close")) {
            boolean isClose = true;
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().getPageCache().put("isclose", String.valueOf(true));
                this.getView().close();
            } else if (MessageBoxResult.Cancel.equals((Object)result)) {
                isClose = false;
            }
            this.getView().getPageCache().put("isclose", String.valueOf(isClose));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean isDataChange = this.getModel().getDataChanged();
        boolean isClose = "true".equals(this.getView().getPageCache().get("isclose"));
        if (isDataChange && !isClose) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("close", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillView_2", (String)"bos-form-mvc", (Object[])new Object[0]);
            this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, callBackListener, btnNameMaps);
            e.setCancel(true);
        }
    }

    private void reloadCheckItemList() {
        String entryKey = "checkentry";
        DynamicObjectCollection checkItems = QueryServiceHelper.query((String)"cal_datacheck_task", (String)"purpose,entryentity.checkitem,entryentity.checkitem.number,entryentity.entryenable,entryentity.level", (QFilter[])new QFilter("id", "in", (Object)CHECKTASK_ID).toArray(), (String)"purpose asc,entryentity.checkitem.number asc");
        if (checkItems.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(entryKey);
        this.getModel().batchCreateNewEntryRow(entryKey, checkItems.size());
        int row = 0;
        for (DynamicObject item : checkItems) {
            this.getModel().setValue("purpose", (Object)item.getString("purpose"), row);
            this.getModel().setValue("checkitem", (Object)item.getLong("entryentity.checkitem"), row);
            this.getModel().setValue("ischeck", (Object)item.getBoolean("entryentity.entryenable"), row);
            if (this.needCheckPreCost() && this.hasTargetItem(item)) {
                this.getModel().setValue("ischeck", (Object)Boolean.TRUE, row);
            }
            this.getModel().setValue("level", (Object)item.getString("entryentity.level"), row);
            ++row;
        }
        this.setCheckItemEnable();
        this.getView().updateView(entryKey);
    }

    private boolean hasTargetItem(DynamicObject item) {
        return item.getString("entryentity.checkitem.number") == null ? false : "CALOUT-ITEM-06".equals(item.getString("entryentity.checkitem.number"));
    }

    private void setCurrentPeriod() {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        HashMap<Long, Long> accountIdPeriodIdMap = new HashMap<Long, Long>(16);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject currentPeriodDyc;
            long costAccountId;
            DynamicObject costAccountDyc = (DynamicObject)this.getModel().getValue("costaccount", i);
            Long periodId = null;
            if (costAccountDyc != null && ((periodId = (Long)accountIdPeriodIdMap.get(costAccountId = costAccountDyc.getLong("id"))) == null || periodId.equals(0L)) && (currentPeriodDyc = PeriodHelper.getCurrentPeriod(costAccountId)) != null) {
                periodId = currentPeriodDyc.getLong("id");
                accountIdPeriodIdMap.put(costAccountId, periodId);
            }
            this.getModel().setValue("period", periodId, i);
        }
    }

    private void setMatToEnable() {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entry").get(rowIndex);
            DynamicObjectCollection materialFrom = entry.getDynamicObjectCollection("materialfrom");
            int size = materialFrom.size();
            this.getModel().beginInit();
            if (size > 1) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialto"});
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialto"});
            }
            this.getModel().endInit();
            this.getView().updateView("materialto", rowIndex);
        }
    }

    private boolean needCheckPreCost() {
        boolean needCheckPreCost = false;
        int mainRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < mainRowCount; ++i) {
            AppParam appParam;
            Boolean deleteprecostadj;
            Long calOrgId;
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entry").get(i);
            Long l = calOrgId = entry.getDynamicObject("calorg") == null ? null : Long.valueOf(entry.getDynamicObject("calorg").getLong("id"));
            if (calOrgId == null || (deleteprecostadj = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)(appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L))), (String)"deleteprecostadj")) != null && !deleteprecostadj.booleanValue()) continue;
            needCheckPreCost = true;
            break;
        }
        return needCheckPreCost;
    }

    private void setCheckItemEnable() {
        int entryRowCount = this.getModel().getEntryRowCount("checkentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("checkentry").get(i);
            String checkItemNumber = entry.getDynamicObject("checkitem") == null ? null : entry.getDynamicObject("checkitem").getString("number");
            boolean ischeck = entry.getBoolean("ischeck");
            this.getModel().beginInit();
            if (checkItemNumber != null && checkItemNumber.length() != 0 && "CALOUT-ITEM-06".equals(checkItemNumber) && ischeck) {
                if (this.needCheckPreCost()) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"ischeck"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"ischeck"});
                }
            }
            this.getModel().endInit();
            this.getView().updateView("ischeck", i);
        }
    }

    private void setCheckItem() {
        DynamicObjectCollection checkItems = this.getModel().getEntryEntity("checkentry");
        boolean isHasNewCheck = false;
        for (Object checkItem : checkItems) {
            if (!"D".equals(checkItem.getString("purpose"))) continue;
            isHasNewCheck = true;
            break;
        }
        HashMap<Long, Boolean> itemIsCheckMap = new HashMap<Long, Boolean>(16);
        for (DynamicObject item : checkItems) {
            Long itemId = item.getDynamicObject("checkitem").getLong("id");
            Boolean ischeck = item.getBoolean("ischeck");
            itemIsCheckMap.put(itemId, ischeck);
        }
        this.getModel().deleteEntryData("checkentry");
        DynamicObjectCollection newCheckItems = QueryServiceHelper.query((String)"cal_datacheck_task", (String)"purpose,entryentity.checkitem,entryentity.checkitem.number,entryentity.entryenable,entryentity.level", (QFilter[])new QFilter("id", "in", (Object)CHECKTASK_ID).toArray(), (String)"purpose asc,entryentity.checkitem.number asc");
        if (newCheckItems.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("checkentry", newCheckItems.size());
        if (!isHasNewCheck) {
            int row = 0;
            for (DynamicObject item : newCheckItems) {
                this.getModel().setValue("purpose", (Object)item.getString("purpose"), row);
                this.getModel().setValue("checkitem", (Object)item.getLong("entryentity.checkitem"), row);
                this.getModel().setValue("ischeck", (Object)item.getBoolean("entryentity.entryenable"), row);
                if (this.needCheckPreCost() && this.hasTargetItem(item)) {
                    this.getModel().setValue("ischeck", (Object)Boolean.TRUE, row);
                }
                this.getModel().setValue("level", (Object)item.getString("entryentity.level"), row);
                ++row;
            }
        } else {
            int row = 0;
            for (DynamicObject item : newCheckItems) {
                Long itemId = item.getLong("entryentity.checkitem");
                this.getModel().setValue("purpose", (Object)item.getString("purpose"), row);
                this.getModel().setValue("checkitem", (Object)itemId, row);
                this.getModel().setValue("ischeck", (Object)item.getBoolean("entryentity.entryenable"), row);
                this.getModel().setValue("level", (Object)item.getString("entryentity.level"), row);
                Boolean ischeck = (Boolean)itemIsCheckMap.get(itemId);
                if (ischeck != null) {
                    this.getModel().setValue("ischeck", (Object)ischeck, row);
                }
                if (this.needCheckPreCost() && this.hasTargetItem(item)) {
                    this.getModel().setValue("ischeck", (Object)Boolean.TRUE, row);
                }
                ++row;
            }
        }
        this.getView().updateView("checkentry");
    }

    private void afterSelScheme() {
        this.removeUnableAcct();
        this.setCurrentPeriod();
        this.setMatToEnable();
        this.setPartitionTaskParams();
        this.setFIFOPeriodDefaultValue();
    }

    private void setFIFOPeriodDefaultValue() {
        String fifo_period = (String)this.getModel().getValue("fifo_period");
        if (fifo_period == null) {
            this.getModel().setValue("fifo_period", (Object)Character.valueOf('0'));
        }
    }

    private void setPartitionTaskParams() {
        Integer concurrency = (Integer)this.getModel().getValue("concurrency");
        Integer batchmatsize = (Integer)this.getModel().getValue("batchmatsize");
        Integer batchrowsize = (Integer)this.getModel().getValue("batchrowsize");
        if (concurrency == null || concurrency == 0) {
            this.getModel().setValue("concurrency", (Object)2000);
        }
        if (batchmatsize == null || batchmatsize == 0) {
            this.getModel().setValue("batchmatsize", (Object)100);
        }
        if (batchrowsize == null || batchrowsize == 0) {
            this.getModel().setValue("batchrowsize", (Object)50000);
        }
    }

    private void removeUnableAcct() {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        HashSet<Long> accountIds = new HashSet<Long>(16);
        for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
            if (costAccount == null) continue;
            Long accountId = (Long)costAccount.getPkValue();
            accountIds.add(accountId);
        }
        QFilter idsF = new QFilter("id", "in", accountIds);
        QFilter unableF = new QFilter("enable", "=", (Object)Boolean.FALSE);
        List unableAccontIds = QueryServiceHelper.queryPrimaryKeys((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{idsF, unableF}, null, (int)-1);
        HashSet<Long> unableAccountIdSet = new HashSet<Long>(16);
        for (Object accountId : unableAccontIds) {
            unableAccountIdSet.add((Long)accountId);
        }
        ArrayList<Integer> deleteRowIndexs = new ArrayList<Integer>(16);
        for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
            Long curAccountId;
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
            if (costAccount == null || !unableAccountIdSet.contains(curAccountId = (Long)costAccount.getPkValue())) continue;
            deleteRowIndexs.add(rowIndex);
        }
        if (deleteRowIndexs.size() > 0) {
            int[] newDeleteRows = new int[deleteRowIndexs.size()];
            for (int i = 0; i < deleteRowIndexs.size(); ++i) {
                newDeleteRows[i] = (Integer)deleteRowIndexs.get(i);
            }
            this.getView().getModel().deleteEntryRows("entry", newDeleteRows);
        }
    }
}

