/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.opplugin.calculate.out;

import java.io.IOException;
import java.util.HashSet;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalculateOutService;
import kd.fi.calx.algox.MoveAvgIntimeCalculateOutService;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;

public class CalculateReExecuteOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("calnumber");
        e.getFieldKeys().add("taskid");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("times");
        e.getFieldKeys().add("progress");
        e.getFieldKeys().add("params_tag");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] progressInfos;
        DynamicObject[] taskInfos = e.getDataEntities();
        HashSet<Long> progressIds = new HashSet<Long>(16);
        int size = taskInfos.length;
        int curBatch = 0;
        for (DynamicObject taskInfo : taskInfos) {
            String sysTaskId;
            Object service;
            String calTaskId = taskInfo.getString("id");
            String calnumber = taskInfo.getString("calnumber");
            String params_tag = taskInfo.getString("params_tag");
            Long progressId = taskInfo.getLong("progress_id");
            int times = taskInfo.getInt("times");
            progressIds.add(progressId);
            CalCulateOutParams params = null;
            try {
                params = (CalCulateOutParams)JSONUtils.cast((String)params_tag, CalCulateOutParams.class);
            }
            catch (IOException exception) {
                throw new KDBizException(exception.getMessage());
            }
            taskInfo.set("times", (Object)(times + 1));
            taskInfo.set("status", (Object)"C");
            String calModel = CalDbParamServiceHelper.getString(CalDbParamConstant.CALC_MODEL, null);
            if ("B".equals(calModel) && 0 != params.getRunningModeMap().get(AccountTypeEnum.MOVEDAVG_INTIME.getValue())) {
                service = new MoveAvgIntimeCalculateOutService(calTaskId);
                sysTaskId = ((MoveAvgIntimeCalculateOutService)service).calCulateOutAsync(params, curBatch, size, calnumber);
            } else {
                service = new CalculateOutService(calTaskId);
                sysTaskId = ((CalculateOutService)service).calCulateOutAsync(params, curBatch, size, calnumber);
            }
            taskInfo.set("taskid", (Object)sysTaskId);
            ++curBatch;
        }
        SaveServiceHelper.save((DynamicObject[])taskInfos);
        for (DynamicObject progressInfo : progressInfos = BusinessDataServiceHelper.load((String)"cal_progress", (String)"progress,entry.status,entry.time", (QFilter[])new QFilter("id", "in", progressIds).toArray())) {
            progressInfo.set("progress", (Object)0);
            DynamicObjectCollection entry = progressInfo.getDynamicObjectCollection("entry");
            for (DynamicObject entryRow : entry) {
                entryRow.set("status", (Object)"D");
                entryRow.set("time", (Object)0);
            }
        }
        SaveServiceHelper.save((DynamicObject[])progressInfos);
    }
}

