/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.capitalreport.qing;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.TimeTypeEnum;
import kd.fi.cas.report.CapitalSumParam;
import kd.fi.cas.report.capitalreport.enums.QueryTypeEnum;
import kd.fi.cas.report.capitalreport.report.CapitalDataAbstract;
import kd.fi.cas.util.EmptyUtil;

public class CapitalDataDayQing
extends CapitalDataAbstract {
    private Map<String, Object> filterQing;

    public DataSet query(Map<String, Object> filterMap) {
        this.filterQing = filterMap;
        return this.query(null, null, true);
    }

    @Override
    public DataSet query(ReportQueryParam arg0, Object arg1, boolean isQing) {
        DataSet ds = super.query(arg0, arg1, isQing);
        log.info("{}CapitalDataDayQing_query.", (Object)"CapitalReportData:");
        return ds.select(new String[]{"forgname as company", "frptbanktype as rptbanktype", "ftype as capital_type", "facctshortname as account", "facctname as acctname", "facctpurpose as acctusege", "facctstyle as acctstyle", "faccttype as accttype", "facctnumber as acctnumber", "fcurrencyname as currency", "fbankname as finorginfo", "sumlevel", "fbalance as yest_original", "fbalancerpt as yest_report", "fdebitamount as income_original", "fdebitamountrpt as income_report", "fcreditamount as expend_original", "fcreditamountrpt as expend_report", "fbalance + fdebitamount - fcreditamount as balan_original", "fbalancerpt + fdebitamountrpt - fcreditamountrpt as balan_report"});
    }

    @Override
    protected List<String> getGroupFields(CapitalSumParam param) {
        return Collections.singletonList("forgname");
    }

    @Override
    protected CapitalSumParam getCapitalSumParam(ReportQueryParam arg0) {
        CapitalSumParam param = new CapitalSumParam();
        String queryOrtType = (String)this.filterQing.get("queryorgtype");
        log.info("{}CapitalDataDayQing.getQueryOrgType:{}.", (Object)"CapitalReportData:", (Object)(queryOrtType == null ? "null" : queryOrtType));
        if (queryOrtType == null) {
            param.setQueryOrgType(QueryTypeEnum.ORG.getValue());
        } else {
            param.setQueryOrgType(queryOrtType);
        }
        List orgIdStr = (List)this.filterQing.get("filter_company");
        HashSet<Long> orgIds = new HashSet<Long>(orgIdStr.size());
        orgIdStr.forEach(e -> orgIds.add(Long.parseLong(e)));
        param.setOrgs(this.queryDyCols("bos_org", "id", orgIds));
        List accCashIdStr = (List)this.filterQing.get("filter_accountcash");
        HashSet<Long> accCashIds = new HashSet<Long>(accCashIdStr.size());
        accCashIdStr.forEach(e -> accCashIds.add(Long.parseLong(e)));
        param.setAccountcashs(this.queryDyCols("cas_accountcash", "id", accCashIds));
        List accBankIdStr = (List)this.filterQing.get("filter_bankaccountnumber");
        HashSet<Long> accBankIds = new HashSet<Long>(accBankIdStr.size());
        accBankIdStr.forEach(e -> accBankIds.add(Long.parseLong(e)));
        param.setBankaccounts(this.queryDyCols("bd_accountbanks", "id", accBankIds));
        DynamicObjectCollection currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id", null);
        param.setCurrencys(currencys);
        Long repCurrency = Long.parseLong(this.filterQing.get("filter_currency").toString());
        param.setCalcCurrency((DynamicObject)this.queryDyCols("bd_currency", "id,sign", Collections.singleton(repCurrency)).get(0));
        String strDate = this.filterQing.get("filter_date").toString();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date dateFrom = formatter.parse(strDate, pos);
        param.setDateFrom(dateFrom);
        param.setDateTo(dateFrom);
        param.setQueryOrgType(QueryTypeEnum.ORG.getValue());
        param.setCategory(3);
        param.setTimeType(TimeTypeEnum.BYDATE.getValue());
        param.setSelDimension(1);
        param.setStatisticUnit((String)this.filterQing.get("filter_currencyunit"));
        Long exrateTable = Long.parseLong(((Map)this.filterQing.get("exratetable")).get("id").toString());
        param.setExrateTable((DynamicObject)this.queryDyCols("bd_exratetable", "id", Collections.singleton(exrateTable)).get(0));
        param.setNotShowZero(true);
        param.setShowCloseAcct(false);
        param.setShowsubtotal(true);
        param.setDefaulttime(true);
        Object exchangeDateStr = this.filterQing.get("exchangedate");
        Date exchangeDate = null;
        if (EmptyUtil.isNoEmpty((Object)exchangeDateStr)) {
            exchangeDate = formatter.parse(exchangeDateStr.toString(), new ParsePosition(0));
        }
        param.setExchangedate(exchangeDate);
        param.setDatasource(1);
        return param;
    }

    private DynamicObjectCollection queryDyCols(String formId, String sel_fields, Set<Long> pkIds) {
        if (pkIds == null || pkIds.size() == 0) {
            return new DynamicObjectCollection();
        }
        QFilter filter = new QFilter("id", "in", pkIds);
        return QueryServiceHelper.query((String)formId, (String)sel_fields, (QFilter[])filter.toArray());
    }
}

