/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.cas.business.helper.ClosePeriodHelper;
import kd.fi.cas.cache.CacheHelper;
import kd.fi.cas.cache.CacheModule;
import kd.fi.cas.cache.DistributeCache;
import kd.fi.cas.consts.closeperiod.ClosePeriodInfo;
import kd.fi.cas.consts.closeperiod.Tuple;
import kd.fi.cas.helper.AppLogHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.ClosePeriodUtils;
import kd.fi.cas.util.EmptyUtil;

public class CasClosePeriodFormRpt
extends AbstractReportFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(CasClosePeriodFormRpt.class);
    private static final String ORG_ID = "org.id";
    private static final String CLOSE_INFO_KEY = "closeInfo";
    private static final String BTN_SELECTALL = "selectall";
    private static final String BTN_CANCELSELECT = "cancelselect";
    private static final String BTN_CLOSE = "periodclose";
    private static final String BTN_ANTI_CLOSE = "reperiodclose";
    private static final String BTN_CLOSE_CHECK = "closecheck";
    private static final String BTN_EXPORT = "exportexcel";
    private static final String PERM_CLOSE = "4730fc9f000001ae";
    private static final String PERM_CLOSE_CHECK = "46=ADXNOEM8F";
    private static final String PERM_ANTI_CLOSE_CHECK = "4730fc9f000010ae";
    private static final String HISTORY_USER = "user";
    private static final String HISTORY_APP = "orgtype";
    private static final String BD_CLOSEDPERIODORGS = "bd_closedperiodorgs";
    private static final String closeStatus = "bd_closecheckitem";
    public static final String EXPORTEXCEL = "exportexcel";
    public static final String EXPORTEXCEL_DATA = "exportexceldata";
    private static final String VIEWALL = "viewall";
    private static final String SHOWTREE = "showtree";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.periodClose);
    private OrgBookInfo bookCache;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        MulBasedataEdit mulOrgEdit = (MulBasedataEdit)this.getControl("periodcloseorg");
        if (mulOrgEdit != null) {
            mulOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        final ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                int rowIndex = evt.getRowIndex();
                DynamicObject rowData = reportList.getReportModel().getRowData(rowIndex);
                String bookType = rowData.getString("booktype");
                String formNumber = rowData.getString("formnumber");
                String queryContitions = rowData.getString("formquery");
                String key = rowData.getString("dealfail");
                if (key.equals(ResManager.loadKDString((String)"\u5904\u7406", (String)"CasClosePeriodFormRpt_0", (String)"fi-cas-report", (Object[])new Object[0]))) {
                    QFilter filter = null;
                    try {
                        filter = QFilter.fromSerializedString((String)queryContitions);
                    }
                    catch (Exception e) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"CasClosePeriodFormRpt_3", (String)"fi-cas-report", (Object[])new Object[0]));
                    }
                    ClosePeriodUtils.createListOnCloseDetail((QFilter)filter, (String)formNumber, (String)bookType, (IFormView)CasClosePeriodFormRpt.this.getView());
                } else if (key.equals(ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"CasClosePeriodFormRpt_1", (String)"fi-cas-report", (Object[])new Object[0]))) {
                    CasClosePeriodFormRpt.this.getView().showMessage("", rowData.getString("message").replace("\n", "\r\n"), MessageTypes.Commit);
                }
            }
        });
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(VIEWALL))) {
            this.removeCache();
        }
        queryParam.getCustomParam().put("pageid", this.getView().getPageId());
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getAllCLoseableOrgs();
        this.orgManage(Boolean.TRUE);
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }

    public void afterQuery(ReportQueryParam queryParam) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(VIEWALL))) {
            ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
            ReportQueryParam reportQueryParam = reportlistap.getReportCache().getReportQueryParam(this.getView().getPageId());
            reportQueryParam.getCustomParam().put("pageid", this.getView().getPageId());
            reportlistap.getReportCache().setReportQueryParam(this.getView().getPageId(), reportQueryParam);
            this.getPageCache().remove(VIEWALL);
        }
    }

    private void orgManage(boolean createNewData) {
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        List<Long> allOrgIds = this.bookCache.getAllOrgIds();
        allOrgIds.remove(0L);
        Long currentOrgId = RequestContext.get().getOrgId();
        if (allOrgIds.isEmpty()) {
            allOrgIds.add(currentOrgId);
        }
        HashSet<Long> closeOrgIds = new HashSet<Long>();
        if (createNewData) {
            if (allOrgIds.contains(currentOrgId)) {
                closeOrgIds.add(currentOrgId);
            } else {
                Set<Long> historyCloseOrgs = this.getHistoryCloseOrgs();
                historyCloseOrgs.retainAll(allOrgIds);
                if (!historyCloseOrgs.isEmpty()) {
                    closeOrgIds.addAll(historyCloseOrgs);
                } else {
                    closeOrgIds.add(allOrgIds.get(0));
                }
            }
            this.getModel().setValue("periodcloseorg", (Object)closeOrgIds.toArray());
        } else {
            closeOrgIds.addAll(allOrgIds);
        }
        this.putHistoryCloseOrgs(closeOrgIds);
    }

    private Set<Long> getHistoryCloseOrgs() {
        QFilter qfBuilder = QFilter.of((String)"1=1", (Object[])new Object[0]);
        qfBuilder.and(HISTORY_USER, "=", (Object)RequestContext.get().getCurrUserId());
        qfBuilder.and(HISTORY_APP, "=", (Object)this.getAppId());
        return QueryServiceHelper.query((String)BD_CLOSEDPERIODORGS, (String)"org", (QFilter[])qfBuilder.toArray()).stream().map(x -> x.getLong("org")).collect(Collectors.toSet());
    }

    private void putHistoryCloseOrgs(Set<Long> orgIds) {
        QFilter qfBuilder = QFilter.of((String)"1=1", (Object[])new Object[0]);
        qfBuilder.and(HISTORY_USER, "=", (Object)RequestContext.get().getCurrUserId());
        qfBuilder.and(HISTORY_APP, "=", (Object)"cas");
        DeleteServiceHelper.delete((String)BD_CLOSEDPERIODORGS, (QFilter[])qfBuilder.toArray());
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])orgIds.stream().map(x -> {
            DynamicObject historyDO = BusinessDataServiceHelper.newDynamicObject((String)BD_CLOSEDPERIODORGS);
            historyDO.set(HISTORY_USER, (Object)RequestContext.get().getCurrUserId());
            historyDO.set("org", x);
            historyDO.set(HISTORY_APP, (Object)"cas");
            return historyDO;
        }).toArray(DynamicObject[]::new)));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        this.mulOrgEditBeforeF7Select(e);
    }

    private void mulOrgEditBeforeF7Select(BeforeF7SelectEvent e) {
        FormShowParameter param = e.getFormShowParameter();
        ListFilterParameter listFilterParameter = ((ListShowParameter)param).getListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("id", "in", this.getAllCLoseableOrgs()));
    }

    private List<Long> getAllCLoseableOrgs() {
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        String appId = this.getView().getFormShowParameter().getAppId();
        List hasPermOrgs = null;
        HasPermOrgResult permResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)BizAppServiceHelp.getAppIdByAppNumber((String)appId), (String)"cas_closeperiod_new", (String)"47150e89000000ac");
        if (!permResult.hasAllOrgPerm()) {
            hasPermOrgs = permResult.getHasPermOrgs();
        }
        this.getAndCacheBookInfo(hasPermOrgs);
        return this.bookCache.getAllOrgIds();
    }

    private ClosePeriodInfo getCloseInfo() {
        String cacheVal = this.getPageCache().get(CLOSE_INFO_KEY);
        if (StringUtils.isNotBlank((CharSequence)cacheVal)) {
            return (ClosePeriodInfo)SerializationUtils.fromJsonString((String)cacheVal, ClosePeriodInfo.class);
        }
        ClosePeriodInfo closeInfo = new ClosePeriodInfo();
        closeInfo.setBizapp("cas");
        closeInfo.setTypeFieldName("");
        closeInfo.setFormId("cas_finalcheckout");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)closeInfo.getFormId());
        LocaleString orgDisplayName = dataEntityType.getProperty("org").getDisplayName();
        closeInfo.setOrgFieldName(orgDisplayName.getLocaleValue());
        this.getPageCache().put(CLOSE_INFO_KEY, SerializationUtils.toJsonString((Object)closeInfo));
        return closeInfo;
    }

    private void getAndCacheBookInfo(List<Long> orgIds) {
        block4: {
            block3: {
                ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get(CLOSE_INFO_KEY), ClosePeriodInfo.class);
                QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
                if (!Objects.isNull(orgIds)) {
                    qFilter.and("org", "in", orgIds);
                }
                qFilter.and("checkoutstatus", "in", Arrays.asList("1", "2", "4"));
                DynamicObject[] bookDOs = BusinessDataServiceHelper.load((String)closeInfo.getFormId(), (String)"id,org,period", (QFilter[])qFilter.toArray());
                this.bookCache = new OrgBookInfo();
                if (bookDOs == null || bookDOs.length <= 0) break block3;
                for (DynamicObject bookDO : bookDOs) {
                    this.bookCache.putOrgBook(bookDO.getLong(ORG_ID), bookDO);
                }
                break block4;
            }
            if (orgIds == null) break block4;
            for (Long orgId : orgIds) {
                this.bookCache.putOrgBook(orgId, null);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection coll;
        int size;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel m = this.getModel();
        if ("periodcloseorg".equals(propertyName) && (size = (coll = (DynamicObjectCollection)m.getValue("periodcloseorg")).size()) > 0) {
            ArrayList<Long> ids = new ArrayList<Long>(size);
            for (DynamicObject dynamicObject : coll) {
                ids.add(dynamicObject.getLong(2));
            }
            this.getAndCacheBookInfo(ids);
            this.orgManage(Boolean.FALSE);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "exportexcel": {
                this.getPageCache().put("exportexcel", "true");
                break;
            }
            case "closecheck": {
                this.checkPermission(evt, PERM_CLOSE_CHECK, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\u671f\u672b\u7ed3\u8d26\u7ed3\u8d26\u68c0\u67e5\u6743\u9650\u3002", (String)"CasClosePeriodFormRpt_13", (String)"fi-cas-report", (Object[])new Object[0]));
                break;
            }
            case "periodclose": {
                this.checkPermission(evt, PERM_CLOSE, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\u671f\u672b\u7ed3\u8d26\u7ed3\u8d26\u6743\u9650\u3002", (String)"CasClosePeriodFormRpt_14", (String)"fi-cas-report", (Object[])new Object[0]));
                break;
            }
            case "reperiodclose": {
                this.checkPermission(evt, PERM_ANTI_CLOSE_CHECK, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\u671f\u672b\u7ed3\u8d26\u53cd\u7ed3\u8d26\u6743\u9650\u3002", (String)"CasClosePeriodFormRpt_15", (String)"fi-cas-report", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void checkPermission(BeforeItemClickEvent evt, String permItem, String errorMsg) {
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)BizAppServiceHelp.getAppIdByAppNumber((String)appId), (String)"cas_closeperiod_new", (String)permItem);
        if (!hasPerm) {
            this.getView().showTipNotification(errorMsg);
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key) || "close".equals(key)) {
            return;
        }
        ReportList control = (ReportList)this.getControl("reportlistap");
        int[] rowIdxs = control.getEntryState().getSelectedRows();
        if (!(BTN_SELECTALL.equals(key) || BTN_CANCELSELECT.equals(key) || "exportexcel".equals(key) || VIEWALL.equals(key) || SHOWTREE.equals(key) || rowIdxs.length != 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"CasClosePeriodFormRpt_7", (String)"fi-cas-report", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "periodclose": {
                LinkedHashSet<String> orgAndBookType = new LinkedHashSet<String>(rowIdxs.length);
                ArrayList<String> noPeirodOrgs = new ArrayList<String>(rowIdxs.length);
                for (int i2 = 0; i2 < rowIdxs.length; ++i2) {
                    String checkoutId = control.getReportModel().getRowData(rowIdxs[i2]).getString("booktype");
                    DynamicObject finalCheckOut = BusinessDataServiceHelper.loadSingle((Object)checkoutId, (String)"cas_finalcheckout");
                    DynamicObject org = finalCheckOut.getDynamicObject("org");
                    DynamicObject currPeriod = finalCheckOut.getDynamicObject("period");
                    DynamicObject nextPeriod = PeriodHelper.getNextPeriodNotAdjustPeriod((long)currPeriod.getLong("id"));
                    if (EmptyUtil.isEmpty((DynamicObject)nextPeriod)) {
                        noPeirodOrgs.add(org.getString("name"));
                    }
                    orgAndBookType.add(org.getString("name") + "@#," + (EmptyUtil.isEmpty((DynamicObject)nextPeriod) ? "1" : nextPeriod.getString("name")));
                }
                String headMsg = ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u5c06\u8fdb\u884c\u7ed3\u8d26\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CasClosePeriodFormRpt_8", (String)"fi-cas-report", (Object[])new Object[0]);
                String msgTemplate = ResManager.loadKDString((String)"%1$s\u5c06\u7ed3\u8d26\u5230%2$s\uff1b", (String)"CasClosePeriodFormRpt_9", (String)"fi-cas-report", (Object[])new Object[0]);
                String msgNoPeirod = ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u5148\u7ef4\u62a4\u671f\u95f4\u57fa\u7840\u8d44\u6599\uff0c\u5426\u5219\u65e0\u6cd5\u8fdb\u884c\u7ed3\u8d26\uff1b", (String)"CasClosePeriodFormRpt_16", (String)"fi-cas-report", (Object[])new Object[0]);
                String confirmMsg = orgAndBookType.stream().map(e -> noPeirodOrgs.contains(e.split("@#,")[0]) ? String.format(msgNoPeirod, e.split("@#,")[0]) : String.format(msgTemplate, e.split("@#,")[0], e.split("@#,")[1])).collect(Collectors.joining("\r\n"));
                this.getView().showConfirm(headMsg, confirmMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(BTN_CLOSE));
                break;
            }
            case "reperiodclose": {
                this.removeCache();
                boolean result = ClosePeriodUtils.doReverseClosing((IFormView)this.getView());
                if (!result) break;
                ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
                reportlistap.refresh();
                break;
            }
            case "closecheck": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5", (String)"CasClosePeriodFormRpt_10", (String)"fi-cas-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5\u53ea\u68c0\u67e5\u5f53\u524d\u671f\u95f4,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CasClosePeriodFormRpt_11", (String)"fi-cas-report", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(BTN_CLOSE_CHECK));
                break;
            }
            case "selectall": 
            case "cancelselect": {
                int rowCount = control.getReportModel().getRowCount();
                ArrayList<Integer> list = new ArrayList<Integer>(rowCount);
                for (int i3 = 1; i3 <= rowCount; ++i3) {
                    list.add(i3);
                }
                control.selectRows(BTN_SELECTALL.equals(key) ? list.stream().mapToInt(i -> i).toArray() : new int[]{}, 0);
                break;
            }
            case "viewall": {
                this.cache.put(this.getView().getPageId() + VIEWALL, "true");
                this.getView().refresh();
                break;
            }
            case "showtree": {
                this.getView().refresh();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (BTN_CLOSE.equals(e.getActionId())) {
            Map result = (Map)returnData;
            if (null != result && result.containsKey("taskinfo")) {
                TaskInfo taskInfo;
                String taskInfoStr = (String)result.get("taskinfo");
                if (StringUtils.isNotBlank((CharSequence)taskInfoStr) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                    String data = taskInfo.getData();
                    try {
                        Map map = (Map)JSONUtils.cast((String)data, HashMap.class);
                        this.cache.put(this.getView().getPageId() + "closeresult", map.get("closeresult").toString());
                        this.refresh();
                    }
                    catch (IOException exception) {
                        log.error((Throwable)exception);
                    }
                }
            } else {
                this.refresh();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (BTN_CLOSE.equals(callBackId)) {
            if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                this.removeCache();
                this.executeClose();
            }
        } else if (BTN_CLOSE_CHECK.equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.removeCache();
            ReportList control = (ReportList)this.getControl("reportlistap");
            int[] rowIdxs = control.getEntryState().getSelectedRows();
            HashMap<String, Tuple> checkperiod = new HashMap<String, Tuple>(rowIdxs.length);
            ArrayList<String> checkedDatas = new ArrayList<String>(rowIdxs.length);
            HashMap idAndDyMap = new HashMap(16);
            HashSet<Long> checkOutIdSet = new HashSet<Long>(16);
            for (int idx : rowIdxs) {
                String checkoutId;
                DynamicObject rowData = control.getReportModel().getRowData(idx);
                if (rowData == null || !EmptyUtil.isNoEmpty((String)(checkoutId = rowData.getString("booktype")))) continue;
                checkOutIdSet.add(Long.parseLong(checkoutId));
            }
            if (EmptyUtil.isNoEmpty(checkOutIdSet)) {
                DynamicObjectCollection finalCheckOutList = QueryServiceHelper.query((String)"cas_finalcheckout", (String)"id,org,period", (QFilter[])new QFilter[]{new QFilter("id", "in", checkOutIdSet)});
                finalCheckOutList.forEach(dy -> idAndDyMap.put(dy.getLong("id"), dy));
            }
            ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>();
            for (int index : rowIdxs) {
                long org;
                String org2booktype;
                String checkoutId;
                DynamicObject finalCheckOut;
                DynamicObject rowData = control.getReportModel().getRowData(index);
                if (rowData == null || (finalCheckOut = (DynamicObject)idAndDyMap.get(EmptyUtil.isNoEmpty((String)(checkoutId = rowData.getString("booktype"))) ? Long.parseLong(checkoutId) : 0L)) == null || checkedDatas.contains(org2booktype = (org = finalCheckOut.getLong("org")) + "_")) continue;
                checkedDatas.add(org2booktype);
                DynamicObjectCollection entryentity = BusinessDataServiceHelper.newDynamicObject((String)closeStatus).getDynamicObjectCollection("entryentity");
                boolean result = ClosePeriodHelper.closeCheck((DynamicObjectCollection)entryentity, (long)org, (long)finalCheckOut.getLong("period"));
                MultiLangEnumBridge opNameBridge = AppLogHelper.buildMultiLangBridge((String)"\u7ed3\u8d26\u68c0\u67e5", (String)"CasClosePeriodFormRpt_10", (String)"fi-cas-report");
                MultiLangEnumBridge passDescBridge = AppLogHelper.buildMultiLangBridge((String)"\u7ed3\u8d26\u68c0\u67e5\u901a\u8fc7\u3002", (String)"CasClosePeriodFormRpt_17", (String)"fi-cas-report");
                MultiLangEnumBridge failDescBridge = AppLogHelper.buildMultiLangBridge((String)"\u7ed3\u8d26\u68c0\u67e5\u4e0d\u901a\u8fc7\u3002", (String)"CasClosePeriodFormRpt_18", (String)"fi-cas-report");
                AppLogInfo appLogInfo = AppLogHelper.createAppLog((String)"cas_finalcheckout", (long)org, (String)BTN_CLOSE_CHECK, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)(result ? passDescBridge : failDescBridge), (Object[])new Object[0]);
                appLogInfos.add(appLogInfo);
                checkperiod.put(org + "_", new Tuple((Object)result, (Object)(result ? "" : SerializationUtils.serializeToBase64((Object)entryentity))));
            }
            LogServiceHelper.addBatchLog(appLogInfos);
            this.cache.put(this.getView().getPageId() + "checkperiod", SerializationUtils.serializeToBase64(checkperiod));
            this.refresh();
        }
    }

    private void executeClose() {
        ReportList control = (ReportList)this.getControl("reportlistap");
        int[] rowIdxs = control.getEntryState().getSelectedRows();
        if (rowIdxs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"CasClosePeriodFormRpt_12", (String)"fi-cas-report", (Object[])new Object[0]));
            return;
        }
        HashSet<String> orgAndBookType = new HashSet<String>(rowIdxs.length);
        for (int i = 0; i < rowIdxs.length; ++i) {
            String checkoutId = control.getReportModel().getRowData(rowIdxs[i]).getString("booktype");
            DynamicObject finalCheckOut = BusinessDataServiceHelper.loadSingle((Object)checkoutId, (String)"cas_finalcheckout");
            DynamicObject org = finalCheckOut.getDynamicObject("org");
            DynamicObject period = finalCheckOut.getDynamicObject("period");
            DynamicObject nextPeriod = PeriodHelper.getNextPeriodNotAdjustPeriod((long)period.getLong("id"));
            orgAndBookType.add(org.getLong("id") + "_" + (EmptyUtil.isEmpty((DynamicObject)nextPeriod) ? "1" : Long.valueOf(nextPeriod.getLong("id"))));
        }
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        closeInfo.setPageId(this.getView().getPageId());
        closeInfo.setPageFormId(this.getView().getEntityId());
        closeInfo.setOrgAndBookType(new ArrayList(orgAndBookType));
        closeInfo.setPageId(this.getView().getPageId());
        closeInfo.setRequestId(RequestContext.get().getRequestId());
        closeInfo.setRequestContextStr(SerializationUtils.serializeToBase64((Object)RequestContext.get()));
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("cas");
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u8d26", (String)"CasClosePeriodFormRpt_2", (String)"fi-cas-report", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setTaskClassname("kd.fi.cas.report.data.ClosePeriodTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put(CLOSE_INFO_KEY, JSONUtils.toString((Object)closeInfo));
            params.put(HISTORY_USER, RequestContext.get().getCurrUserId());
            params.put("clientType", RequestContext.get().getClient());
            params.put("clientIP", RequestContext.get().getLoginIP());
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_CLOSE);
        JobForm.dispatch((JobInfo)jobInfo, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getCustomParam().put("pageid", this.getView().getPageId());
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            if (!"status".equals(event.getColumnName()) && !"checkitem".equals(event.getColumnName()) && !"dealfail".equals(event.getColumnName())) continue;
            event.setFilter(true);
        }
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        if (!"true".equals(this.getPageCache().get(VIEWALL))) {
            event.setTreeReportList(true);
        }
        event.setTreeExpandColId("checkitem");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (key.equals(VIEWALL)) {
            this.getPageCache().put(VIEWALL, "true");
        } else if (key.equals(SHOWTREE)) {
            this.getPageCache().put(VIEWALL, "false");
            this.cache.remove(this.getView().getPageId() + VIEWALL);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("exportexcel")) {
            this.getPageCache().remove("exportexcel");
            this.getPageCache().remove(EXPORTEXCEL_DATA);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        if (this.getPageCache().get("exportexcel") != null) {
            Map<String, String> pidAndStatus = new HashMap(16);
            String data = this.getPageCache().get(EXPORTEXCEL_DATA);
            if (StringUtils.isNotEmpty((CharSequence)data)) {
                pidAndStatus = (Map)SerializationUtils.deSerializeFromBase64((String)data);
            }
            for (DynamicObject row : rowData) {
                if (row.getLong("isgroupnode") == 1L) {
                    pidAndStatus.put(row.getString("rowid"), row.getString("status"));
                    continue;
                }
                if (!pidAndStatus.containsKey(row.getString("pid"))) continue;
                row.set("status", pidAndStatus.get(row.getString("pid")));
            }
            this.getPageCache().put(EXPORTEXCEL_DATA, SerializationUtils.serializeToBase64(pidAndStatus));
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        Object formatValue;
        ReportColumn column = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = column.getFieldKey();
        if ("dealfail".equals(fieldKey) && (formatValue = packageDataEvent.getFormatValue()) != null && ResManager.loadKDString((String)"\u68c0\u67e5\u901a\u8fc7", (String)"ClosePeriodQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]).equals(formatValue)) {
            packageDataEvent.setFormatValue((Object)("<nolink>" + formatValue));
        }
    }

    private String getAppId() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String appId = (String)parameter.getCustomParam("closePeriodApp");
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = parameter.getAppId();
        }
        return appId == null ? "" : appId;
    }

    private void refresh() {
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        ReportQueryParam reportQueryParam = reportlistap.getReportCache().getReportQueryParam(this.getView().getPageId());
        reportQueryParam.getCustomParam().put("pageid", this.getView().getPageId());
        reportlistap.getReportCache().setReportQueryParam(this.getView().getPageId(), reportQueryParam);
        reportlistap.refresh();
    }

    private void removeCache() {
        this.cache.remove(this.getView().getPageId() + "closeresult");
        this.cache.remove(this.getView().getPageId() + "checkperiod");
        this.cache.remove(this.getView().getPageId() + VIEWALL);
    }

    private static class OrgBookInfo {
        private transient Map<Long, List<DynamicObject>> orgBookDOs = new HashMap<Long, List<DynamicObject>>(16);

        private OrgBookInfo() {
        }

        public void putOrgBook(long org, DynamicObject book) {
            if (this.orgBookDOs == null) {
                this.orgBookDOs = new HashMap<Long, List<DynamicObject>>();
            }
            if (this.orgBookDOs.get(org) == null) {
                this.orgBookDOs.put(org, new ArrayList<DynamicObject>(Collections.singletonList(book)));
            } else {
                this.orgBookDOs.get(org).add(book);
            }
        }

        public List<DynamicObject> getBooks(long org) {
            return this.orgBookDOs.get(org);
        }

        public List<DynamicObject> getAllBooks() {
            return this.orgBookDOs.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }

        public List<Long> getAllOrgIds() {
            return new ArrayList<Long>(this.orgBookDOs.keySet());
        }
    }
}

