/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.print;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.print.dataprovider.ReportDataProvider;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.report.capitalreport.report.CapitalDataDay;
import kd.fi.cas.util.EmptyUtil;

public class CapitalDayOrgPrintPlugin
extends AbstractPrintServicePlugin {
    private static final String[] currFiled = new String[]{"yest_original", "income_original", "expend_original", "balan_original"};
    private static final String[] reportFiled = new String[]{"yest_report", "income_report", "expend_report", "balan_report"};

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        List dyns = e.getDataEntities();
        ReportDataProvider o = (ReportDataProvider)e.getSource();
        ReportQueryParam queryParam = o.getQueryParam();
        int size = queryParam.getFilter().getFilterItems().size();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(size);
        for (FilterItemInfo filterItem : queryParam.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        DynamicObjectType customDT = new DynamicObjectType();
        if ("capitaldayhead".equals(e.getDataSourceName())) {
            customDT.registerProperty("period", String.class, (Object)"", false);
            customDT.registerProperty("bdcurrency", String.class, (Object)"", false);
            customDT.registerProperty("currorg", String.class, (Object)"", false);
            DynamicObject capitalsumhead = new DynamicObject(customDT);
            StringBuilder period = new StringBuilder();
            period.append(ResManager.loadKDString((String)"\u65e5\u671f\uff1a", (String)"CapitalSumPrintPlugin_9", (String)"fi-cas-report", (Object[])new Object[0]));
            StringBuilder periodName = new StringBuilder();
            Date datefrom = (Date)paramMap.get("filter_date");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/M/dd");
            periodName.append(sdf.format(datefrom));
            period.append((CharSequence)periodName);
            capitalsumhead.set("period", (Object)period.toString());
            StringBuilder bdcurrency = new StringBuilder();
            bdcurrency.append(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\uff1a", (String)"CapitalSumPrintPlugin_1", (String)"fi-cas-report", (Object[])new Object[0]));
            if (Objects.nonNull(paramMap.get("filter_currency"))) {
                bdcurrency.append(((DynamicObject)paramMap.get("filter_currency")).getString("name"));
            }
            capitalsumhead.set("bdcurrency", (Object)bdcurrency.toString());
            StringBuilder currorg = new StringBuilder();
            currorg.append(ResManager.loadKDString((String)"\u7edf\u8ba1\u5355\u4f4d\uff1a", (String)"CapitalSumPrintPlugin_2", (String)"fi-cas-report", (Object[])new Object[0]));
            String statisticunit = paramMap.get("filter_currencyunit").toString();
            if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"Original")) {
                statisticunit = ResManager.loadKDString((String)"\u5143", (String)"CapitalSumPrintPlugin_3", (String)"fi-cas-report", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"Thousand")) {
                statisticunit = ResManager.loadKDString((String)"\u5343\u5143", (String)"CapitalSumPrintPlugin_4", (String)"fi-cas-report", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"TenThousand")) {
                statisticunit = ResManager.loadKDString((String)"\u4e07\u5143", (String)"CapitalSumPrintPlugin_5", (String)"fi-cas-report", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"Million")) {
                statisticunit = ResManager.loadKDString((String)"\u767e\u4e07\u5143", (String)"CapitalSumPrintPlugin_6", (String)"fi-cas-report", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"Billion")) {
                statisticunit = ResManager.loadKDString((String)"\u5343\u4e07\u5143", (String)"CapitalSumPrintPlugin_7", (String)"fi-cas-report", (Object[])new Object[0]);
            }
            currorg.append(statisticunit);
            capitalsumhead.set("currorg", (Object)currorg.toString());
            dyns.add(capitalsumhead);
        } else if ("capitaldaybody".equals(e.getDataSourceName())) {
            DynamicObjectCollection currencys;
            customDT.registerProperty("org", String.class, (Object)"", false);
            customDT.registerProperty("fundtype", String.class, (Object)"", false);
            customDT.registerProperty("account", String.class, (Object)"", false);
            customDT.registerProperty("acctpurpose", String.class, (Object)"", false);
            customDT.registerProperty("bankno", String.class, (Object)"", false);
            customDT.registerProperty("bank", String.class, (Object)"", false);
            customDT.registerProperty("startcurr", String.class, (Object)"", false);
            customDT.registerProperty("startbdcurr", String.class, (Object)"", false);
            customDT.registerProperty("reccurr", String.class, (Object)"", false);
            customDT.registerProperty("recbdcurr", String.class, (Object)"", false);
            customDT.registerProperty("paycurr", String.class, (Object)"", false);
            customDT.registerProperty("paybdcurr", String.class, (Object)"", false);
            customDT.registerProperty("endcurr", String.class, (Object)"", false);
            customDT.registerProperty("endbdcurr", String.class, (Object)"", false);
            DataSet dataSet = new CapitalDataDay().query(queryParam, null, false);
            Row row = null;
            DynamicObject capitalsumbody = null;
            String[] currValue = new String[currFiled.length];
            Object currObject = null;
            Integer calcPrecision = null;
            String calcCurr = "";
            if (Objects.nonNull(paramMap.get("filter_currency"))) {
                calcCurr = ((DynamicObject)paramMap.get("filter_currency")).getString("sign");
                calcPrecision = ((DynamicObject)paramMap.get("filter_currency")).getInt("amtprecision");
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(currencys = (DynamicObjectCollection)paramMap.get("orgcurrency")))) {
                currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id,sign,amtprecision", null);
            }
            Map<Long, String> currencySign = currencys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("sign")));
            Map<Long, Integer> currencyPrecision = currencys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getInt("amtprecision")));
            Integer sumlevel = 0;
            while (dataSet.hasNext()) {
                row = dataSet.next();
                capitalsumbody = new DynamicObject(customDT);
                capitalsumbody.set("org", row.get("company"));
                capitalsumbody.set("fundtype", row.get("capital_type"));
                capitalsumbody.set("account", row.get("account"));
                capitalsumbody.set("acctpurpose", row.get("acctpurpose"));
                capitalsumbody.set("bankno", row.get("accountnumber"));
                capitalsumbody.set("bank", row.get("finorginfo"));
                for (int i = 0; i < currFiled.length; ++i) {
                    sumlevel = row.getInteger("sumlevel");
                    currObject = sumlevel == 0 ? row.get(currFiled[i]) : row.get(reportFiled[i]);
                    if (!EmptyUtil.isEmpty((Object)currObject)) {
                        if (currObject instanceof Integer) {
                            currObject = "0";
                        } else if (((BigDecimal)currObject).compareTo(BigDecimal.ZERO) == 0) {
                            currObject = "0";
                        } else {
                            Integer precision = calcPrecision;
                            if (sumlevel == 0) {
                                precision = currencyPrecision.get(row.get("currencyfield1"));
                            }
                            if (Objects.nonNull(precision)) {
                                currObject = CasHelper.formatDecimal((BigDecimal)((BigDecimal)currObject), (int)precision);
                            }
                        }
                    } else {
                        currObject = "0";
                    }
                    if (!"0".equals(currObject)) {
                        currObject = sumlevel == 0 ? currencySign.get(row.get("currencyfield1")) + currObject : calcCurr + currObject;
                    }
                    currValue[i] = currObject;
                }
                capitalsumbody.set("startcurr", (Object)currValue[0]);
                capitalsumbody.set("reccurr", (Object)currValue[1]);
                capitalsumbody.set("paycurr", (Object)currValue[2]);
                capitalsumbody.set("endcurr", (Object)currValue[3]);
                dyns.add(capitalsumbody);
            }
            if (EmptyUtil.isNoEmpty((Object)dataSet)) {
                dataSet.close();
            }
        }
    }
}

