/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.qing;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.qing.EntryEntity;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.cas.util.EmptyUtil;

public abstract class AbstractQingAnlsDataPlugin
extends AbstractFormPlugin
implements IQingDataProvider {
    public QingData getData(String qingPageId, int startRow, int limit) {
        System.err.println("startRow = " + startRow);
        System.err.println("limit = " + limit);
        QingData qingData = new QingData();
        qingData.setDataindex(this.createDataIndex());
        String filterstr = this.getPageCache().get("qFilter");
        LinkedList<Object[]> data = new LinkedList<Object[]>();
        if (!EmptyUtil.isEmpty((String)filterstr)) {
            Map filterParam = (Map)SerializationUtils.fromJsonString((String)filterstr, Map.class);
            DataSet ds = this.getDataSet(filterParam);
            if (!EmptyUtil.isEmpty((Object)ds)) {
                for (Row rs : ds) {
                    List<Object[]> cols = this.getColumnItems();
                    Object[] row = new Object[cols.size()];
                    for (int index = 0; index < cols.size(); ++index) {
                        Object[] column = cols.get(index);
                        String filed = (String)column[0];
                        Object value = rs.get(filed);
                        if (value != null && QingFieldType.Date.toNumber() == ((Integer)column[2]).intValue()) {
                            Date date = (Date)rs.get(filed);
                            value = date.getTime();
                        }
                        row[index] = value = this.translateCellDisplay(filed, value, rs);
                    }
                    data.add(row);
                }
            }
            qingData.setRows(data);
        }
        if (startRow > 1) {
            return null;
        }
        return qingData;
    }

    protected Map<String, Integer> createDataIndex() {
        HashMap<String, Integer> index = new HashMap<String, Integer>(10);
        for (int k = 0; k < this.getColumnItems().size(); ++k) {
            Object[] column = this.getColumnItems().get(k);
            index.put((String)column[0], k);
        }
        return index;
    }

    public QingMeta getMeta(String qingPageId) {
        QingMeta qingMeta = this.createColumnItems();
        return qingMeta;
    }

    private QingMeta createColumnItems() {
        QingMeta qingMeta = new QingMeta();
        qingMeta.addEntryEntity(this.createEntityMetas());
        for (Object[] column : this.getColumnItems()) {
            qingMeta.addColumn(this.createField((String)column[0], (String)column[1], (Integer)column[2], (Boolean)column[3]));
        }
        return qingMeta;
    }

    protected EntryEntity createEntityMetas() {
        EntryEntity entity = new EntryEntity();
        entity.setKey(this.getEntityName());
        entity.setName(new LocaleString(this.getEntityName()));
        entity.setPkFieldName(this.getFieldPK());
        return entity;
    }

    private Field createField(String key, String name, int fieldType, boolean hide) {
        Field field = new Field();
        field.setEntity(this.getEntityName());
        field.setKey(key);
        field.setName(new LocaleString(name));
        field.setFieldType(fieldType);
        field.setHide(hide);
        return field;
    }

    protected abstract List<Object[]> getColumnItems();

    protected abstract DataSet getDataSet(Map<String, Object> var1);

    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        return value;
    }

    protected String getEntityName() {
        return this.getModel().getDataEntityType().getName();
    }

    protected String getFieldPK() {
        return "id";
    }

    public String getFilterParameter() {
        return this.getPageCache().get("qFilter");
    }

    public void setFilterParameter(String filterParameter) {
        this.getPageCache().put("qFilter", filterParameter);
    }
}

