/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class AccountCashF7TreeListPlugin
extends AbstractTreeListPlugin {
    private static final String BILL_LIST_KEY = "billlistap";

    public void filterContainerInit(FilterContainerInitArgs args) {
        List fastFilterCols = args.getFastFilterColumns();
        fastFilterCols.removeIf(fCol -> fCol.getFieldName().equals("remark"));
    }

    public void initializeTree(EventObject e) {
        List orgIdList;
        super.initializeTree(e);
        String orgField = "org.id, org.name";
        String cacheSelectOrgStr = this.getView().getParentView().getPageCache().get("selectedOrgIdList");
        if (EmptyUtil.isEmpty((String)cacheSelectOrgStr)) {
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            orgIdList = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_cash_verification", (String)"47150e89000000ac");
        } else {
            orgIdList = (List)SerializationUtils.fromJsonString((String)cacheSelectOrgStr, List.class);
        }
        QFilter q = new QFilter("org", "in", (Object)orgIdList);
        q.and(new QFilter("closestatus", "=", (Object)"0"));
        QFilter[] qFilterArray = new QFilter[]{q};
        DataSet ds = QueryServiceHelper.queryDataSet((String)AccountCashF7TreeListPlugin.class.getName(), (String)"cas_accountcash", (String)orgField, (QFilter[])qFilterArray, null).groupBy(new String[]{"org.id", "org.name"}).finish();
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (Row row : ds) {
            String id = row.getString("org.id");
            String name = row.getString("org.name");
            nodes.add(new TreeNode(root.getId(), id, name));
        }
        root.setChildren(nodes);
        ds.close();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        FilterParameter fp = new FilterParameter();
        if (nodeId == null || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(nodeId)) {
            return;
        }
        QFilter filter = new QFilter("org", "=", (Object)Long.valueOf(nodeId));
        filter.and(new QFilter("closestatus", "=", (Object)"0"));
        fp.setFilter(filter);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_KEY);
        billList.setFilterParameter(fp);
        billList.addSetFilterListener(event -> event.getQFilters().add(filter));
        billList.refresh();
        billList.clearSelection();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        if (qFilters != null) {
            qFilters.add(new QFilter("closestatus", "=", (Object)"0"));
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            List orgIdList = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_cash_verification", (String)"47150e89000000ac");
            qFilters.add(new QFilter("org", "in", (Object)orgIdList));
        }
    }
}

