/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.ManualMatchHelper;
import kd.fi.cas.business.opservice.impl.AgentPayPayImpl;
import kd.fi.cas.enums.SysParamCs1046Enum;
import kd.fi.cas.formplugin.common.AbstractCasBillListPlugin;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CasPluginHelper;
import kd.fi.cas.helper.PayInfoChgHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.PluginSignHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentPayBillList
extends AbstractCasBillListPlugin
implements SignCallbackLisenter {
    private static final Log logger = LogFactory.getLog(AgentPayBillList.class);
    private static final String KEY_CALLBACK_CHARGEBACK = "CALLBACK_CHARGEBACK";
    private static final String KEY_CANCELLATION = "cancellation";
    private static final String KEY_DIFFPAY_CALLBACK = "KEY_DIFFPAY_CALLBACK";
    private static final String KEY_CHANGECHG_CALLBACK = "KEY_CHANGECHG_CALLBACK";
    private static final String KEY_CHOOSEENTRY_CALLBACK = "KEY_CHOOSEENTRY_CALLBACK";

    public void afterCreateNewData(EventObject e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean permission = PermissionHelper.hasEntrustPayPermission((String)appId, (String)"cas_agentpaybill");
        this.getView().setVisible(Boolean.valueOf(permission), new String[]{"gendelegagent", "cancelentrustpay"});
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData;
        DataEntityPropertyCollection properties;
        super.packageData(e);
        if (e.getSource() instanceof ColumnDesc && (properties = (rowData = e.getRowData()).getDataEntityType().getProperties()).containsKey((Object)"isencryption")) {
            Boolean encryption = rowData.getBoolean("isencryption");
            if (rowData.containsProperty("entry.e_refundamt") && encryption.booleanValue()) {
                rowData.set("entry.e_refundamt", null);
            }
            if (rowData.containsProperty("entry.entrymatchamount") && encryption.booleanValue()) {
                rowData.set("entry.entrymatchamount", null);
            }
            if (rowData.containsProperty("entry.entryunmatchamount") && encryption.booleanValue()) {
                rowData.set("entry.entryunmatchamount", null);
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if (CasPluginHelper.isTrack((FormShowParameter)this.getView().getFormShowParameter())) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if ("org.id".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValue("");
                    continue;
                }
                if ("billstatus".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValues(new Object[]{""});
                    continue;
                }
                if (!"bizdate".equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("fee".equals(itemKey) || "salary".equals(itemKey)) {
            this.getPageCache().put("itemclickkey", itemKey);
            this.getView().invokeOperation("new");
        } else if ("tblbeforesubmit".equalsIgnoreCase(itemKey)) {
            this.beforeSubmit();
        } else if ("tblcanclepay".equalsIgnoreCase(itemKey)) {
            this.cancelPay();
        }
    }

    private void cancelPay() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PaymentBillList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            LinkedList<Long> paymentBillPks = new LinkedList<Long>();
            for (ListSelectedRow selectedRow : selectedRows) {
                paymentBillPks.add((Long)selectedRow.getPrimaryKeyValue());
            }
            QFilter payPidFilter = new QFilter("id", "in", paymentBillPks);
            DynamicObject[] payobjs = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,billno,isvoucher,billstatus", (QFilter[])new QFilter[]{payPidFilter});
            LinkedList<DynamicObject> bills = new LinkedList<DynamicObject>();
            for (DynamicObject payobj : payobjs) {
                bills.add(payobj);
            }
            StringBuffer sb = new StringBuffer();
            int flag = 0;
            for (DynamicObject obj : bills) {
                if (!obj.getBoolean("isvoucher")) continue;
                ++flag;
                String billno = obj.getString("billno");
                sb.append(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\r\n", (String)"PaymentBillList_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno));
            }
            if (flag == 1) {
                this.getView().showConfirm(sb.substring(0, sb.length() - 1) + "\uff0c" + ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"PaymentBillList_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else if (flag > 0) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%d\u4e2a\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"PaymentBillList_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), flag), sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("cancelpay");
            }
        }
    }

    private void beforeSubmit() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AgentPayBillList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().invokeOperation("beforesubmit");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object[] selectedRowPks;
        BillList list;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("chargeback".equals(key)) {
            list = (BillList)this.getView().getControl("billlistap");
            selectedRowPks = list.getSelectedRows().getPrimaryKeyValues();
            if (selectedRowPks.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9000\u5355\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"AgentPayBillList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.cancel = true;
            }
        } else if ("invalid".equals(key)) {
            boolean result = op.getOption().tryGetVariableValue(KEY_CANCELLATION, new RefObject());
            if (!result) {
                BillList list2 = (BillList)this.getView().getControl("billlistap");
                Object[] selectedRowPks2 = list2.getSelectedRows().getPrimaryKeyValues();
                args.cancel = true;
                if (selectedRowPks2.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"AgentPayBillList_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f5c\u5e9f\u9009\u4e2d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AgentPayBillList_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_CANCELLATION, (IFormPlugin)this));
            }
        } else if ("repay".equals(key)) {
            DynamicObjectCollection entry;
            DynamicObject agentBill;
            list = (BillList)this.getView().getControl("billlistap");
            selectedRowPks = list.getSelectedRows().getPrimaryKeyValues();
            if (selectedRowPks.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"AgentPayBillList_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.cancel = true;
            }
            if ("er_dailyreimbursebill".equals((agentBill = BusinessDataServiceHelper.loadSingle((Object)selectedRowPks[0], (String)"cas_agentpaybill")).getString("sourcebilltype")) && CasHelper.isNotEmpty((Object)(entry = agentBill.getDynamicObjectCollection("entry"))) && entry.size() > 0) {
                DynamicObject object = (DynamicObject)entry.get(0);
                String repayId = String.format("cas_agentpaybill_repay_%s", object.getString("sourcebillid"));
                IAppCache appCache = AppCache.get((String)"fi.cas.app.cache");
                appCache.put(repayId, (Object)"true");
            }
        } else if ("matchdetail".equals(key)) {
            list = (BillList)this.getView().getControl("billlistap");
            ManualMatchHelper.verifySameOrg((ListSelectedRowCollection)list.getSelectedRows(), (String)"cas_agentpaybill", (IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
        }
        if ("submit".equals(key) && (selectedRowPks = (list = (BillList)this.getView().getControl("billlistap")).getSelectedRows().getPrimaryKeyValues()) != null && selectedRowPks.length > 0) {
            DynamicObject[] agentBills = BusinessDataServiceHelper.load((Object[])selectedRowPks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_agentpaybill"));
            ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(agentBills.length);
            for (DynamicObject agentBill : agentBills) {
                DynamicObject object;
                Iterator iterator;
                DynamicObjectCollection collection;
                boolean isRemove = false;
                if (agentBill.getBoolean("isencryption")) {
                    collection = agentBill.getDynamicObjectCollection("entry");
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        object = (DynamicObject)iterator.next();
                        if (!CasHelper.isEmpty((Object)AgentPayBillHelper.decodeAmount((String)object.getString("e_encryptamount")))) continue;
                        iterator.remove();
                        isRemove = true;
                    }
                } else {
                    collection = agentBill.getDynamicObjectCollection("entry");
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        object = (DynamicObject)iterator.next();
                        if (!CasHelper.isEmpty((Object)object.get("e_amount")) || !CasHelper.isEmpty((Object)AgentPayBillHelper.decodeAmount((String)object.getString("e_encryptamount")))) continue;
                        iterator.remove();
                        isRemove = true;
                    }
                }
                if (!isRemove) continue;
                updateBills.add(agentBill);
            }
            if (updateBills.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])updateBills.toArray(new DynamicObject[0]));
            }
        }
    }

    private void openChooseEntryModel(String billFormId) {
        FormShowParameter showParameter = new FormShowParameter();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Long chooseBillId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        StyleCss css = new StyleCss();
        css.setWidth("700");
        css.setHeight("400");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCustomParam("billFormId", (Object)billFormId);
        showParameter.setCustomParam("chooseBillId", (Object)chooseBillId);
        showParameter.setFormId("cas_chooseagententry");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CHOOSEENTRY_CALLBACK));
        this.getView().showForm(showParameter);
    }

    private void payInfoChg(String sourceType, String sourceAction, String openView, String changeCause, List<Object> selectEntryRows) {
        BillShowParameter showParameter = new BillShowParameter();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Long sourceId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        showParameter.setCustomParam("sourceId", (Object)sourceId);
        showParameter.setCustomParam("sourceType", (Object)sourceType);
        showParameter.setCustomParam("sourceAction", (Object)sourceAction);
        showParameter.setCustomParam("changeCause", (Object)changeCause);
        showParameter.setCustomParam("selectEntryRows", selectEntryRows);
        showParameter.setFormId(openView);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openChangeChg(String sourceType, String sourceAction, String openView, Set<Object> selectEntryRows, Set<Object> selectEntrySourceId) {
        FormShowParameter showParameter = new FormShowParameter();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Long sourceId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        StyleCss css = new StyleCss();
        css.setWidth("700");
        css.setHeight("400");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCustomParam("sourceId", (Object)sourceId);
        showParameter.setCustomParam("sourceType", (Object)sourceType);
        showParameter.setCustomParam("sourceAction", (Object)sourceAction);
        showParameter.setCustomParam("selectEntryRows", selectEntryRows);
        showParameter.setCustomParam("selectEntrySourceId", selectEntrySourceId);
        showParameter.setCustomParam("openView", (Object)openView);
        showParameter.setFormId("cas_changemodeselection");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CHANGECHG_CALLBACK));
        this.getView().showForm(showParameter);
    }

    private boolean isOnlyOneEntryNums(String billType) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object[] selectedIds = selectedRows.getPrimaryKeyValues();
        DynamicObject agentBill = BusinessDataServiceHelper.loadSingle((Object)selectedIds[0], (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billType));
        DynamicObjectCollection entry = agentBill.getDynamicObjectCollection("entry");
        return entry.size() == 1;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String opKey = evt.getOperationKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        if ("pay".equals(opKey)) {
            DynamicObject agentPayBill2;
            if (selectRows.size() <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AgentPayBillList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            HashSet selectRowsPks = new HashSet();
            selectRows.forEach(listSelectedRow -> selectRowsPks.add(listSelectedRow.getPrimaryKeyValue()));
            Object[] pkArray = selectRowsPks.toArray(new Object[0]);
            QFilter pkFilter = new QFilter("id", "in", (Object)pkArray);
            QFilter isDiffFilter = new QFilter("isdiffcur", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection agentPayBillCol = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"org", (QFilter[])new QFilter[]{pkFilter, isDiffFilter});
            if (agentPayBillCol != null && agentPayBillCol.size() > 0) {
                for (DynamicObject agentPayBill2 : agentPayBillCol) {
                    long orgId = (Long)agentPayBill2.get("org");
                    Set cs1046 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs1046");
                    if (!cs1046.contains(SysParamCs1046Enum.DIFF.getValue()) || selectRowsPks.size() <= 1) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u5f02\u5e01\u79cd\u9700\u8981\u786e\u8ba4\u4ed8\u6b3e\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u6279\u91cf\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"AgentPayBillList_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
            }
            Object pk = selectRows.get(0).getPrimaryKeyValue();
            agentPayBill2 = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"cas_agentpaybill");
            boolean isDiffPay = agentPayBill2.getBoolean("isdiffcur");
            long orgId = (Long)agentPayBill2.getDynamicObject("org").getPkValue();
            Set cs1046 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs1046");
            if (isDiffPay && cs1046.contains(SysParamCs1046Enum.DIFF.getValue())) {
                new AgentPayPayImpl().validate(agentPayBill2);
                FormShowParameter para = new FormShowParameter();
                para.setFormId("cas_agentpaybill_diffpay");
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_DIFFPAY_CALLBACK));
                para.getOpenStyle().setShowType(ShowType.Modal);
                para.setCustomParam("dpcurrency", agentPayBill2.getDynamicObject("dpcurrency").getPkValue());
                para.setCustomParam("payamount", (Object)agentPayBill2.getBigDecimal("payamount"));
                para.setCustomParam("payamt", (Object)agentPayBill2.getBigDecimal("dpamt"));
                para.setCustomParam("agreedrate", (Object)agentPayBill2.getBigDecimal("agreedrate"));
                para.setCustomParam("agreedquotation", (Object)agentPayBill2.getString("agreedquotation"));
                this.getView().showForm(para);
                evt.setCancel(true);
            }
        }
        if ("commitbe".equals(opKey) && selectRows.size() > 0) {
            Object[] selectedRowPks = this.getSelectedRows().getPrimaryKeyValues();
            PluginSignHelper.signOperate((BeforeItemClickEvent)evt, (SignCallbackLisenter)this, (Object[])selectedRowPks, (IFormView)this.getView(), (String)"cas_agentpaybill", (Boolean)true);
        }
    }

    private void changeChg(ClosedCallBackEvent e) {
        Map data;
        String actionId = e.getActionId();
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        if (KEY_CHANGECHG_CALLBACK.equals(actionId)) {
            Map data2 = (Map)e.getReturnData();
            if (null != data2) {
                String btnGroup = (String)data2.get("btnGroup");
                String changeCause = (String)data2.get("changeCause");
                Object selectEntryRowStr = data2.get("selectEntryRows");
                List selectEntryRows = null;
                if (!EmptyUtil.isEmpty(selectEntryRowStr) && selectEntryRowStr instanceof JSONArray) {
                    selectEntryRows = JSONArray.parseArray((String)selectEntryRowStr.toString(), Object.class);
                }
                String sourceAction = (String)data2.get("sourceAction");
                String openView = (String)data2.get("openView");
                switch (btnGroup) {
                    case "A": {
                        this.payInfoChg(billFormId, sourceAction, openView, changeCause, selectEntryRows);
                        break;
                    }
                    case "B": 
                    case "C": {
                        PayInfoChgHelper.saveChangeChg((IFormView)this.getView(), (String)btnGroup, (Map)data2);
                    }
                }
            }
        } else if (KEY_CHOOSEENTRY_CALLBACK.equals(actionId) && null != (data = (Map)e.getReturnData())) {
            Set selectEntryRows = (Set)data.get("selectEntryRows");
            Set selectEntrySourceId = (Set)data.get("selectEntrySourceId");
            if (!CollectionUtils.isEmpty((Collection)selectEntryRows)) {
                logger.info("====\u4ee3\u53d1\u5355\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u63a5\u6536\u56de\u6765\u7684\u5206\u5f55id\u4e3a" + selectEntryRows);
                this.openChangeChg(billFormId, "recAction", "cas_paychgbill_recchg", selectEntryRows, selectEntrySourceId);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)KEY_CANCELLATION) && MessageBoxResult.Yes.equals((Object)res)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(KEY_CANCELLATION, "yes");
            this.getView().invokeOperation("invalid", operateOption);
        }
        if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CANCELPAY_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("cancelpay");
        }
        if ("CONFIRM_MANUALMATCH".equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            ManualMatchHelper.confirmBizBillMatchDetail((IFormView)this.getView(), (String)"org,payeracctbank,dpcurrency");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List successPkIds;
        BillList list;
        List pks;
        boolean isSuccess;
        AbstractOperate op = (AbstractOperate)args.getSource();
        OperationResult result = args.getOperationResult();
        String key = op.getOperateKey();
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String successMessage = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AgentPayBillList_9", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        boolean showSuccess = true;
        switch (key) {
            case "trackdownchgbill": {
                if (result == null || !result.isSuccess()) break;
                CasPluginHelper.trackdownChgBill((IFormView)this.getView());
                return;
            }
            case "pay": {
                successMessage = ResManager.loadKDString((String)"\u4ed8\u6b3e\u6210\u529f\u3002", (String)"AgentPayBillList_10", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                showSuccess = false;
                break;
            }
            case "cancelpay": {
                successMessage = ResManager.loadKDString((String)"\u53d6\u6d88\u4ed8\u6b3e\u6210\u529f\u3002", (String)"AgentPayBillList_11", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                showSuccess = false;
                break;
            }
            case "payagain": {
                successMessage = ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u6210\u529f\u3002", (String)"AgentPayBillList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                showSuccess = false;
            }
        }
        if (result != null && (isSuccess = result.isSuccess()) && showSuccess) {
            this.getView().showSuccessNotification(successMessage);
        }
        if (result != null && "beforesubmit".equals(key) && (pks = result.getSuccessPkIds()) != null && pks.size() > 0) {
            result.setShowMessage(false);
            this.getView().invokeOperation("submit");
        }
        if (result != null && result.isSuccess() && "chargeback".equals(key)) {
            list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (null != selectedRows && selectedRows.size() > 0) {
                CasPluginHelper.chargeBack((IFormPlugin)this, (IFormView)this.getView(), (Object)selectedRows.get(0).getPrimaryKeyValue(), (String)KEY_CALLBACK_CHARGEBACK);
            }
        } else if (result != null && result.isSuccess() && "chargebackwrite".equals(key)) {
            ((IEntityOperate)args.getSource()).setCancelRefresh(false);
        } else if (result != null && result.isSuccess() && "paypushchg".equals(key)) {
            this.openChangeChg(billFormId, "payAction", "cas_paychgbill_paychg", null, null);
        } else if (result != null && result.isSuccess() && "recpushchg".equals(key)) {
            boolean oneEntry = this.isOnlyOneEntryNums(billFormId);
            if (oneEntry) {
                this.openChangeChg(billFormId, "recAction", "cas_paychgbill_recchg", null, null);
            } else {
                this.openChooseEntryModel(billFormId);
            }
        } else if ("urgentpay".equals(key) && result.isSuccess()) {
            successPkIds = result.getSuccessPkIds();
            if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u6025\u6210\u529f\u3002", (String)"PaymentBillList_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        } else if ("cancelurgentpay".equals(key) && result.isSuccess()) {
            successPkIds = result.getSuccessPkIds();
            if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u52a0\u6025\u6210\u529f\u3002", (String)"PaymentBillList_39", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        } else if ("matchdetail".equals(key)) {
            list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            ManualMatchHelper.bizBillMatchDetail((IFormView)this.getView(), (AfterDoOperationEventArgs)args, (ListSelectedRowCollection)selectedRows, (IFormPlugin)this, (String)list.getEntityId(), (String)"org,payeracctbank,dpcurrency");
        }
        if (Arrays.asList("pay", "cancelpay", "syncbankbillstatus", "marknoneedmatch", "cancelmark", "gendelegagent", "cancelentrustpay", "cancelmatch").contains(key) && result != null && result.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.changeChg(e);
        if ("beforesubmit".equals(e.getActionId())) {
            String confirm = (String)e.getReturnData();
            if (confirm != null && confirm.equals("ok")) {
                this.getView().invokeOperation("submit");
            }
        } else {
            Map data;
            if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)KEY_CALLBACK_CHARGEBACK)) {
                Map data2 = (Map)e.getReturnData();
                if (null != data2) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("billid", String.valueOf(data2.get("billid")));
                    option.setVariableValue("reason", String.valueOf(data2.get("reason")));
                    option.setVariableValue("entityname", "cas_agentpaybill");
                    this.getView().invokeOperation("chargebackwrite", option);
                }
                return;
            }
            if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)KEY_DIFFPAY_CALLBACK) && (data = (Map)e.getReturnData()) != null) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("agreedrate", data.get("agreedrate").toString());
                option.setVariableValue("dpamt", data.get("dpamt").toString());
                option.setVariableValue("fee", data.get("fee").toString());
                option.setVariableValue("agreedquotation", data.get("agreedquotation").toString());
                this.getView().invokeOperation("pay", option);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        FormShowParameter formShowParameter = new FormShowParameter();
        BillOperationStatus billStatus = parameter.getBillStatus();
        if (BillOperationStatus.ADDNEW == billStatus) {
            String itemKey = this.getPageCache().get("itemclickkey");
            parameter.getShowParameter().setCustomParam("billtype", (Object)itemKey);
            this.getView().showForm((FormShowParameter)parameter);
            return;
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("EntityName", parameter.getFormId());
        if (!OperationStatus.ADDNEW.equals((Object)e.getParameter().getStatus())) {
            customParam.put("PkId", parameter.getPkId());
        }
        formShowParameter.setCustomParams(customParam);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("bizdate desc,org.id desc,id desc");
    }

    public void signCallback(SignCallbackEvent evt) {
        PluginSignHelper.signCallBack((SignCallbackEvent)evt, (IFormView)this.getView(), (Boolean)true);
    }
}

