/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.cas.business.helper.AcctBalanceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.SettingMapperHelper;
import kd.fi.cas.helper.SystemParameterFcsHelper;
import kd.fi.cas.pojo.BizBalanceModelBean;
import kd.fi.cas.pojo.ModelRequestBean;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.FiCacheHelper;
import org.apache.commons.lang.StringUtils;

public class AttentionCardPlugin
extends DynamicFormPlugin
implements ClickListener {
    private static final String ATTENTIONCARDSET_BTN = "attentioncardset_btn";
    private static final String ADD_ATTENTION_SETTING = "addAttentionSetting";
    private static final Log logger = LogFactory.getLog(AttentionCardPlugin.class);
    private String labCurrencySign;
    private int currencyAmtprecision;

    private void initFormat() {
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        fobj.getCurrencyFormat().setCurrencySymbols(this.labCurrencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(this.currencyAmtprecision);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refresh_btn", "lookupjournal_btn", "lookuptransaction_btn", "addaccountbank_btn", "closeup_btn", "refreshall_btn", "open_btn", ATTENTIONCARDSET_BTN});
        this.addClickListeners(new String[]{"add_pic", "add_label", "delete"});
        this.initF7();
        this.getView().getFormShowParameter().setListentimerElapsed(true);
    }

    private void initF7() {
        BasedataEdit acctBankF7 = (BasedataEdit)this.getControl("accountbankf7");
        acctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"am_accountbank", (String)"47150e89000000ac");
            QFilter[] acctFilter = this.getAcctFilter(orgList);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(acctFilter));
            this.setF7SelectedItem(showParameter);
        });
    }

    protected QFilter[] getAcctFilter(Set<Long> orgPks) {
        QFilter[] accountFilter = new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgPks)};
        ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
        Collections.addAll(qFilterArrayList, accountFilter);
        qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
        return accountFilter;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<DynamicObject> userSettings = this.getUserSetting();
        ArrayList<Long> acctBankIds = new ArrayList<Long>(userSettings.size());
        for (int i = 0; i < userSettings.size(); ++i) {
            Long acctBankId = userSettings.get(i).getLong("accountbank.id");
            acctBankIds.add(acctBankId);
        }
        this.addAttentionCard(acctBankIds);
        this.getView().setVisible(Boolean.FALSE, new String[]{"lastupdatetime", "open_btn"});
    }

    private List<DynamicObject> getUserSetting() {
        Long userId = RequestContext.get().getCurrUserId();
        String selectors = "user,accountbank,currency,order";
        DynamicObject[] userSettings = BusinessDataServiceHelper.load((String)"cas_attentionsetting", (String)selectors, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)}, (String)"order");
        ArrayList<DynamicObject> attentionSettings = new ArrayList<DynamicObject>(userSettings.length);
        attentionSettings.addAll(Arrays.asList(userSettings));
        return attentionSettings;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "refresh_btn": {
                this.refreshSingle();
                break;
            }
            case "lookupjournal_btn": {
                this.lookUpJournal();
                break;
            }
            case "lookuptransaction_btn": {
                this.lookUpTransDetail();
                break;
            }
            case "add_pic": {
                this.showAddAcctBankView();
                break;
            }
            case "add_label": {
                this.showAddAcctBankView();
                break;
            }
            case "addaccountbank_btn": {
                this.showAddAcctBankView();
                break;
            }
            case "refreshall_btn": {
                this.refreshAll();
                break;
            }
            case "delete": {
                this.confirmBeforeDelete();
                break;
            }
            case "attentioncardset_btn": {
                this.showAttentionCardSetView();
                break;
            }
        }
    }

    private void confirmBeforeDelete() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        String bankNumber = (String)this.getModel().getValue("banknumber", rowIndex);
        String confirmMessage = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4e0d\u518d\u5173\u6ce8\u5c3e\u53f7\u4e3a%s\u7684\u94f6\u884c\u8d26\u6237\uff1f", (String)"AttentionCardPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), bankNumber);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete", (IFormPlugin)this);
        this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && "delete".equals(callBackId)) {
            this.deleteAttentionItem();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (ADD_ATTENTION_SETTING.equals(actionId)) {
            this.getModel().deleteEntryData("acctbankcardentry");
            List<DynamicObject> userSettings = this.getUserSetting();
            if (EmptyUtil.isEmpty(userSettings)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"add_card"});
                return;
            }
            ArrayList<Long> acctBankIds = new ArrayList<Long>(userSettings.size());
            for (int i = 0; i < userSettings.size(); ++i) {
                Long acctBankId = userSettings.get(i).getLong("accountbank.id");
                acctBankIds.add(acctBankId);
            }
            this.addAttentionCard(acctBankIds);
            this.getView().updateView();
        }
        super.closedCallBack(closedCallBackEvent);
    }

    private void deleteAttentionItem() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        DynamicObject acctBank = this.getDynamicObject("accountbank", rowIndex);
        DynamicObject currency = this.getDynamicObject("currency", rowIndex);
        Long userId = RequestContext.get().getCurrUserId();
        QFilter acctBankFilter = new QFilter("accountbank", "=", acctBank.getPkValue());
        QFilter currencyFilter = new QFilter("currency", "=", currency.getPkValue());
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        DeleteServiceHelper.delete((String)"cas_attentionsetting", (QFilter[])new QFilter[]{userFilter, acctBankFilter, currencyFilter});
        this.getModel().deleteEntryRow("acctbankcardentry", rowIndex);
        int rowCount = this.getModel().getEntryRowCount("acctbankcardentry");
        if (rowCount == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"add_card"});
        }
    }

    private void refreshAll() {
        int rowCount = this.getModel().getEntryRowCount("acctbankcardentry");
        if (rowCount == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u91cd\u70b9\u5173\u6ce8\u8d26\u6237\u3002", (String)"AttentionCardPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        int[] indexArr = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            indexArr[i] = i;
        }
        this.refreshBalance(indexArr);
        this.getView().updateView("acctbankcardentry");
    }

    private void refreshSingle() {
        int index = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        this.queryBalanceByOnline(new int[]{index});
    }

    private void refreshBalance(int[] rowIndexs) {
        ArrayList<OperateErrorInfo> allErrorInfo = new ArrayList<OperateErrorInfo>();
        HashMap<Long, Boolean> rightMap = new HashMap<Long, Boolean>();
        LinkedHashMap<Long, String> accountCurrencyIdMap = new LinkedHashMap<Long, String>();
        HashMap<Long, DynamicObject> accountMap = new HashMap<Long, DynamicObject>(rowIndexs.length);
        HashSet<Long> orgIds = new HashSet<Long>(rowIndexs.length);
        for (int i = 0; i < rowIndexs.length; ++i) {
            int rowIndex = rowIndexs[i];
            DynamicObject acctBank = this.getDynamicObject("accountbank", rowIndex);
            Long orgId = acctBank.getLong("company.id");
            Boolean hasViewRight = (Boolean)rightMap.get(orgId);
            if (hasViewRight == null) {
                hasViewRight = PermissionHelper.hasViewRight((long)orgId, (String)"bei_bankbalance");
                rightMap.put(orgId, hasViewRight);
            }
            if (!hasViewRight.booleanValue()) {
                String message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7%s\u94f6\u884c\u8d26\u6237\u4f59\u989d\u7684\u66f4\u65b0\u6743\u9650\uff0c\u8bf7\u5206\u914d\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AttentionCardPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBank.getString("company.name"));
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Warning);
                errorInfo.setMessage(message);
                allErrorInfo.add(errorInfo);
                continue;
            }
            Long currencyId = this.getPk("currency", rowIndex);
            accountCurrencyIdMap.put(acctBank.getLong("id"), currencyId + "_" + rowIndex + "_" + orgId);
            orgIds.add(orgId);
            accountMap.put(acctBank.getLong("id"), acctBank);
        }
        Map<String, BizBalanceModelBean> balanceModelMap = this.queryBalanceModel(accountCurrencyIdMap, orgIds);
        for (Map.Entry entry : accountCurrencyIdMap.entrySet()) {
            Long currencyId = Long.valueOf(((String)entry.getValue()).split("_")[0]);
            int rowIndex = Integer.parseInt(((String)entry.getValue()).split("_")[1]);
            this.showBalanceByModel(rowIndex, balanceModelMap.get(entry.getKey() + ";" + currencyId));
            Long accountId = (Long)entry.getKey();
            DynamicObject acctBank = (DynamicObject)accountMap.get(accountId);
            this.setVisibleByRefreshBtn(acctBank, rowIndex);
        }
        if (!allErrorInfo.isEmpty()) {
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setBillCount(rowIndexs.length);
            operationResult.setSuccessPkIds(new ArrayList(accountCurrencyIdMap.keySet()));
            operationResult.setShowMessage(true);
            operationResult.setAllErrorInfo(allErrorInfo);
            this.getView().showOperationResult(operationResult);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u6210\u529f\u3002", (String)"AttentionCardPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private void lookUpJournal() {
        int index = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        DynamicObject acctBank = this.getDynamicObject("accountbank", index);
        Long orgId = acctBank.getLong("company.id");
        boolean hasViewRight = PermissionHelper.hasViewRight((long)orgId, (String)"cas_bankjournal");
        if (!hasViewRight) {
            String message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7%s\u94f6\u884c\u65e5\u8bb0\u8d26\u7684\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u5206\u914d\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AttentionCardPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBank.getString("org.name"));
            this.getView().showErrorNotification(message);
            return;
        }
        DynamicObject period = PeriodHelper.getPeriodByDate((long)orgId, (Date)new Date());
        if (period == null) {
            String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u672a\u8fdb\u884c\u521d\u59cb\u5316\uff0c\u5982\u9700\u7ee7\u7eed\u67e5\u8be2\uff0c\u8bf7\u524d\u5f80\u201c\u521d\u59cb\u5316>\u51fa\u7eb3\u521d\u59cb\u5316\u201d\u83dc\u5355\u5b8c\u6210\u8bbe\u7f6e\u53ca\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"AttentionCardPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBank.getString("org.name"));
            this.getView().showErrorNotification(message);
            return;
        }
        ReportShowParameter fsp = new ReportShowParameter();
        fsp.setFormId("cas_bankjournalformrpt");
        fsp.setCustomParam("setDefaultFilters", (Object)Boolean.TRUE);
        fsp.setCustomParam("org", (Object)orgId);
        fsp.setCustomParam("accountBank", acctBank.getPkValue());
        fsp.setCustomParam("currency", (Object)acctBank.getLong("defaultcurrency.id"));
        fsp.setCustomParam("datatype", (Object)1);
        fsp.setCustomParam("beginperiod", period.getPkValue());
        fsp.setCustomParam("endperiod", period.getPkValue());
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        fsp.setOpenStyle(openStyle);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void lookUpTransDetail() {
        int index = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        DynamicObject acctBank = this.getDynamicObject("accountbank", index);
        Long orgId = acctBank.getLong("company.id");
        boolean hasViewRight = PermissionHelper.hasViewRight((long)orgId, (String)"bei_transdetail_cas");
        if (!hasViewRight) {
            String message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7%s\u4ea4\u6613\u660e\u7ec6\u7684\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u5206\u914d\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AttentionCardPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBank.getString("org.name"));
            this.getView().showErrorNotification(message);
            return;
        }
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("bei_transdetail_cas");
        fsp.setCustomParam("setDefaultFilters", (Object)Boolean.TRUE);
        fsp.setCustomParam("company.id", Collections.singletonList(orgId));
        fsp.setCustomParam("accountbank.id", Collections.singletonList(acctBank.getPkValue()));
        fsp.setCustomParam("currency.id", (Object)acctBank.getLong("defaultcurrency.id"));
        fsp.setCustomParam("bizdate", (Object)63);
        LspWapper lspWapper = new LspWapper(fsp);
        lspWapper.clearPlugins();
        lspWapper.registerPlugin("kd.tmc.bei.formplugin.detail.TransDetailHyperlinkList");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        fsp.setOpenStyle(openStyle);
        fsp.setCaption(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5217\u8868", (String)"AttentionCardPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void showAddAcctBankView() {
        String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"am_accountbank", (String)"47150e89000000ac");
        if (orgList.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u6ca1\u6709\u6709\u6743\u9650\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"PaymentCalendarPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        BasedataEdit acctBankF7 = (BasedataEdit)this.getControl("accountbankf7");
        acctBankF7.click();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("accountbankf7".equals(key)) {
            this.acctBankChanged(newValue);
        }
    }

    private void acctBankChanged(Object newValue) {
        if (newValue == null) {
            return;
        }
        DynamicObjectCollection acctBanks = (DynamicObjectCollection)newValue;
        ArrayList<Long> acctBankIds = new ArrayList<Long>(acctBanks.size());
        for (DynamicObject acctBank : acctBanks) {
            acctBank = acctBank.getDynamicObject("fbasedataid");
            this.saveAttentionSetting(acctBank);
            acctBankIds.add(acctBank.getLong("id"));
        }
        this.addAttentionCard(acctBankIds);
        this.getModel().setValue("accountbankf7", (Object)new Object[0]);
    }

    private void addAttentionCard(List<Long> acctBankIds) {
        DynamicObject[] acctBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"bank,defaultcurrency,company", (QFilter[])new QFilter("id", "in", acctBankIds = acctBankIds.stream().distinct().collect(Collectors.toList())).toArray());
        if (acctBanks == null || acctBanks.length <= 0) {
            return;
        }
        DynamicObject[] acctBanksOrder = AttentionCardPlugin.getOrderlyAcctBanks(acctBankIds, acctBanks);
        Set bankIds = Arrays.asList(acctBanksOrder).stream().map(o -> o.getLong("bank.id")).collect(Collectors.toSet());
        DynamicObjectCollection banks = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIds)});
        Map<Long, DynamicObject> idToBankMap = banks.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (a, b) -> a));
        DynamicObject[] finOrgImgs = SettingMapperHelper.queryAll((String)"finorgimg");
        Map<String, DynamicObject> idToFinOrgImgMap = Arrays.asList(finOrgImgs).stream().collect(Collectors.toMap(o -> o.getString("key"), o -> o, (a, b) -> a));
        LinkedHashMap<Long, String> accountCurrencyIdMap = new LinkedHashMap<Long, String>(acctBanksOrder.length);
        HashSet<Long> orgIds = new HashSet<Long>(acctBanksOrder.length);
        for (DynamicObject acctBank : acctBanksOrder) {
            Long currencyId = acctBank.getLong("defaultcurrency.id");
            String rowIndex = "0";
            Long orgId = acctBank.getLong("company.id");
            accountCurrencyIdMap.put(acctBank.getLong("id"), currencyId + "_" + rowIndex + "_" + orgId);
            orgIds.add(orgId);
        }
        Map<String, BizBalanceModelBean> balanceModelBeanMap = this.queryBalanceModel(accountCurrencyIdMap, orgIds);
        for (DynamicObject acctBank : acctBanksOrder) {
            DynamicObject finOrgImg;
            DynamicObject bank = idToBankMap.get(acctBank.getLong("bank.id"));
            String url = null;
            if (bank != null && (finOrgImg = idToFinOrgImgMap.get(bank.getString("bank_cate"))) != null) {
                url = finOrgImg.getString("value");
            }
            this.addAttentionCard(acctBank.getLong("id"), bank, url, balanceModelBeanMap);
        }
        this.getView().updateView("acctbankcardentry");
    }

    private void addAttentionCard(Object accountBank, DynamicObject bank, String url, Map<String, BizBalanceModelBean> balanceModelBeanMap) {
        String acctBankNumber;
        if (accountBank == null) {
            return;
        }
        if (this.existCard(accountBank)) {
            return;
        }
        int newIndex = this.getModel().createNewEntryRow("acctbankcardentry");
        this.setValue("accountbank", accountBank, newIndex);
        DynamicObject acctBank = null;
        if (accountBank instanceof DynamicObject) {
            acctBank = (DynamicObject)accountBank;
        } else if (accountBank instanceof Long) {
            acctBank = this.getDynamicObject("accountbank", newIndex);
        }
        if (acctBank == null) {
            this.getModel().deleteEntryRow("acctbankcardentry", newIndex);
            return;
        }
        this.setValue("currency", acctBank.getLong("defaultcurrency.id"), newIndex);
        String bankName = acctBank.getString("bank.name");
        this.setValue("bankname", bankName, newIndex);
        if (bank != null) {
            String bkImg = url != null ? url : "/images/pc/cardbackground/card_otherbank_280_150.png";
            String rootUrl = UrlService.getDomainContextUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            this.setValue("backgroundimg", rootUrl + bkImg, newIndex);
        }
        if ((acctBankNumber = acctBank.getString("bankaccountnumber")).length() > 4) {
            acctBankNumber = acctBankNumber.substring(acctBankNumber.length() - 4);
        }
        acctBankNumber = String.format("(%s)", acctBankNumber);
        this.setValue("banknumber", acctBankNumber, newIndex);
        DynamicObject bankOrg = acctBank.getDynamicObject("company");
        String bankOrgName = null;
        if (EmptyUtil.isNoEmpty((DynamicObject)bankOrg)) {
            bankOrgName = bankOrg.getLocaleString("name").toString();
        }
        this.setValue("bankorg", bankOrgName, newIndex);
        Long currencyId = this.getPk("currency", newIndex);
        this.showBalanceByModel(newIndex, balanceModelBeanMap.get(acctBank.getLong("id") + ";" + currencyId));
        this.setVisibleByRefreshBtn(acctBank, newIndex);
        this.getView().setVisible(Boolean.FALSE, new String[]{"add_card"});
    }

    private void setVisibleByRefreshBtn(DynamicObject acctBank, int newIndex) {
        if (EmptyUtil.isEmpty((DynamicObject)acctBank)) {
            return;
        }
        boolean visible = false;
        if (acctBank.getBoolean("issetbankinterface")) {
            visible = true;
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("acctbankcardentry");
        cardEntry.setChildVisible(visible, newIndex, new String[]{"refresh_btn"});
    }

    private void showBalanceByOnline(int newIndex, DynamicObject lastestBalanceInquire) {
        if (lastestBalanceInquire != null) {
            BigDecimal balance = lastestBalanceInquire.getBigDecimal("amount");
            DynamicObject currency = this.getDynamicObject("currency", newIndex);
            String balanceStr = this.formatAmount(balance, currency);
            this.setValue("balance", balanceStr, newIndex);
            this.initFormat();
            Date lastUpdateTime = lastestBalanceInquire.getDate("modifytime");
            this.setValue("updatetime", lastUpdateTime, newIndex);
        }
    }

    private void showBalanceByModel(int newIndex, BizBalanceModelBean bizBalanceModelBean) {
        if (bizBalanceModelBean != null) {
            BigDecimal balance = bizBalanceModelBean.getAmount();
            DynamicObject currency = this.getDynamicObject("currency", newIndex);
            String balanceStr = this.formatAmount(balance, currency);
            this.setValue("balance", balanceStr, newIndex);
            this.initFormat();
            Date lastUpdateTime = bizBalanceModelBean.getLastTime();
            String balanceType = bizBalanceModelBean.getBalanceType();
            if ("book".equals(balanceType) || lastUpdateTime == null) {
                CardEntry cardEntry = (CardEntry)this.getView().getControl("acctbankcardentry");
                cardEntry.setChildVisible(false, newIndex, new String[]{"updatetime"});
            } else {
                this.setValue("updatetime", lastUpdateTime, newIndex);
            }
        }
    }

    private void saveAttentionSetting(DynamicObject acctBank) {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] userSettings = BusinessDataServiceHelper.load((String)"cas_attentionsetting", (String)"order", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)}, (String)"order");
        int order = 0;
        if (userSettings.length > 0) {
            order = userSettings[userSettings.length - 1].getInt("order") + 1;
        }
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"cas_attentionsetting");
        DynamicObject attentionItem = new DynamicObject((DynamicObjectType)dt);
        attentionItem.set("user", (Object)userId);
        attentionItem.set("accountbank", acctBank.getPkValue());
        attentionItem.set("currency", (Object)acctBank.getLong("defaultcurrency.id"));
        attentionItem.set("order", (Object)order);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attentionItem});
    }

    private boolean existCard(Object acctBank) {
        int rowCount = this.getModel().getEntryRowCount("acctbankcardentry");
        Long acctBankId = null;
        if (acctBank instanceof DynamicObject) {
            acctBankId = Long.valueOf(((DynamicObject)acctBank).getPkValue().toString());
        } else if (acctBank instanceof Long) {
            acctBankId = (Long)acctBank;
        }
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entryAccountBank = this.getDynamicObject("accountbank", i);
            if (entryAccountBank == null || acctBankId == null || !acctBankId.equals(entryAccountBank.getLong("id"))) continue;
            return true;
        }
        return false;
    }

    private String formatAmount(BigDecimal amount, DynamicObject currency) {
        String currencySign = "";
        int amountPrecition = 4;
        if (amount == null) {
            amount = BigDecimal.ZERO;
        }
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
            amount = amount.setScale(amountPrecition, 4);
            this.labCurrencySign = currency.getString("sign");
            this.currencyAmtprecision = amountPrecition;
        }
        String formatStr = "###,##0." + StringUtils.repeat((String)"0", (int)amountPrecition);
        DecimalFormat decimalFormat = new DecimalFormat(formatStr);
        String amountStr = decimalFormat.format(amount);
        return currencySign + amountStr;
    }

    private static DynamicObject[] getOrderlyAcctBanks(List<Long> acctBankIds, DynamicObject[] acctBanks) {
        Map acctBankMap = Arrays.stream(acctBanks).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        DynamicObject[] acctBanksOrder = new DynamicObject[acctBanks.length];
        int index = 0;
        for (Long acctbankId : acctBankIds) {
            DynamicObject dynamicObject = (DynamicObject)acctBankMap.get(acctbankId);
            if (!EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) continue;
            acctBanksOrder[index++] = dynamicObject;
        }
        return acctBanksOrder;
    }

    private void showAttentionCardSetView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d26\u6237\u8bbe\u7f6e", (String)"AttentionCardPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("cas_attentionsettingform");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getPageId();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_ATTENTION_SETTING);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void setF7SelectedItem(ListShowParameter showParameter) {
        List<DynamicObject> userSetting = this.getUserSetting();
        if (EmptyUtil.isNoEmpty(userSetting)) {
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            for (DynamicObject dynamicObject : userSetting) {
                DynamicObject accountbank = dynamicObject.getDynamicObject("accountbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)accountbank)) continue;
                long accountbankId = accountbank.getLong("id");
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)accountbankId);
                listSelectedRows.add((Object)listSelectedRow);
            }
            showParameter.setListSelectedRowCollection(listSelectedRows);
        }
    }

    private void queryBalanceByOnline(int[] rowIndexs) {
        int rowIndex = rowIndexs[0];
        ArrayList<OperateErrorInfo> allErrorInfo = new ArrayList<OperateErrorInfo>(2);
        DynamicObject acctBank = this.getDynamicObject("accountbank", rowIndex);
        Long orgId = acctBank.getLong("company.id");
        boolean hasViewRight = PermissionHelper.hasViewRight((long)orgId, (String)"bei_bankbalance");
        if (!hasViewRight) {
            String message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7%s\u94f6\u884c\u8d26\u6237\u4f59\u989d\u7684\u66f4\u65b0\u6743\u9650\uff0c\u8bf7\u5206\u914d\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AttentionCardPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBank.getString("company.name"));
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setLevel(ErrorLevel.Error);
            errorInfo.setMessage(message);
            allErrorInfo.add(errorInfo);
        }
        Long currencyId = this.getPk("currency", rowIndex);
        ArrayList<Long> successPkIds = new ArrayList<Long>(2);
        DistributeSessionlessCache cache = FiCacheHelper.getSessionlessCacheInstance();
        long acctBankId = acctBank.getLong("id");
        String cacheKey = "refreshBalance-" + RequestContext.get().getCurrUserId();
        cache.put(cacheKey, (Object)cacheKey, 60, TimeUnit.SECONDS);
        OperationResult onlineUpdateOperationResult = AcctBalanceHelper.onlineUpdate((Long)acctBankId, (Long)currencyId);
        if (onlineUpdateOperationResult.isSuccess()) {
            successPkIds.add(acctBankId);
            DynamicObject lastestBeBalance = AcctBalanceHelper.getLastestBeBalance((Long)acctBankId, (Long)currencyId);
            logger.info(String.format("==\u94f6\u884c\u4fe1\u606f{%s}==", acctBank));
            logger.info(String.format("==\u4f59\u989d\u67e5\u8be2{%s}==", lastestBeBalance));
            this.showBalanceByOnline(rowIndex, lastestBeBalance);
            this.setVisibleByRefreshBtn(acctBank, rowIndex);
        } else {
            allErrorInfo.addAll(onlineUpdateOperationResult.getAllErrorInfo());
        }
        logger.info(String.format("==\u66f4\u65b0\u6b21\u6570{%s},\u66f4\u65b0\u7ed3\u679c{%s}==", rowIndex, onlineUpdateOperationResult.toString()));
        if (allErrorInfo.size() > 0) {
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setBillCount(rowIndexs.length);
            operationResult.setSuccessPkIds(successPkIds);
            operationResult.setShowMessage(true);
            operationResult.setAllErrorInfo(allErrorInfo);
            this.getView().showOperationResult(operationResult);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f\u3002", (String)"AttentionCardPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        this.getView().updateView("acctbankcardentry");
    }

    private Map<String, BizBalanceModelBean> queryBalanceModel(Map<Long, String> accountCurrencyIdMap, Set<Long> orgIds) {
        Map balancevalueMap = SystemParameterFcsHelper.getBatchParameterString(new ArrayList<Long>(orgIds), (String)"balancevalue");
        ArrayList<BizBalanceModelBean> bizBeanList = new ArrayList<BizBalanceModelBean>(accountCurrencyIdMap.size());
        for (Map.Entry<Long, String> entry : accountCurrencyIdMap.entrySet()) {
            BizBalanceModelBean bizBean = new BizBalanceModelBean();
            String[] keys = entry.getValue().split("_");
            bizBean.setAccountId(entry.getKey());
            bizBean.setCurrencyId(Long.valueOf(Long.parseLong(keys[0])));
            bizBean.setBalanceType((String)balancevalueMap.get(keys[2]));
            bizBeanList.add(bizBean);
        }
        Map<String, BizBalanceModelBean> bizBalanceModelBeanMap = new HashMap<String, BizBalanceModelBean>(bizBeanList.size());
        if (!bizBeanList.isEmpty()) {
            ModelRequestBean modelRequestBean = new ModelRequestBean();
            modelRequestBean.setBizBeans(bizBeanList);
            Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalanceBatch", (Object[])new Object[]{SerializationUtils.toJsonString((Object)modelRequestBean)});
            modelRequestBean = (ModelRequestBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), ModelRequestBean.class);
            if (modelRequestBean != null && modelRequestBean.getBizBeans() != null) {
                bizBalanceModelBeanMap = modelRequestBean.getBizBeans().stream().filter(d -> d != null && EmptyUtil.isNoEmpty((Long)d.getAccountId()) && EmptyUtil.isNoEmpty((Long)d.getCurrencyId())).collect(Collectors.toMap(e -> e.getAccountId() + ";" + e.getCurrencyId(), e -> e, (v1, v2) -> v2));
            }
        }
        return bizBalanceModelBeanMap;
    }
}

