/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.journal.SourceNumber;
import kd.fi.cas.business.journal.VoucherBookService;
import kd.fi.cas.business.journal.VoucherMatcher;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;

public class BalanceAdjustEditPlugin
extends BillEditPlugin {
    private static final Log logger = LogFactory.getLog(BalanceAdjustEditPlugin.class);
    private BalanceCountService balanceCountService = new BalanceCountService();

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_refresh"});
        DynamicObject balAdjust = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"cas_balanceadjust");
        if ("A".equals(this.getModel().getValue("billstatus"))) {
            this.getModel().deleteEntryData("enter_entry");
            this.getModel().deleteEntryData("bank_entry");
            this.getNewEntryInfo(balAdjust.getLong("org.id"), balAdjust.getLong("bankaccount.id"), balAdjust.getLong("currency.id"), balAdjust.getDate("bizdate"));
        } else {
            int enterindexs = this.getModel().getEntryRowCount("enter_entry");
            for (int i = 0; i < enterindexs; ++i) {
                if (QueryServiceHelper.exists((String)((String)this.getModel().getValue("sourcetype", i)), (Object)this.getModel().getValue("billid", i))) continue;
                this.getModel().setValue("enter_errmessage", (Object)ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u88ab\u5220\u9664", (String)"BalanceAdjustEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), i);
            }
            int bankindexs = this.getModel().getEntryRowCount("bank_entry");
            for (int i = 0; i < bankindexs; ++i) {
                if (QueryServiceHelper.exists((String)((String)this.getModel().getValue("banksourcetype", i)), (Object)this.getModel().getValue("bankbillid", i))) continue;
                this.getModel().setValue("bank_errmessage", (Object)ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u88ab\u5220\u9664", (String)"BalanceAdjustEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), i);
            }
        }
        this.getPageCache().put("saveed", "1");
        this.getView().getModel().setDataChanged(false);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("isinit")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit", "bar_refresh", "btn_submit", "btn_unaudit"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_audit", "bar_refresh"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.containsKey("org") && customParams.containsKey("accountbank") && customParams.containsKey("currency") && customParams.containsKey("enddate")) {
            if (CasHelper.isEmpty(customParams.get("org")) || CasHelper.isEmpty(customParams.get("accountbank")) || CasHelper.isEmpty(customParams.get("currency")) || CasHelper.isEmpty(customParams.get("enddate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u9884\u89c8\u5931\u8d25\u3002", (String)"BalanceAdjustEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_refresh"});
            if (customParams.containsKey("isinit")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit", "bar_refresh", "btn_submit", "btn_unaudit"});
            }
            Long orgId = this.getLong(customParams.get("org"));
            Long accountBankId = this.getLong(customParams.get("accountbank"));
            Long currencyId = this.getLong(customParams.get("currency"));
            Date endDate = DateUtils.stringToDate((String)String.valueOf(customParams.get("enddate")), (String)"yyyy-MM-dd HH:mm:ss");
            this.setValue("org", orgId);
            this.setValue("bankaccount", accountBankId);
            this.setValue("currency", currencyId);
            this.setValue("bizdate", endDate);
            DynamicObject periodByDate = PeriodHelper.getPeriodByDate((long)orgId, (Date)endDate);
            if (periodByDate != null) {
                this.setValue("period", periodByDate);
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"billstatus"});
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)orgId);
            if (initObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u521d\u59cb\u5316\u672a\u5b8c\u6210\u3002", (String)"BalanceAdjustEditPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            DynamicObject startperiod = initObj.getDynamicObject("startperiod");
            if (startperiod == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"BalanceAdjustEditPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            Date startDate = startperiod.getDate("begindate");
            if (endDate.before(startDate) && !customParams.containsKey("isinit")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5c0f\u4e8e\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\uff01", (String)"BalanceAdjustEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            this.getNewEntryInfo(orgId, accountBankId, currencyId, endDate);
        }
        if (customParams != null && !customParams.containsKey("billno")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_print"});
        }
    }

    private void getNewEntryInfo(Long orgId, Long accountBankId, Long currencyId, Date endDate) {
        DynamicObject accountBank = AccountBankHelper.getAccountBankById((long)accountBankId);
        Long createOrgId = (Long)accountBank.getDynamicObject("createorg").getPkValue();
        DynamicObject initObj = PeriodHelper.getCasInitInfo((long)createOrgId);
        endDate = DateUtils.getBeforeDate((Date)endDate, (Date)new Date());
        boolean useBalanceModel = ExtendConfigHelper.useBalanceModel();
        BigDecimal journalbalamt = BigDecimal.ZERO;
        BigDecimal statmntbalamt = BigDecimal.ZERO;
        if (useBalanceModel) {
            logger.info("---->>> BalanceAdjustEditPlugin.getNewEntryInfo(),orgId={},endDate={}", (Object)orgId, (Object)DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss"));
            DynamicObject period = PeriodHelper.getPeriodByDate((long)orgId, (Date)endDate);
            Date startDate = period.getDate("begindate");
            journalbalamt = this.balanceCountService.queryByBalanceModel(BalanceType.JOURNAL, orgId.longValue(), accountBankId.longValue(), currencyId.longValue(), startDate, endDate);
            statmntbalamt = this.balanceCountService.queryByBalanceModel(BalanceType.STATE, orgId.longValue(), accountBankId.longValue(), currencyId.longValue(), startDate, endDate);
            logger.info("---->>> BalanceAdjustEditPlugin.getNewEntryInfo(),query balance from balance-model, journalbalamt={},statmntbalamt={}", (Object)String.valueOf(journalbalamt), (Object)String.valueOf(statmntbalamt));
        } else {
            journalbalamt = this.balanceCountService.getJournalBalanceByAccount(accountBankId, currencyId, endDate);
            statmntbalamt = this.balanceCountService.getStatmBalance(createOrgId, accountBankId, currencyId, endDate);
        }
        List stateIds = BalanceAdjustHelper.getHasCheckedByDate((Long)createOrgId, (Long)accountBankId, (Long)currencyId, (Date)endDate, (String)"cas_bankstatement");
        List journalIds = BalanceAdjustHelper.getHasCheckedByDate((Long)createOrgId, (Long)accountBankId, (Long)currencyId, (Date)endDate, (String)"cas_bankjournal");
        ArrayList<Long> stateIdsNew = new ArrayList<Long>(stateIds.size());
        if (stateIds.size() > 0) {
            stateIds.forEach(o -> stateIdsNew.add(Long.parseLong(o)));
        }
        ArrayList<Long> journalIdsNew = new ArrayList<Long>(journalIds.size());
        if (journalIds.size() > 0) {
            journalIds.forEach(o -> journalIdsNew.add(Long.parseLong(o)));
        }
        DynamicObject recInitObject = this.getRecInit(orgId);
        this.adJustAmount(journalbalamt, endDate, "cas_bankstatement", new QFilter[]{this.getNoReachQfilter(recInitObject, accountBankId, currencyId, endDate, false)}, stateIdsNew);
        this.adJustAmount(statmntbalamt, endDate, "cas_bankjournal", new QFilter[]{this.getNoReachQfilter(initObj, accountBankId, currencyId, endDate, true)}, journalIdsNew);
    }

    private void adJustAmount(BigDecimal startbalamt, Date endDate, String sourceType, QFilter[] procFilters, List<Long> ids) {
        BigDecimal adjustamt = new BigDecimal("0");
        BigDecimal creditSum = new BigDecimal("0");
        BigDecimal debitSum = new BigDecimal("0");
        DynamicObjectCollection colls = QueryServiceHelper.query((String)sourceType, (String)this.getQueryStr(sourceType), (QFilter[])procFilters, (String)"accountbank");
        Set idsOnce = colls.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        List<Object> willQueryIds = new ArrayList();
        if (null != ids && ids.size() > 0) {
            if (null != idsOnce && idsOnce.size() > 0) {
                for (Long id : ids) {
                    if (idsOnce.contains(id)) continue;
                    willQueryIds.add(id);
                }
            } else {
                willQueryIds = ids;
            }
            logger.info("========will query willQueryIds\uff1a" + willQueryIds.size());
            if (willQueryIds.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", willQueryIds);
                if (sourceType.equals("cas_bankstatement")) {
                    qFilter.and(new QFilter("isbank", "=", (Object)"1"));
                }
                qFilter.and(new QFilter("isvalid", "=", (Object)"1"));
                DynamicObjectCollection collsByIds = QueryServiceHelper.query((String)sourceType, (String)this.getQueryStr(sourceType), (QFilter[])new QFilter[]{qFilter}, (String)"accountbank");
                if (null != collsByIds && collsByIds.size() > 0) {
                    colls.addAll((Collection)collsByIds);
                }
            }
        }
        logger.info("======== query data end\uff1a");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object journal = customParams.get("journal");
        Object statem = customParams.get("statem");
        Object orgId = customParams.get("org");
        Object periodId = customParams.get("startPeriod");
        Object acctId = customParams.get("acct");
        Object currency = customParams.get("currency");
        for (DynamicObject obj : colls) {
            creditSum = creditSum.add(obj.getBigDecimal("creditamount"));
            debitSum = debitSum.add(obj.getBigDecimal("debitamount"));
        }
        if (sourceType.equals("cas_bankstatement")) {
            logger.info("before deal balance:" + startbalamt);
            if (customParams.containsKey("journal")) {
                if (CasHelper.isNotEmpty(orgId) && CasHelper.isNotEmpty(periodId) && CasHelper.isNotEmpty(acctId)) {
                    BigDecimal amountByPeriod = BalanceAdjustHelper.getAmountByPeriod((Long)Long.parseLong(String.valueOf(periodId)), (Long)Long.parseLong(String.valueOf(acctId)), (Long)Long.parseLong(String.valueOf(orgId)), (Long)Long.parseLong(String.valueOf(currency)));
                    startbalamt = amountByPeriod.add(startbalamt);
                }
                startbalamt = startbalamt.add((BigDecimal)journal);
            }
            logger.info("after deal balance" + startbalamt);
            adjustamt = startbalamt.add(creditSum).subtract(debitSum);
            this.getModel().setValue("journalbalamt", (Object)startbalamt);
            this.getModel().setValue("bankgotamt", (Object)creditSum);
            this.getModel().setValue("bankpayedamt", (Object)debitSum);
            this.getModel().setValue("adjustjournalamt", (Object)adjustamt);
        } else {
            logger.info("before deal balance1" + startbalamt);
            if (CasHelper.isNotEmpty(statem)) {
                startbalamt = startbalamt.add((BigDecimal)statem);
            }
            adjustamt = startbalamt.add(debitSum).subtract(creditSum);
            logger.info("after deal balance1" + startbalamt);
            this.getModel().setValue("statmntbalamt", (Object)startbalamt);
            this.getModel().setValue("entprgotamt", (Object)debitSum);
            this.getModel().setValue("entprpayedamt", (Object)creditSum);
            this.getModel().setValue("adjuststatementamt", (Object)adjustamt);
        }
        this.getTableVsSetter(sourceType, colls);
    }

    public QFilter getNoReachQfilter(DynamicObject initObj, Long accountBankId, Long currencyId, Date endDate, Boolean isJournal) {
        QFilter noInitFilter = new QFilter("period", "=", (Object)0);
        QFilter procFilters = new QFilter("accountbank", "=", (Object)accountBankId);
        procFilters = procFilters.and(new QFilter("currency", "=", (Object)currencyId));
        procFilters = procFilters.and(new QFilter("ischeck", "=", (Object)"0"));
        procFilters = procFilters.and(new QFilter("isvalid", "=", (Object)"1"));
        QFilter noReachFilter = procFilters.copy().and(noInitFilter);
        Date date = DateUtils.getBeforeDate((Date)endDate, (Date)new Date());
        date = DateUtils.getDataFormat((Date)date, (boolean)false);
        if (initObj != null && initObj.getBoolean("isfinishinit")) {
            noReachFilter = procFilters.and(new QFilter(isJournal != false ? "bookdate" : "bizdate", "<=", (Object)date));
        }
        if (!isJournal.booleanValue()) {
            noReachFilter.and(new QFilter("isbank", "=", (Object)"1"));
        }
        return noReachFilter;
    }

    public void getTableVsSetter(String sourceType, DynamicObjectCollection colls) {
        HashMap<Object, String> reasonMap = new HashMap();
        Object balAdjustId = null;
        QFilter[] reasonFilters = null;
        String reasonSelProp = "";
        DynamicObjectCollection reasonColl = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.containsKey("org") && customParams.containsKey("accountbank") && customParams.containsKey("currency")) {
            reasonSelProp = "id";
            reasonFilters = new QFilter[]{new QFilter("org", "=", customParams.get("org")), new QFilter("bankaccount", "=", customParams.get("accountbank")), new QFilter("currency", "=", customParams.get("currency"))};
            reasonColl = QueryServiceHelper.query((String)"cas_balanceadjust", (String)reasonSelProp, (QFilter[])reasonFilters, (String)"bizdate desc");
            if (!reasonColl.isEmpty()) {
                balAdjustId = ((DynamicObject)reasonColl.get(0)).get("id");
            }
        } else {
            balAdjustId = this.getModel().getValue("id");
        }
        if ("cas_bankjournal".equals(sourceType)) {
            reasonSelProp = "bank_entry.bankbillid, bank_entry.bank_reason";
            reasonFilters = new QFilter[]{new QFilter("id", "=", balAdjustId), new QFilter("bank_entry.banksourcetype", "=", (Object)sourceType)};
            reasonColl = QueryServiceHelper.query((String)"cas_balanceadjust", (String)reasonSelProp, (QFilter[])reasonFilters, null);
            if (!reasonColl.isEmpty()) {
                reasonMap = reasonColl.stream().collect(Collectors.toMap(dyn -> dyn.get("bank_entry.bankbillid"), dyn -> dyn.getString("bank_entry.bank_reason"), (e1, e2) -> e1));
            }
        } else {
            reasonSelProp = "enter_entry.billid, enter_entry.enter_reason";
            reasonFilters = new QFilter[]{new QFilter("id", "=", balAdjustId), new QFilter("enter_entry.sourcetype", "=", (Object)sourceType)};
            reasonColl = QueryServiceHelper.query((String)"cas_balanceadjust", (String)reasonSelProp, (QFilter[])reasonFilters, null);
            if (!reasonColl.isEmpty()) {
                reasonMap = reasonColl.stream().collect(Collectors.toMap(dyn -> dyn.get("enter_entry.billid"), dyn -> dyn.getString("enter_entry.enter_reason"), (e1, e2) -> e1));
            }
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        String entry = "cas_bankjournal".equals(sourceType) ? "bank_entry" : "enter_entry";
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        this.setFieldValue(vs, colls, sourceType, reasonMap);
        model.batchCreateNewEntryRow(entry, vs);
        model.endInit();
        this.getView().updateView(entry);
    }

    private void setFieldValue(TableValueSetter vs, DynamicObjectCollection colls, String sourceType, Map<Object, String> reasonMap) {
        if ("cas_bankjournal".equals(sourceType)) {
            this.addBankField(vs);
            HashSet rowIds = new HashSet();
            colls.forEach(c -> rowIds.add(Long.valueOf(c.getString("id"))));
            DynamicObject[] journals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,sourcebilltype,sourcebillid,sourcebillnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", rowIds)});
            Map voucherJournalMap = new VoucherMatcher().findRelatedVouchers(Arrays.asList(journals), "cas_bankjournal");
            HashMap result = new HashMap();
            String fields = "vouchertype.name,billno";
            if (this.getVoucherFields() != null && this.getVoucherFields().size() > 0) {
                fields = fields + "," + String.join((CharSequence)",", this.getVoucherFields());
            }
            Map voucherMap = new VoucherBookService().queryVouchers(voucherJournalMap, fields);
            HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>();
            voucherJournalMap.forEach((journal, voucherPks) -> {
                ArrayList voucherTypeNos = new ArrayList();
                LinkedList voucherBillNos = new LinkedList();
                voucherPks.forEach(voucherPk -> {
                    DynamicObject voucher = (DynamicObject)voucherMap.get(voucherPk);
                    if (voucher != null) {
                        String voucherType = voucher.getString("vouchertype.name");
                        String voucherNumber = voucher.getString("billno");
                        String voucherTypeNumber = voucherType + " " + voucherNumber;
                        voucherTypeNos.add(voucherTypeNumber);
                        voucherBillNos.add(voucherNumber);
                        resultMap.computeIfAbsent(journal.getString("id"), k -> new ArrayList());
                        resultMap.computeIfPresent(journal.getString("id"), (k, v) -> {
                            v.add(voucher);
                            return v;
                        });
                    }
                });
                String sourceBillType = journal.getString("sourcebilltype");
                SourceNumber sourceNumber = new SourceNumber();
                sourceNumber.setSourceType(sourceBillType);
                sourceNumber.setVoucherNo(String.join((CharSequence)",", voucherTypeNos));
                if ("gl_voucher".equals(sourceBillType)) {
                    sourceNumber.setBillno(String.join((CharSequence)",", voucherBillNos));
                } else {
                    sourceNumber.setBillno(journal.getString("sourcebillnumber"));
                }
                result.put(journal, sourceNumber);
            });
            HashMap numMap = new HashMap();
            result.keySet().forEach(key -> numMap.put(key.getString("id"), (SourceNumber)result.get(key)));
            for (int i = 0; i < colls.size(); ++i) {
                DynamicObject obj = (DynamicObject)colls.get(i);
                SourceNumber sourceNumber = (SourceNumber)numMap.get(obj.getString("id"));
                this.addBankRow(vs, obj, sourceType, reasonMap, sourceNumber, resultMap);
            }
        } else {
            this.addStatementField(vs);
            for (int i = 0; i < colls.size(); ++i) {
                DynamicObject obj = (DynamicObject)colls.get(i);
                this.addStatemRow(vs, obj, reasonMap);
            }
        }
    }

    public void addStatementField(TableValueSetter vs) {
        vs.addField("billid", new Object[0]);
        vs.addField("sourceType", new Object[0]);
        vs.addField("enter_bizdate", new Object[0]);
        vs.addField("enter_description", new Object[0]);
        vs.addField("enter_settletype", new Object[0]);
        vs.addField("enter_settlenumber", new Object[0]);
        vs.addField("enter_creditamount", new Object[0]);
        vs.addField("enter_debitamount", new Object[0]);
        vs.addField("ratesdate", new Object[0]);
        vs.addField("tradenumber", new Object[0]);
        vs.addField("source", new Object[0]);
        vs.addField("balanceamt", new Object[0]);
        vs.addField("enter_reason", new Object[0]);
        vs.addField("bankdetailno", new Object[0]);
        vs.addField("oppunit", new Object[0]);
        vs.addField("oppbank", new Object[0]);
        vs.addField("oppaccountnumber", new Object[0]);
    }

    public void addStatemRow(TableValueSetter vs, DynamicObject obj, Map<Object, String> reasonMap) {
        vs.addRow(new Object[]{obj.get("id"), "cas_bankstatement", obj.getDate("bizdate"), obj.getString("description"), obj.getString("settlementtype.name"), obj.getString("settlementnumber"), new BigDecimal(obj.getBigDecimal("creditamount").toString()), new BigDecimal(obj.getBigDecimal("debitamount").toString()), obj.getDate("ratesdate"), obj.getString("tradenumber"), obj.getString("source"), obj.getBigDecimal("balanceamt"), reasonMap.get(obj.get("id")), obj.getString("bankdetailno"), obj.getString("oppunit"), obj.getString("oppbank"), obj.getString("oppaccountnumber")});
    }

    public void addBankRow(TableValueSetter vs, DynamicObject obj, String sourceType, Map<Object, String> reasonMap, SourceNumber sourceNumber, Map<String, List<DynamicObject>> resultMap) {
        vs.addRow(new Object[]{obj.get("org"), obj.getDate("bookdate"), obj.getDate("bizdate"), obj.getString("description"), obj.getString("settlementtype.name"), obj.getString("settlementnumber"), SourceBillTypeEnum.getName((String)obj.getString("sourcebilltype")), sourceNumber.getBillno(), sourceNumber.getVoucherNo(), obj.getBigDecimal("debitamount"), obj.getBigDecimal("creditamount"), sourceType, obj.getString("id"), obj.getDate("pddate"), obj.getDate("avddate"), obj.getDate("preparationdate"), obj.getDate("createtime"), obj.getString("source"), obj.getString("cashier.name"), obj.getString("feepayer"), reasonMap.get(obj.get("id")), obj.getString("oppunit"), obj.getString("oppacctnumber"), obj.getString("oppbank")});
    }

    public void addBankField(TableValueSetter vs) {
        vs.addField("bank_org", new Object[0]);
        vs.addField("bank_bookdate", new Object[0]);
        vs.addField("bank_bizdate", new Object[0]);
        vs.addField("bank_description", new Object[0]);
        vs.addField("bank_settletype", new Object[0]);
        vs.addField("bank_settlenumber", new Object[0]);
        vs.addField("bank_billtype", new Object[0]);
        vs.addField("bank_billnumber", new Object[0]);
        vs.addField("bank_vouchernumber", new Object[0]);
        vs.addField("bank_debitamount", new Object[0]);
        vs.addField("bank_creditamount", new Object[0]);
        vs.addField("banksourceType", new Object[0]);
        vs.addField("bankbillid", new Object[0]);
        vs.addField("pddate", new Object[0]);
        vs.addField("avddate", new Object[0]);
        vs.addField("preparationdate", new Object[0]);
        vs.addField("sysdate", new Object[0]);
        vs.addField("banksource", new Object[0]);
        vs.addField("cashier", new Object[0]);
        vs.addField("feepayer", new Object[0]);
        vs.addField("bank_reason", new Object[0]);
        vs.addField("bankoppunit", new Object[0]);
        vs.addField("oppacctnumber", new Object[0]);
        vs.addField("bankoppbank", new Object[0]);
    }

    public Set<String> getVoucherFields() {
        return null;
    }

    public String getQueryStr(String sourceType) {
        String str = "id, org,accountbank, currency, creditamount, debitamount,bizdate,description,settlementtype,settlementtype.name,settlementnumber,source";
        if ("cas_bankjournal".equals(sourceType)) {
            return str + ",bookdate,sourcebilltype,sourcebillid, sourcebillnumber,pddate,avddate,preparationdate,createtime,cashier.name,feepayer,oppunit,oppacctnumber,oppbank";
        }
        return str + ",bankvouvherno,bankdetailno,oppbank,oppaccountnumber,ratesdate,tradenumber,balanceamt, oppunit";
    }

    private Long getLong(Object obj) {
        return Long.valueOf(String.valueOf(obj));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_refresh".equals(itemKey)) {
            Long orgId = this.getPk("org");
            Date endDate = (Date)this.getModel().getValue("bizdate");
            Long accountBankId = this.getPk("bankaccount");
            Long currencyId = this.getPk("currency");
            this.getModel().deleteEntryData("enter_entry");
            this.getModel().deleteEntryData("bank_entry");
            DynamicObject accountBank = AccountBankHelper.getAccountBankById((long)accountBankId);
            Long createOrgId = (Long)accountBank.getDynamicObject("createorg").getPkValue();
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)createOrgId);
            BalanceCountService balanceSerVice = new BalanceCountService();
            endDate = DateUtils.getBeforeDate((Date)endDate, (Date)new Date());
            BigDecimal journalbalamt = balanceSerVice.getJournalBalanceByAccount(accountBankId, currencyId, endDate);
            BigDecimal statmntbalamt = balanceSerVice.getStatmBalance(createOrgId, accountBankId, currencyId, endDate);
            List sateIds = BalanceAdjustHelper.getHasCheckedByDate((Long)createOrgId, (Long)accountBankId, (Long)currencyId, (Date)endDate, (String)"cas_bankstatement");
            List journalIds = BalanceAdjustHelper.getHasCheckedByDate((Long)createOrgId, (Long)accountBankId, (Long)currencyId, (Date)endDate, (String)"cas_bankjournal");
            ArrayList<Long> stateIdsNew = new ArrayList<Long>(sateIds.size());
            if (sateIds.size() > 0) {
                sateIds.forEach(o -> stateIdsNew.add(Long.parseLong(o)));
            }
            ArrayList<Long> journalIdsNew = new ArrayList<Long>(journalIds.size());
            if (journalIds.size() > 0) {
                journalIds.forEach(o -> journalIdsNew.add(Long.parseLong(o)));
            }
            DynamicObject recInitObject = this.getRecInit(orgId);
            this.adJustAmount(journalbalamt, endDate, "cas_bankstatement", new QFilter[]{this.getNoReachQfilter(recInitObject, accountBankId, currencyId, endDate, false)}, stateIdsNew);
            this.adJustAmount(statmntbalamt, endDate, "cas_bankjournal", new QFilter[]{this.getNoReachQfilter(initObj, accountBankId, currencyId, endDate, true)}, journalIdsNew);
            this.getModel().setDataChanged(false);
        }
        if ("bar_save".equals(itemKey) || "bar_submit".equals(itemKey)) {
            if ("bar_submit".equals(itemKey) && this.getPageCache().get("saveed") != null) {
                this.getView().invokeOperation("submit");
            } else {
                Object date = this.getModel().getValue("bizdate");
                String dateStr = DateUtils.formatString((Date)((Date)date), (String)"yyyy-MM-dd");
                logger.info("========genery balance adjust date\uff1a" + dateStr);
                String balance = this.getBalance();
                if (!CasHelper.isEmpty((Object)balance) && balance.length() > 1) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u4f1a\u8986\u76d6%s\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CheckResultPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), balance), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("bar_save".equals(itemKey) ? "CONFIRM_BALANCE_CALLBACK_SAVE" : "CONFIRM_BALANCE_CALLBACK_SUBMIT", (IFormPlugin)this));
                    return;
                }
                if (BillStatusEnum.SUBMIT.getValue().equals(balance)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u5f53\u65e5\u4f59\u989d\u8c03\u8282\u8868\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210!", (String)"CheckResultPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (BillStatusEnum.AUDIT.getValue().equals(balance)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u5f53\u65e5\u4f59\u989d\u8c03\u8282\u8868\u5df2\u5ba1\u6279\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"CheckResultPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter dateFilter = new QFilter("bizdate", ">", (Object)DateUtils.getDataFormat((Date)((Date)date), (boolean)false));
                boolean exsitLargerDateBalance = QueryServiceHelper.exists((String)"cas_balanceadjust", (QFilter[])new QFilter[]{this.getBaseQfilter(), dateFilter});
                if (exsitLargerDateBalance) {
                    String error = String.format(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\u3002\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728%1$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u5982\u9700\u7ee7\u7eed\uff0c\u8bf7\u5c06%2$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u5220\u9664\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CheckResultPlugin_35", (String)"fi-cas-formplugin", (Object[])new Object[0]), dateStr, dateStr);
                    this.getView().showTipNotification(error);
                    return;
                }
                String opKey = "bar_save".equals(itemKey) ? "save" : "submit";
                OperateOption option = OperateOption.create();
                option.setVariableValue("directsubmit", "1");
                this.getView().invokeOperation(opKey, option);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
            this.getPageCache().put("saveed", "1");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"billstatus", "bar_print"});
        } else if ("submit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"billstatus", "bar_audit"});
        } else if ("unaudit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_submit"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        OperateOption option = OperateOption.create();
        if (id.equals("CONFIRM_BALANCE_CALLBACK_SAVE") && MessageBoxResult.Yes.equals((Object)res)) {
            option.setVariableValue("directsubmit", "1");
            this.getView().invokeOperation("save", option);
        }
        if (id.equals("CONFIRM_BALANCE_CALLBACK_SUBMIT") && MessageBoxResult.Yes.equals((Object)res)) {
            option.setVariableValue("directsubmit", "1");
            this.getView().invokeOperation("submit", option);
        }
    }

    public String getBalance() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject initObj = PeriodHelper.getCasInitInfo((long)org.getLong("id"));
        DynamicObject startperiod = initObj.getDynamicObject("startperiod");
        Date date = (Date)this.getModel().getValue("bizdate");
        QFilter filterSubmit = this.getBaseQfilter().and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)date, (boolean)true)).and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)false))).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObject[] submitBalances = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id,billstatus,bizdate", (QFilter[])new QFilter[]{filterSubmit});
        if (submitBalances != null && submitBalances.length > 0) {
            return submitBalances[0].getString("billstatus");
        }
        QFilter filter = this.getBaseQfilter().and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)startperiod.getDate("begindate"), (boolean)true)).and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)false)));
        DynamicObject[] balances = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id,billstatus,bizdate", (QFilter[])new QFilter[]{filter});
        if (balances == null || balances.length == 0) {
            return "";
        }
        for (DynamicObject balance : balances) {
            if (!BillStatusEnum.SAVE.getValue().equals(balance.getString("billstatus"))) continue;
            return DateUtils.formatString((Date)balance.getDate("bizdate"), (String)"yyyy-MM-dd");
        }
        return "";
    }

    private QFilter getBaseQfilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("bankaccount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter filter = new QFilter("bankaccount", "=", (Object)accountBank.getLong("id"));
        filter = filter.and("org", "=", org.getPkValue()).and("currency", "=", (Object)currency.getLong("id"));
        return filter;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    private DynamicObject getRecInit(Object orgId) {
        QFilter orgFilter = new QFilter("org", "=", orgId);
        DynamicObject recEdc = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{orgFilter});
        if (recEdc == null) {
            return null;
        }
        DynamicObject recPeriod = recEdc.getDynamicObject("recperiod");
        if (recPeriod == null) {
            return null;
        }
        QFilter periodFilter = new QFilter("initperiod", "=", recPeriod.getPkValue());
        DynamicObject recInitObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_init", (String)"id,isfinishinit", (QFilter[])new QFilter[]{orgFilter, periodFilter});
        return recInitObject;
    }
}

