/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.formplugin.BankJournalBaseFormRpt;
import kd.fi.cas.formplugin.calendar.DateUtils;
import kd.fi.cas.formplugin.journalprintall.JournalPrintHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.prop.BankJournalDownload;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.ViewUtils;

public class BankJournalFormRpt
extends BankJournalBaseFormRpt {
    private static final String CUSTOMSORTENTRY = "customsortentry";
    private static final String FIELDCOMBO = "fieldcombo";
    private static final String SORTCOMBO = "sortcombo";

    public BankJournalFormRpt() {
        this.rptEntity = "cas_bankjournalformrpt";
        this.acctEntity = "bd_accountbanks";
        this.acctControlName = "accountbank";
        this.journalEntity = "cas_bankjournal";
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"showtype"});
        FilterGrid filterGrid = (FilterGrid)this.getControl("bankfiltergridap");
        filterGrid.setEntityNumber("cas_bankjournal");
        this.setBankJournalFilterFields(filterGrid);
        this.getView().updateView("bankfiltergridap");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams != null && customParams.containsKey("fromAccountTrade")) {
            IDataModel model = this.getModel();
            model.setValue("queryorgtype", customParams.get("queryorgtype"));
            if (customParams.containsKey("fromAccountAssignCancel")) {
                Set orgIds = (Set)SerializationUtils.fromJsonString((String)customParams.get("org").toString(), HashSet.class);
                model.setValue("org", (Object)orgIds.toArray(new Object[0]));
            } else {
                model.setValue("org", (Object)new Object[]{customParams.get("org")});
            }
            model.setValue("accountbank", (Object)new Object[]{customParams.get("accountbank")});
            model.setValue("datetype", (Object)"1");
            Object periodType = customParams.get("periodtype");
            model.setValue("periodtype", periodType);
            model.setValue("beginperiod", customParams.get("periodId"));
            model.setValue("endperiod", customParams.get("periodId"));
            if (EmptyUtil.isEmpty(periodType)) {
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"periodtype"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"datetype"});
            ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
            control.search();
            return;
        }
        if (customParams != null && customParams.containsKey("isTrack")) {
            IDataModel model = this.getModel();
            model.setValue("queryorgtype", (Object)"org");
            model.setValue("org", (Object)new Object[]{customParams.get("trackOrg")});
            model.setValue("datetype", (Object)"1");
            model.setValue("beginperiod", customParams.get("trackPeriod"));
            model.setValue("endperiod", customParams.get("trackPeriod"));
            ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
            control.search();
        } else if (customParams == null || !customParams.containsKey("fromAEF")) {
            this.queryOrgTypeChange((String)this.getModel().getValue("queryorgtype"));
        }
    }

    private void setBankJournalFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>(13);
        filterFileds.add("bookdate");
        filterFileds.add("description");
        filterFileds.add("sourcebilltype");
        filterFileds.add("billno");
        filterFileds.add("settlementtype.number");
        filterFileds.add("settlementnumber");
        filterFileds.add("debitamount");
        filterFileds.add("creditamount");
        filterFileds.add("oppacctnumber");
        filterFileds.add("oppunit");
        filterFileds.add("oppbank");
        filterFileds.add("cashier.number");
        filterFileds.add("source");
        filterFileds.add("ischeck");
        filterFileds.add("datasource");
        filterGrid.setFilterFieldKeys(filterFileds);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        Map<String, Map> filterColumnsTemp = entityTypeUtil.createFilterColumns((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal"), false).stream().filter(m -> filterFileds.contains(m.get("fieldName"))).collect(Collectors.toMap(m -> (String)m.get("fieldName"), m -> m));
        ArrayList<Map> filterColumns = new ArrayList<Map>(filterFileds.size());
        Map filterColumn = null;
        String filterName = "";
        for (String string : filterFileds) {
            filterColumn = filterColumnsTemp.get(string);
            if (string.contains(".number")) {
                filterName = (String)filterColumn.get("fieldCaption");
                filterColumn.put("fieldCaption", filterName.substring(0, filterName.indexOf(46)));
            }
            if (string.equals("billno")) {
                filterColumn.put("fieldCaption", ResManager.loadKDString((String)"\u5355\u636e\u53f7", (String)"BankJournalFormRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            filterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(filterColumns);
    }

    @Override
    protected QFilter[] getAcctFilter(List<Long> orgPks) {
        String queryOrgType = (String)this.getModel().getValue("queryorgtype");
        QFilter[] accountFilter = null;
        accountFilter = "org".equals(queryOrgType) ? new QFilter[]{AccountBankHelper.getUseAuthAccountBankFilterByOrg(orgPks)} : new QFilter[]{new QFilter("openorg", "in", orgPks)};
        ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
        Collections.addAll(qFilterArrayList, accountFilter);
        qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
        return accountFilter;
    }

    @Override
    protected void orgChange(DynamicObjectCollection orgs) {
        super.orgChange(orgs);
        if (orgs != null && orgs.size() > 0) {
            boolean isCombine = false;
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)isCombine, (String[])new String[]{"iscombine"});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("qingview".equalsIgnoreCase(key)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cas_bankjournalqing");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            FormShowParameter parent = this.getView().getFormShowParameter();
            showParameter.setParentPageId(parent.getParentPageId());
            view.showForm(showParameter);
        } else if ("bar_new".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cas_bankjournaledit");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            this.getView().showForm(showParameter);
        } else if ("download".equals(key)) {
            List<Long> defaultOrgId = this.getDefaultOrgId();
            if (defaultOrgId == null || defaultOrgId.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8d44\u91d1\u7ec4\u7ec7\uff0c\u4ee5\u4fbf\u4e0b\u8f7d\u94f6\u884c\u65e5\u8bb0\u8d26\u3002", (String)"BankJournalFormRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cas_downbankjournal");
            showParameter.getCustomParams().put("customorg", defaultOrgId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "bank_journal_download");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.showDownJournalMessage(event);
    }

    public void showDownJournalMessage(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (!"bank_journal_download".equals(actionId)) {
            return;
        }
        Object returnData = event.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        Map data = (Map)returnData;
        Integer acctBankCount = (Integer)data.get("acctBankCount");
        Integer successCount = (Integer)data.get("successCount");
        Integer failCount = (Integer)data.get("failCount");
        String message = String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u94f6\u884c\u8d26\u6237\uff0c\u4e0b\u8f7d\u6210\u529f%2$s\u7b14\u8bb0\u5f55\uff0c\u5931\u8d25%3$s\u7b14\u8bb0\u5f55\u3002", (String)"BankJournalFormRpt_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBankCount, successCount, failCount);
        this.getView().showSuccessNotification(message, BankJournalDownload.SHOW_MESSAGE_TIME);
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("exportallacc", (Object)false);
        FilterItemInfo filterShowType = filter.getFilterItem("showType");
        String showType = (String)this.getModel().getValue("showtype");
        if (filterShowType != null) {
            filterShowType.setValue((Object)showType);
        } else {
            filter.addFilterItem("showType", (Object)showType);
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        FilterInfo filter = event.getQueryParam().getFilter();
        boolean exportexcel = filter.getBoolean("exportallacc");
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            ReportColumn col = (ReportColumn)column;
            String key = col.getFieldKey();
            if (key.equals("acctname") && !exportexcel) {
                col.setHide(true);
            } else {
                col.setHide(false);
            }
            if (!key.equals("datatype") && !key.equals("id") && !key.equals("sourcebillid")) continue;
            col.setHide(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("exportallacc".equals(key)) {
            this.exportAllToExcel();
        } else if ("addnew".equals(key)) {
            this.openManualJournalNewViewBy("cas_manualbankjournal");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        if ("queryorgtype".equals(name)) {
            this.queryOrgTypeChange((String)newValue);
        } else if ("openorg".equals(name)) {
            this.openOrgChange();
        } else if ("showtype".equalsIgnoreCase(name)) {
            this.getView().refresh();
        }
    }

    private void exportAllToExcel() {
        ReportQueryParam queryParam = this.getQueryParam();
        queryParam.getFilter().getFilterItem("exportallacc").setValue((Object)true);
        ReportList list = (ReportList)this.getControl("reportlistap");
        String taskId = Uuid16.create().toString();
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        reportCache.setReportQueryParam(taskId, queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)list.getReportModel();
        reportModel.setPageId(taskId);
        boolean isAsynQuery = list.isAsynQuery();
        list.setAsynQuery(true);
        String nodes_cahce = JournalPrintHelper.getLeftNodesFromCache(queryParam);
        if (StringUtils.isBlank((CharSequence)nodes_cahce)) {
            nodes_cahce = this.buildNodeIdStr(this.getQueryParam());
        }
        list.submitTask(queryParam, (Object)nodes_cahce);
        String url = list.exportExcel();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            IClientViewProxy clientProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientProxy.addAction("download", (Object)url);
        }
        reportModel.close();
        reportModel.setPageId(this.getView().getPageId());
        list.setAsynQuery(isAsynQuery);
    }

    public String buildNodeIdStr(ReportQueryParam queryParam) {
        StringBuilder sb = new StringBuilder();
        FilterInfo filterInfo = queryParam.getFilter();
        String queryorgtype = filterInfo.getString("queryorgtype");
        DynamicObjectCollection orgColl = null;
        orgColl = "org".equals(queryorgtype) ? filterInfo.getDynamicObjectCollection("org") : filterInfo.getDynamicObjectCollection("openorg");
        DynamicObjectCollection acctColl = filterInfo.getDynamicObjectCollection("accountbank");
        DynamicObjectCollection currencyColl = filterInfo.getDynamicObjectCollection("currency");
        DynamicObjectCollection acctPlainColl = this.getAcctPlainColl(orgColl, acctColl, queryorgtype, filterInfo);
        for (int j = 0; j < acctPlainColl.size(); ++j) {
            DynamicObject acct = (DynamicObject)acctPlainColl.get(j);
            if (currencyColl != null) {
                if (!this.isContains(currencyColl, acct.getLong("currencyid"))) continue;
                sb.append(acct.getString("currencyid")).append('-').append(acct.getString("id")).append('-').append(acct.getString("orgid")).append('-').append(acct.getString("acctname")).append('%');
                continue;
            }
            sb.append(acct.getString("currencyid")).append('-').append(acct.getString("id")).append('-').append(acct.getString("orgid")).append('-').append(acct.getString("acctname")).append('%');
        }
        return sb.toString();
    }

    public DynamicObjectCollection getAcctPlainColl(DynamicObjectCollection orgColl, DynamicObjectCollection acctColl, String queryorgtype, FilterInfo filterInfo) {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (acctColl != null) {
            filters.add(new QFilter("id", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)acctColl)));
        } else if ("org".equals(queryorgtype)) {
            ArrayList<QFilter> listQ = new ArrayList<QFilter>(1);
            listQ.add(AccountBankHelper.getUseAuthAccountBankFilterByOrg((Collection)OrgHelper.getIdList((DynamicObjectCollection)orgColl)));
            filters.addAll(listQ);
            filters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        } else if ("openorg".equals(queryorgtype)) {
            filters.add(new QFilter("openorg", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)orgColl)));
        }
        boolean isContainClosed = filterInfo.getBoolean("iscontainclosed");
        int type = filterInfo.getInt("datetype");
        if (orgColl != null && orgColl.size() > 1 && type == 1) {
            DynamicObject periodType = filterInfo.getDynamicObject("periodtype");
            for (int i = orgColl.size() - 1; i >= 0; --i) {
                DynamicObject org = (DynamicObject)orgColl.get(i);
                long orgId = (Long)org.getPkValue();
                long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
                if (periodTypeId == periodType.getLong("id")) continue;
                orgColl.remove(i);
            }
        }
        if (!isContainClosed) {
            filters.add(new QFilter("acctstatus", "!=", (Object)"closed"));
        } else {
            Date beginDate = null;
            Date endDate = null;
            if (type == 1) {
                DynamicObject beginPeriodDo = filterInfo.getDynamicObject("beginperiod");
                DynamicObject endPeriodDo = filterInfo.getDynamicObject("endperiod");
                if (beginPeriodDo != null) {
                    beginDate = beginPeriodDo.getDate("begindate");
                }
                if (endPeriodDo != null) {
                    endDate = endPeriodDo.getDate("enddate");
                }
            } else {
                endDate = filterInfo.getDate("enddate");
                beginDate = filterInfo.getDate("begindate");
            }
            QFilter qFilter = QFilter.of((String)"(closedate = null or closedate >= ?)", (Object[])new Object[]{kd.fi.cas.util.DateUtils.getDataFormat((Date)beginDate, (boolean)true)});
            filters.add(qFilter);
        }
        String selectFields = "id,name as acctname,number as acctnumber,company.id as orgid,company.name as orgname,currency.fbasedataid.id as currencyid,currency.fbasedataid.name as currencyname";
        return QueryServiceHelper.query((String)"bd_accountbanks", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
    }

    protected boolean isContains(DynamicObjectCollection coll, long id) {
        boolean flag = false;
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject object = (DynamicObject)coll.get(i);
            if (object.getLong("id") != id) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    protected String getOrgControlName(String queryOrgType) {
        String orgControlName = "org";
        if ("openorg".equals(queryOrgType)) {
            orgControlName = "openorg";
        }
        return orgControlName;
    }

    protected void openOrgChange() {
        this.getModel().setValue(this.acctControlName, null);
        this.getModel().setValue("currency", null);
    }

    private void queryOrgTypeChange(String queryOrgType) {
        if ("org".equals(queryOrgType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"org"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"openorg"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"datetype"});
            this.getModel().setValue("datetype", (Object)1);
            this.getModel().setValue("openorg", null);
            this.defaultOrg();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_del_manual", "bar_new_manual", "org"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"openorg"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"datetype"});
            this.getModel().setValue("datetype", (Object)2);
            this.getModel().setValue("begindate", (Object)DateUtils.getFirstDateOfMonth(new Date()));
            this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth(new Date()));
            this.getModel().setValue("org", null);
            this.defaultOpenOrg();
        }
    }

    private void defaultOpenOrg() {
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set openOrgList = OrgHelper.getAuthAcctOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.rptEntity, (String)"47150e89000000ac");
        if (openOrgList.size() > 0) {
            long currentOrgId = RequestContext.get().getOrgId();
            long openOrgId = (Long)openOrgList.toArray()[0];
            if (openOrgList.contains(currentOrgId)) {
                openOrgId = currentOrgId;
            }
            Object[] arrObj = new Object[]{openOrgId};
            this.getModel().setValue("openorg", (Object)arrObj);
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection sortEntry;
        boolean verifyQuery = super.verifyQuery(queryParam);
        if (this.getModel().getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY))) {
            HashSet<String> fieldSet = new HashSet<String>(10);
            for (DynamicObject sortRow : sortEntry) {
                if (fieldSet.add(sortRow.getString(FIELDCOMBO))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d", (String)"SubsiDiaryTreeFormRpt_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            this.setOtherEntryFilter(queryParam.getFilter());
        }
        return verifyQuery;
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        DynamicObjectCollection sortEntry;
        super.setOtherEntryFilter(filterInfo);
        if (this.getModel().getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY))) {
            HashMap otherEntryFilter = new HashMap();
            ArrayList<DynamicObject> saveEntrys = new ArrayList<DynamicObject>();
            for (DynamicObject sortRow : sortEntry) {
                saveEntrys.add(sortRow);
            }
            otherEntryFilter.put(CUSTOMSORTENTRY, saveEntrys);
            filterInfo.setOtherEntryFilter(otherEntryFilter);
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        DynamicObjectCollection sortEntry;
        super.loadOtherEntryFilter(scheme);
        if (scheme.getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && (sortEntry = scheme.getDynamicObjectCollection(CUSTOMSORTENTRY)) != null && !sortEntry.isEmpty()) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(CUSTOMSORTENTRY);
            model.batchCreateNewEntryRow(CUSTOMSORTENTRY, sortEntry.size());
            for (int i = 0; i < sortEntry.size(); ++i) {
                DynamicObject sortRow = (DynamicObject)sortEntry.get(i);
                model.setValue(FIELDCOMBO, (Object)sortRow.getString(FIELDCOMBO), i);
                model.setValue(SORTCOMBO, (Object)sortRow.getString(SORTCOMBO), i);
            }
            model.endInit();
            this.getView().updateView(CUSTOMSORTENTRY);
        }
    }

    private List<Long> getDefaultOrgId() {
        Long userID = Long.valueOf(RequestContext.get().getUserId());
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgIds = OrgHelper.getAuthBankOrgIds((Long)userID, (String)appId, (String)"cas_bankjournalformrpt", (String)"4730fc9f000007ae");
        Long defaultOrgId = null;
        List<Long> defaultOrIds = null;
        if (orgIds.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8d44\u91d1\u7ec4\u7ec7\uff0c\u4ee5\u4fbf\u4e0b\u8f7d\u94f6\u884c\u65e5\u8bb0\u8d26\u3002", (String)"BankJournalFormRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return null;
        }
        defaultOrIds = this.getCachedOrgId(orgIds);
        if (defaultOrIds != null && defaultOrIds.size() > 0) {
            return defaultOrIds;
        }
        defaultOrIds = new ArrayList<Long>(100);
        Long loginOrgId = RequestContext.get().getOrgId();
        defaultOrgId = orgIds.contains(loginOrgId) ? loginOrgId : (Long)orgIds.toArray()[0];
        defaultOrIds.add(defaultOrgId);
        return defaultOrIds;
    }

    private List<Long> getCachedOrgId(Set<Long> orgIds) {
        ArrayList<Long> resultIds = new ArrayList<Long>(100);
        DynamicObjectCollection mulOrgObject = (DynamicObjectCollection)this.getModel().getValue("org");
        if (mulOrgObject == null || mulOrgObject.size() <= 0) {
            return null;
        }
        List cachedOrgList = mulOrgObject.stream().map(o -> o.get("fbasedataid_id")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(cachedOrgList) || cachedOrgList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < cachedOrgList.size(); ++i) {
            Long id;
            String orgStr = cachedOrgList.get(i).toString().trim();
            if (EmptyUtil.isEmpty((String)orgStr) || !orgIds.contains(id = Long.valueOf(orgStr))) continue;
            resultIds.add(id);
        }
        return resultIds;
    }
}

