/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.formplugin.JournalBaseListDataRpt;
import kd.fi.cas.param.JournalParam;

public class BankJournalListDataRpt
extends JournalBaseListDataRpt {
    private static final String CUSTOMSORTENTRY = "customsortentry";
    private static final String FIELDCOMBO = "fieldcombo";
    private static final String SORTCOMBO = "sortcombo";

    public BankJournalListDataRpt() {
        this.journalEntity = "cas_bankjournal";
        this.acctPropertyName = "accountbank";
        this.type = "2";
    }

    private String[] getOrderBys(List<Object> sortEntry) {
        if (sortEntry != null && sortEntry.size() > 0) {
            String[] tOrderBys = new String[sortEntry.size()];
            for (int i = 0; i < sortEntry.size(); ++i) {
                DynamicObject sort = (DynamicObject)sortEntry.get(i);
                tOrderBys[i] = sort.getString(FIELDCOMBO) + " " + sort.getString(SORTCOMBO);
            }
            return tOrderBys;
        }
        return null;
    }

    @Override
    protected List<Field> getRowMetaField() {
        List<Field> list = super.getRowMetaField();
        list.add(new Field("openorgname", (DataType)DataType.StringType));
        list.add(new Field("settlementtype", (DataType)DataType.StringType));
        list.add(new Field("settlementnumber", (DataType)DataType.StringType));
        list.add(new Field("oppbank", (DataType)DataType.StringType));
        list.add(new Field("batchno", (DataType)DataType.StringType));
        list.add(new Field("bankno", (DataType)DataType.LongType));
        list.add(new Field("ischeck", (DataType)DataType.BooleanType));
        list.add(new Field("isvalid", (DataType)DataType.BooleanType));
        list.add(new Field("avddate", (DataType)DataType.TimestampType));
        list.add(new Field("pddate", (DataType)DataType.TimestampType));
        list.add(new Field("createtime", (DataType)DataType.TimestampType));
        list.add(new Field("feepayer", (DataType)DataType.StringType));
        list.add(new Field("preparationdate", (DataType)DataType.TimestampType));
        list.add(new Field("tracedate", (DataType)DataType.TimestampType));
        list.add(new Field("datasource", (DataType)DataType.StringType));
        list.add(new Field("billno", (DataType)DataType.StringType));
        return list;
    }

    @Override
    protected String getQueryFiled(JournalParam param) {
        return super.getQueryFiled(param) + ",billno,bankcheckflag as batchno,openorg.name as openorgname,settlementtype.name as settlementtype,settlementnumber,oppbank,accountbank.id as bankno,ischeck,isvalid,avddate,pddate,createtime,feepayer,preparationdate,datasource";
    }

    @Override
    protected List<String> getShowFields() {
        List<String> list = super.getShowFields();
        list.add("openorgname");
        list.add("settlementtype");
        list.add("settlementnumber");
        list.add("oppbank");
        list.add("batchno");
        list.add("bankno");
        list.add("ischeck");
        list.add("isvalid");
        list.add("avddate");
        list.add("pddate");
        list.add("createtime");
        list.add("feepayer");
        list.add("preparationdate");
        list.add("tracedate");
        list.add("datasource");
        list.add("billno");
        return list;
    }

    @Override
    protected JournalParam getJournalParam(ReportQueryParam arg0, Object arg1) {
        JournalParam journalParam = super.getJournalParam(arg0, arg1);
        FilterInfo filterInfo = arg0.getFilter();
        List filterItems = filterInfo.getFilterItems();
        for (FilterItemInfo filterItemInfo : filterItems) {
            if (journalParam == null) continue;
            String propName = filterItemInfo.getPropName();
            if (propName.equals("filter_amt")) {
                journalParam.setAmt(filterItemInfo.getBigDecimal());
                continue;
            }
            if (propName.equals("filter_type")) {
                journalParam.setFilterType(filterItemInfo.getString());
                continue;
            }
            if (!propName.equals("filter_amttype")) continue;
            journalParam.setFilterAmtType(filterItemInfo.getString());
        }
        this.orderBys = this.getOrderBys((List)filterInfo.getOtherEntryFilter().get(CUSTOMSORTENTRY));
        return journalParam;
    }

    @Override
    public QFilter[] getQFilter(JournalParam param) {
        String filterAmtType = param.getFilterAmtType();
        String filterType = param.getFilterType();
        BigDecimal amt = param.getAmt();
        QFilter amtFilter = null;
        if (!StringUtils.isEmpty((CharSequence)filterAmtType) && !StringUtils.isEmpty((CharSequence)filterType) && amt != null) {
            amtFilter = new QFilter(filterAmtType, filterType, (Object)amt);
            if (BigDecimal.ZERO.compareTo(amt) != 0 && !filterType.equals("=")) {
                amtFilter = amtFilter.and(new QFilter(filterAmtType, ">", (Object)BigDecimal.ZERO));
            }
        }
        if (param.isCombine()) {
            HashSet<Long> orgIdSet = new HashSet<Long>();
            orgIdSet.add(param.getOrgid());
            QFilter filter = new QFilter("org", "in", orgIdSet);
            if (null != amtFilter) {
                filter = filter.and(amtFilter);
            }
            if (param.getCurrencyid() != 0L) {
                filter = filter.and(new QFilter("currency", "=", (Object)param.getCurrencyid()));
            }
            if (param.getAcctid() != 0L) {
                filter = filter.and(new QFilter(this.acctPropertyName, "=", (Object)param.getAcctid()));
            }
            if (param.getDateType() == 1 && param.getBeginPeriod() != null & param.getEndPeriod() != null) {
                filter = filter.and(new QFilter("bookdate", ">=", (Object)param.getBeginPeriod().getDate("begindate"))).and(new QFilter("bookdate", "<=", (Object)param.getEndPeriod().getDate("enddate")));
            } else if (param.getBeginDate() != null && param.getEndDate() != null) {
                filter = filter.and(new QFilter("bookdate", ">=", (Object)param.getBeginDate())).and(new QFilter("bookdate", "<=", (Object)param.getEndDate()));
            }
            return filter.toArray();
        }
        if (null == amtFilter) {
            return super.getQFilter(param);
        }
        QFilter[] qFilters = super.getQFilter(param);
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
        Stream.of(qFilters).forEach(v -> qfilterList.add((QFilter)v));
        qfilterList.add(amtFilter);
        return qfilterList.toArray(new QFilter[qfilterList.size()]);
    }
}

