/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.journal.BookJournalLogger;
import kd.fi.cas.business.journal.JournalBookImpl;
import kd.fi.cas.business.journal.JournalEntryInfo;
import kd.fi.cas.business.journal.JournalInfo;
import kd.fi.cas.business.journal.SourceNumber;
import kd.fi.cas.business.journal.VoucherBookJournalBuilder;
import kd.fi.cas.business.journal.VoucherBookService;
import kd.fi.cas.formplugin.common.CasCommonFilterListPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.StringUtils;

public class BankJournalListPlugin
extends CasCommonFilterListPlugin {
    private Map<DynamicObject, SourceNumber> voucherNoCache = new HashMap<DynamicObject, SourceNumber>();
    private static final String VOUCHERBYHAND = "voucherbyhand";
    private static Log logger = LogFactory.getLog(BankJournalListPlugin.class);

    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isshowtoolbarap && isshowtoolbarap.equals("no")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"tbldel"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("delete");
        if (customParam != null) {
            view.setVisible(Boolean.valueOf(true), new String[]{"tbldel"});
            view.setVisible(Boolean.valueOf(false), new String[]{"baritemap1", "baritemap2", "importdata", "importdetails", "importtemplate"});
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("delete");
        if (customParam == null) {
            List columns = args.getListColumns();
            IListColumn removeColumn = null;
            for (IListColumn column : columns) {
                String fieldName = column.getListFieldKey();
                if (!"batchno".equals(fieldName)) continue;
                removeColumn = column;
            }
            if (removeColumn != null) {
                columns.remove(removeColumn);
                args.setListColumns(columns);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if ("view".equals(opKey) && CasHelper.getSelectedRowSize((ListSelectedRowCollection)selectedRows) > 1) {
            args.setCancel(true);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u67e5\u770b\u3002", (String)"CAS-E-672512", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject journal = e.getRowData();
        AbstractColumnDesc column = (AbstractColumnDesc)e.getSource();
        String columnName = column.getFieldKey();
        if (this.voucherNoCache.size() > 0 && this.voucherNoCache.get(journal) != null) {
            SourceNumber sourceNumber = this.voucherNoCache.get(journal);
            if ("voucherno".equalsIgnoreCase(columnName)) {
                e.setFormatValue((Object)sourceNumber.getVoucherNo());
            } else if ("sourcebillnumber".equalsIgnoreCase(columnName) && StringUtils.isNotEmpty((String)sourceNumber.getVoucherNo())) {
                e.setFormatValue((Object)sourceNumber.getVoucherNo());
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                DynamicProperty property = data.getDynamicObjectType().getProperty("sourcebilltype");
                if (property != null) {
                    BankJournalListPlugin.this.voucherNoCache = new VoucherBookService().getSourceNumbers((Collection)data, "cas_bankjournal");
                }
                return data;
            }
        });
    }

    @Override
    protected String getAcctEntity() {
        return "bd_accountbanks";
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (VOUCHERBYHAND.equals(itemKey)) {
            ListShowParameter listForm = ShowFormHelper.createShowListForm((String)"gl_voucher", (boolean)false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, VOUCHERBYHAND);
            listForm.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listForm);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (VOUCHERBYHAND.equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (CasHelper.isEmpty((Object)returnData)) {
                return;
            }
            List rows = (List)returnData;
            Object voucherId = ((ListSelectedRow)rows.get(0)).getPrimaryKeyValue();
            DynamicObject[] bankJournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"gl_voucher"), new QFilter("sourcebillid", "=", voucherId)});
            if (!CasHelper.isEmpty((DynamicObject[])bankJournals)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u51ed\u8bc1\u5df2\u751f\u6210\u65e5\u8bb0\u8d26\uff01", (String)"BankJournalListPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject voucher = BusinessDataServiceHelper.loadSingle((Object)voucherId, (String)"gl_voucher");
            if (voucher == null) {
                return;
            }
            List journalInfoList = new VoucherBookJournalBuilder().getJournalInfoList(voucher);
            List<DynamicObject> saveBankJournal = this.saveBankJournal(journalInfoList);
            if (saveBankJournal != null && saveBankJournal.size() > 0) {
                JournalBookImpl journalBookImpl = new JournalBookImpl();
                journalBookImpl.process(saveBankJournal.toArray(new DynamicObject[0]));
            }
        }
    }

    public List<DynamicObject> saveBankJournal(List<JournalInfo> journalInfoList) {
        try {
            ArrayList<DynamicObject> journalList = new ArrayList<DynamicObject>();
            for (int i = 0; i < journalInfoList.size(); ++i) {
                DynamicObject journal = null;
                JournalInfo journalInfo = journalInfoList.get(i);
                DynamicObject settlementType = journalInfo.getSettlementType();
                if (settlementType != null && "14".equals(settlementType.getString("settlementtype"))) {
                    BookJournalLogger.log((String)String.format(ResManager.loadKDString((String)"\u865a\u62df\u652f\u4ed8\u4e0d\u767b\u65e5\u8bb0\u8d26%s", (String)"BankJournalListPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), settlementType.getString("number")));
                    continue;
                }
                DynamicObject org = journalInfo.getOrg();
                long orgId = (Long)org.getPkValue();
                boolean voucherBookJournal = SystemParameterHelper.isVoucherBookJournal((long)orgId);
                String sourceBillType = journalInfo.getSourceBillType();
                BookJournalLogger.log((String)String.format(ResManager.loadKDString((String)"\u767b\u8d26\u53c2\u6570\uff0csourceBillType\u4e3a%1$s\uff0cCS105\u4e3a%2$s\u3002", (String)"BankJournalListPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), sourceBillType, voucherBookJournal));
                if ("gl_voucher".equals(sourceBillType)) {
                    boolean fromCashCount = "cas_cash_verification".equals(journalInfo.getSourceBillTypeOfSourceBill());
                    if (!voucherBookJournal) {
                        continue;
                    }
                } else if (!SystemParameterHelper.isBillBookJournal((long)orgId)) continue;
                if (journalInfo.getAccountBank() != null) {
                    journal = this.newJournalObject("cas_bankjournal");
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"accountbank", (Object)journalInfo.getAccountBank());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"ischeck", (Object)false);
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bankCheckFlag", (Object)CasHelper.subFlag((String)journalInfo.getBankCheckFlag()));
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bankcheckflag_tag", (Object)journalInfo.getBankCheckFlag());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"synccheck", (Object)journalInfo.getSynccheck());
                } else if (journalInfo.getAccountCash() != null) {
                    journal = this.newJournalObject("cas_cashjournal");
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"accountcash", (Object)journalInfo.getAccountCash());
                } else {
                    BookJournalLogger.log((String)ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u548c\u73b0\u91d1\u8d26\u6237\u4e3a\u7a7a\u3002", (String)"BankJournalListPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    continue;
                }
                BigDecimal creditAmount = journalInfo.getCreditAmount();
                BigDecimal debitAmount = journalInfo.getDebitAmount();
                int direction = journalInfo.getDirection();
                if (creditAmount.compareTo(BigDecimal.ZERO) < 0) {
                    debitAmount = creditAmount.abs();
                    creditAmount = BigDecimal.ZERO;
                    direction = 2;
                }
                if (debitAmount.compareTo(BigDecimal.ZERO) < 0) {
                    creditAmount = debitAmount.abs();
                    debitAmount = BigDecimal.ZERO;
                    direction = 1;
                }
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"org", (Object)org);
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"currency", (Object)journalInfo.getCurrency());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"cashier", (Object)journalInfo.getCashier());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"settlementType", (Object)journalInfo.getSettlementType());
                int CS104 = SystemParameterHelper.getParameterInteger((long)orgId, (String)"cs104");
                Date bookDate = journalInfo.getBizDate();
                if (CS104 == 2) {
                    bookDate = new Date();
                } else if (CS104 == 3) {
                    bookDate = journalInfo.getBookDate();
                }
                Set cs109 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs109");
                if (("cas_paybill".equals(sourceBillType) || "cas_agentpaybill".equals(sourceBillType)) && cs109.contains(journalInfo.getPaychannel()) && journalInfo.getPayDate() != null) {
                    bookDate = journalInfo.getPayDate();
                }
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bookDate", (Object)journalInfo.getBookDate());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"period", (Object)PeriodHelper.getPeriodByDate((long)orgId, (Date)journal.getDate("bookDate")));
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bizDate", (Object)journalInfo.getBizDate());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"description", (Object)journalInfo.getDescription());
                DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)journal, (String)"description");
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourceBillType", (Object)sourceBillType);
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourceBillNumber", (Object)journalInfo.getSourceBillNumber());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"billno", (Object)journalInfo.getBillno());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"settlementNumber", (Object)journalInfo.getSettlementNumber());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourceBillId", (Object)journalInfo.getSourceBillId());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"direction", (Object)direction);
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"source", (Object)journalInfo.getSource());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"relatedBizDate", (Object)journalInfo.getRelatedBizDate());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"ticketNumber", (Object)journalInfo.getTicketNumber());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"lineno", (Object)journalInfo.getLineno());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"oppUnit", (Object)journalInfo.getOppUnit());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"oppAcctNumber", (Object)journalInfo.getOppAcctNumber());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"oppBank", (Object)journalInfo.getOppBank());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"creditAmount", (Object)creditAmount);
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"debitAmount", (Object)debitAmount);
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"exchangeRate", (Object)journalInfo.getExchangeRate());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"batchNo", (Object)journalInfo.getBatchNo());
                if (journalInfo.getLocalAmount() != null) {
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"localamount", (Object)journalInfo.getLocalAmount().abs());
                }
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"basecurrency", (Object)OrgHelper.getBaseCurrency((long)org.getLong("id")));
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"billstatus", (Object)EnumBillStatus.C);
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"createtime", (Object)new Date());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"tracedate", (Object)journalInfo.getTraceDate());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"avddate", (Object)journalInfo.getAvd());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"pddate", (Object)journalInfo.getPd());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"preparationdate", (Object)journalInfo.getPreparationdate());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"feepayer", (Object)journalInfo.getFeepayer());
                EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)journal.getDataEntityType().getName()).findProperty("entry");
                DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
                List entryList = journalInfo.getEntry();
                for (int j = 0; j < entryList.size(); ++j) {
                    JournalEntryInfo entryInfo = (JournalEntryInfo)entryList.get(j);
                    DynamicObject entryObject = new DynamicObject(dt);
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"seq", (Object)(j + 1));
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_fundflowitem", (Object)entryInfo.getFundFlowItem());
                    if (entryInfo.getAmount() != null) {
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_amount", (Object)entryInfo.getAmount().abs());
                    }
                    if (entryInfo.getLocalAmount() != null) {
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_localamount", (Object)entryInfo.getLocalAmount().abs());
                    }
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_org", (Object)org);
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_currency", (Object)journalInfo.getCurrency());
                    if (journalInfo.getAccountBank() != null) {
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_accountbank", (Object)journalInfo.getAccountBank());
                    } else {
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_accountcash", (Object)journalInfo.getAccountCash());
                    }
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_oppunit", (Object)(entryInfo.getOppUnit() != null ? entryInfo.getOppUnit() : journalInfo.getOppUnit()));
                    journal.getDynamicObjectCollection("entry").add((Object)entryObject);
                }
                journalList.add(journal);
                return journalList;
            }
        }
        catch (Exception e) {
            logger.error("error voucher\uff1a" + e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        return null;
    }

    private DynamicObject newJournalObject(String entityName) {
        return BusinessDataServiceHelper.newDynamicObject((String)entityName);
    }
}

