/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.formplugin.JournalBaseTreeRpt;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.DateUtils;

public class BankJournalTreeRpt
extends JournalBaseTreeRpt {
    @Override
    public List<TreeNode> query(ReportQueryParam arg0, String arg1) throws Throwable {
        FilterInfo filterInfo = arg0.getFilter();
        String queryorgtype = filterInfo.getString("queryorgtype");
        this.orgControlName = "org".equals(queryorgtype) ? "org" : "openorg";
        String showtype = filterInfo.getString("showType");
        if (showtype != null) {
            this.showType = showtype;
        }
        this.acctColl = filterInfo.getDynamicObjectCollection("accountbank");
        return super.query(arg0, arg1);
    }

    @Override
    public DynamicObjectCollection getAcctPlainColl() {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.acctColl != null) {
            filters.add(new QFilter("id", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)this.acctColl)));
        } else if ("org".equals(this.orgControlName)) {
            ArrayList<QFilter> listQ = new ArrayList<QFilter>(1);
            listQ.add(AccountBankHelper.getUseAuthAccountBankFilterByOrg((Collection)OrgHelper.getIdList((DynamicObjectCollection)this.orgColl)));
            filters.addAll(listQ);
        } else if ("openorg".equals(this.orgControlName)) {
            filters.add(new QFilter("openorg", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)this.orgColl)));
        }
        if (!this.isContainClosed) {
            filters.add(new QFilter("acctstatus", "!=", (Object)"closed"));
        } else {
            QFilter qFilter = QFilter.of((String)"(closedate = null or closedate >= ?)", (Object[])new Object[]{DateUtils.getDataFormat((Date)this.beginDate, (boolean)true)});
            filters.add(qFilter);
        }
        filters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        String selectFields = "id,name as acctname,number as acctnumber,openorg.id as orgid,openorg.name as orgname,currency.fbasedataid.id as currencyid,currency.fbasedataid.name as currencyname";
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bd_accountbanks", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        if ("org".equals(this.orgControlName) && queryResult != null && queryResult.size() > 0) {
            this.acctAuthOrgs = new HashMap(queryResult.size());
            for (DynamicObject acct : queryResult) {
                long acctId = acct.getLong("id");
                Set userAuthorityOrgs = AccountBankHelper.getUseAuthorityOrg((Long)acctId);
                this.acctAuthOrgs.put(acctId, userAuthorityOrgs);
            }
        }
        return queryResult;
    }

    @Override
    protected boolean isAuthOrg(DynamicObject acct, long orgId) {
        if ("org".equals(this.orgControlName)) {
            long acctId = acct.getLong("id");
            if (this.acctAuthOrgs == null) {
                return false;
            }
            Set userAuthorityOrgs = (Set)this.acctAuthOrgs.get(acctId);
            return userAuthorityOrgs != null && userAuthorityOrgs.contains(orgId);
        }
        return acct.getLong("orgid") == orgId;
    }
}

