/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.query.impl.SumQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalances;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.service.BalanceDataService;
import kd.fi.cas.business.balancemodel.service.balance.BalanceQueryType;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.business.statement.BankStatementCheck;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.CheckedResultSourceEnum;
import kd.fi.cas.formplugin.BeforeQueryListDataProvider;
import kd.fi.cas.formplugin.common.CasCommonFilterListPlugin;
import kd.fi.cas.formplugin.helper.UnCheckExportHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BalanceAccHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.CreateExcelUtil;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BankVCCheckList
extends CasCommonFilterListPlugin {
    private static final Log logger = LogFactory.getLog(BankVCCheckList.class);
    public static final DBRoute SYS = new DBRoute("sys");
    protected static final String[] exportFieldSheet1 = new String[]{"company.number", "company.name", "accountbank", "accountbank.name", "accountbank.bankaccountnumber", "currency", "checktype", "checkdate"};
    protected static final String[] exportFieldSheet2 = new String[]{"company.number", "company.name", "accountbank", "accountbank.name", "accountbank.bankaccountnumber", "currency", "checktype", "checkdate", "bizobject", "bizdate", "debitamount", "creditamount", "oppunit", "description", "bankcheckflag", "matchcode", "settlementnumber", "vouchernumber", "pddate", "avddate", "sysdate", "settlementtype.name", "oppacctnumber", "balanceamt", "sourcebillnumber", "tradenumber", "bankvouvherno", "ischeck", "source", "cashier.name"};
    private static final String EXPORT_UNCHECK = "exportuncheck";
    private BalanceCountService balanceCountService = new BalanceCountService();
    private static final String CACHE_KEY_ACCOUNTS = "account_set";
    private static final String CACHE_KEY_ACCT_CRY = "account_currency_set";
    private static final String CACHE_KEY_HISTORY_JOURNAL = "history_journal";
    private static final String CACHE_KEY_HISTORY_STATEMENT = "history_statement";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setOrderBy("org,accountbank,currency");
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        AccountBankHelper.initOrgForAccountManagerTransfer((ListShowParameter)listShowParameter, (List)args.getCommonFilterColumns(), (IPageCache)this.getPageCache());
        super.filterContainerInit(args);
        AccountBankHelper.initForAccountManagerTransfer((ListShowParameter)listShowParameter, (List)args.getCommonFilterColumns(), (IPageCache)this.getPageCache());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Date endDate = this.getFilterEndDate(e);
        e.getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctToBillQf());
        if (EmptyUtil.isNoEmpty((Object)endDate)) {
            QFilter qFilter = new QFilter("accountbank.opendate", "<=", (Object)endDate);
            e.getQFilters().add(qFilter);
        }
    }

    private Date getFilterEndDate(SetFilterEvent e) {
        List filter = e.getQFilters();
        Date endDate = null;
        if (filter != null && !filter.isEmpty()) {
            for (int i = 0; i < filter.size(); ++i) {
                List qFilterNestList = ((QFilter)filter.get(i)).getNests(true);
                LinkedList<QFilter> singleFilterList = new LinkedList<QFilter>();
                for (QFilter.QFilterNest qFilterNest : qFilterNestList) {
                    singleFilterList.add(qFilterNest.getFilter());
                }
                if (!qFilterNestList.isEmpty()) {
                    singleFilterList.add(0, ((QFilter.QFilterNest)qFilterNestList.get(0)).getParent());
                }
                for (QFilter singleFilter : singleFilterList) {
                    String property = singleFilter.getProperty();
                    if (!"bizdate".equals(property)) continue;
                    endDate = this.parseDateBeginAndEnd(singleFilter.copy());
                }
            }
        }
        return endDate;
    }

    private Date parseDateBeginAndEnd(QFilter dateFilter) {
        Date dateFilterEnd = null;
        if (dateFilter != null && null != dateFilter.getValue() && !"EMPTY".equalsIgnoreCase(dateFilter.getValue().toString()) && !">=".equals(dateFilter.getCP())) {
            dateFilterEnd = DateUtils.getNextSeconds((Date)((Date)dateFilter.getValue()), (int)-1);
        }
        return dateFilterEnd;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (key != null && key.startsWith("exportlist")) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.getFilterParameter().getQFilters().add(new QFilter("pageid", "=", (Object)this.getPageCache().get("pageId")));
        } else if ("balanceadjust".equals(key)) {
            String endDateStr = this.getPageCache().get("endDate");
            if (CasHelper.isEmpty((Object)endDateStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u622a\u6b62\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"BankVCCheckList_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                args.setCancel(true);
            }
            op.getOption().setVariableValue("endDate", endDateStr);
            DynamicObject[] selectedData = this.getSelectedData();
            Map<String, Long> orgBeginDate = this.getOrgBeginDate(selectedData);
            op.getOption().setVariableValue("orgBeginDate", JSON.toJSONString(orgBeginDate));
        } else if ("viewadjust".equals(key)) {
            DynamicObject[] selectedData = this.getSelectedData();
            if (selectedData == null || selectedData.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u3002", (String)"BankVCCheckList_5_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                args.setCancel(true);
            } else {
                DynamicObject acctBank = selectedData[0].getDynamicObject("accountbank");
                String acctStatus = acctBank.getString("acctstatus");
                if (BankAcctStatusEnum.CLOSED.getValue().equals(acctStatus)) {
                    Map<String, Long> orgPeriod = this.getOrgBeginDate(selectedData);
                    Date closeDate = acctBank.getDate("closedate");
                    Long currTermBeginDate = orgPeriod.get(String.valueOf(selectedData[0].getDynamicObject("org").getLong("id")));
                    if (closeDate == null) {
                        String msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff1a\u8be5\u8d26\u6237\u5df2\u9500\u6237\u4e14\u9500\u6237\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\u9884\u89c8\u4f59\u989d\u8c03\u8282\u8868\uff1f", (String)"BankVCCheckList_5_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBank.getString("number"), selectedData[0].getDynamicObject("currency").getString("name"));
                        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_VIEW_ADJUST_CALLBACK", (IFormPlugin)this));
                        args.setCancel(true);
                    } else if (currTermBeginDate == null) {
                        String message = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u201d%1$s\u201d\u7684\u5f53\u524d\u671f\u95f4\uff0c\u5426\u5219\u65e0\u6cd5\u9884\u89c8\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVCCheckList_5_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), selectedData[0].getDynamicObject("org").getString("name"));
                        this.getView().showTipNotification(message, Integer.valueOf(5000));
                        args.setCancel(true);
                    } else if (closeDate.getTime() < currTermBeginDate) {
                        String msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff1a\u8be5\u8d26\u6237\u5df2\u9500\u6237\uff0c\u4e0d\u53ef\u9884\u89c8\u9500\u6237\u65e5\u671f\u6240\u5728\u671f\u95f4\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVCCheckList_5_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), acctBank.getString("number"), selectedData[0].getDynamicObject("currency").getString("name"));
                        this.getView().showTipNotification(msg, Integer.valueOf(5000));
                        args.setCancel(true);
                    }
                }
            }
        } else if ("autocheck".equals(key)) {
            String strEndDate = this.getPageCache().get("endDate");
            op.getOption().setVariableValue("checkEndDate", strEndDate);
            String strStartDate = this.getPageCache().get("beginDate");
            op.getOption().setVariableValue("checkBeginDate", strStartDate);
            logger.info("\u81ea\u52a8\u5bf9\u8d26\u5f00\u59cb\u65e5\u671f\uff1a{}\uff0c\u7ed3\u675f\u65e5\u671f\uff1a{}", (Object)strStartDate, (Object)strEndDate);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        DynamicObject[] selectedData = this.getSelectedData();
        DynamicObject bankVc = null;
        boolean hasPermission = false;
        FormShowParameter formParameter = new FormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        switch (key) {
            case "checkset": {
                List<Object> orgIdList = new ArrayList();
                if (selectedData == null || selectedData.length == 0) {
                    orgIdList = this.getCachedOrgList();
                } else {
                    for (DynamicObject data : selectedData) {
                        orgIdList.add(data.getDynamicObject("org").getPkValue());
                    }
                }
                if (orgIdList == null || orgIdList.size() == 0 || CasHelper.isEmpty((Object)orgIdList.get(0))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u914d\u7f6e\u7684\u7ec4\u7ec7\u3002", (String)"BankVCCheckList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                ArrayList<Object> hasPermOrg = new ArrayList<Object>();
                boolean hasPerm = false;
                for (Object orgId : orgIdList) {
                    hasPerm = PermissionHelper.checkCurrentUserPermission((String)appId, (long)Long.parseLong(orgId.toString()), (String)"cas_bankvccheck", (String)"0C4GTWNOP=IC");
                    if (!hasPerm) continue;
                    hasPermOrg.add(orgId);
                }
                if (hasPermOrg.size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709[\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26]\u7684\u64cd\u4f5c[\u5bf9\u8d26\u89c4\u5219\u8bbe\u7f6e]\u7684\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d[\u7ec4\u7ec7\u5bf9\u8d26\u89c4\u5219\u8bbe\u7f6e]\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BankVCCheckList_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("cas_reconciliationrule");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "checkset"));
                parameter.setCustomParam("orgList", hasPermOrg.stream().distinct().collect(Collectors.toList()));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "checkbyhand": {
                boolean isCanCheck;
                if (selectedData == null || selectedData.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u3002", (String)"BankVCCheckList_5_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                bankVc = selectedData[0];
                DynamicObject org = bankVc.getDynamicObject("org");
                hasPermission = PermissionHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)org.getLong("id"), (String)appId, (String)"cas_bankvccheck", (String)"4730fc9f000008ae");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u201d\u7684\u201c\u5bf9\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BankVCCheckList_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                String endDateStr = this.getPageCache().get("endDate");
                if (CasHelper.isEmpty((Object)endDateStr)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u622a\u6b62\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"BankVCCheckList_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                Date endDate = DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
                endDate = DateUtils.getBeforeDate((Date)endDate, (Date)new Date());
                DynamicObject accountBank = bankVc.getDynamicObject("accountbank");
                boolean authorityAccount = AccountBankHelper.isAuthorityAccount((DynamicObject)accountBank, (DynamicObject)org);
                if (!authorityAccount && !(isCanCheck = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"cs099"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u6237\u4f7f\u7528\u6743\u7ec4\u7ec7\u4e0d\u652f\u6301\u5bf9\u8d26\uff0c\u8bf7\u524d\u5f80\u914d\u7f6e\u5de5\u5177\u4e2d\u8c03\u6574\u53c2\u6570\u914d\u7f6e\u3002", (String)"BankVCCheckList_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                formParameter.setFormId("cas_checkresult");
                formParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formParameter.getOpenStyle().setTargetKey("tabap");
                formParameter.setCustomParam("orgid", (Object)org.getLong("id"));
                formParameter.setCustomParam("accountbankid", (Object)accountBank.getLong("id"));
                formParameter.setCustomParam("currencyid", (Object)bankVc.getLong("currency.id"));
                formParameter.setCustomParam("bizdateend", (Object)this.getEndDate());
                formParameter.setCustomParam("bizdate", (Object)this.getStartDate());
                formParameter.setCustomParam("verifystatus", (Object)bankVc.getBoolean("verifystatus"));
                formParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "checkresultclose"));
                this.getView().showForm(formParameter);
                break;
            }
            case "bankuncheck": {
                hasPermission = PermissionHelper.checkCurrentUserPermission((String)appId, (long)RequestContext.get().getOrgId(), (String)"cas_bankvccheck", (String)"4730fc9f000008ae");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u201d\u7684\u201c\u5bf9\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BankVCCheckList_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                OperationResult result = OperateServiceHelper.execOperate((String)"bankuncheck", (String)"cas_bankvccheck", (DynamicObject[])new DynamicObject[]{BusinessDataServiceHelper.newDynamicObject((String)"cas_bankvccheck")}, (OperateOption)OperateOption.create());
                if (!result.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6309\u89c4\u5219\u64a4\u9500\u5bf9\u8d26\u6210\u529f\u3002", (String)"BankVCCheckList_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
            case "exportexcel": {
                hasPermission = PermissionHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_bankvccheck", (String)"4FT13VAN74HJ");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u201d\u7684\u201c\u5df2\u5bf9\u8d26\u7ed3\u679c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckResultPlugin_36", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (selectedData == null) {
                    BillList s = (BillList)this.getView().getControl("billlistap");
                    s.selectAllRows();
                    selectedData = this.getSelectedData();
                    if (selectedData == null || selectedData.length == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"ExportExcelErrorCode_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                this.exportExcelFile(selectedData);
                break;
            }
            case "exportuncheck": {
                hasPermission = PermissionHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_bankvccheck", (String)"4FT19/GI92BJ");
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u201d\u7684\u201c\u672a\u5bf9\u8d26\u7ed3\u679c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckResultPlugin_37", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                long start = System.currentTimeMillis();
                logger.info("[EXPORT_UNCHECK]\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)start);
                if (selectedData == null) {
                    BillList s = (BillList)this.getView().getControl("billlistap");
                    s.selectAllRows();
                    selectedData = this.getSelectedData();
                    if (selectedData == null || selectedData.length == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"ExportExcelErrorCode_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                long afterQueryListDataTime = System.currentTimeMillis();
                logger.info("[EXPORT_UNCHECK]\u67e5\u8be2\u5b8c\u5217\u8868\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(afterQueryListDataTime - start));
                this.exportUnCheck(selectedData);
                break;
            }
            case "getbalance": {
                this.getBalance(selectedData);
                break;
            }
            case "tblrefresh": {
                this.getPageCache().put("isfirst", null);
                break;
            }
            case "syncbank": {
                try {
                    Set orgIds = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)"cas", (String)"cas_bankvccheck", (String)"47150e89000000ac");
                    BankStatementCheck.getInstance().syncBankAccount2Statement(orgIds, null);
                }
                catch (Exception e) {
                    logger.error("error:", (Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff01", (String)"BankVCCheckList_26", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    throw new KDBizException(e.getMessage());
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u5b8c\u6210\uff01", (String)"BankVCCheckList_27", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
            case "export": {
                if (selectedData != null) break;
                BillList s = (BillList)this.getView().getControl("billlistap");
                s.selectAllRows();
                break;
            }
        }
    }

    private void getBalance(DynamicObject[] selectedDatas) {
        String endDateStr = this.getPageCache().get("endDate");
        if (CasHelper.isEmpty((Object)endDateStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u622a\u6b62\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"BankVCCheckList_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String beginDateStr = this.getPageCache().get("beginDate");
        HashSet<Long> acctSet = new HashSet<Long>(16);
        String hisJarStr = this.getPageCache().get(CACHE_KEY_HISTORY_JOURNAL);
        Map<String, String> hisJarMap = EmptyUtil.isEmpty((String)hisJarStr) ? new HashMap() : (Map)SerializeUtils.fromJsonString((String)hisJarStr, Map.class);
        String hisSatStr = this.getPageCache().get(CACHE_KEY_HISTORY_STATEMENT);
        Map<String, String> hisSatMap = EmptyUtil.isEmpty((String)hisSatStr) ? new HashMap() : (Map)SerializeUtils.fromJsonString((String)hisSatStr, Map.class);
        boolean useBalanceModel = ExtendConfigHelper.useBalanceModel();
        Date endDate = DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd");
        if (!useBalanceModel) {
            endDate = DateUtils.getBeforeDate((Date)endDate, (Date)new Date());
        }
        Date beginDate = DateUtils.stringToDate((String)beginDateStr, (String)"yyyy-MM-dd");
        if (EmptyUtil.isNoEmpty((Object[])selectedDatas)) {
            for (DynamicObject row : selectedDatas) {
                DynamicObject accountBank = row.getDynamicObject("accountbank");
                DynamicObject currency = row.getDynamicObject("currency");
                if (accountBank == null || currency == null) continue;
                acctSet.add(accountBank.getLong("id"));
                String key = accountBank.getString("id") + "-" + currency.getString("id");
                hisJarMap.put(key, null);
                hisSatMap.put(key, null);
            }
            this.getPageCache().put(CACHE_KEY_ACCOUNTS, SerializeUtils.toJsonString(acctSet));
            Map<String, BigDecimal> jarBalanceMap = null;
            Map statBalanceMap = null;
            if (useBalanceModel) {
                jarBalanceMap = this.queryByBalanceModel_new(BalanceType.JOURNAL, selectedDatas, beginDate, endDate);
                statBalanceMap = this.queryByBalanceModel_new(BalanceType.STATE, selectedDatas, beginDate, endDate);
            } else {
                jarBalanceMap = this.getAccountBalance(selectedDatas, endDate);
                Map acctToCnyMap = Arrays.stream(selectedDatas).filter(r -> r.getDynamicObject("accountbank") != null && r.getDynamicObject("currency") != null).collect(Collectors.groupingBy(r -> r.getDynamicObject("accountbank").getLong("id"), Collectors.mapping(r -> r.getDynamicObject("currency").getLong("id"), Collectors.toSet())));
                statBalanceMap = this.balanceCountService.getStatmBalanceBatch(acctSet, acctToCnyMap, endDate);
            }
            if (null != jarBalanceMap) {
                for (Map.Entry<String, BigDecimal> jarBalance : jarBalanceMap.entrySet()) {
                    hisJarMap.put(jarBalance.getKey(), jarBalance.getValue().toPlainString());
                }
            }
            if (null != statBalanceMap) {
                for (Map.Entry<String, BigDecimal> statBalance : statBalanceMap.entrySet()) {
                    hisSatMap.put(statBalance.getKey(), statBalance.getValue().toPlainString());
                }
            }
            this.getPageCache().put(CACHE_KEY_HISTORY_JOURNAL, SerializeUtils.toJsonString(hisJarMap));
            this.getPageCache().put(CACHE_KEY_HISTORY_STATEMENT, SerializeUtils.toJsonString(hisSatMap));
            this.billRefresh();
        }
    }

    private void exportUnCheck(DynamicObject[] selectedData) {
        if ((selectedData = this.getAllIfNotHaveSelectedData(selectedData)) == null || selectedData.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"ExportExcelErrorCode_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.doexportUnCheck(selectedData);
    }

    private void doexportUnCheck(DynamicObject[] selectedData) {
        String endDateStr = this.getPageCache().get("endDate");
        if (EmptyUtil.isEmpty((String)endDateStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u622a\u6b62\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"BankVCCheckList_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList exportEntitySheet = null;
        UnCheckExportHelper instance = UnCheckExportHelper.getInstance();
        int maxSize = 50000;
        for (DynamicObject dynamicObject : selectedData) {
            if (Objects.isNull(dynamicObject)) continue;
            DynamicObject[] bankCheck = this.queryBankCheck(dynamicObject);
            DynamicObject[] bankDaily = this.queryBankDaily(dynamicObject);
            if (Objects.isNull(exportEntitySheet)) {
                int size = (bankCheck.length + bankDaily.length) * selectedData.length;
                if (size >= maxSize) {
                    size = maxSize + 10000;
                }
                exportEntitySheet = new ArrayList(size);
            }
            instance.doExprotUnCheckBatch(exportEntitySheet, "bankcheck", bankCheck);
            instance.doExprotUnCheckBatch(exportEntitySheet, "bankdaily", bankDaily);
            int totalSize = exportEntitySheet.size() + bankCheck.length + bankDaily.length;
            if (totalSize <= maxSize) continue;
            String message = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u91cf\uff1a%s\u5927\u4e8e50000\uff0c\u540e\u7eed\u6570\u636e\u4e0d\u518d\u5bfc\u51fa", (String)"BankVCCheckList_21", (String)"fi-cas-formplugin", (Object[])new Object[]{totalSize});
            this.getView().showTipNotification(message);
            break;
        }
        SXSSFWorkbook wb = new SXSSFWorkbook(-1);
        String excelName = ResManager.loadKDString((String)"\u672a\u5bf9\u8d26\u8bb0\u5f55", (String)"BankVCCheckList_22", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        CreateExcelUtil.createExcelFile((SXSSFWorkbook)wb, (String)excelName, (String[])UnCheckExportHelper.getExportUnCheckHeadTitle(), exportEntitySheet);
        try {
            excelName = CreateExcelUtil.getTempFilename1((String)excelName);
            String fileUrl = CreateExcelUtil.writeFile((SXSSFWorkbook)wb, (String)excelName);
            this.getView().download(fileUrl);
        }
        catch (KDException e) {
            logger.error((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private DynamicObject[] queryBankDaily(DynamicObject dynamicObject) {
        Object[] idObjects;
        DynamicObject mainOrg = dynamicObject.getDynamicObject("org");
        DynamicObject accountBank = dynamicObject.getDynamicObject("accountbank");
        QFilter filter = new QFilter("accountbank", "=", (Object)accountBank.getLong("id"));
        if (Objects.nonNull(mainOrg) && mainOrg.getLong("id") != accountBank.getDynamicObject("createorg").getLong("id")) {
            filter.and(new QFilter("org", "in", mainOrg.getPkValue()));
        }
        filter = filter.and("currency", "=", (Object)dynamicObject.getLong("currency.id"));
        filter = filter.and("ischeck", "=", (Object)"0");
        String endDateStr = this.getPageCache().get("endDate");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)endDateStr)) {
            Date end = DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
            filter = filter.and("bookdate", "<=", (Object)end);
        }
        return EmptyUtil.isNoEmpty((Object[])(idObjects = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id", (QFilter[])new QFilter[]{filter}))) ? BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)String.join((CharSequence)",", UnCheckExportHelper.BANK_DAILY_SELECT_FIELDS), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)Arrays.stream(idObjects).map(DataEntityBase::getPkValue).toArray())}) : new DynamicObject[]{};
    }

    private DynamicObject[] queryBankCheck(DynamicObject dynamicObject) {
        DynamicObject accountBank = dynamicObject.getDynamicObject("accountbank");
        QFilter filter = new QFilter("accountbank", "=", (Object)accountBank.getLong("id"));
        filter = filter.and("currency", "=", (Object)dynamicObject.getLong("currency.id"));
        filter = filter.and("ischeck", "=", (Object)"0");
        String endDateStr = this.getPageCache().get("endDate");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)endDateStr)) {
            Date end = DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
            filter = filter.and("bizdate", "<=", (Object)end);
        }
        filter.and(new QFilter("isbank", "=", (Object)"1"));
        Object[] idObjects = BusinessDataServiceHelper.load((String)"cas_bankstatement", (String)"id", (QFilter[])new QFilter[]{filter});
        return EmptyUtil.isNoEmpty((Object[])idObjects) ? BusinessDataServiceHelper.load((String)"cas_bankstatement", (String)String.join((CharSequence)",", UnCheckExportHelper.BANK_STATEMENT_SELECT_FIELDS), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)Arrays.stream(idObjects).map(DataEntityBase::getPkValue).toArray())}) : new DynamicObject[]{};
    }

    private boolean checkPermission(String appId, DynamicObject dynamicObject) {
        boolean isCanCheck;
        DynamicObject org = dynamicObject.getDynamicObject("org");
        DynamicObject accountBank = dynamicObject.getDynamicObject("accountbank");
        boolean authorityAccount = AccountBankHelper.isAuthorityAccount((DynamicObject)accountBank, (DynamicObject)org);
        if (!authorityAccount && !(isCanCheck = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"cs099"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u6237\u4f7f\u7528\u6743\u7ec4\u7ec7\u4e0d\u652f\u6301\u5bf9\u8d26\uff0c\u8bf7\u524d\u5f80\u914d\u7f6e\u5de5\u5177\u4e2d\u8c03\u6574\u53c2\u6570\u914d\u7f6e\u3002", (String)"BankVCCheckList_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        boolean hasPermission = PermissionHelper.checkCurrentUserPermission((String)appId, (long)dynamicObject.getLong("org.id"), (String)"cas_bankvccheck", (String)"4730fc9f000008ae");
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u201d\u7684\u201c\u5bf9\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BankVCCheckList_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private DynamicObject[] getAllIfNotHaveSelectedData(DynamicObject[] selectedData) {
        if (EmptyUtil.isEmpty((Object[])selectedData)) {
            BillList s = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = s.getSelectedRows();
            if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u672a\u627e\u5230\u8bb0\u5f55\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5", (String)"BankVCCheckList_23", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            s.selectAllRows();
            selectedData = this.getSelectedData();
            s.clearSelection();
            s.refresh();
            return selectedData;
        }
        return selectedData;
    }

    protected static String[] getExportHeadTitle() {
        String[] exportHeadTitle = new String[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"CheckResultPlugin_ExportExcelH_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"CheckResultPlugin_ExportExcelH_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"CheckResultPlugin_ExportExcelH_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u540d\u79f0", (String)"CheckResultPlugin_ExportExcelH_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"CheckResultPlugin_ExportExcelH_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CheckResultPlugin_ExportExcelH_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u5f0f", (String)"CheckResultPlugin_ExportExcelH_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u8d26\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"CheckResultPlugin_ExportExcelH_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d", (String)"CheckResultPlugin_ExportExcelH_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d", (String)"CheckResultPlugin_ExportExcelH_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u65b9\u6237\u540d", (String)"CheckResultPlugin_ExportExcelH_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6458\u8981", (String)"CheckResultPlugin_ExportExcelH_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u8d26\u6807\u8bc6\u7801", (String)"CheckResultPlugin_ExportExcelH_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5339\u914d\u7801", (String)"CheckResultPlugin_ExportExcelH_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u53f7", (String)"CheckResultPlugin_ExportExcelH_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7", (String)"CheckResultPlugin_ExportExcelH_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u671f\u671b\u4ed8\u6b3e\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7cfb\u7edf\u65e5\u671f", (String)"CheckResultPlugin_ExportExcelH_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"CheckResultPlugin_ExportExcelH_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u65b9\u8d26\u53f7", (String)"CheckResultPlugin_ExportExcelH_22", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f59\u989d", (String)"CheckResultPlugin_ExportExcelH_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u53f7", (String)"CheckResultPlugin_ExportExcelH_24", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u8003\u53f7", (String)"CheckResultPlugin_ExportExcelH_25", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u6d41\u6c34\u53f7", (String)"CheckResultPlugin_ExportExcelH_26", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f\u5426\u52fe\u5bf9", (String)"CheckResultPlugin_ExportExcelH_27", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6765\u6e90", (String)"CheckResultPlugin_ExportExcelH_28", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51fa\u7eb3", (String)"CheckResultPlugin_ExportExcelH_29", (String)"fi-cas-formplugin", (Object[])new Object[0])};
        return exportHeadTitle;
    }

    public void exportExcelFile(DynamicObject[] selectedData) {
        String[] exportTitleSheet2 = BankVCCheckList.getExportHeadTitle();
        SXSSFWorkbook wb = new SXSSFWorkbook(-1);
        Object exportDetail = null;
        ArrayList exportEntitySheet2 = new ArrayList(selectedData.length);
        for (DynamicObject dyObj : selectedData) {
            Set<Long> idSet = this.getCheckedFilter(dyObj);
            for (Long id : idSet) {
                DynamicObject dyObj1 = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_checkedresult");
                DynamicObjectCollection dynamicObjectCollection = dyObj1.getDynamicObjectCollection("entry");
                LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(exportFieldSheet1.length);
                int amtPrecision = 0;
                String[] stringArray = exportFieldSheet1;
                int n = stringArray.length;
                block27: for (int i = 0; i < n; ++i) {
                    String str;
                    switch (str = stringArray[i]) {
                        case "accountbank": {
                            DynamicObject tempDyn;
                            if (dyObj1.getDynamicObject("accountbank") == null || (tempDyn = BusinessDataServiceHelper.loadSingle((Object)dyObj1.getDynamicObject("accountbank").getPkValue(), (String)"bd_accountbanks")).get("bank.bank_cate") == null) continue block27;
                            details.put(str, ((OrmLocaleValue)tempDyn.get("bank.bank_cate.name")).getLocaleValue());
                            continue block27;
                        }
                        case "currency": {
                            if (dyObj1.getDynamicObject("currency") == null) continue block27;
                            details.put(str, dyObj1.getString("currency.name"));
                            DynamicObject currency = dyObj1.getDynamicObject("currency");
                            amtPrecision = currency.getInt("amtprecision");
                            continue block27;
                        }
                        case "checktype": {
                            String tempStr = dyObj1.getString("checktype");
                            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)"byauto")) {
                                tempStr = ResManager.loadKDString((String)"\u81ea\u52a8\u5bf9\u8d26", (String)"CheckResultPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                            } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)"byhand")) {
                                tempStr = ResManager.loadKDString((String)"\u624b\u5de5\u5bf9\u8d26", (String)"CheckResultPlugin_20", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                            }
                            details.put(str, tempStr);
                            continue block27;
                        }
                        default: {
                            details.put(str, dyObj1.get(str));
                        }
                    }
                }
                Object res = null;
                for (DynamicObject dyObj2 : dynamicObjectCollection) {
                    LinkedHashMap details1 = new LinkedHashMap(exportFieldSheet2.length);
                    int count = 0;
                    for (Map.Entry entry : details.entrySet()) {
                        if (count++ > 7) break;
                        details1.put(entry.getKey(), entry.getValue());
                    }
                    String tempStr = "";
                    block30: for (int i = 8; i < exportFieldSheet2.length; ++i) {
                        String str = exportFieldSheet2[i];
                        try {
                            res = dyObj2.get(str);
                        }
                        catch (ORMDesignException e) {
                            res = null;
                            logger.error((Throwable)e);
                        }
                        switch (str) {
                            case "bizobject": {
                                if (res == null) {
                                    details1.put(str, null);
                                    continue block30;
                                }
                                tempStr = res.toString();
                                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)"cas_bankstatement")) {
                                    tempStr = ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355", (String)"CheckResultPlugin_21", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                                } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)"cas_bankjournal")) {
                                    tempStr = ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26", (String)"CheckResultPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                                }
                                details1.put(str, tempStr);
                                continue block30;
                            }
                            case "source": {
                                if (res == null) {
                                    details1.put(str, null);
                                    continue block30;
                                }
                                tempStr = res.toString();
                                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.BNKK_TRANSDOWNLOAD.getValue())) {
                                    details1.put(str, CheckedResultSourceEnum.BNKK_TRANSDOWNLOAD.getName());
                                    continue block30;
                                }
                                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.INNER_FIN_DOWNLOAD.getValue())) {
                                    details1.put(str, CheckedResultSourceEnum.INNER_FIN_DOWNLOAD.getName());
                                    continue block30;
                                }
                                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.INTRODUCE_BYHAND.getValue())) {
                                    details1.put(str, CheckedResultSourceEnum.INTRODUCE_BYHAND.getName());
                                    continue block30;
                                }
                                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.ADD_BYHAND.getValue())) {
                                    details1.put(str, CheckedResultSourceEnum.ADD_BYHAND.getName());
                                    continue block30;
                                }
                                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.ENTER_BYHAND.getValue())) {
                                    details1.put(str, CheckedResultSourceEnum.ENTER_BYHAND.getName());
                                    continue block30;
                                }
                                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.BILL_PRODUCE.getValue())) {
                                    details1.put(str, CheckedResultSourceEnum.BILL_PRODUCE.getName());
                                    continue block30;
                                }
                                if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.STANDARD_IMPORT.getValue())) {
                                    details1.put(str, CheckedResultSourceEnum.STANDARD_IMPORT.getName());
                                    continue block30;
                                }
                                if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tempStr, (CharSequence)CheckedResultSourceEnum.VOUCHER_ACCOUNT.getValue())) continue block30;
                                details1.put(str, CheckedResultSourceEnum.VOUCHER_ACCOUNT.getName());
                                continue block30;
                            }
                            case "matchcode": {
                                details1.put(str, dyObj1.getLong("id") + "");
                                continue block30;
                            }
                            default: {
                                details1.put(str, res);
                            }
                        }
                    }
                    details1.put("amtprecision", amtPrecision);
                    exportEntitySheet2.add(details1);
                }
            }
        }
        String fileUrl = null;
        CreateExcelUtil.createExcelFile((SXSSFWorkbook)wb, (String)ResManager.loadKDString((String)"\u5df2\u5bf9\u8d26\u7ed3\u679c", (String)"CheckResultPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]), (String[])exportTitleSheet2, exportEntitySheet2);
        try {
            String excelName = ResManager.loadKDString((String)"\u5df2\u5bf9\u8d26\u7ed3\u679c", (String)"CheckResultPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            excelName = CreateExcelUtil.getTempFilename1((String)excelName);
            fileUrl = CreateExcelUtil.writeFile((SXSSFWorkbook)wb, (String)excelName);
        }
        catch (KDException e) {
            logger.error((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        this.getView().download(fileUrl);
    }

    private Set<Long> getCheckedFilter(DynamicObject dyObj) {
        long orgId;
        List useCompanies;
        DynamicObject org = dyObj.getDynamicObject("org");
        DynamicObject accountBank = dyObj.getDynamicObject("accountbank");
        DynamicObject currency = dyObj.getDynamicObject("currency");
        QFilter filter = new QFilter("accountbank", "=", (Object)accountBank.getLong("id"));
        filter = currency != null ? filter.and("currency", "=", (Object)currency.getLong("id")) : filter.and("currency", "=", (Object)0);
        String endDateStr = this.getPageCache().get("endDate");
        String beginDateStr = this.getPageCache().get("beginDate");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)endDateStr) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)beginDateStr)) {
            Date end = DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
            Date begin = DateUtils.stringToDate((String)beginDateStr, (String)"yyyy-MM-dd HH:mm:ss");
            filter = filter.and("entry.bizdate", ">=", (Object)begin);
            filter = filter.and("entry.bizdate", "<=", (Object)end);
        }
        if (!(useCompanies = AccountBankHelper.getUseCompanies((long)((Long)accountBank.getPkValue()))).contains(orgId = org.getLong("id"))) {
            filter = filter.and("entry.org", "=", (Object)orgId);
        }
        logger.info("filter:{}", (Object)filter);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cas_checkedresult", (String)"id", (QFilter[])filter.toArray());
        HashSet<Long> idSet = new HashSet<Long>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            idSet.add(((DynamicObject)coll.get(i)).getLong("id"));
        }
        return idSet;
    }

    private DynamicObject[] getSelectedData() {
        List<Long> idList = this.getSelectedIdList();
        if (idList == null || idList.size() == 0) {
            return null;
        }
        return BusinessDataServiceHelper.load((String)"cas_bankvccheck", (String)"org,accountbank,currency,verifystatus,bizdate,bizdateend,bankcgsetting", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
    }

    @Override
    protected String getAcctEntity() {
        return "bd_accountbanks";
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        args.setListDataProvider((IListDataProvider)new BankVCCheckListProvider(appId));
    }

    public void billRefresh() {
        this.getPageCache().put("isfirst", null);
        this.getView().invokeOperation("refresh");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("verifystatus".equals(fieldName)) {
            boolean isCanCheck;
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Object pkId = billList.getFocusRowPkId();
            DynamicObject obj = null;
            DynamicObject[] bankChecks = BusinessDataServiceHelper.load((String)"cas_bankvccheck", (String)"id,org,accountbank,currency,bizdate,bizdateend,verifystatus", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            if (bankChecks != null && bankChecks.length > 0) {
                obj = bankChecks[0];
            }
            if (obj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u5df2\u81ea\u52a8\u5237\u65b0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BankVCCheckList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                this.billRefresh();
                return;
            }
            DynamicObject org = obj.getDynamicObject("org");
            boolean authorityAccount = AccountBankHelper.isAuthorityAccount((DynamicObject)obj.getDynamicObject("accountbank"), (DynamicObject)org);
            if (!authorityAccount && !(isCanCheck = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"cs099"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u6237\u4f7f\u7528\u6743\u7ec4\u7ec7\u4e0d\u652f\u6301\u5bf9\u8d26\uff0c\u8bf7\u524d\u5f80\u914d\u7f6e\u5de5\u5177\u4e2d\u8c03\u6574\u53c2\u6570\u914d\u7f6e\u3002", (String)"BankVCCheckList_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            boolean hasPermission = PermissionHelper.checkCurrentUserPermission((String)appId, (long)org.getLong("id"), (String)"cas_bankvccheck", (String)"4730fc9f000008ae");
            if (hasPermission) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("cas_checkresult");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("tabap");
                parameter.setCustomParam("orgid", (Object)obj.getLong("org.id"));
                parameter.setCustomParam("accountbankid", (Object)obj.getLong("accountbank.id"));
                parameter.setCustomParam("currencyid", (Object)obj.getLong("currency.id"));
                parameter.setCustomParam("bizdate", (Object)this.getStartDate());
                parameter.setCustomParam("bizdateend", (Object)this.getEndDate());
                parameter.setCustomParam("verifystatus", (Object)obj.getBoolean("verifystatus"));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "checkresultclose"));
                this.getView().showForm(parameter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u201d\u7684\u201c\u5bf9\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BankVCCheckList_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if ("baladjust".equals(fieldName)) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Object pkId = billList.getFocusRowPkId();
            DynamicObject obj = null;
            DynamicObject[] bankChecks = BusinessDataServiceHelper.load((String)"cas_bankvccheck", (String)"id,baladjust,org", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            if (bankChecks != null && bankChecks.length > 0) {
                obj = bankChecks[0];
            }
            if (obj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u5df2\u81ea\u52a8\u5237\u65b0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BankVCCheckList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                this.billRefresh();
                return;
            }
            DynamicObject org = obj.getDynamicObject("org");
            String appId = this.getView().getFormShowParameter().getAppId();
            boolean hasPermission = PermissionHelper.checkCurrentUserPermission((String)appId, (long)org.getLong("id"), (String)"cas_balanceadjust", (String)"47150e89000000ac");
            if (hasPermission) {
                DynamicObject balanceAjust = null;
                DynamicObject[] balances = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)obj.getString("baladjust"))});
                if (balances != null && balances.length > 0) {
                    balanceAjust = balances[0];
                }
                if (balanceAjust == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u5df2\u81ea\u52a8\u5237\u65b0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BankVCCheckList_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    this.billRefresh();
                    return;
                }
                String billstatus = balanceAjust.getString("billstatus");
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("cas_balanceadjust");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setPkId(balanceAjust.getPkValue());
                if (BillStatusEnum.SUBMIT.getValue().equals(billstatus) || BillStatusEnum.AUDIT.getValue().equals(billstatus)) {
                    parameter.setStatus(OperationStatus.VIEW);
                }
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u7ec4\u7ec7\u4f59\u989d\u8c03\u8282\u8868\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u4e0d\u80fd\u6253\u5f00\u94fe\u63a5\u3002", (String)"BankVCCheckList_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.getPageCache().put(CACHE_KEY_ACCOUNTS, null);
        this.getPageCache().put(CACHE_KEY_ACCT_CRY, null);
        this.getPageCache().put(CACHE_KEY_HISTORY_JOURNAL, null);
        this.getPageCache().put(CACHE_KEY_HISTORY_STATEMENT, null);
        this.getPageCache().put("isfirst", null);
        String orgIdsStr = this.getPageCache().get("selectedOrgIdList");
        if ("[\"\"]".equals(orgIdsStr) || EmptyUtil.isEmpty((String)orgIdsStr)) {
            ListShowParameter listParam = (ListShowParameter)this.getView().getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            List orgIds = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)listParam.getBillFormId(), (String)"47150e89000000ac");
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString((Object)orgIds));
        }
    }

    @Override
    protected void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        if (null == this.getCachedOrgList()) {
            String firstOrgId = null;
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if (!"org.id".equals(filterColumn.getFieldName())) continue;
                List defaultValues = filterColumn.getDefaultValues();
                if (null != defaultValues && defaultValues.size() > 0) {
                    this.selectedOrgIdList = defaultValues.stream().filter(t -> kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)t.toString())).map(item -> item.toString()).collect(Collectors.toList());
                }
                if (this.selectedOrgIdList == null || this.selectedOrgIdList.size() == 0) {
                    this.selectedOrgIdList = new ArrayList();
                    String loginOrg = String.valueOf(RequestContext.get().getOrgId());
                    CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                    List orgItems = commonFilterColumn.getComboItems();
                    Optional<ComboItem> any = orgItems.stream().filter(item -> item.getValue().equals(loginOrg)).findFirst();
                    if (any.isPresent()) {
                        firstOrgId = any.get().getValue();
                    } else if (orgItems.size() > 0) {
                        firstOrgId = ((ComboItem)orgItems.get(0)).getValue();
                    }
                    if (firstOrgId != null) {
                        this.selectedOrgIdList.add(firstOrgId);
                        this.getPageCache().put("org.id", firstOrgId);
                    }
                }
                this.cacheSelectedOrgIdList(this.selectedOrgIdList);
                break;
            }
        }
    }

    @Override
    protected void initFilterItems(FilterContainerInitArgs args) {
        if (this.selectedOrgIdList.size() < 1) {
            this.selectedOrgIdList.addAll(this.getAllOrgIdList(args));
        }
        this.acctsShow = this.getAcctsShowByOrg(this.selectedOrgIdList);
        List<ComboItem> acctItems = this.getAcctItems();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List listComboItem;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"accountbank.acctstatus".equals(fieldName) && this.isBankAccountFilterColumn(fieldName)) {
                listComboItem = commonFilterColumn.getComboItems();
                listComboItem.clear();
                commonFilterColumn.setComboItems(acctItems);
                commonFilterColumn.setDefValue("");
                continue;
            }
            if (fieldName.startsWith("accountcash.")) {
                listComboItem = commonFilterColumn.getComboItems();
                listComboItem.clear();
                commonFilterColumn.setComboItems(acctItems);
                commonFilterColumn.setDefValue("");
                continue;
            }
            if (!fieldName.startsWith("currency.")) continue;
            List<ComboItem> currencyItems = this.getCurrencyItems();
            List listComboItem2 = commonFilterColumn.getComboItems();
            listComboItem2.clear();
            commonFilterColumn.setComboItems(currencyItems);
            commonFilterColumn.setDefValue("");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        OperationResult result = args.getOperationResult();
        switch (operateKey) {
            case "autocheck": {
                this.doResultOp(result);
                break;
            }
            case "viewadjust": {
                if (!result.isSuccess() && result.getValidateResult().errorSize() != 0) break;
                args.getOperationResult().setShowMessage(false);
                this.viewAdjust();
                break;
            }
            case "balanceadjust": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refreshData();
                break;
            }
        }
    }

    private Boolean isCreateAdjustBalance(DynamicObject bankVc) {
        DynamicObject startPeriod;
        Date startPeriodBegin;
        DynamicObject org = bankVc.getDynamicObject("org");
        QFilter filterRecEdc = new QFilter("org", "=", org.getPkValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{filterRecEdc});
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s):\u6240\u9009\u8d44\u91d1\u7ec4\u7ec7\u672a\u542f\u7528\u5bf9\u8d26\uff0c\u65e0\u9700\u9884\u89c8\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVCCheckList_24", (String)"fi-cas-formplugin", (Object[])new Object[0]), bankVc.getDynamicObject("accountbank").getString("number"), bankVc.getDynamicObject("currency").getString("name"));
            this.getView().showErrorNotification(msg);
            return false;
        }
        String endDateStr = this.getPageCache().get("endDate");
        Date dateEnd = DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        if (dateEnd.compareTo(startPeriodBegin = (startPeriod = dynamicObject.getDynamicObject("recperiod")).getDate("begindate")) < 0) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s):\u6240\u9009\u8d44\u91d1\u7ec4\u7ec7\u5f53\u524d\u7ed3\u675f\u65e5\u671f\u65e9\u4e8e\u542f\u7528\u5bf9\u8d26\u671f\u95f4\u7b2c\u4e00\u65e5\uff0c\u65e0\u9700\u9884\u89c8\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVCCheckList_25", (String)"fi-cas-formplugin", (Object[])new Object[0]), bankVc.getDynamicObject("accountbank").getString("number"), bankVc.getDynamicObject("currency").getString("name"));
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    private void viewAdjust() {
        DynamicObject[] selectedData = this.getSelectedData();
        if (selectedData == null || selectedData.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u3002", (String)"BankVCCheckList_5_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        DynamicObject bankVc = selectedData[0];
        DynamicObject org = bankVc.getDynamicObject("org");
        DynamicObject accountBank = bankVc.getDynamicObject("accountbank");
        if (!AccountBankHelper.isAuthorityAccount((DynamicObject)accountBank, (DynamicObject)org)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u662f\u8d26\u6237\u201c%2$s\u201d\u7684\u7ba1\u7406\u6743\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u9884\u89c8\u8d26\u6237\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVCCheckList_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), bankVc.getDynamicObject("org").getString("name"), bankVc.getDynamicObject("accountbank").getString("bankaccountnumber")), Integer.valueOf(10000));
            return;
        }
        String endDateStr = this.getPageCache().get("endDate");
        if (CasHelper.isEmpty((Object)endDateStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u622a\u6b62\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"BankVCCheckList_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (!this.isCreateAdjustBalance(bankVc).booleanValue()) {
            return;
        }
        Date endDate = DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("cas_balanceadjust");
        parameter.setCustomParam("org", (Object)org.getLong("id"));
        parameter.setCustomParam("accountbank", (Object)accountBank.getLong("id"));
        parameter.setCustomParam("currency", (Object)bankVc.getDynamicObject("currency").getLong("id"));
        parameter.setCustomParam("enddate", (Object)DateUtils.getBeforeDate((Date)endDate, (Date)new Date()));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public static String decodeMultiErrorMsg(OperationResult operationResult) {
        List uniqueErrorInfos = operationResult.getAllErrorOrValidateInfo().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<IOperateInfo>(Comparator.comparing(IOperateInfo::getMessage))), ArrayList::new));
        StringBuilder buf = new StringBuilder();
        int len = uniqueErrorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)uniqueErrorInfos.get(i)).getMessage());
        }
        String result = buf.toString();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)result)) {
            result = ResManager.loadKDString((String)"\u65e0\u81ea\u52a8\u5bf9\u8d26\u7ed3\u679c\u3002\u53ef\u80fd\u662f\u5df2\u914d\u7f6e\u7684\u5bf9\u8d26\u89c4\u5219\u4e0d\u9002\u7528\uff0c\u6216\u8005\u6ca1\u6709\u627e\u5230\u7b26\u5408\u81ea\u52a8\u5bf9\u8d26\u89c4\u5219\u7684\u6570\u636e\u3002", (String)"BankVCCheckList_17", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        return result;
    }

    protected List<Long> getSelectedIdList() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Long> idList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow listSelectedRowValue : selectedRows) {
            idList.add((Long)listSelectedRowValue.getPrimaryKeyValue());
        }
        return idList;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("checkresultclose".equalsIgnoreCase(e.getActionId())) {
            this.billRefresh();
        }
    }

    private Map<String, BigDecimal> getAccountBalance(DynamicObject[] datas, Date endDate) {
        if (datas == null || datas.length == 0) {
            return null;
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (DynamicObject data : datas) {
            DynamicObject accountBank = data.getDynamicObject("accountbank");
            DynamicObject currency = data.getDynamicObject("currency");
            if (accountBank == null || currency == null) continue;
            long accountBankId = accountBank.getLong("id");
            long currencyId = currency.getLong("id");
            String acKey = String.valueOf(accountBankId) + '-' + currencyId;
            BigDecimal bankBalance = this.balanceCountService.getJournalBalanceByAccount(Long.valueOf(accountBankId), Long.valueOf(currencyId), endDate);
            map.put(acKey, bankBalance);
        }
        return map;
    }

    private Map<Long, DynamicObject> getOrgPeriod() {
        List orgIds = new ArrayList(16);
        if (EmptyUtil.isNoEmpty((String)this.getPageCache().get("selectedOrgIdList"))) {
            orgIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
        }
        HashSet<Long> orgSet = new HashSet<Long>(orgIds.size());
        for (Object orgId : orgIds) {
            if (!EmptyUtil.isNoEmpty(orgId) || !EmptyUtil.isNoEmpty((String)orgId.toString())) continue;
            orgSet.add(Long.valueOf(orgId.toString()));
        }
        HashMap<Long, DynamicObject> orgPeriod = new HashMap(16);
        try {
            orgPeriod = this.resetStatement(orgSet);
            logger.info("====BankVCCHeckList==org period size:{} orgIds:{} periodIds:{}", new Object[]{orgPeriod.size(), orgPeriod.keySet(), orgPeriod.values().stream().map(DataEntityBase::getPkValue)});
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
        }
        return orgPeriod;
    }

    private Map<Long, DynamicObject> resetStatement(Set<Long> orgIds) {
        DynamicObject[] casRecInit;
        DynamicObject[] initStates;
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(64);
        if (orgIds.size() == 0) {
            return result;
        }
        HashMap<Long, DynamicObject> orgPeriods = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject initState : initStates = BusinessDataServiceHelper.load((String)"cas_rec_edc", (String)"org, recperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)})) {
            DynamicObject org = initState.getDynamicObject("org");
            Long orgId = org.getLong("id");
            DynamicObject recPeriod = initState.getDynamicObject("recperiod");
            orgPeriods.put(orgId, recPeriod);
        }
        if (orgPeriods.size() == 0) {
            return result;
        }
        for (DynamicObject row : casRecInit = BusinessDataServiceHelper.load((String)"cas_rec_init", (String)"id, org, billno,initperiod, currentperiod,isfinishinit, modifytime, entrybank, entrybank.bank_accountbank, entrybank.bank_currency, entrybank.bank_openorg, entrybank.bank_statementbalance", (QFilter[])new QFilter[]{new QFilter("org", "in", orgPeriods.keySet()), new QFilter("isfinishinit", "=", (Object)"1")})) {
            Long periodId;
            DynamicObject org = row.getDynamicObject("org");
            Long orgId = org.getLong("id");
            Long initPeriodId = row.getDynamicObject("initperiod").getLong("id");
            DynamicObject period = (DynamicObject)orgPeriods.get(orgId);
            if (period == null || EmptyUtil.isEmpty((DynamicObject)period) || (periodId = Long.valueOf(period.getLong("id"))).compareTo(initPeriodId) != 0) continue;
            result.put(orgId, period);
        }
        return result;
    }

    private Date getStartDate() {
        String startDateStr = this.getPageCache().get("beginDate");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)startDateStr)) {
            return DateUtils.getLastDay((Date)this.getEndDate(), (int)1);
        }
        return DateUtils.stringToDate((String)startDateStr, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private Date getEndDate() {
        Date endDate = null;
        String endDateStr = this.getPageCache().get("endDate");
        endDate = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)endDateStr) ? new Date() : DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        return endDate;
    }

    private Map<String, BigDecimal> queryByBalanceModel_new(BalanceType balanceType, DynamicObject[] datas, Date startDate, Date endDate) {
        HashSet<Long> orgIds = new HashSet<Long>(datas.length);
        HashSet<Long> acctIds = new HashSet<Long>(datas.length);
        HashSet<Long> currencyIds = new HashSet<Long>(datas.length);
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>(datas.length);
        for (DynamicObject data : datas) {
            boolean isRecInit;
            DynamicObject org = data.getDynamicObject("org");
            DynamicObject accountBank = data.getDynamicObject("accountbank");
            DynamicObject currency = data.getDynamicObject("currency");
            if (EmptyUtil.isEmpty((DynamicObject)org) || EmptyUtil.isEmpty((DynamicObject)accountBank) || EmptyUtil.isEmpty((DynamicObject)currency)) continue;
            long acctId = accountBank.getLong("id");
            if (BalanceType.STATE.getValue().equals(balanceType.getValue()) && !(isRecInit = BalanceAccHelper.validateRecInit((Long)acctId, (Date)endDate).booleanValue())) continue;
            orgIds.add(org.getLong("id"));
            acctIds.add(acctId);
            currencyIds.add(currency.getLong("id"));
        }
        RequestBalanceParameter param = new RequestBalanceParameter();
        param.setOrgIds(orgIds);
        param.setAccountIds(acctIds);
        param.setCurrencyIds(currencyIds);
        param.setStartDate(startDate);
        param.setEndDate(DateUtils.getDataFormat((Date)endDate, (boolean)false));
        param.setType(balanceType.getValue());
        if (orgIds.size() == 0) {
            return balanceMap;
        }
        try {
            List monthBalances = BalanceDataService.getInstance().getBalances(Collections.singletonList(param), BalanceQueryType.ENDDATE);
            for (ResponseBalances monthBalance : monthBalances) {
                Long acctId = monthBalance.getAccountId();
                Long curId = monthBalance.getCurrencyId();
                BigDecimal balanceAmt = monthBalance.getBalance().getMonthStart();
                String balanceKey = acctId + "-" + curId;
                BigDecimal balance = (BigDecimal)balanceMap.get(balanceKey);
                if (balance == null) {
                    balance = BigDecimal.ZERO;
                }
                balance = balance.add(balanceAmt);
                balanceMap.put(balanceKey, balance);
            }
        }
        catch (Exception e) {
            logger.error("--->>> BankVCCheckList.queryByBalanceModel(),to getMonthBalances(),error:", (Throwable)e);
        }
        return balanceMap;
    }

    private void doResultOp(OperationResult result) {
        if (result.isSuccess() || result.getValidateResult().errorSize() == 0) {
            int count = result.getBillCount();
            result.setShowMessage(false);
            List successPkIds = result.getSuccessPkIds();
            successPkIds.removeAll(this.getSelectedIdList());
            List uniqueErrorInfos = result.getAllErrorOrValidateInfo().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<IOperateInfo>(Comparator.comparing(IOperateInfo::getMessage))), ArrayList::new));
            if (count == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u81ea\u52a8\u5bf9\u8d26\u7ed3\u679c\u3002\u53ef\u80fd\u662f\u5df2\u914d\u7f6e\u7684\u5bf9\u8d26\u89c4\u5219\u4e0d\u9002\u7528\uff0c\u6216\u8005\u6ca1\u6709\u627e\u5230\u7b26\u5408\u81ea\u52a8\u5bf9\u8d26\u89c4\u5219\u7684\u6570\u636e\u3002", (String)"BankVCCheckList_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
                return;
            }
            if (!successPkIds.isEmpty()) {
                String tips = String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u5bf9\u8d26\u6210\u529f\uff0c\u5df2\u52fe\u5bf9%s\u6761\u6570\u636e\u3002", (String)"BankVCCheckList_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), successPkIds.size());
                this.getView().showSuccessNotification(tips, Integer.valueOf(6000));
            } else if (successPkIds.isEmpty() && uniqueErrorInfos.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u81ea\u52a8\u5bf9\u8d26\u7ed3\u679c\u3002\u53ef\u80fd\u662f\u5df2\u914d\u7f6e\u7684\u5bf9\u8d26\u89c4\u5219\u4e0d\u9002\u7528\uff0c\u6216\u8005\u6ca1\u6709\u627e\u5230\u7b26\u5408\u81ea\u52a8\u5bf9\u8d26\u89c4\u5219\u7684\u6570\u636e\u3002", (String)"BankVCCheckList_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
            } else {
                this.getView().showTipNotification(BankVCCheckList.decodeMultiErrorMsg(result), Integer.valueOf(6000));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if ("CONFIRM_VIEW_ADJUST_CALLBACK".equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            this.viewAdjust();
        }
    }

    private Map<String, Long> getOrgBeginDate(DynamicObject[] datas) {
        HashMap<String, Long> orgBeginDateMap = new HashMap<String, Long>(16);
        if (datas != null) {
            DynamicObject[] casHmgtInit;
            Set orgList = Arrays.stream(datas).map(d -> (Long)d.getDynamicObject("org").getPkValue()).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("isfinishinit", "=", (Object)"1");
            qFilter.and("org", "in", orgList);
            for (DynamicObject casInit : casHmgtInit = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,currentperiod", (QFilter[])new QFilter[]{qFilter})) {
                DynamicObject currentPeriod = casInit.getDynamicObject("currentperiod");
                if (currentPeriod == null) continue;
                Long beginDate = currentPeriod.getDate("begindate").getTime();
                orgBeginDateMap.put(String.valueOf(casInit.getDynamicObject("org").getLong("id")), beginDate);
            }
        }
        return orgBeginDateMap;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        String refEntityId = args.getRefEntityId();
        if ("bd_accountbanks".equals(refEntityId) || "cas_accountcash".equals(refEntityId)) {
            String orgIdsStr = this.getPageCache().get("selectedOrgIdList");
            if (orgIdsStr != null && !"[\"\"]".equals(orgIdsStr) && "id".equals(args.getRefPropKey())) {
                List orgIds = (List)SerializationUtils.fromJsonString((String)orgIdsStr, List.class);
                List orgIdList = orgIds.stream().map(orgId -> Long.parseLong(orgId.toString())).collect(Collectors.toList());
                args.getQfilters().add(new QFilter("org", "in", orgIdList));
            } else {
                ListShowParameter listParam = (ListShowParameter)this.getView().getFormShowParameter();
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                List orgIds = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)listParam.getBillFormId(), (String)"47150e89000000ac");
                if ("id".equals(args.getRefPropKey())) {
                    args.getQfilters().add(new QFilter("org", "in", (Object)orgIds));
                } else {
                    String sql = "select fdataid from t_bd_accountbanks_U where fuseorgid in (" + StringUtils.join((Object[])orgIds.toArray(), (String)",") + ");";
                    List dataIdList = (List)DB.query((DBRoute)SYS, (String)sql, resultSet -> {
                        ArrayList<Long> haveCount = new ArrayList<Long>(100);
                        while (resultSet.next()) {
                            haveCount.add(resultSet.getLong(1));
                        }
                        return haveCount;
                    });
                    QFilter filter = new QFilter("id", "in", (Object)dataIdList);
                    args.getQfilters().add(filter);
                }
            }
        }
        if (kd.bos.dataentity.utils.StringUtils.startsWith((CharSequence)(fieldName = args.getFieldName()), (CharSequence)"accountbank")) {
            args.getQfilters().add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        }
    }

    class BankVCCheckListProvider
    extends BeforeQueryListDataProvider {
        private int tempStart = 0;
        private String appId = "cas";
        private Map<Long, DynamicObject> orgPeriod = new HashMap<Long, DynamicObject>(16);

        BankVCCheckListProvider(String appId) {
            this.appId = appId;
        }

        @Override
        public DynamicObjectCollection getData(int start, int limit) {
            String hisJalStr = BankVCCheckList.this.getPageCache().get(BankVCCheckList.CACHE_KEY_HISTORY_JOURNAL);
            Map hisJarMap = EmptyUtil.isEmpty((String)hisJalStr) ? new HashMap() : (Map)SerializeUtils.fromJsonString((String)hisJalStr, Map.class);
            this.orgPeriod = BankVCCheckList.this.getOrgPeriod();
            String hisSatStr = BankVCCheckList.this.getPageCache().get(BankVCCheckList.CACHE_KEY_HISTORY_STATEMENT);
            Map<String, String> hisSatMap = EmptyUtil.isEmpty((String)hisSatStr) ? new HashMap() : (Map)SerializeUtils.fromJsonString((String)hisSatStr, Map.class);
            this.tempStart = start;
            List filterList = this.getQFilters();
            ArrayList<QFilter> filterListNew = new ArrayList<QFilter>();
            if (filterList != null && !filterList.isEmpty()) {
                for (QFilter singleFilter : filterList) {
                    String property = singleFilter.getProperty();
                    if (property.startsWith("accountbank.bankaccountnumber") || property.startsWith("accountbank.bank.name") || property.startsWith("accountbank.name") || property.startsWith("currency.name") || property.startsWith("org.number")) continue;
                    filterListNew.add(singleFilter);
                }
            }
            super.setFilterList(filterListNew);
            super.setClazzName("BankVCCheckList");
            DynamicObjectCollection data = super.getData(start, limit);
            if (data == null || data.size() == 0) {
                return data;
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            HashMap<String, Map<String, Object>> updateMap = new HashMap<String, Map<String, Object>>(64);
            Date endDate = BankVCCheckList.this.getEndDate();
            Date beginDate = BankVCCheckList.this.getStartDate();
            HashSet<Long> accountIds = new HashSet<Long>();
            data.parallelStream().forEach(o -> {
                if (o.containsProperty("accountbank")) {
                    DynamicObject accountBank = o.getDynamicObject("accountbank");
                    if (EmptyUtil.isNoEmpty((DynamicObject)accountBank)) {
                        accountIds.add(accountBank.getLong("id"));
                    } else {
                        long accountId = o.getLong("accountbank_id");
                        accountIds.add(accountId);
                    }
                } else if (o.containsProperty("accountbank_id")) {
                    long accountId = o.getLong("accountbank_id");
                    accountIds.add(accountId);
                }
            });
            logger.info("accountIds: " + accountIds + " startDate: " + beginDate + " endDate: " + endDate);
            Iterator iterator = data.iterator();
            HashMap<String, Object> map = new HashMap<String, Object>(64);
            BigDecimal smallAmt = new BigDecimal("0.0000000001");
            Map<String, Object> balanceAdjustMap = this.getBalanceAdjust(accountIds, beginDate, endDate);
            Map<String, String> bankStatementStatusMap = this.getBankStatementStatus(accountIds, endDate);
            Map<String, String> bankJournalStatusMap = this.getBankJournalStatus(accountIds, endDate);
            while (iterator.hasNext()) {
                boolean isZero;
                map = new HashMap(64);
                DynamicObject row = (DynamicObject)iterator.next();
                ids.add(row.getLong("id"));
                DynamicObject currency = row.getDynamicObject("currency");
                if (!row.containsProperty("accountbank")) continue;
                String accountbankId = "";
                if (row.containsProperty("accountbank")) {
                    DynamicObject accountBank = row.getDynamicObject("accountbank");
                    if (EmptyUtil.isNoEmpty((DynamicObject)accountBank)) {
                        Long accountId = accountBank.getLong("id");
                        accountbankId = String.valueOf(accountId);
                    }
                } else if (row.containsProperty("accountbank_id")) {
                    Long accountId = row.getLong("accountbank_id");
                    accountbankId = String.valueOf(accountId);
                }
                if ("".equals(accountbankId)) {
                    logger.info("accountbankId is null::id:{}", (Object)row.getLong("id"));
                    continue;
                }
                if (currency == null) continue;
                DynamicObject org = row.getDynamicObject("org");
                Long orgId = org.getLong("id");
                String currencyid = currency.getString("id");
                String key = accountbankId + '-' + currencyid;
                BigDecimal journalAmt = EmptyUtil.isEmpty((String)((String)hisJarMap.get(key))) ? null : new BigDecimal((String)hisJarMap.get(key));
                boolean bl = isZero = hisJarMap.containsKey(key) && journalAmt == null || journalAmt != null && journalAmt.compareTo(BigDecimal.ZERO) == 0;
                if (isZero) {
                    journalAmt = smallAmt;
                }
                row.set("journalamt", (Object)journalAmt);
                map.put("journalamt", journalAmt);
                BigDecimal statmAmt = EmptyUtil.isEmpty((String)((String)hisSatMap.get(key))) ? null : new BigDecimal((String)hisSatMap.get(key));
                boolean isZero0 = hisSatMap.containsKey(key) && statmAmt == null || statmAmt != null && statmAmt.compareTo(BigDecimal.ZERO) == 0;
                String zeroDesc = "";
                if (isZero0) {
                    zeroDesc = this.getZeroDesc(hisSatMap, accountbankId, currencyid, org.getString("name"));
                    statmAmt = smallAmt;
                }
                row.set("stmtamtdesc", (Object)zeroDesc);
                row.set("stmtamt", (Object)statmAmt);
                map.put("stmtamt", statmAmt);
                map.put("stmtamtdesc", zeroDesc);
                boolean verifyStatus = bankStatementStatusMap.get(key) != null || bankJournalStatusMap.get(key) != null;
                row.set("verifystatus", (Object)this.isVery(orgId, verifyStatus, endDate));
                row.set("adjuststatus", (Object)(null != balanceAdjustMap.get(key) ? 1 : 0));
                row.set("baladjust", balanceAdjustMap.get(key));
                String bizDateKey = key + "-bizdate";
                row.set("bizdate", balanceAdjustMap.get(bizDateKey));
                map.put("bizdate", row.getDate("bizdate"));
                map.put("adjuststatus", row.getBoolean("adjuststatus"));
                map.put("baladjust", row.getString("baladjust"));
                map.put("verifystatus", row.getString("verifystatus"));
                updateMap.put(row.getString("id"), map);
            }
            if (map.size() > 0) {
                this.updateBankVc(ids, updateMap);
            }
            return data;
        }

        private String getZeroDesc(Map<String, String> hisSatMap, String accountBankId, String currencyId, String orgName) {
            String desc = "";
            String key = accountBankId + "-zeroDesc";
            desc = hisSatMap.get(key);
            if (EmptyUtil.isEmpty((String)desc)) {
                key = accountBankId + "-" + currencyId + "-zeroDesc";
                desc = hisSatMap.get(key);
            }
            if ("1".equals(desc)) {
                desc = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355\u4f59\u989d\u4e3a0\u7684\u539f\u56e0\uff1a\u201c%s\u201d\u672a\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u529f\u80fd\u3002", (String)"ZeroDesc_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), orgName);
            } else if ("2".equals(desc)) {
                desc = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355\u4f59\u989d\u4e3a0\u7684\u539f\u56e0\uff1a\u201c%s\u201d\u7684\u5bf9\u8d26\u542f\u7528\u671f\u95f4\u672a\u8fdb\u884c\u5bf9\u8d26\u521d\u59cb\u5316\u6216\u8005\u672a\u7ed3\u675f\u5bf9\u8d26\u521d\u59cb\u5316\u3002", (String)"ZeroDesc_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), orgName);
            } else if ("3".equals(desc)) {
                desc = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355\u4f59\u989d\u4e3a0\u7684\u539f\u56e0\uff1a\u201c%s\u201d\u5f53\u524d\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u672a\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u529f\u80fd\u3002", (String)"ZeroDesc_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), orgName);
            }
            return desc;
        }

        public List<SummaryResult> getSummaryResults() {
            QueryBuilder queryBuilder = super.getQueryBuilder();
            this.getQFilters().removeIf(o -> o.getProperty().equals("bizdate"));
            queryBuilder.setFilters(this.getQFilters().toArray(new QFilter[0]));
            List summaryResults = SumQuery.getSummaryResults((QueryBuilder)queryBuilder);
            return summaryResults;
        }

        private boolean isVery(Long orgId, boolean verifyStatus, Date endDate) {
            if (this.orgPeriod == null) {
                return verifyStatus;
            }
            if (!this.orgPeriod.containsKey(orgId)) {
                return verifyStatus;
            }
            if (!verifyStatus) {
                return verifyStatus;
            }
            DynamicObject period = this.orgPeriod.get(orgId);
            if (period == null || EmptyUtil.isEmpty((DynamicObject)period)) {
                return verifyStatus;
            }
            Date pEndDate = period.getDate("begindate");
            if (endDate.getTime() < pEndDate.getTime()) {
                return false;
            }
            return verifyStatus;
        }

        private void updateBankVc(List<Long> ids, Map<String, Map<String, Object>> updateMap) {
            DynamicObject[] bankVcs;
            QFilter filter = new QFilter("id", "in", ids);
            for (DynamicObject bankVc : bankVcs = BusinessDataServiceHelper.load((String)"cas_bankvccheck", (String)"id,stmtamtdesc,journalamt,stmtamt,adjuststatus,baladjust,bizdate,verifystatus", (QFilter[])new QFilter[]{filter})) {
                String bankVcId = String.valueOf(bankVc.getPkValue());
                Map<String, Object> map = updateMap.get(bankVcId);
                if (map == null) continue;
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    bankVc.set(entry.getKey(), entry.getValue());
                }
            }
            SaveServiceHelper.update((DynamicObject[])bankVcs);
        }

        @Override
        public void before() {
            if (this.tempStart > 0 || BankVCCheckList.this.getPageCache().get("isfirst") != null) {
                return;
            }
            if (BankVCCheckList.this.getPageCache().get("pageId") == null) {
                BankVCCheckList.this.getPageCache().put("pageId", this.pageId);
            }
            super.before();
        }

        @Override
        public void doProcess() {
            if (this.dateFilterEnd != null) {
                BankVCCheckList.this.getPageCache().put("endDate", DateUtils.formatString((Date)this.dateFilterEnd, (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (this.dateFilterBegin != null) {
                BankVCCheckList.this.getPageCache().put("beginDate", DateUtils.formatString((Date)this.dateFilterBegin, (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }

        @Override
        protected List<Long> getOrgIds(QFilter filter) {
            List<Long> orgIds = super.getOrgIds(filter);
            if (orgIds.size() > 0) {
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("isfinishinit", "=", (Object)"1")});
                orgIds.clear();
                orgIds.addAll(OrgHelper.getIdList((DynamicObjectCollection)coll));
            } else {
                Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)this.appId, (String)"cas_bankvccheck", (String)"47150e89000000ac");
                orgIds = new ArrayList<Long>(orgList);
            }
            return orgIds;
        }

        private Map<String, String> getBankStatementStatus(HashSet<Long> accountBankIdList, Date endDate) {
            HashMap<String, String> map = new HashMap<String, String>();
            Date nextDay = DateUtils.getNextDay((Date)DateUtils.truncateDate((Date)endDate), (int)1);
            QFilter filter = new QFilter("accountbank", "in", accountBankIdList).and(new QFilter("ischeck", "=", (Object)"0")).and(new QFilter("bizdate", "<", (Object)nextDay)).and(new QFilter("isbank", "=", (Object)"1")).and(new QFilter("isvalid", "=", (Object)"1"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getBankStatementStatus", (String)"cas_bankstatement", (String)"accountbank,currency", (QFilter[])filter.toArray(), null);){
                for (Row row : dataSet) {
                    String key = row.getString("accountbank") + '-' + row.getString("currency");
                    map.put(key, "true");
                }
            }
            return map;
        }

        private Map<String, String> getBankJournalStatus(HashSet<Long> accountBankIdList, Date endDate) {
            HashMap<String, String> map = new HashMap<String, String>();
            Date nextDay = DateUtils.getNextDay((Date)DateUtils.truncateDate((Date)endDate), (int)1);
            QFilter filter = new QFilter("accountbank", "in", accountBankIdList).and(new QFilter("ischeck", "=", (Object)"0")).and(new QFilter("bookdate", "<", (Object)nextDay)).and(new QFilter("isvalid", "=", (Object)"1"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getBankJournalStatus", (String)"cas_bankjournal", (String)"accountbank,currency", (QFilter[])filter.toArray(), null);){
                for (Row row : dataSet) {
                    String key = row.getString("accountbank") + '-' + row.getString("currency");
                    map.put(key, "true");
                }
            }
            return map;
        }

        private Map<String, Object> getBalanceAdjust(HashSet<Long> accountBankIdList, Date beginDate, Date endDate) {
            QFilter qFilter = new QFilter("bankaccount", "in", accountBankIdList);
            Date eDate = DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)endDate, (int)1), (boolean)true);
            qFilter.and(new QFilter("bizdate", "<", (Object)eDate).and("bizdate", ">=", (Object)beginDate)).and(new QFilter("period", "!=", (Object)0));
            DynamicObjectCollection dataSet = QueryServiceHelper.query((String)"cas_balanceadjust", (String)"bankaccount,currency,billno,bizdate", (QFilter[])qFilter.toArray(), (String)"bizdate desc");
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (dataSet != null && dataSet.size() > 0) {
                Map<String, List<DynamicObject>> groupDataSet = dataSet.stream().collect(Collectors.groupingBy(o -> o.getString("bankaccount") + '-' + o.getString("currency")));
                groupDataSet.forEach((key, value) -> {
                    map.put((String)key, ((DynamicObject)value.get(0)).getString("billno"));
                    String bizDateKey = key + "-bizdate";
                    map.put(bizDateKey, ((DynamicObject)value.get(0)).getDate("bizdate"));
                });
            }
            return map;
        }
    }
}

