/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.TmcAppCache;
import kd.fi.cas.util.DateUtils;

public abstract class BeforeQueryListDataProvider
extends ListDataProvider {
    private static final Log logger = LogFactory.getLog(BeforeQueryListDataProvider.class);
    protected IAppCache iAppCache = TmcAppCache.get((String)"cas", (String)"listquery", (String)"query");
    protected String pageId;
    protected QFilter dateFilter = null;
    protected Date dateFilterBegin;
    protected Date dateFilterEnd;
    private List<QFilter> filterList;
    private String clazzName = "";

    public List<QFilter> getFilterList() {
        if (this.filterList == null) {
            this.filterList = this.getQFilters();
        }
        return this.filterList;
    }

    public void setFilterList(List<QFilter> filterList) {
        this.filterList = filterList;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        this.pageId = PageRowCacheUtils.getPageId();
        String cacheId = (String)this.iAppCache.get(this.pageId, String.class);
        if (!StringUtils.isNotEmpty((CharSequence)cacheId) || cacheId.startsWith("onlyonepage_")) {
            this.prepareShowData();
        }
        if ("BankVCCheckList".equals(this.clazzName)) {
            this.getQFilters().removeIf(o -> o.getProperty().equals("bizdate"));
        }
        return super.getData(start, limit);
    }

    private void prepareShowData() {
        this.before();
        this.doProcess();
        this.after();
    }

    protected void before() {
        List<QFilter> filter = this.getFilterList();
        QFilter orgFilter = null;
        QFilter acctFilter = null;
        QFilter currencyFilter = null;
        QFilter periodFilter = null;
        int dateIndex = -1;
        if (filter != null && !filter.isEmpty()) {
            for (int i = 0; i < filter.size(); ++i) {
                List qFilterNestList = filter.get(i).getNests(true);
                LinkedList<QFilter> singleFilterList = new LinkedList<QFilter>();
                for (QFilter.QFilterNest qFilterNest : qFilterNestList) {
                    singleFilterList.add(qFilterNest.getFilter());
                }
                if (!qFilterNestList.isEmpty()) {
                    singleFilterList.add(0, ((QFilter.QFilterNest)qFilterNestList.get(0)).getParent());
                }
                for (QFilter singleFilter : singleFilterList) {
                    String property = singleFilter.getProperty();
                    if (property.equals("org") || property.startsWith("org.")) {
                        if (orgFilter == null) {
                            orgFilter = singleFilter.copy();
                            continue;
                        }
                        orgFilter = orgFilter.and(singleFilter.copy());
                        continue;
                    }
                    if (property.startsWith("accountbank.")) {
                        acctFilter = new QFilter(singleFilter.getProperty(), singleFilter.getCP(), singleFilter.getValue());
                        continue;
                    }
                    if (property.startsWith("currency.")) {
                        currencyFilter = new QFilter(singleFilter.getProperty(), singleFilter.getCP(), singleFilter.getValue());
                        continue;
                    }
                    if (this.getDatePropertyName().equals(property)) {
                        this.dateFilter = singleFilter.copy();
                        this.parseDateBeginAndEnd();
                        dateIndex = i;
                        continue;
                    }
                    if (property.startsWith("period.") && !singleFilter.getValue().toString().equals("0")) {
                        periodFilter = singleFilter.copy();
                        continue;
                    }
                    if (!property.startsWith("bankaccount.")) continue;
                    acctFilter = new QFilter(singleFilter.getProperty(), singleFilter.getCP(), singleFilter.getValue());
                }
            }
        }
        if (dateIndex >= 0) {
            filter.remove(dateIndex);
            this.getQFilters().remove(dateIndex);
        }
        logger.info("orgFilter:" + orgFilter);
    }

    public abstract void doProcess();

    protected void after() {
    }

    protected String getDatePropertyName() {
        return "bizdate";
    }

    protected List<Long> getOrgIds(QFilter filter) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if (filter != null) {
            this.processFilterProp(filter);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter});
            if (coll.size() > 0) {
                orgIds.addAll(OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        }
        return orgIds;
    }

    protected List<Long> getCurrencyIds(QFilter filter) {
        ArrayList<Long> currencyIds = new ArrayList<Long>(10);
        if (filter != null) {
            this.processFilterProp(filter);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{filter});
            if (coll.size() > 0) {
                currencyIds.addAll(OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        }
        return currencyIds;
    }

    protected List<Long> getAcctIds(QFilter filter) {
        ArrayList<Long> acctIds = new ArrayList<Long>(10);
        if (filter != null) {
            this.processFilterProp(filter);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{filter});
            if (coll.size() > 0) {
                acctIds.addAll(OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        }
        return acctIds;
    }

    protected List<Long> getPeriodIds(QFilter filter) {
        ArrayList<Long> periodIds = new ArrayList<Long>(10);
        if (filter != null) {
            this.processFilterProp(filter);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{filter});
            if (coll.size() > 0) {
                periodIds.addAll(OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        }
        return periodIds;
    }

    private void processFilterProp(QFilter filter) {
        String property = filter.getProperty();
        String[] str = property.split("\\.");
        if (str.length == 1) {
            filter.setProperty("id");
        } else {
            int indexOf = property.indexOf(".");
            String substring = property.substring(indexOf + 1);
            filter.setProperty(substring);
        }
        List filterNest = filter.getNests(true);
        Iterator it = filterNest.iterator();
        while (it.hasNext()) {
            QFilter filterInner = ((QFilter.QFilterNest)it.next()).getFilter();
            this.processFilterProp(filterInner);
        }
    }

    private void parseDateBeginAndEnd() {
        if (this.dateFilter != null && null != this.dateFilter.getValue() && !"EMPTY".equalsIgnoreCase(this.dateFilter.getValue().toString())) {
            if (">=".equals(this.dateFilter.getCP())) {
                this.dateFilterBegin = (Date)this.dateFilter.getValue();
            } else {
                this.dateFilterEnd = DateUtils.getNextSeconds((Date)((Date)this.dateFilter.getValue()), (int)-1);
            }
        } else if (null != this.getEntityType() && "cas_bankvccheck".equalsIgnoreCase(this.getEntityType().getName())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fc7\u6ee4\u65e5\u671f\uff01", (String)"BeforeQueryListDataProvider_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    protected void setClazzName(String clazzName) {
        this.clazzName = clazzName;
    }
}

