/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.ConditionEdit;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class CasConditionEdit
extends ConditionEdit {
    private static final String NON_FIELDS = "nonFields";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
            if ("cas_exchangebill".equals(entityNumber)) {
                this.removeCommissionFields(entityNumber, filterGrid);
            }
            filterGrid.setEntityNumber(entityNumber);
        }
    }

    private void removeCommissionFields(String entityNumber, FilterGrid filterGrid) {
        String onlyHeadField = (String)this.getView().getFormShowParameter().getCustomParam("onlyheadfield");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterFieldBuildOption option = new FilterFieldBuildOption();
        boolean isOnlyMainEntityField = !StringUtils.isBlank((CharSequence)onlyHeadField) && Boolean.parseBoolean(onlyHeadField);
        option.setCompatibleProductMode(true);
        if (isOnlyMainEntityField) {
            option.getSelectedEntity().add(entityNumber);
        }
        List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
        String id = MetadataDao.getIdByNumber((String)"cas_exchangebill", (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List items = formMeta.getItems().stream().filter(i -> "fs_commissioninfo".equals(i.getKey())).collect(Collectors.toList());
        for (ControlAp item : items) {
            List fields = ((FieldsetPanelAp)item).getItems();
            for (ControlAp filed : fields) {
                cols.removeIf(v -> v.get("fieldName").toString().startsWith(filed.getKey()));
            }
        }
        filterGrid.setFilterColumns(cols);
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
        }
        catch (Throwable e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeID = e.getNodeId().toString();
        String nonFdStr = (String)this.getView().getFormShowParameter().getCustomParam(NON_FIELDS);
        if (StringUtils.isNotBlank((CharSequence)nonFdStr)) {
            Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
            if (!nonSet.contains(nodeID)) {
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)nodeID);
            }
        } else {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)nodeID);
        }
    }
}

