/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.formplugin.BeforeQueryListDataProvider;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PermissionHelper;

public class CashMgtInitSetList
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblset", "tblinit", "navbill"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List fastFilterCols = args.getFastFilterColumns();
        fastFilterCols.removeIf(fCol -> "billno".equals(fCol.getFieldName()));
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        QFilter qfilter = new QFilter("billno", "!=", (Object)RequestContext.get().getUserId());
        filters.add(qfilter);
        e.setQFilters(filters);
        super.setFilter(e);
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String key = e.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "tblset": {
                if (!this.isSelectRows()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"CashMgtInitSetList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.checkFinishInitPerm()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f53\u524d\u9009\u4e2d\u7ec4\u7ec7\u7ed3\u675f\u521d\u59cb\u5316\u7684\u6743\u9650\u3002", (String)"CashMgtInitSetList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.isFinishInit()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u91cd\u65b0\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\u3002", (String)"CashMgtInitSetList_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.isInitSet() && this.isHasCasData()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u51fa\u7eb3\u540e\u7eed\u4e1a\u52a1\uff0c\u5305\u62ec\u8c03\u62e8\u7533\u8bf7\u5355\u3001\u4ed8\u6b3e\u5355\u3001\u6536\u6b3e\u5355\u3001\u4ee3\u53d1\u5355\u3001\u5916\u5e01\u5151\u6362\u5355\u3001\u94f6\u884c\u65e5\u8bb0\u8d26\u548c\u73b0\u91d1\u65e5\u8bb0\u8d26\u3002\u521d\u59cb\u8bbe\u7f6e\u4e0d\u53ef\u4fee\u6539\u3002", (String)"CashMgtInitSetList_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.showSetForm();
                break;
            }
            case "tblinit": {
                if (!this.isSelectRows()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"CashMgtInitSetList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.isSelectSingleRow()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u9009\u62e9\u5355\u884c\u64cd\u4f5c\u3002", (String)"CashMgtInitSetList_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.checkFinishInitPerm()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f53\u524d\u9009\u4e2d\u7ec4\u7ec7\u7ed3\u675f\u521d\u59cb\u5316\u7684\u6743\u9650\u3002", (String)"CashMgtInitSetList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.isInitSet()) {
                    this.showInitForm();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e4b\u540e\u518d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u3002", (String)"CashMgtInitSetList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "navbill": {
                if (!this.isSelectRows()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"CashMgtInitSetList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.isInitSet()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"CashMgtInitSetList_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.navigateRelationBills();
                break;
            }
            case "resetinitbalance": {
                if (!this.isSelectRows()) {
                    return;
                }
                if (!this.isSelectOneRow()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CashMgtInitSetList_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.isFinishInit()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bf9\u9009\u4e2d\u6570\u636e\u7684\u7ec4\u7ec7\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"CashMgtInitSetList_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                BaseShowParameter showForm = new BaseShowParameter();
                showForm.setFormId("cas_resetinitbalance");
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRow initInfo = list.getCurrentSelectedRowInfo();
                DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)initInfo.getPrimaryKeyValue(), (String)"cas_cashmgtinit", (String)"org");
                DynamicObject org = info.getDynamicObject("org");
                showForm.setCustomParam("org", org.getPkValue());
                showForm.setCustomParam("orgId", (Object)org.getLong("id"));
                showForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showForm);
            }
        }
    }

    private boolean isSelectRows() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        return selectedRows != null && selectedRows.size() != 0;
    }

    private boolean isSelectOneRow() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        return selectedRows != null && selectedRows.size() == 1;
    }

    private boolean isSelectSingleRow() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        return selectedRows == null || selectedRows.size() <= 1;
    }

    private boolean isFinishInit() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows != null) {
            List pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cas_cashmgtinit");
            DynamicObject[] infoArr = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)dataEntityType);
            if (infoArr != null) {
                for (DynamicObject info : infoArr) {
                    if (!info.getBoolean("isfinishinit")) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isInitSet() {
        DynamicObject[] infoArr;
        BillList list = (BillList)this.getView().getControl("billlistap");
        Set pkIds = list.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", pkIds);
        for (DynamicObject info : infoArr = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org,standardcurrency,periodtype,startperiod,exratetable", (QFilter[])new QFilter[]{qfilter})) {
            if (info == null || info.getDynamicObject("standardcurrency") == null || info.getDynamicObject("periodtype") == null || info.getDynamicObject("startperiod") == null || info.getDynamicObject("exratetable") == null) continue;
            return true;
        }
        return false;
    }

    private boolean isHasCasData() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRow = list.getSelectedRows();
        if (selectedRow != null) {
            DynamicObject[] infoArr;
            Set pkIds = selectedRow.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            QFilter qfilter1 = new QFilter("id", "in", pkIds);
            for (DynamicObject info : infoArr = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org", (QFilter[])new QFilter[]{qfilter1})) {
                if (info == null || info.getDynamicObject("org") == null) continue;
                long orgid = info.getDynamicObject("org").getLong("id");
                QFilter qfilter = new QFilter("org", "=", (Object)orgid);
                boolean haspaybill = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{qfilter});
                if (haspaybill) {
                    return true;
                }
                boolean hasrecbill = QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{qfilter});
                if (hasrecbill) {
                    return true;
                }
                boolean hasagentpaybill = QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])new QFilter[]{qfilter});
                if (hasagentpaybill) {
                    return true;
                }
                boolean hasTransferPlay = QueryServiceHelper.exists((String)"cas_transferapply", (QFilter[])new QFilter[]{new QFilter("applyorg", "=", (Object)orgid)});
                if (hasTransferPlay) {
                    return true;
                }
                boolean hasExchangeBill = QueryServiceHelper.exists((String)"cas_exchangebill", (QFilter[])new QFilter[]{qfilter});
                if (hasExchangeBill) {
                    return true;
                }
                boolean hasBankJournal = QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])new QFilter[]{qfilter});
                if (hasBankJournal) {
                    return true;
                }
                boolean hasCashJournal = QueryServiceHelper.exists((String)"cas_cashjournal", (QFilter[])new QFilter[]{qfilter});
                if (!hasCashJournal) continue;
                return true;
            }
        }
        return false;
    }

    public void listRowDoubleClick(ListRowClickEvent e) {
        super.listRowDoubleClick(e);
        if (!this.isInitSet()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e4b\u540e\u518d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u3002", (String)"CashMgtInitSetList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            e.setCancel(true);
            this.showInitForm();
        }
    }

    private void showSetForm() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows.size() != 0) {
            ArrayList<Object> pks = new ArrayList<Object>();
            for (ListSelectedRow row : selectedRows) {
                pks.add(row.getPrimaryKeyValue());
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", pks)};
            String selectorStr = "id,org,standardcurrency,periodtype,startperiod,exratetable";
            DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)selectorStr, (QFilter[])filters);
            ArrayList<Long> orgPks = new ArrayList<Long>(infos.length);
            for (DynamicObject info : infos) {
                orgPks.add(info.getLong("org.id"));
            }
            DynamicObject info = infos[0];
            Long id = info.getLong("id");
            Long standardcurrency = info.getDynamicObject("standardcurrency") != null ? Long.valueOf(info.getDynamicObject("standardcurrency").getLong("id")) : null;
            Long periodtype = info.getDynamicObject("periodtype") != null ? Long.valueOf(info.getDynamicObject("periodtype").getLong("id")) : null;
            Long startperiod = info.getDynamicObject("startperiod") != null ? Long.valueOf(info.getDynamicObject("startperiod").getLong("id")) : null;
            Long exratetable = info.getDynamicObject("exratetable") != null ? Long.valueOf(info.getDynamicObject("exratetable").getLong("id")) : null;
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("cas_cashmgtinitset");
            parameter.setCustomParam("id", (Object)id);
            parameter.setCustomParam("org", orgPks);
            parameter.setCustomParam("standardcurrency", (Object)standardcurrency);
            parameter.setCustomParam("periodtype", (Object)periodtype);
            parameter.setCustomParam("startperiod", (Object)startperiod);
            parameter.setCustomParam("exratetable", (Object)exratetable);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshlist"));
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("opencashmgtinitform".equalsIgnoreCase(e.getActionId())) {
            Map resultMap = (Map)e.getReturnData();
            if (resultMap != null) {
                DynamicObject org = (DynamicObject)resultMap.get("org");
                Long orgid = null;
                if (org != null) {
                    orgid = org.getLong("id");
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("cas_cashmgtinit");
                parameter.setCustomParam("orgid", (Object)orgid);
                ShowType showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
                parameter.getOpenStyle().setTargetKey("tabap");
                parameter.getOpenStyle().setShowType(showType);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshlist"));
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().invokeOperation("refresh");
            }
        } else if ("refreshlist".equalsIgnoreCase(e.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("antiinitbatch".equals(operateKey) || "finishinitbatch".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showInitForm() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow initInfo = list.getCurrentSelectedRowInfo();
        if (initInfo != null) {
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)initInfo.getPrimaryKeyValue(), (String)"cas_cashmgtinit", (String)"org.id");
            long orgid = info.getLong("org.id");
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("cas_cashmgtinit");
            parameter.setCustomParam("orgid", (Object)orgid);
            ShowType showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
            parameter.getOpenStyle().setTargetKey("tabap");
            parameter.getOpenStyle().setShowType(showType);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshlist"));
            parameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private boolean checkFinishInitPerm() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection initInfos = list.getSelectedRows();
        for (ListSelectedRow initInfo : initInfos) {
            if (initInfo == null) continue;
            long orgid = initInfo.getMainOrgId();
            String appId = this.getView().getFormShowParameter().getAppId();
            boolean isOk = PermissionHelper.checkCurrentUserPermission((String)appId, (long)orgid, (String)"cas_cashmgtinit", (String)"4730fc9f000005ae");
            if (isOk) continue;
            return false;
        }
        return true;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new CashMgtInitSetDataProvider());
    }

    private static void deleteNotBankOrg() {
        QFilter filter = new QFilter("isfinishinit", "=", (Object)"0");
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org", (QFilter[])new QFilter[]{filter});
        if (!CasHelper.isEmpty((DynamicObject[])inits)) {
            HashSet<Long> dels = new HashSet<Long>();
            ArrayList<Long> initOrgIds = new ArrayList<Long>();
            for (DynamicObject init : inits) {
                DynamicObject org = init.getDynamicObject("org");
                if (org == null) {
                    dels.add(init.getLong("id"));
                    continue;
                }
                initOrgIds.add(org.getLong("id"));
            }
            Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "in", initOrgIds), new QFilter("fisbankroll", "=", (Object)"0")});
            if (orgs != null && orgs.size() > 0) {
                ArrayList<Long> orgids = new ArrayList<Long>(orgs.size());
                for (Object org : orgs.keySet()) {
                    orgids.add(Long.parseLong(String.valueOf(org)));
                }
                QFilter delFilter = new QFilter("org", "in", orgids);
                if (dels.size() > 0) {
                    delFilter.or(new QFilter("id", "in", dels));
                }
                DeleteServiceHelper.delete((String)"cas_cashmgtinit", (QFilter[])new QFilter[]{delFilter});
            }
        }
    }

    private static void initSave(List<Long> orgIds) {
        if (orgIds == null || orgIds.size() == 0) {
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_cashmgtinit");
        ArrayList<DynamicObject> unInitSetObjectList = new ArrayList<DynamicObject>(orgIds.size());
        for (int i = 0; i < orgIds.size(); ++i) {
            long orgid = orgIds.get(i);
            DynamicObject initInfo = new DynamicObject((DynamicObjectType)entityType);
            initInfo.set("org", (Object)orgid);
            initInfo.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            initInfo.set("createtime", (Object)new Date());
            initInfo.set("isfinishinit", (Object)"0");
            initInfo.set("billstatus", (Object)"A");
            unInitSetObjectList.add(initInfo);
        }
        if (unInitSetObjectList != null && unInitSetObjectList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])unInitSetObjectList.toArray(new DynamicObject[0]));
        }
    }

    private void navigateRelationBills() {
        List<Long> orgIds = this.selectOrgIds();
        QFilter[] filter = new QFilter[]{new QFilter("org", "in", orgIds)};
        DynamicObject[] restBalanceBills = BusinessDataServiceHelper.load((String)"cas_resetinitbalance", (String)"id", (QFilter[])filter);
        ArrayList<Long> billIds = new ArrayList<Long>(restBalanceBills.length);
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(2);
        for (DynamicObject resetBill : restBalanceBills) {
            billIds.add(resetBill.getLong("id"));
        }
        if (billIds.size() > 0) {
            tuples.add(new Tuple((Object)"cas_resetinitbalance", billIds));
        }
        CasBotpHelper.showTrackParameter(tuples, (IFormView)this.getView());
    }

    private List<Long> selectOrgIds() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (ListSelectedRow selectedRow : selectedRows) {
            Long orgId = selectedRow.getMainOrgId();
            orgIds.add(orgId);
        }
        return orgIds;
    }

    static class CashMgtInitSetDataProvider
    extends BeforeQueryListDataProvider {
        CashMgtInitSetDataProvider() {
        }

        @Override
        public void doProcess() {
            CashMgtInitSetList.deleteNotBankOrg();
            List orgIds = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"cas_cashmgtinit", (String)"47150e89000000ac");
            if (orgIds != null && orgIds.size() > 0) {
                QFilter qFilter = new QFilter("org", "in", (Object)orgIds);
                DynamicObject[] casInit = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org", (QFilter[])new QFilter[]{qFilter});
                if (casInit == null || casInit.length == 0) {
                    CashMgtInitSetList.initSave(orgIds);
                    return;
                }
                List existOrgIds = Arrays.asList(casInit).stream().map(i -> i.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
                if (existOrgIds != null && existOrgIds.size() > 0) {
                    Iterator ite = orgIds.iterator();
                    while (ite.hasNext()) {
                        Long org = (Long)ite.next();
                        if (!existOrgIds.contains(org)) continue;
                        ite.remove();
                    }
                    CashMgtInitSetList.initSave(orgIds);
                }
            }
        }
    }
}

