/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.util.PayeeInfoHelper;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.util.EmptyUtil;

public class CashPayeeInfoEdit
extends DynamicFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(CashPayeeInfoEdit.class);
    private static final String ID = "id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"payeeacctcashf7"});
        this.init();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "payee": {
                this.payeeChange((DynamicObject)newValue);
                break;
            }
            case "payeeacctcashf7": {
                this.payeeAcctCashF7Changed((DynamicObject)newValue);
            }
        }
    }

    private void payeeChange(DynamicObject payee) {
        this.init();
        this.setValue("payeeacctcashf7", null);
        if (this.isCash() && EmptyUtil.isNoEmpty((DynamicObject)payee)) {
            this.setValue("payeeacctcashf7", AccountCashHelper.getDefaultAccountcash((Long)payee.getLong(ID), (String)"payee"));
            DynamicObject acctCash = this.getDynamicObject("payeeacctcashf7");
            if (EmptyUtil.isNoEmpty((DynamicObject)acctCash)) {
                this.setValue("payeeacctcash", acctCash.getPkValue());
                this.clearBankAccountVal();
            }
        }
    }

    private void payeeAcctCashF7Changed(DynamicObject acctCash) {
        this.setValue("payeeacctcash", null);
        this.clearBankAccountVal();
        if (this.isCash() && EmptyUtil.isNoEmpty((DynamicObject)acctCash)) {
            this.setValue("payeeaccformid", "cas_accountcash");
            this.setValue("payeeacctcash", acctCash.getPkValue());
        }
    }

    private void init() {
        IDataEntityProperty settleTypeProp;
        DynamicObject billType;
        IDataModel parentModel;
        IDataEntityProperty billTypeProp;
        boolean isCash = false;
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView != null && (billTypeProp = (parentModel = parentView.getModel()).getProperty("billtype")) != null && PayeeInfoHelper.isPaymentBill((DynamicObject)(billType = (DynamicObject)parentModel.getValue("billtype"))) && (settleTypeProp = parentModel.getProperty("settletype")) != null) {
            DynamicObject settleType = (DynamicObject)parentModel.getValue("settletype");
            isCash = PayeeInfoHelper.useCashAccount((DynamicObject)settleType, (long)(EmptyUtil.isNoEmpty((DynamicObject)this.getDynamicObject("payee")) ? this.getDynamicObject("payee").getLong(ID) : 0L), (String)((String)this.getValue("asstacttype")));
            view.setVisible(Boolean.valueOf(isCash), new String[]{"payeeacctcashf7"});
            view.setVisible(Boolean.valueOf(!isCash), new String[]{"payeebanknum", "payeebankname"});
            if (isCash) {
                this.setValue("payeeacctcashf7", this.getValue("payeeacctcash"));
                DynamicObject acctCash = this.getDynamicObject("payeeacctcashf7");
                if (EmptyUtil.isNoEmpty((DynamicObject)acctCash)) {
                    this.setValue("payeebanknum", acctCash.getString("number"));
                } else {
                    this.setValue("payeebanknum", null);
                }
                this.setValue("payeeaccformid", "cas_accountcash");
                this.clearBankAccountVal();
            }
        }
        this.getPageCache().put("isCash", isCash ? "1" : "0");
    }

    private boolean isCash() {
        String val = this.getPageCache().get("isCash");
        return StringUtils.equals((CharSequence)val, (CharSequence)"1");
    }

    private void clearBankAccountVal() {
        this.setValue("payeeacctbank", null);
        this.setValue("payeeacctbankf7", null);
    }
}

