/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class ChangePayeeInfoPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ChangePayeeInfoPlugin.class);

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object sourceId = formShowParameter.getCustomParam("sourceId");
        String sourceType = (String)formShowParameter.getCustomParam("sourceType");
        logger.info("\u5355\u636e\u627e\u51fa\u4e0a\u6e38\u5355\u636e\u53c2\u6570sourceId: " + sourceId + ";sourceType: " + sourceType);
        Map upBillMap = BFTrackerServiceHelper.findSourceBills((String)sourceType, (Long[])new Long[]{(Long)sourceId});
        logger.info("\u5355\u636e\u627e\u51fa\u4e0a\u6e38\u5355\u636e\u53c2\u6570upBillMap:" + upBillMap);
        for (Map.Entry recBillI : upBillMap.entrySet()) {
            HashSet sourceIds = (HashSet)recBillI.getValue();
            if (CollectionUtils.isEmpty((Collection)sourceIds)) continue;
            for (Long id : sourceIds) {
                DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)((String)recBillI.getKey()));
                if (!sourceBill.containsProperty("creator")) continue;
                Object creator = sourceBill.get("creator");
                RequestContext requestContext = RequestContext.get();
                String currentUserID = requestContext.getUserId();
                DynamicObject creatorObj = (DynamicObject)creator;
                if (EmptyUtil.isNoEmpty((DynamicObject)creatorObj) && currentUserID.equals(creatorObj.getPkValue().toString())) continue;
                Object billNo = sourceBill.get("billno");
                Object createTime = sourceBill.get("createtime");
                String billName = EntityMetadataCache.getDataEntityType((String)((String)recBillI.getKey())).getDisplayName().getLocaleValue();
                Object jsonArray = formShowParameter.getCustomParam("selectEntrySourceId");
                if ("cas_agentpaybill".equals(sourceType) && jsonArray != null) {
                    List selectEntryRows = JSONArray.parseArray((String)jsonArray.toString(), Object.class);
                    if (selectEntryRows == null || selectEntryRows.size() == 0 || !selectEntryRows.contains(sourceBill.getPkValue())) continue;
                    this.addEntryRow(model, billNo, billName, createTime, creator);
                    continue;
                }
                this.addEntryRow(model, billNo, billName, createTime, creator);
            }
        }
    }

    private void addEntryRow(IDataModel model, Object billNo, Object billName, Object createTime, Object creator) {
        int rowIdx = model.createNewEntryRow("entryentity");
        model.setEntryCurrentRowIndex("entryentity", rowIdx);
        model.setValue("billno", billNo, rowIdx);
        model.setValue("billname", billName, rowIdx);
        model.setValue("createtime", createTime, rowIdx);
        model.setValue("creator", creator, rowIdx);
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"comfirm"});
    }

    public void click(EventObject evt) {
        Button button;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        IDataModel model = this.getModel();
        if (source instanceof Button && "comfirm".equals(key = (button = (Button)source).getKey())) {
            Object btnGroup = this.getModel().getValue("btngroup");
            Object userField = this.getModel().getValue("userfield");
            Object changeCause = this.getModel().getValue("changecause");
            Object billNo = null;
            Object billName = null;
            Object creator = null;
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
            int row = grid.getEntryState().getFocusRow();
            if ("B".equals(btnGroup) && row < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4eba\u8fdb\u884c\u901a\u77e5\u3002", (String)"ChangePayeeInfoPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject billNoObj = model.getEntryRowEntity("entryentity", row);
            if (null != billNoObj) {
                billNo = billNoObj.get("billno");
                billName = billNoObj.get("billname");
                creator = billNoObj.get("creator");
            }
            if ("C".equals(btnGroup) && null == userField) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4eba\u8fdb\u884c\u901a\u77e5\u3002", (String)"ChangePayeeInfoPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (("B".equals(btnGroup) || "C".equals(btnGroup)) && StringUtils.isEmpty((String)((String)changeCause))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChangePayeeInfoPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object selectEntryRows = formShowParameter.getCustomParam("selectEntryRows");
            String sourceType = (String)formShowParameter.getCustomParam("sourceType");
            String sourceAction = (String)formShowParameter.getCustomParam("sourceAction");
            String openView = (String)formShowParameter.getCustomParam("openView");
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            resultMap.put("btnGroup", btnGroup);
            resultMap.put("userField", userField);
            resultMap.put("changeCause", changeCause);
            resultMap.put("billNo", billNo);
            resultMap.put("billName", billName);
            resultMap.put("creator", creator);
            resultMap.put("selectEntryRows", selectEntryRows);
            resultMap.put("sourceType", sourceType);
            resultMap.put("sourceAction", sourceAction);
            resultMap.put("openView", openView);
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        }
    }
}

