/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.helper.PayInfoChgHelper;
import kd.fi.cas.util.EmptyUtil;

public class ChooseEntryRowPlugin
extends AbstractFormPlugin {
    private static final Map<Long, Long> choseEntryIdToSourceId = new HashMap<Long, Long>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String billFormId = (String)fsp.getCustomParam("billFormId");
        Object chooseBillId = fsp.getCustomParam("chooseBillId");
        DynamicObject agentBill = null;
        try {
            agentBill = BusinessDataServiceHelper.loadSingle((Object)chooseBillId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billFormId));
        }
        catch (Exception e1) {
            return;
        }
        DynamicObjectCollection entry = agentBill.getDynamicObjectCollection("entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return;
        }
        this.getModel().setValue("currency", agentBill.getDynamicObject("currency").getPkValue());
        if (this.getControl("entryentity") != null) {
            this.getModel().deleteEntryData("entryentity");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("choseentryid", new Object[0]).addField("e_amount", new Object[0]).addField("payeetypelist", new Object[0]).addField("payee", new Object[0]).addField("payeename", new Object[0]).addField("payeeacctbank", new Object[0]).addField("payeebankname", new Object[0]).addField("e_remark", new Object[0]);
            for (DynamicObject rowDO : entry) {
                vs.addRow(new Object[]{rowDO.getPkValue(), rowDO.getBigDecimal("e_amount"), rowDO.get("importpayeetype"), EmptyUtil.isEmpty((Object)rowDO.get("payee")) ? "" : rowDO.getDynamicObject("payee").getString("name"), rowDO.get("payeename"), rowDO.get("payeeacctbank"), rowDO.get("payeebankname"), rowDO.get("e_remark")});
                choseEntryIdToSourceId.put((Long)rowDO.getPkValue(), (Long)rowDO.get("sourcebillid"));
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String billFormId = (String)fsp.getCustomParam("billFormId");
        Object chooseBillId = fsp.getCustomParam("chooseBillId");
        DynamicObject agentBill = null;
        try {
            agentBill = BusinessDataServiceHelper.loadSingle((Object)chooseBillId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billFormId));
        }
        catch (Exception e1) {
            return;
        }
        if (PayInfoChgHelper.isNeedEncrypVisable((DynamicObject)agentBill)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"payeeacctbank", "e_amount"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"encryptpayeeacctbank", "e_amount_encry"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            HashMap data = new HashMap(16);
            EntryGrid detailsEntryObj = (EntryGrid)this.getControl("entryentity");
            int[] rows = detailsEntryObj.getSelectRows();
            HashSet<Object> selectEntryRows = new HashSet<Object>(16);
            HashSet<Long> selectEntrySourceId = new HashSet<Long>(16);
            for (int index : rows) {
                DynamicObject selectRowObj = this.getModel().getEntryRowEntity("entryentity", index);
                selectEntryRows.add(selectRowObj.get("choseentryid"));
                selectEntrySourceId.add(choseEntryIdToSourceId.get(selectRowObj.get("choseentryid")));
            }
            if (selectEntryRows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"ChooseEntryRowPlugin_01", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            data.put("selectEntryRows", selectEntryRows);
            data.put("selectEntrySourceId", selectEntrySourceId);
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }
}

