/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class FundItemFlowTreeList
extends AbstractTreeListPlugin {
    public static final String ISLEAF = "isleaf";
    public static final String ENABLE = "enable";
    public static final String ENTITY_NAME = "cas_fundflowitem";
    public static final String ORG_CACHE = "_org_cache_";
    public static final String ENABLE_CACHE = "_enable_cache_";

    public void filterContainerInit(FilterContainerInitArgs e) {
        List<QFilter> cachedFilter;
        super.filterContainerInit(e);
        List list = e.getFilterContainerInitEvent().getCommonFilterColumns();
        Long orgId = null;
        String enable = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (FilterColumn col : list) {
                String fieldName = col.getFieldName();
                if (CollectionUtils.isEmpty((Collection)col.getDefaultValues())) continue;
                Object defVal = col.getDefaultValues().get(0);
                if ("useorg.id".equals(fieldName)) {
                    orgId = Long.valueOf(defVal.toString());
                    continue;
                }
                if (!ENABLE.equals(fieldName)) continue;
                enable = (String)defVal;
            }
        }
        if (CollectionUtils.isEmpty(cachedFilter = this.getCachedOrgAndEnableFilter())) {
            this.cacheOrgAndEnableFilter(orgId, enable);
            cachedFilter = this.getCachedOrgAndEnableFilter();
            ITreeModel treeModel = this.getTreeModel();
            if (treeModel != null) {
                List filter = treeModel.getTreeFilter();
                filter.clear();
                filter.addAll(cachedFilter);
            }
            this.getTreeListView().refreshTreeView();
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String key = e.getItemKey();
        if ("tblrefresh".equals(key)) {
            this.getTreeListView().refreshTreeView();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.getTreeListView().focusRootNode();
        Map currentCommonFilters = args.getSearchClickEvent().getCurrentCommonFilter();
        if (currentCommonFilters != null && !currentCommonFilters.isEmpty()) {
            Map filterValues = args.getSearchClickEvent().getFilterValues();
            List fastlist = (List)filterValues.get("fastfilter");
            Long orgId = (Long)args.getSearchClickEvent().getFilterValue("useorg.id");
            String enable = (String)args.getSearchClickEvent().getFilterValue(ENABLE);
            if (orgId != null && (fastlist == null || fastlist.isEmpty())) {
                this.cacheOrgAndEnableFilter(orgId, enable);
                this.getTreeListView().refreshTreeView();
            }
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        List<QFilter> cachedOrgAndEnableFilter = this.getCachedOrgAndEnableFilter();
        ITreeModel treeModel = this.getTreeModel();
        List list = treeModel.getTreeFilter();
        if (!CollectionUtils.isEmpty(cachedOrgAndEnableFilter)) {
            list.clear();
            list.addAll(cachedOrgAndEnableFilter);
        } else {
            list.clear();
            List qs = ((ListShowParameter)this.getView().getFormShowParameter()).getListFilterParameter().getQFilters();
            qs.forEach(q -> {
                if (!q.getProperty().equals(ISLEAF)) {
                    list.add(q);
                } else if (!CollectionUtils.isEmpty((Collection)q.getNests(false))) {
                    List nests = q.getNests(true);
                    QFilter nestFilter = null;
                    for (int i = 0; i < nests.size(); ++i) {
                        QFilter.QFilterNest nest = (QFilter.QFilterNest)nests.get(i);
                        if (i == 0) {
                            nestFilter = nest.getFilter();
                            continue;
                        }
                        if (nest.isAnd()) {
                            nestFilter.and(nest.getFilter());
                            continue;
                        }
                        nestFilter.or(nest.getFilter());
                    }
                    list.add(nestFilter);
                }
            });
        }
        if (treeModel instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            HashMap<String, String> orderMap = new HashMap<String, String>(2);
            orderMap.put("order", "number asc");
            treeListModel.setQueryParas(orderMap);
        }
    }

    private void cacheOrgAndEnableFilter(Long orgId, String enable) {
        if (orgId != null) {
            this.getPageCache().put(ORG_CACHE, orgId.toString());
        }
        this.getPageCache().put(ENABLE_CACHE, enable);
    }

    private List<QFilter> getCachedOrgAndEnableFilter() {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        String orgId = this.getPageCache().get(ORG_CACHE);
        String enable = this.getPageCache().get(ENABLE_CACHE);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.containsKey("org")) {
            orgId = String.valueOf(customParams.get("org"));
        }
        if (orgId != null) {
            filterList.add(BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_NAME, (Long)Long.valueOf(orgId)));
        }
        if (enable != null && !"null".equals(enable)) {
            filterList.add(new QFilter(ENABLE, "=", (Object)enable));
        }
        return filterList;
    }
}

