/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.journal.SourceNumber;
import kd.fi.cas.business.journal.VoucherBookService;
import kd.fi.cas.formplugin.journalprintall.JournalPrintHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.helper.ManualJournalHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.F7FilterUtil;
import kd.fi.cas.util.ViewUtils;

public abstract class JournalBaseFormRpt
extends AbstractReportFormPlugin {
    protected String rptEntity;
    protected String acctEntity;
    protected String acctControlName;
    protected String journalEntity;
    protected static final String BAR_NEW_MANUAL = "bar_new_manual";
    protected static final String BAR_DEL_MANUAL = "bar_del_manual";
    protected static final String BAR_SUBMIT_MANUAL = "bar_submit_manual";
    protected static final String BAR_AUDIT_MANUAL = "bar_audit_manual";
    protected static final String BAR_UNAUDIT_MANUAL = "bar_unaudit_manual";
    private static final String SOURCE_ONE = "1";
    private static final String SOURCE_THREE = "3";
    private static final String SOURCE_FIVE = "5";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "bar_new"});
        this.initF7(this.rptEntity, this.acctEntity, this.acctControlName);
        ReportList rptList = (ReportList)this.getView().getControl("reportlistap");
        rptList.addRowClickListener(new RowClickEventListener(){

            public void entryRowDoubleClick(RowClickEvent evt) {
                int[] selectedRows = ((ReportList)evt.getSource()).getEntryState().getSelectedRows();
                DynamicObject row = ((ReportList)evt.getSource()).getReportModel().getRowData(selectedRows[0]);
                if (row.getLong("id") != 0L) {
                    long journalId = row.getLong("id");
                    BillShowParameter param = new BillShowParameter();
                    param.setPkId((Object)journalId);
                    param.setStatus(OperationStatus.VIEW);
                    param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    param.setFormId(JournalBaseFormRpt.this.journalEntity);
                    ((ReportList)evt.getSource()).getView().showForm((FormShowParameter)param);
                }
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("botpview".equalsIgnoreCase(key)) {
            String appId = this.getView().getFormShowParameter().getAppId();
            boolean hasPermission = PermissionHelper.checkCurrentUserPermission((String)appId, (long)RequestContext.get().getOrgId(), (String)this.getView().getEntityId(), (String)"4FT8=XP8Q8OF");
            if (!hasPermission) {
                String caption = this.getView().getFormShowParameter().getCaption();
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u8054\u67e5\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JournalBaseFormRpt_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), caption));
                return;
            }
            ReportList list = (ReportList)this.getView().getControl("reportlistap");
            int[] selectedRows = list.getEntryState().getSelectedRows();
            if (selectedRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"JournalBaseFormRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else if (selectedRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u6267\u884c\u3002", (String)"JournalBaseFormRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                DynamicObject row = list.getReportModel().getRowData(selectedRows[0]);
                CasBotpHelper.showParamter((String)this.journalEntity, (Long)row.getLong("id"), (String)"lookup", (IFormView)this.getView());
            }
        }
    }

    private List<Long> getOrgValue() {
        String orgField = "org";
        String orgType = "";
        if ("cas_bankjournalformrpt".equalsIgnoreCase(this.getView().getEntityId())) {
            orgType = this.getModel().getValue("queryorgtype").toString();
        }
        if ("openorg".equalsIgnoreCase(orgType)) {
            orgField = "openorg";
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(orgField);
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    private boolean checkSelSingleOrg() {
        HashSet<Long> selectOrgs = new HashSet<Long>(this.getOrgValue());
        if (selectOrgs.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6240\u6709\u65f6\uff0c\u53ea\u80fd\u9009\u4e00\u4e2a\u7ec4\u7ec7\u3002", (String)"JournalBaseFormRpt_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IReportListModel reportModel;
        ReportList rpt;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("exportexcel".equalsIgnoreCase(op.getOperateKey()) || "exportallacc".equalsIgnoreCase(op.getOperateKey())) {
            rpt = (ReportList)this.getView().getControl("reportlistap");
            if (rpt.getReportModel().getRowCount() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"JournalBaseFormRpt_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.cancel = true;
            }
            if ("exportallacc".equalsIgnoreCase(op.getOperateKey()) && !this.checkSelSingleOrg()) {
                args.cancel = true;
            }
        }
        if ("printpreview".equalsIgnoreCase(op.getOperateKey()) && (reportModel = (rpt = (ReportList)this.getView().getControl("reportlistap")).getReportModel()) != null) {
            ReportListModel listModel = (ReportListModel)reportModel;
            try {
                DynamicObjectCollection ds = listModel.getRowData(0, rpt.getReportModel().getRowCount());
                Object[] objs = ds.stream().filter(o -> StringUtils.equals((CharSequence)SOURCE_THREE, (CharSequence)o.getString("datatype"))).toArray();
                if (objs == null || objs.length == 0) {
                    Boolean isPrintNull = (Boolean)this.getModel().getValue("isprintnull");
                    if (!isPrintNull.booleanValue()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u6253\u5370\u7684\u6570\u636e\u3002", (String)"JournalBaseFormRpt_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        args.cancel = true;
                    } else {
                        TreeView tree = (TreeView)this.getControl("reporttreeap");
                        List selectedNodeIds = tree.getTreeState().getSelectedNodeId();
                        this.getPageCache().put("printselnode", SerializationUtils.toJsonString((Object)selectedNodeIds));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ("checkdelauth".equalsIgnoreCase(op.getOperateKey())) {
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            int[] rowKeys = reportList.getEntryState().getSelectedRows();
            if (rowKeys == null || rowKeys.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"JournalBaseFormRpt_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.confirmDelete(reportList, rowKeys);
        }
    }

    private void initF7(String rptEntity, String acctEntity, String acctControlName) {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("org");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (orgCtrl.getQFilter() == null) {
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)true)}, null);
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                F7FilterUtil.bankrollOrgF7QFilter((BeforeF7SelectEvent)beforeF7SelectEvent, (String)appId, (String)rptEntity, (String)"47150e89000000ac", (List)OrgHelper.getIdList((DynamicObjectCollection)coll));
            }
        });
        BasedataEdit acctCtrl = (BasedataEdit)this.getControl(acctControlName);
        acctCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
            new LspWapper(beforeF7SelectEvent).setFilters(this.getAcctFilter(this.getIdList(orgColl)));
        });
        BasedataEdit currencyCtrl = (BasedataEdit)this.getControl("currency");
        currencyCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection acctColl = (DynamicObjectCollection)this.getModel().getValue(acctControlName);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (acctColl.size() > 0) {
                Set currencyIdSet = AccountBankHelper.getCurrencyPks((String)acctEntity, this.getIdList(acctColl));
                QFilter qFilter = new QFilter("id", "in", (Object)currencyIdSet);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
        BasedataEdit periodTypeCtrl = (BasedataEdit)this.getControl("periodtype");
        periodTypeCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (orgColl.size() > 0) {
                HashSet<Long> typeIds = new HashSet<Long>(orgColl.size());
                for (int i = 0; i < orgColl.size(); ++i) {
                    DynamicObject org = ((DynamicObject)orgColl.get(i)).getDynamicObject("fbasedataid");
                    long orgId = (Long)org.getPkValue();
                    long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
                    typeIds.add(periodTypeId);
                }
                QFilter qFilter = new QFilter("id", "in", typeIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", null));
            }
        });
        BasedataEdit beginPeriod = (BasedataEdit)this.getControl("beginperiod");
        beginPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject periodType = (DynamicObject)this.getModel().getValue("periodtype");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (periodType != null) {
                QFilter qFilter = new QFilter("periodtype", "=", (Object)periodType.getLong("id"));
                qFilter.and("isadjustperiod", "=", (Object)"0");
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", null));
            }
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject periodType = (DynamicObject)this.getModel().getValue("periodtype");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (periodType != null) {
                QFilter qFilter = new QFilter("periodtype", "=", (Object)periodType.getLong("id"));
                qFilter.and("isadjustperiod", "=", (Object)"0");
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", null));
            }
        });
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"begindate", "enddate", "periodtype"});
        this.getModel().setValue("datetype", (Object)1);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParam("fromAEF") != null) {
            Long org = Long.valueOf(parameter.getCustomParam("org").toString());
            Long beginPeriod = Long.valueOf(parameter.getCustomParam("beginperiod").toString());
            Long endPeriod = Long.valueOf(parameter.getCustomParam("endperiod").toString());
            this.getModel().setValue("org", (Object)new Object[]{org});
            this.getModel().setValue("datetype", (Object)SOURCE_ONE);
            this.getModel().setValue("beginPeriod", (Object)beginPeriod);
            this.getModel().setValue("endPeriod", (Object)endPeriod);
            this.getModel().setValue("iscontainclosed", (Object)SOURCE_ONE);
            ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
            control.search();
            return;
        }
        if (parameter.getCustomParam("setDefaultFilters") != null) {
            Long org = Long.valueOf(parameter.getCustomParam("org").toString());
            Long accountBank = Long.valueOf(parameter.getCustomParam("accountBank").toString());
            Long currency = Long.valueOf(parameter.getCustomParam("currency").toString());
            Long beginPeriod = Long.valueOf(parameter.getCustomParam("beginperiod").toString());
            Long endPeriod = Long.valueOf(parameter.getCustomParam("endperiod").toString());
            this.getModel().setValue("org", (Object)new Object[]{org});
            this.getModel().setValue("accountcash", (Object)new Object[]{accountBank});
            this.getModel().setValue("currency", (Object)new Object[]{currency});
            this.getModel().setValue("datetype", (Object)1);
            this.getModel().setValue("beginPeriod", (Object)beginPeriod);
            this.getModel().setValue("endPeriod", (Object)endPeriod);
            this.getModel().setValue("begindate", (Object)new Date());
            this.getModel().setValue("enddate", (Object)new Date());
            long periodTypeId = PeriodHelper.getPeriodTypeId((long)org);
            this.getModel().setValue("periodtype", (Object)periodTypeId);
            ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
            control.search();
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgList = OrgHelper.getAuthBankOrgIds((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.rptEntity, (String)"47150e89000000ac");
        if (orgList.size() > 0) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgList), new QFilter("isfinishinit", "=", (Object)true)}, (String)"org");
            if (coll.size() > 0) {
                DynamicObject currentPeriod;
                long currentOrgId = RequestContext.get().getOrgId();
                long orgId = ((DynamicObject)coll.get(0)).getLong("id");
                for (DynamicObject org : coll) {
                    if (currentOrgId != org.getLong("id")) continue;
                    orgId = currentOrgId;
                }
                Object[] arrObj = new Object[]{orgId};
                this.getModel().setValue("org", (Object)arrObj);
                DynamicObject initObj = PeriodHelper.getCasInitInfo((long)orgId);
                if (initObj != null && (currentPeriod = initObj.getDynamicObject("currentperiod")) != null) {
                    this.getModel().setValue("beginperiod", currentPeriod.getPkValue());
                    this.getModel().setValue("endperiod", currentPeriod.getPkValue());
                    this.getModel().setValue("begindate", (Object)currentPeriod.getDate("begindate"));
                    this.getModel().setValue("enddate", (Object)currentPeriod.getDate("enddate"));
                }
                long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
                this.getModel().setValue("periodtype", (Object)periodTypeId);
                if ("accountbank".equals(this.acctControlName)) {
                    boolean isCombine = false;
                    ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)isCombine, (String[])new String[]{"iscombine"});
                }
            }
            this.getPageCache().put("isPeriodTypeSame", "true");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParam("fromAEF") != null) {
            return;
        }
        String dateType = (String)this.getModel().getValue("datetype");
        this.dateTypeChg(dateType);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        if ("datetype".equals(name)) {
            this.dateTypeChg((String)newValue);
        } else if ("org".equals(name)) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)newValue;
            this.orgChange(orgs);
            this.showNewItemBy(orgs);
        } else if (this.acctControlName.equals(name)) {
            DynamicObjectCollection accountColl = (DynamicObjectCollection)newValue;
            if (accountColl.size() == 1) {
                DynamicObject account = (DynamicObject)accountColl.get(0);
                account = account.getDynamicObject("fbasedataid");
                boolean isMulCurrency = false;
                if ("bd_accountbanks".equals(this.acctEntity)) {
                    isMulCurrency = account.getBoolean("ismulcurrency");
                } else {
                    boolean bl = isMulCurrency = !account.getBoolean("isbycurrency");
                }
                if (!isMulCurrency) {
                    Object[] arrObj = new Object[]{account.getLong("defaultcurrency.id")};
                    this.getModel().setValue("currency", (Object)arrObj);
                } else {
                    this.getModel().setValue("currency", null);
                }
            } else {
                this.getModel().setValue("currency", null);
            }
        } else if ("periodtype".equals(name)) {
            if ("false".equals(this.getPageCache().get("isPeriodTypeSame"))) {
                this.getModel().setValue("beginperiod", null);
                this.getModel().setValue("endperiod", null);
            }
        } else if ("beginperiod".equals(name)) {
            this.synPeriod(true);
        } else if ("endperiod".equals(name)) {
            this.synPeriod(false);
        }
    }

    private void dateTypeChg(String dateType) {
        if (dateType == null || StringUtils.isBlank((CharSequence)dateType)) {
            return;
        }
        if (1 == Integer.parseInt(dateType)) {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"begindate", "enddate"});
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"beginperiod", "endperiod"});
            if ("false".equals(this.getPageCache().get("isPeriodTypeSame"))) {
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"periodtype"});
                this.getModel().setValue("periodtype", null);
            }
        } else {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"begindate", "enddate"});
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"beginperiod", "endperiod", "periodtype"});
        }
    }

    private void synPeriod(boolean isBeginPeriod) {
        Long beginperiod = Optional.ofNullable((DynamicObject)this.getModel().getValue("beginperiod")).map(v -> v.getLong("id")).orElse(0L);
        Long endperiod = Optional.ofNullable((DynamicObject)this.getModel().getValue("endperiod")).map(v -> v.getLong("id")).orElse(0L);
        if (beginperiod > 0L && endperiod == 0L) {
            this.getModel().setValue("endperiod", this.getModel().getValue("beginperiod"));
            return;
        }
        if (beginperiod == 0L && endperiod > 0L) {
            this.getModel().setValue("beginperiod", this.getModel().getValue("endperiod"));
            return;
        }
        if (beginperiod > endperiod) {
            if (isBeginPeriod) {
                this.getModel().setValue("endperiod", this.getModel().getValue("beginperiod"));
            } else {
                this.getModel().setValue("beginperiod", this.getModel().getValue("endperiod"));
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.getValue("org");
            if (org == null || org.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"JournalBaseFormRpt_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            int datetype = filterInfo.getInt("datetype");
            if (datetype == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"JournalBaseFormRpt_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (filterInfo.getInt("datetype") == 1) {
                DynamicObject periodType = filterInfo.getDynamicObject("periodtype");
                if (periodType == null && "false".equals(this.getPageCache().get("isPeriodTypeSame"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u56e0\u4e3a\u9009\u4e2d\u7684\u591a\u4e2a\u7ec4\u7ec7\u671f\u95f4\u7c7b\u578b\u4e0d\u540c\uff0c\u8bf7\u9009\u62e9\u9002\u5f53\u7684\u671f\u95f4\u7c7b\u578b\u3002", (String)"JournalBaseFormRpt_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                DynamicObject beginPeriod = filterInfo.getDynamicObject("beginperiod");
                if (beginPeriod == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"JournalBaseFormRpt_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                DynamicObject endPeriod = filterInfo.getDynamicObject("endperiod");
                if (endPeriod == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"JournalBaseFormRpt_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                if (endPeriod.getLong("id") < beginPeriod.getLong("id")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"JournalBaseFormRpt_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
            } else {
                Date beginDate = filterInfo.getDate("begindate");
                Date endDate = filterInfo.getDate("enddate");
                if (beginDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"JournalBaseFormRpt_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                if (endDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"JournalBaseFormRpt_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
                if (beginDate.after(endDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"JournalBaseFormRpt_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
            }
            return super.verifyQuery(queryParam);
        }
        return false;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String dataType = this.getModel().getValue("datetype").toString();
        if ("2".equals(dataType)) {
            FilterInfo filterInfo = queryParam.getFilter();
            FilterItemInfo beginItem = filterInfo.getFilterItem("begindate");
            Date beginDate = (Date)this.getModel().getValue("begindate");
            beginItem.setValue((Object)DateUtils.getDataFormat((Date)beginDate, (boolean)true));
            FilterItemInfo endItem = filterInfo.getFilterItem("enddate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            endItem.setValue((Object)DateUtils.getDataFormat((Date)endDate, (boolean)false));
        }
        JournalPrintHelper.setLeftNoteCacheKey(this.getView().getPageId(), queryParam);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        ReportQueryParam queryParam = event.getQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        if (!filterInfo.getBoolean("iscombine")) {
            List columns = event.getColumns();
            for (int i = columns.size() - 1; i >= 0; --i) {
                ReportColumn column = (ReportColumn)columns.get(i);
                if (!"orgname".equals(column.getFieldKey())) continue;
            }
        }
        super.afterCreateColumn(event);
    }

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridId, rowData, queryParam);
        if (rowData.size() > 0) {
            ArrayList<DynamicObject> journalData = new ArrayList<DynamicObject>();
            String radioGroup = (String)queryParam.getFilter().getFilterItem("radiogroup").getValue();
            for (int i = 0; i < rowData.size(); ++i) {
                DynamicObject row = (DynamicObject)rowData.get(i);
                if ("cas_bankjournal".equals(this.journalEntity)) {
                    if (row.getInt("source") == 1 || row.getInt("source") == 3) {
                        row.set("batchno", (Object)"");
                    }
                    if (row.getLong("sourcebillid") == 0L) {
                        row.set("sourcebillid", (Object)"");
                    }
                }
                if (row.getInt("datatype") == 3) {
                    if (row.getBigDecimal("actualbalance").compareTo(BigDecimal.ZERO) > 0) {
                        row.set("direction", (Object)SOURCE_ONE);
                    } else if (row.getBigDecimal("actualbalance").compareTo(BigDecimal.ZERO) < 0) {
                        row.set("direction", (Object)"2");
                    } else {
                        row.set("direction", (Object)SOURCE_THREE);
                    }
                    journalData.add(row);
                }
                if (SOURCE_ONE.equals(radioGroup)) {
                    row.set("actualbalance", (Object)row.getBigDecimal("actualbalance").abs());
                }
                if (!"2".equals(radioGroup) || !"2".equals(row.get("direction"))) continue;
                row.set("direction", (Object)SOURCE_ONE);
            }
            VoucherBookService voucherBookService = new VoucherBookService();
            Map voucherNumbers = voucherBookService.getSourceNumbers(journalData, this.journalEntity);
            for (DynamicObject journal : journalData) {
                SourceNumber voucherNumber = (SourceNumber)voucherNumbers.get(journal);
                if (voucherNumber == null) continue;
                journal.set("voucherno", (Object)voucherNumber.getVoucherNo());
                journal.set("sourcebillnumber", (Object)voucherNumber.getBillno());
            }
        }
    }

    protected abstract QFilter[] getAcctFilter(List<Long> var1);

    protected boolean containsClosed() {
        return (Boolean)this.getModel().getValue("iscontainclosed");
    }

    protected void orgChange(DynamicObjectCollection orgs) {
        this.getModel().setValue(this.acctControlName, null);
        this.getModel().setValue("currency", null);
        boolean isPeriodTypeSame = true;
        long orgId = 0L;
        if (orgs != null && orgs.size() > 0) {
            DynamicObject currentPeriod;
            DynamicObject initObj;
            long tempTypeId = 0L;
            for (int i = 0; i < orgs.size(); ++i) {
                orgId = (Long)((DynamicObject)orgs.get(i)).getDynamicObject("fbasedataid").getPkValue();
                long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
                if (i == 0) {
                    tempTypeId = periodTypeId;
                    continue;
                }
                if (tempTypeId == periodTypeId) continue;
                isPeriodTypeSame = false;
                break;
            }
            if (orgs.size() == 1 && (initObj = PeriodHelper.getCasInitInfo((long)((Long)((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid").getPkValue()))) != null && (currentPeriod = initObj.getDynamicObject("currentperiod")) != null) {
                this.getModel().setValue("beginperiod", currentPeriod.getPkValue());
                this.getModel().setValue("endperiod", currentPeriod.getPkValue());
                this.getModel().setValue("begindate", (Object)currentPeriod.getDate("begindate"));
                this.getModel().setValue("enddate", (Object)currentPeriod.getDate("enddate"));
            }
            if (isPeriodTypeSame) {
                ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"periodtype"});
                this.getPageCache().put("isPeriodTypeSame", "true");
                this.getModel().setValue("periodtype", (Object)PeriodHelper.getPeriodTypeId((long)orgId));
            } else {
                String dataType = this.getModel().getValue("datetype").toString();
                this.getPageCache().put("isPeriodTypeSame", "false");
                if (SOURCE_ONE.equals(dataType)) {
                    ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"periodtype"});
                    this.getModel().setValue("periodtype", null);
                }
            }
        } else {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"periodtype"});
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("periodtype", null);
        }
    }

    private List<Long> getIdList(DynamicObjectCollection coll) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            idList.add((Long)((DynamicObject)coll.get(i)).getDynamicObject("fbasedataid").getPkValue());
        }
        return idList;
    }

    protected void openManualJournalNewViewBy(String formId) {
        DynamicObjectCollection orgs = this.getOrgs();
        ArrayList orgList = new ArrayList(orgs.size());
        orgs.forEach(org -> {
            DynamicObject currOrg = (DynamicObject)org.get(1);
            orgList.add(currOrg.getLong("id"));
        });
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(formId);
        billShowParameter.setCustomParam("filtersCacheOrgsKey", orgList);
        billShowParameter.setCustomParam("filtersCacheCONTAINKey", (Object)this.containsClosed());
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("confirm_del".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            String cacheStr = this.getPageCache().get("ManualJournalSelectRow");
            if (CasHelper.isEmpty((Object)cacheStr)) {
                return;
            }
            List listIds = (List)SerializationUtils.fromJsonString((String)cacheStr, List.class);
            if (listIds == null || listIds.size() == 0) {
                return;
            }
            OperationResult del = OperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)this.journalEntity, (Object[])listIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            if (del.isSuccess()) {
                this.refreshReport();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"JournalBaseFormRpt_20", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                List successPkIds = del.getSuccessPkIds();
                if (successPkIds != null && successPkIds.size() > 0) {
                    this.refreshReport();
                }
                CasHelper.showOperationResultMulti((OperationResult)del, (String)("cas_bankjournal".equals(this.journalEntity) ? ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26", (String)"JournalBaseFormRpt_21", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u73b0\u91d1\u65e5\u8bb0\u8d26", (String)"JournalBaseFormRpt_22", (String)"fi-cas-formplugin", (Object[])new Object[0])), (IFormView)this.getView());
            }
        }
    }

    private void refreshReport() {
        TreeView tree = (TreeView)this.getControl("reporttreeap");
        List selectedNodeIds = tree.getTreeState().getSelectedNodeId();
        tree.treeNodeClick("", (String)selectedNodeIds.get(0));
    }

    protected void confirmDelete(ReportList reportList, int[] rowKeys) {
        this.getPageCache().remove("ManualJournalSelectRow");
        if (rowKeys == null || rowKeys.length < 1) {
            return;
        }
        ArrayList<Long> listIds = new ArrayList<Long>(rowKeys.length);
        for (int rowKey : rowKeys) {
            DynamicObject row = reportList.getReportModel().getRowData(rowKey);
            if (row == null || CasHelper.isEmpty((Object)row.get("id"))) continue;
            listIds.add(row.getLong("id"));
        }
        if (listIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"JournalBaseFormRpt_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!listIds.isEmpty()) {
            this.getPageCache().put("ManualJournalSelectRow", SerializationUtils.toJsonString(listIds));
        }
        if (this.checkBatchNo(listIds)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"JournalBaseFormRpt_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirm_del", (IFormPlugin)this));
        } else {
            FormShowParameter showPara = new FormShowParameter();
            showPara.setFormId("cas_manualjouranl_del");
            showPara.setCustomParam("sum", (Object)this.getPageCache().get("sum"));
            showPara.getOpenStyle().setShowType(ShowType.Modal);
            showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_manualjouranl_del"));
            this.getView().showForm(showPara);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("cas_manualjouranl_del".equals(actionId)) {
            Object returnData = event.getReturnData();
            if (returnData != null) {
                String ret = String.valueOf(returnData);
                this.deleteByReturn(ret);
            }
        } else if ("del_batchNo".equals(actionId)) {
            this.refreshReport();
        }
    }

    public void deleteByReturn(String selectType) {
        if (CasHelper.isEmpty((Object)selectType)) {
            return;
        }
        switch (selectType) {
            case "1": {
                this.deleteSelectRows();
                break;
            }
            case "2": {
                this.deleteByBatchNo();
                break;
            }
            case "3": {
                this.deleteToList();
            }
        }
    }

    public void deleteToList() {
        String cacheStr = this.getPageCache().get("batchNo");
        if (CasHelper.isEmpty((Object)cacheStr)) {
            return;
        }
        Set batchNos = (Set)SerializationUtils.fromJsonString((String)cacheStr, Set.class);
        if (batchNos != null && batchNos.size() > 0) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(this.journalEntity);
            showParameter.setCustomParam("batchNos", (Object)"batchNos");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
            QFilter filter = new QFilter("batchno", "in", (Object)batchNos);
            filters.add(filter);
            showParameter.getListFilterParameter().setQFilters(filters);
            showParameter.setCustomParam("delete", (Object)true);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "del_batchNo"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void deleteByBatchNo() {
        DynamicObject[] journals;
        String cacheStr = this.getPageCache().get("batchNo");
        if (CasHelper.isEmpty((Object)cacheStr)) {
            return;
        }
        Set batchNos = (Set)SerializationUtils.fromJsonString((String)cacheStr, Set.class);
        if (batchNos != null && batchNos.size() > 0 && (journals = BusinessDataServiceHelper.load((String)this.journalEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("batchno", "in", (Object)batchNos)})) != null && journals.length > 0) {
            List idList = CasHelper.getIdList((DynamicObject[])journals);
            OperationResult del = OperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)this.journalEntity, (Object[])idList.toArray(new Long[0]), (OperateOption)OperateOption.create());
            if (del.isSuccess()) {
                this.refreshReport();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"JournalBaseFormRpt_20", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                List successPkIds = del.getSuccessPkIds();
                if (successPkIds != null && successPkIds.size() > 0) {
                    this.refreshReport();
                }
                CasHelper.showOperationResultMulti((OperationResult)del, (String)("cas_bankjournal".equals(this.journalEntity) ? ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26", (String)"JournalBaseFormRpt_21", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u73b0\u91d1\u65e5\u8bb0\u8d26", (String)"JournalBaseFormRpt_22", (String)"fi-cas-formplugin", (Object[])new Object[0])), (IFormView)this.getView());
            }
        }
    }

    public void deleteSelectRows() {
        String cacheStr = this.getPageCache().get("ManualJournalSelectRow");
        if (CasHelper.isEmpty((Object)cacheStr)) {
            return;
        }
        List listIds = (List)SerializationUtils.fromJsonString((String)cacheStr, List.class);
        if (listIds != null && listIds.size() > 0) {
            OperationResult del = OperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)this.journalEntity, (Object[])listIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            if (del.isSuccess()) {
                this.refreshReport();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"JournalBaseFormRpt_20", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                List successPkIds = del.getSuccessPkIds();
                if (successPkIds != null && successPkIds.size() > 0) {
                    this.refreshReport();
                }
                CasHelper.showOperationResultMulti((OperationResult)del, (String)("cas_bankjournal".equals(this.journalEntity) ? ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26", (String)"JournalBaseFormRpt_21", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u73b0\u91d1\u65e5\u8bb0\u8d26", (String)"JournalBaseFormRpt_22", (String)"fi-cas-formplugin", (Object[])new Object[0])), (IFormView)this.getView());
            }
        }
    }

    public boolean checkBatchNo(List<Long> listIds) {
        DynamicObject[] dbRows;
        this.getPageCache().put("sum", "0");
        this.getPageCache().put("batchNo", "");
        if (listIds == null || listIds.size() == 0) {
            return true;
        }
        HashSet<String> batchNos = new HashSet<String>(listIds.size());
        Boolean check = true;
        if (listIds != null && listIds.size() > 0 && (dbRows = BusinessDataServiceHelper.load((String)this.journalEntity, (String)"id,batchno,source", (QFilter[])new QFilter[]{new QFilter("id", "in", listIds)})) != null && dbRows.length > 0) {
            for (DynamicObject row : dbRows) {
                if (!kd.fi.cas.util.StringUtils.equalAllValues((String)row.getString("source"), (String[])new String[]{SOURCE_ONE, SOURCE_THREE, SOURCE_FIVE}).booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u522a\u9664\u624b\u5de5\u5f55\u5165/\u6807\u51c6\u5bfc\u5165/\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u65e5\u8bb0\u8d26\u6570\u636e\u3002", (String)"JournalBaseFormRpt_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                String batchno = row.getString("batchno");
                batchNos.add(batchno);
            }
            DynamicObjectCollection rows = QueryServiceHelper.query((String)this.journalEntity, (String)"id,batchno", (QFilter[])new QFilter[]{new QFilter("batchno", "in", batchNos)});
            if (rows != null && rows.size() > listIds.size()) {
                check = false;
                this.getPageCache().put("sum", String.valueOf(rows.size()));
            }
        }
        this.getPageCache().put("batchNo", SerializationUtils.toJsonString(batchNos));
        return check;
    }

    private void showNewItemBy(DynamicObjectCollection orgs) {
        if (orgs == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_DEL_MANUAL, BAR_NEW_MANUAL});
            return;
        }
        boolean isManual = ManualJournalHelper.isManualJournalMode((DynamicObjectCollection)orgs);
        this.getView().setVisible(Boolean.valueOf(isManual), new String[]{BAR_DEL_MANUAL, BAR_NEW_MANUAL});
    }

    private DynamicObjectCollection getOrgs() {
        Object orgObjects = this.getModel().getValue("org");
        if (orgObjects instanceof DynamicObjectCollection) {
            return (DynamicObjectCollection)orgObjects;
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection orgs = this.getOrgs();
        this.showNewItemBy(orgs);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        JournalPrintHelper.clearLeftNoteCache(this.getView().getPageId());
    }
}

