/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalances;
import kd.fi.cas.business.balancemodel.service.BalanceDataService;
import kd.fi.cas.business.balancemodel.service.balance.BalanceQueryType;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.param.JournalParam;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class JournalRptHandleByPeriod {
    private static Log logger = LogFactory.getLog(JournalRptHandleByPeriod.class);
    protected JournalParam param;

    public JournalRptHandleByPeriod(JournalParam param) {
        this.param = param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BigDecimal> getBeginPeriodData() {
        HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>(4);
        BigDecimal beginBalance = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((DynamicObject)this.param.getBeginPeriod())) {
            DynamicObjectCollection resultColl = QueryServiceHelper.query((String)"cas.getjournalbalance", (String)"cas_journalbalance", (String)"id,monthstart", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.param.getOrgid()), new QFilter("currency", "=", (Object)this.param.getCurrencyid()), new QFilter(this.param.getAcctPropertyName(), "=", (Object)this.param.getAcctid()), new QFilter("period", "=", (Object)this.param.getBeginPeriod().getLong("id")), new QFilter("type", "=", (Object)this.param.getType())}, null, (int)1);
            if (resultColl != null && resultColl.size() > 0) {
                DynamicObject result = (DynamicObject)resultColl.get(0);
                beginBalance = result.getBigDecimal("monthstart");
            } else if (PeriodHelper.after((DynamicObject)this.param.getBeginPeriod(), (DynamicObject)this.param.getCurrentPeriod())) {
                DynamicObjectCollection currentRes = QueryServiceHelper.query((String)"cas.getjournalbalance", (String)"cas_journalbalance", (String)"id,monthstart", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.param.getOrgid()), new QFilter("currency", "=", (Object)this.param.getCurrencyid()), new QFilter(this.param.getAcctPropertyName(), "=", (Object)this.param.getAcctid()), new QFilter("period", "=", (Object)this.param.getCurrentPeriod().getLong("id")), new QFilter("type", "=", (Object)this.param.getType())}, null, (int)1);
                DynamicObject result = currentRes != null && currentRes.size() > 0 ? (DynamicObject)currentRes.get(0) : null;
                beginBalance = result == null ? BigDecimal.ZERO : result.getBigDecimal("monthstart");
                try (DataSet resultSet = null;){
                    resultSet = QueryServiceHelper.queryDataSet((String)"cas.getBeginYearData", (String)this.param.getJournalEntity(), (String)"debitamount,creditamount,1 as group", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.param.getOrgid()), new QFilter("currency", "=", (Object)this.param.getCurrencyid()), new QFilter(this.param.getAcctPropertyName(), "=", (Object)this.param.getAcctid()), new QFilter("bookdate", ">=", this.param.getCurrentPeriod().get("begindate")), new QFilter("bookdate", "<", this.param.getBeginPeriod().get("begindate"))}, null);
                    resultSet = resultSet.groupBy(new String[]{"group"}).sum("creditamount").sum("debitamount").finish();
                    Iterator it = resultSet.iterator();
                    if (it.hasNext()) {
                        Row row = (Row)it.next();
                        beginBalance = beginBalance.add(row.getBigDecimal("debitamount").subtract(row.getBigDecimal("creditamount")));
                    }
                }
            }
        }
        data.put("beginBalance", beginBalance);
        return data;
    }

    public Map<String, BigDecimal> getBeginPeriodDataByBalanceModel() {
        HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>(4);
        BigDecimal beginBalance = BigDecimal.ZERO;
        try {
            Date startDate = this.param.getBeginPeriod().getDate("begindate");
            Date endDate = this.param.getEndPeriod().getDate("enddate");
            Balance balance = this.getBalance(startDate, endDate);
            if (balance != null) {
                beginBalance = balance.getMonthStart();
            }
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
        }
        data.put("beginBalance", beginBalance);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Map<String, BigDecimal> getBeginYearData() {
        data = new HashMap<String, BigDecimal>();
        yearBeginDebitAmt = this.param.getYearBeginDebitAmt();
        yearBeginCreditAmt = this.param.getYearBeginCreditAmt();
        beginPeriod = this.param.getBeginPeriod();
        currentPeriod = this.param.getCurrentPeriod();
        if (EmptyUtil.isNoEmpty((DynamicObject)beginPeriod)) {
            resultColl = QueryServiceHelper.query((String)"cas.getBeginYearData", (String)"cas_journalbalance", (String)"id,yeardebit,yearcredit", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.param.getOrgid()), new QFilter("currency", "=", (Object)this.param.getCurrencyid()), new QFilter(this.param.getAcctPropertyName(), "=", (Object)this.param.getAcctid()), new QFilter("period", "=", (Object)beginPeriod.getLong("id")), new QFilter("type", "=", (Object)this.param.getType())}, null, (int)1);
            if (beginPeriod.getLong("id") != currentPeriod.getLong("id")) {
                if (resultColl != null && resultColl.size() > 0) {
                    result = (DynamicObject)resultColl.get(0);
                    yearBeginDebitAmt = yearBeginDebitAmt.add(result.getBigDecimal("yeardebit"));
                    yearBeginCreditAmt = yearBeginCreditAmt.add(result.getBigDecimal("yearcredit"));
                    resultSet = null;
                    try {
                        resultSet = QueryServiceHelper.queryDataSet((String)"cas.getBeginYearData", (String)this.param.getJournalEntity(), (String)"debitamount,creditamount,1 as group", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.param.getOrgid()), new QFilter("currency", "=", (Object)this.param.getCurrencyid()), new QFilter(this.param.getAcctPropertyName(), "=", (Object)this.param.getAcctid()), new QFilter("bookdate", ">=", beginPeriod.get("begindate")), new QFilter("bookdate", "<", (Object)DateUtils.getNextDay((Date)DateUtils.getDataFormat((Date)beginPeriod.getDate("enddate"), (boolean)true), (int)1)), new QFilter("period", "!=", (Object)0L)}, null);
                        if (resultSet == null || !(it = (resultSet = resultSet.groupBy(new String[]{"group"}).sum("creditamount").sum("debitamount").finish()).iterator()).hasNext()) ** GOTO lbl33
                        row = (Row)it.next();
                        yearBeginDebitAmt = yearBeginDebitAmt.subtract(row.getBigDecimal("debitamount"));
                        yearBeginCreditAmt = yearBeginCreditAmt.subtract(row.getBigDecimal("creditamount"));
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                } else {
                    yearData = this.calYearAmt(beginPeriod, currentPeriod, yearBeginDebitAmt, yearBeginCreditAmt);
                    yearBeginDebitAmt = yearData.get("yearBeginDebitAmt");
                    yearBeginCreditAmt = yearData.get("yearBeginCreditAmt");
                }
            } else if (resultColl != null && resultColl.size() > 0) {
                result = (DynamicObject)resultColl.get(0);
                yearBeginDebitAmt = yearBeginDebitAmt.add(result.getBigDecimal("yeardebit"));
                yearBeginCreditAmt = yearBeginCreditAmt.add(result.getBigDecimal("yearcredit"));
            }
        }
lbl33:
        // 8 sources

        data.put("yearBeginDebitAmt", yearBeginDebitAmt);
        data.put("yearBeginCreditAmt", yearBeginCreditAmt);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BigDecimal> calYearAmt(DynamicObject beginPeriod, DynamicObject currentPeriod, BigDecimal yearBeginDebitAmt, BigDecimal yearBeginCreditAmt) {
        HashMap<String, BigDecimal> resultData = new HashMap<String, BigDecimal>(2);
        Date largeDate = currentPeriod.getDate("begindate");
        Date lessDate = beginPeriod.getDate("begindate");
        if (DateUtils.isSameYear((Date)lessDate, (Date)largeDate)) {
            DynamicObjectCollection balanceResult = QueryServiceHelper.query((String)"cas.getBeginYearData", (String)"cas_journalbalance", (String)"id,yeardebit,yearcredit", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.param.getOrgid()), new QFilter("currency", "=", (Object)this.param.getCurrencyid()), new QFilter(this.param.getAcctPropertyName(), "=", (Object)this.param.getAcctid()), new QFilter("period", "=", (Object)currentPeriod.getLong("id")), new QFilter("type", "=", (Object)this.param.getType())}, null, (int)1);
            if (balanceResult != null && balanceResult.size() > 0) {
                DynamicObject result = (DynamicObject)balanceResult.get(0);
                yearBeginDebitAmt = yearBeginDebitAmt.add(result.getBigDecimal("yeardebit"));
                yearBeginCreditAmt = yearBeginCreditAmt.add(result.getBigDecimal("yearcredit"));
            }
        } else {
            largeDate = DateUtils.getYearFirst((int)DateUtils.getYear((Date)beginPeriod.getDate("begindate")));
        }
        try (DataSet journalSet = null;){
            Iterator it;
            journalSet = QueryServiceHelper.queryDataSet((String)"cas.getBeginYearData", (String)this.param.getJournalEntity(), (String)"debitamount,creditamount,1 as group", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.param.getOrgid()), new QFilter("currency", "=", (Object)this.param.getCurrencyid()), new QFilter(this.param.getAcctPropertyName(), "=", (Object)this.param.getAcctid()), new QFilter("bookdate", ">=", (Object)largeDate), new QFilter("bookdate", "<", (Object)lessDate), new QFilter("period", "!=", (Object)0L)}, null);
            if (journalSet != null && (it = (journalSet = journalSet.groupBy(new String[]{"group"}).sum("creditamount").sum("debitamount").finish()).iterator()).hasNext()) {
                Row row = (Row)it.next();
                yearBeginDebitAmt = yearBeginDebitAmt.add(row.getBigDecimal("debitamount"));
                yearBeginCreditAmt = yearBeginCreditAmt.add(row.getBigDecimal("creditamount"));
            }
        }
        resultData.put("yearBeginDebitAmt", yearBeginDebitAmt);
        resultData.put("yearBeginCreditAmt", yearBeginCreditAmt);
        return resultData;
    }

    public BigDecimal getYearBeginBalance() {
        BigDecimal yearBeginBalance = BigDecimal.ZERO;
        DynamicObjectCollection resultColl = QueryServiceHelper.query((String)"cas.getYearBeginBalance", (String)"cas_journalbalance", (String)"id,yearstart", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.param.getOrgid()), new QFilter("currency", "=", (Object)this.param.getCurrencyid()), new QFilter(this.param.getAcctPropertyName(), "=", (Object)this.param.getAcctid()), new QFilter("period", "=", (Object)this.param.getStartPeriod().getLong("id")), new QFilter("type", "=", (Object)this.param.getType())}, null, (int)1);
        if (resultColl != null && resultColl.size() > 0) {
            DynamicObject result = (DynamicObject)resultColl.get(0);
            yearBeginBalance = result.getBigDecimal("yearstart");
        }
        return yearBeginBalance;
    }

    private Balance getBalance(Date startDate, Date endDate) throws Exception {
        if (EmptyUtil.isEmpty((DynamicObject)this.param.getBeginPeriod()) || EmptyUtil.isEmpty((DynamicObject)this.param.getEndPeriod())) {
            return null;
        }
        try {
            Long orgId = this.param.getOrgid();
            Long accountId = this.param.getAcctid();
            Long currencyId = this.param.getCurrencyid();
            RequestBalanceParameter requestBalanceParameter = new RequestBalanceParameter();
            requestBalanceParameter.setOrgIds(Collections.singleton(orgId));
            requestBalanceParameter.setAccountIds(Collections.singleton(accountId));
            requestBalanceParameter.setCurrencyIds(Collections.singleton(currencyId));
            requestBalanceParameter.setStartDate(startDate);
            requestBalanceParameter.setEndDate(endDate);
            requestBalanceParameter.setType(this.param.getType());
            List balances = BalanceDataService.getInstance().getBalances(Collections.singletonList(requestBalanceParameter), BalanceQueryType.BEGINDATE);
            if (balances != null && balances.size() > 0) {
                ResponseBalances responseBalance = (ResponseBalances)balances.get(0);
                return responseBalance.getBalance();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            throw e;
        }
    }
}

