/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.info.SCAccountInfo;
import kd.fi.cas.util.ViewUtils;

public class MatchingRuleEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static boolean orgChange = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"customer"});
        this.addClickListeners(new String[]{"payaccount"});
        this.initF7();
    }

    private void initF7() {
        this.fillAccountBank();
    }

    private void fillAccountBank() {
        BasedataEdit accountbank = (BasedataEdit)this.getControl("accountbank");
        accountbank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setIsolationOrg(false);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                QFilter[] usableAccountFilter = AccountBankHelper.getUsableAccountFilter((long)((Long)org.getPkValue()));
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(usableAccountFilter));
            } else {
                showParameter.getListFilterParameter().setFilter(AccountBankHelper.getUsableFilter());
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("customer".equals(key)) {
            BasedataEdit control = (BasedataEdit)this.getControl("customerf7");
            control.click();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW) || status.equals((Object)OperationStatus.EDIT) && orgChange) {
            this.getAcctByOrg();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String bizType = (String)this.getModel().getValue("businesstype");
        this.bizTypeChanged(bizType);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "org": {
                orgChange = true;
                break;
            }
            case "customerf7": {
                this.customerChanged(newValue);
                break;
            }
            case "businesstype": {
                this.bizTypeChanged((String)newValue);
            }
        }
    }

    private void bizTypeChanged(String bizType) {
        if ("REC".equals(bizType)) {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"rectype"});
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"paytype"});
        } else {
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)false, (String[])new String[]{"rectype"});
            ViewUtils.setVisible((AbstractFormPlugin)this, (boolean)true, (String[])new String[]{"paytype"});
        }
    }

    private void customerChanged(Object newValue) {
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject customer = (DynamicObject)newValue;
        if (customer != null) {
            this.getModel().setValue("customer", (Object)customer.getString("name"), currentIndex);
            boolean isInternal = BaseDataHelper.getInternalOrg((DynamicObject)((DynamicObject)this.getModel().getValue("org")), (DynamicObject)customer) != null;
            this.getModel().setValue("isinternal", (Object)isInternal, currentIndex);
            SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)customer);
            if (defaultBankInfo != null) {
                this.getModel().setValue("payaccount", (Object)defaultBankInfo.getAccount(), currentIndex);
            }
        } else {
            this.getModel().setValue("payaccount", null, currentIndex);
        }
    }

    private void getAcctByOrg() {
        Long orgId;
        DynamicObject defaultPayAccount;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && (defaultPayAccount = AccountBankHelper.getDefaultPayAccount((Long)(orgId = (Long)org.getPkValue()))) != null) {
            this.getModel().setValue("accountbank", defaultPayAccount.get("id"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        if ("save".equals(key)) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            if (collection != null && collection.size() != 0) {
                for (DynamicObject obj : collection) {
                    DynamicObject ffi = obj.getDynamicObject("fundflowitem");
                    if (ffi != null) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u4e2d\u7684\u8d44\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"MatchingRuleEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    args.cancel = true;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u3002", (String)"MatchingRuleEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.cancel = true;
            }
            Object enable = this.getModel().getValue("enable");
            if (enable.equals("0")) {
                this.getModel().setValue("enable", (Object)"1");
                this.getModel().setValue("expirationdate", null);
                this.getModel().setValue("effectivedate", (Object)new Date());
            }
        }
    }
}

