/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.opservice.helper.PaymentPayeeInfo;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AsstActTypeAddressEnum;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.helper.DynamicListHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.info.SCAccountInfo;
import kd.fi.cas.util.EmptyUtil;
import kd.sdk.fi.cas.extpoint.paybill.IPayeeBankInfoFilter;

public class PayeeInfoEdit
extends DynamicFormPlugin {
    public static final String ER_PAYEER = "er_payeer";
    private boolean isSelectAcctBankF7 = false;
    private boolean isSelectBankF7 = false;
    private boolean isSelectErpayeef7F7 = false;
    private static String[] temp = new String[]{"normal", "freeze", "closing", "changing"};
    private static final Log LOGGER = LogFactory.getLog(PayeeInfoEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.initF7();
        TextEdit payeebanknum = (TextEdit)this.getView().getControl("payeebanknum");
        payeebanknum.addButtonClickListener((ClickListener)this);
        TextEdit payeebankname = (TextEdit)this.getView().getControl("payeebankname");
        payeebankname.addButtonClickListener((ClickListener)this);
    }

    private void initF7() {
        this.fillOrgF7();
        this.fillPayeeAcctBank();
        this.fillErPayeeF7();
        this.fillPayeeAcctCash();
    }

    private void fillOrgF7() {
        BasedataEdit orgF7;
        if (this.isCompany()) {
            orgF7 = (BasedataEdit)this.getControl("payee");
            orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                qFilter.and(new QFilter("fisbankroll", "=", (Object)"1"));
                showParameter.getListFilterParameter().setFilter(qFilter);
            });
        }
        if (this.isSupplier()) {
            orgF7 = (BasedataEdit)this.getControl("payee");
            orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("payhold", "=", (Object)"0"));
            });
        }
    }

    private void fillPayeeAcctBank() {
        BasedataEdit payeeAcctBankF7 = (BasedataEdit)this.getControl("payeeacctbankf7");
        payeeAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject currency;
            boolean virtual;
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            DynamicObject payee = this.getDynamicObject("payee");
            if (this.isSupplier() || this.isCustomer()) {
                payee = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)payee);
            }
            QFilter[] accountFilter = null;
            if (payee != null) {
                if (this.isCompany() || this.isCustomer() || this.isSupplier()) {
                    accountFilter = new QFilter[2];
                    int i = 0;
                    long orgID = payee.getPkValue() == null ? 0L : Long.parseLong(payee.getPkValue().toString());
                    QFilter accountAuthAssignFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)orgID);
                    accountFilter[i++] = accountAuthAssignFilter;
                    parameter.setCustomParam("org", (Object)orgID);
                    QFilter qFilter = new QFilter("acctstatus", "in", (Object)temp);
                    accountFilter[i++] = qFilter;
                    if (parameter instanceof ListShowParameter) {
                        ((ListShowParameter)parameter).setUseOrgId(orgID);
                    }
                } else {
                    accountFilter = AccountBankHelper.getUsableAccountFilter((long)((Long)payee.getPkValue()));
                }
            } else if (this.isOther()) {
                accountFilter = AccountBankHelper.getUsableFilter().toArray();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"PayeeInfoEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
            Map paramMap = parameter.getCustomParams();
            if (paramMap.containsKey("virtual") && (virtual = ((Boolean)paramMap.get("virtual")).booleanValue())) {
                QFilter virtualQFilter = new QFilter("isvirtual", "=", (Object)"1");
                filters.add(virtualQFilter);
            }
            filters.addAll(Arrays.asList(accountFilter));
            IDataModel parentModel = this.getView().getParentView().getModel();
            DynamicObject billtype = (DynamicObject)parentModel.getValue("billtype");
            if (billtype != null && (BillTypeConstants.PAYBILL_SYN.equals(billtype.getPkValue()) || BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue()) || BillTypeConstants.PAYBILL_DCEP.equals(billtype.getPkValue())) && (currency = (DynamicObject)parentModel.getValue("currency")) != null) {
                filters.add(new QFilter("currency.fbasedataid.id", "=", (Object)currency.getLong("id")));
            }
            this.setDcepFilter(parentModel, filters);
            new LspWapper(beforeF7SelectEvent).setFilters(filters.toArray(new QFilter[0]));
        });
    }

    private void setDcepFilter(IDataModel parentModel, List<QFilter> filters) {
        DynamicObject settleType;
        boolean isDcep;
        String filterIsElec = "0";
        if (parentModel.getDataEntity().containsProperty("businesstype") && (isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)(settleType = (DynamicObject)parentModel.getValue("settletype"))))) {
            String businessType = (String)parentModel.getValue("businesstype");
            DynamicObject payAccBank = (DynamicObject)parentModel.getValue("payeracctbank");
            if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
                if (EmptyUtil.isNoEmpty((DynamicObject)payAccBank)) {
                    DynamicObjectCollection relatedsettleacct = payAccBank.getDynamicObjectCollection("relatedsettleacct");
                    List accId = relatedsettleacct.stream().map(o -> o.get("fbasedataid_id")).collect(Collectors.toList());
                    filters.add(new QFilter("id", "in", accId));
                }
            } else if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                if (EmptyUtil.isNoEmpty((DynamicObject)payAccBank)) {
                    filters.add(new QFilter("relatedsettleacct.fbasedataid.id", "=", payAccBank.getPkValue()));
                }
                filterIsElec = "1";
            }
            if (PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                String payeeType = (String)parentModel.getValue("payeetype");
                if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType) || AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType)) {
                    DynamicObject internalOrg;
                    DynamicObject payeeObj = (DynamicObject)this.getModel().getValue("payee");
                    if (EmptyUtil.isNoEmpty((DynamicObject)payeeObj) && EmptyUtil.isNoEmpty((DynamicObject)(internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)((DynamicObject)parentModel.getValue("org")), (DynamicObject)payeeObj)))) {
                        filterIsElec = "1";
                    }
                } else if (AsstActTypeEnum.COMPANY.getValue().equals(payeeType)) {
                    filterIsElec = "1";
                }
            }
        }
        filters.add(new QFilter("iselecpayment", "=", (Object)filterIsElec));
    }

    private void fillPayeeAcctCash() {
        BasedataEdit payeeacctcashf7 = (BasedataEdit)this.getControl("payeeacctcashf7");
        payeeacctcashf7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject currency;
            DynamicObject payee = this.getDynamicObject("payee");
            if (this.isSupplier() || this.isCustomer()) {
                payee = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)payee);
            }
            QFilter[] accountFilter = null;
            if (payee == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"PayeeInfoEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            accountFilter = AccountCashHelper.getUsableAccountFilter((Long)Long.valueOf(payee.getPkValue().toString()));
            ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
            filters.addAll(Arrays.asList(accountFilter));
            IDataModel parentModel = this.getView().getParentView().getModel();
            DynamicObject billtype = (DynamicObject)parentModel.getValue("billtype");
            if (billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue()) && (currency = (DynamicObject)parentModel.getValue("currency")) != null) {
                filters.add(new QFilter("currency.fbasedataid.id", "=", (Object)currency.getLong("id")));
            }
            new LspWapper(beforeF7SelectEvent).setFilters(filters.toArray(new QFilter[0]));
        });
    }

    private void fillErPayeeF7() {
        BasedataEdit erpayeeF7 = (BasedataEdit)this.getControl("erpayeef7");
        erpayeeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject user = this.getDynamicObject("payee");
            QFilter uFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
            if (user != null) {
                QFilter payerFilter = new QFilter("payer", "=", user.getPkValue());
                QFilter isemployeeFilter = new QFilter("isemployee", "=", (Object)Character.valueOf('1'));
                DynamicObjectCollection query = QueryServiceHelper.query((String)ER_PAYEER, (String)"id", (QFilter[])new QFilter[]{uFilter, payerFilter, isemployeeFilter});
                if (query.isEmpty()) {
                    uFilter = uFilter.and(new QFilter("name", "=", (Object)user.getLocaleString("name").getLocaleValue()));
                    uFilter.and(new QFilter("isemployee", "=", (Object)Character.valueOf('0')));
                    uFilter.and(new QFilter("enable", "=", (Object)"1"));
                } else {
                    uFilter = new QFilter("id", "in", (Object)query.stream().map(dy -> dy.get("id")).toArray());
                }
            }
            showParameter.getListFilterParameter().setFilter(uFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        IFormView parentView;
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map paramMap = parameter.getCustomParams();
        IDataModel model = this.getModel();
        this.setValue("org", paramMap.get("org"));
        String asstActType = (String)paramMap.get("asstActType");
        this.setValue("asstacttype", asstActType);
        boolean isBE = paramMap.get("isBE") == null ? false : (Boolean)paramMap.get("isBE");
        this.setValue("isbe", isBE);
        if (this.isOther()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"payee"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"payeename"});
            HashMap map = new HashMap();
            HashMap<String, Boolean> style = new HashMap<String, Boolean>();
            style.put("showEditButton", Boolean.FALSE);
            map.put("item", style);
            this.getView().updateControlMetadata("payeebanknum", map);
        }
        if ((parentView = this.getView().getParentView()) != null) {
            IDataModel parentModel = parentView.getModel();
            if (parameter.getStatus() != OperationStatus.ADDNEW) {
                DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    boolean isValue;
                    String propName = property.getName();
                    String asstacttype = (String)this.getModel().getValue("asstacttype");
                    if (parentModel.getProperty(propName) == null || !StringUtils.isNotBlank((CharSequence)asstacttype) || (isValue = "other".equals(asstacttype) && propName.equals("payee"))) continue;
                    this.setValue(propName, parentModel.getValue(propName));
                }
                this.setValue("bebankf7", parentModel.getValue("payeebank"));
                if (this.isCashOut()) {
                    this.setValue("payeeacctcashf7", this.getValue("payeeacctcash"));
                } else {
                    this.setValue("payeeacctbankf7", this.getValue("payeeacctbank"));
                }
                String sourceBillType = (String)parentModel.getValue("sourcebilltype");
                List<String> sourceBillTypes = Arrays.asList("ap_finapbill", "pm_purorderbill", "ap_payapply", "er_vehiclecheckingbill", "er_planecheckingbill", "er_hotelcheckingbill", "er_publicreimbursebill", "fca_transupbill", "cfm_repaymentbill", "cfm_interestbill", "lc_arrival", "pmct_paymentapply");
                if (sourceBillTypes.contains(sourceBillType) || "cas_paybill".equals(sourceBillType) && parentModel.getValue("applyorg") != null) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"payee", "payeename"});
                }
            }
            Object billtype = paramMap.get("billtype");
            boolean isShow = false;
            if (parentModel.getDataEntity().containsProperty("businesstype")) {
                String businessType = (String)parentModel.getValue("businesstype");
                isShow = PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType);
            }
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"institutioncode", "institutionname"});
            if (BillTypeConstants.PAYBILL_SYN.equals(billtype) || BillTypeConstants.PAYBILL_CASH.equals(billtype) || BillTypeConstants.PAYBILL_DCEP.equals(billtype)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"payee", "payeename"});
                this.changeStyle();
            } else if (BillTypeConstants.PAYBILL_SPAN.equals(billtype)) {
                this.changeStyle();
            }
            if (this.isCashOut()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"payeebankname"});
            }
        }
    }

    private void changeStyle() {
        HashMap map = new HashMap();
        HashMap<String, Boolean> style = new HashMap<String, Boolean>();
        style.put("eb", Boolean.FALSE);
        map.put("item", style);
        this.getView().updateControlMetadata("payeebanknum", map);
        HashMap map2 = new HashMap();
        HashMap<String, Boolean> style2 = new HashMap<String, Boolean>();
        style2.put("eb", Boolean.FALSE);
        style2.put("showEditButton", Boolean.FALSE);
        map2.put("item", style2);
        this.getView().updateControlMetadata("payeebankname", map2);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "payee": {
                int cs126 = BaseDataHelper.getCS126Param((DynamicObject)this.getDynamicObject("org"));
                if (this.isSupplier() || this.isCustomer()) {
                    if (cs126 != 3) {
                        this.supplierOrCustomerChanged((DynamicObject)newValue);
                        break;
                    }
                    this.setValue("payeebanknum", null);
                    this.setValue("recaccbankname", null);
                    this.setValue("bebankf7", null);
                    this.setValue("payeecurrency", null);
                    this.setValue("supplierBankId", null);
                }
                if (this.isUser()) {
                    this.userF7Changed((DynamicObject)newValue);
                    break;
                }
                if (!this.isCompany()) break;
                this.orgF7Changed((DynamicObject)newValue);
                break;
            }
            case "payeeacctbankf7": {
                this.payeeAcctBankF7Changed((DynamicObject)newValue);
                break;
            }
            case "payeeacctcashf7": {
                this.payeeAcctCashF7Changed((DynamicObject)newValue);
                break;
            }
            case "erpayeef7": {
                this.erPayeeF7Changed((DynamicObject)newValue);
                break;
            }
            case "payeebanknum": {
                this.payeeBankNumChanged((String)newValue);
                break;
            }
            case "bebankf7": {
                this.beBankF7Changed((DynamicObject)newValue);
                break;
            }
            case "payeebankname": {
                this.payeeBankNameChanged((String)newValue);
            }
        }
    }

    private void orgF7Changed(DynamicObject org) {
        if (this.isSelectAcctBankF7) {
            return;
        }
        this.setValue("payeeacctbankf7", null);
        this.setValue("payeeacctcashf7", null);
        this.setValue("payeeaccformid", null);
        this.setValue("payeebanknum", null);
        if (org != null) {
            DynamicObject defaultPayAccount = AccountBankHelper.getDefaultPayAccount((Long)((Long)org.getPkValue()));
            boolean setPayeeInfo = true;
            IDataModel parentModel = this.getView().getParentView().getModel();
            if (parentModel.getDataEntity().containsProperty("businesstype")) {
                DynamicObject settleType = (DynamicObject)parentModel.getValue("settletype");
                String businessType = (String)this.getView().getParentView().getModel().getValue("businesstype");
                boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
                if (EmptyUtil.isNoEmpty((DynamicObject)defaultPayAccount) && isDcep && (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) && !defaultPayAccount.getBoolean("iselecpayment")) {
                    setPayeeInfo = false;
                }
            }
            if (setPayeeInfo) {
                this.setValue("payeeacctbankf7", defaultPayAccount);
                this.setValue("payeeaccformid", "bd_accountbanks");
            }
        }
    }

    private void supplierOrCustomerChanged(DynamicObject basedata) {
        if (basedata == null) {
            this.setValue("payeebanknum", null);
            this.setValue("recaccbankname", null);
            this.setValue("bebankf7", null);
            this.setValue("payeecurrency", null);
            this.setValue("supplierBankId", null);
            return;
        }
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)basedata);
        if (internalOrg != null) {
            DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)internalOrg.getPkValue()));
            if (defaultRecAccount != null) {
                this.setValue("payeeaccformid", "bd_accountbanks");
                this.setValue("payeeacctbankf7", defaultRecAccount);
            } else {
                this.setValue("payeeaccformid", null);
                this.setValue("payeeacctbankf7", null);
                this.setValue("payeebanknum", null);
                this.setValue("recaccbankname", basedata.getLocaleString("name").getLocaleValue());
                this.setValue("bebankf7", null);
                this.setValue("payeecurrency", null);
            }
            this.setValue("supplierBankId", null);
        } else {
            SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)basedata);
            if (defaultBankInfo != null) {
                this.setValue("payeebanknum", defaultBankInfo.getAccount());
                String accountName = defaultBankInfo.getAccountName();
                if (CasHelper.isEmpty((Object)accountName)) {
                    this.setValue("recaccbankname", basedata.getLocaleString("name").getLocaleValue());
                } else {
                    this.setValue("recaccbankname", accountName);
                }
                this.setValue("bebankf7", defaultBankInfo.getBeBank());
                this.setValue("payeecurrency", defaultBankInfo.getCurrency() == null ? null : defaultBankInfo.getCurrency().getPkValue());
                this.setValue("supplierBankId", defaultBankInfo.getSupplierBankId());
            } else {
                this.setValue("payeebanknum", null);
                this.setValue("recaccbankname", basedata.getLocaleString("name").getLocaleValue());
                this.setValue("bebankf7", null);
                this.setValue("payeecurrency", null);
                this.setValue("supplierBankId", null);
            }
            this.setValue("payeeaccformid", null);
            this.setValue("payeeacctbankf7", null);
        }
    }

    private void userF7Changed(DynamicObject user) {
        if (this.isSelectErpayeef7F7) {
            return;
        }
        if (user == null) {
            this.setValue("erpayeef7", null);
            return;
        }
        DynamicObject erPayeeInfo = this.getErPayeeInfo(user.getLong("id"), user.getLocaleString("name").getLocaleValue());
        if (erPayeeInfo != null) {
            this.setValue("erpayeef7", erPayeeInfo);
        } else if (this.getValue("erpayeef7") != null) {
            this.setValue("erpayeef7", null);
        } else {
            this.setValue("payeebanknum", null);
            this.setValue("payeebankname", null);
        }
    }

    private DynamicObject getErPayeeInfo(long userId, String name) {
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("payer", "=", (Object)userId);
        uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')));
        uFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter[] qFilters = new QFilter[]{uFilter};
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number,payeraccountname";
        String orderBys = "isdefault desc";
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)ER_PAYEER, (String)selectFields, (QFilter[])qFilters, (String)orderBys, (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    private void payeeAcctBankF7Changed(DynamicObject acctBank) {
        this.setValue("supplierBankId", null);
        if (acctBank == null) {
            this.setValue("payeename", null);
            this.setValue("payeebankname", null);
            this.setValue("recaccbankname", null);
            this.setValue("recbanknumber", null);
            this.setValue("payeecurrency", null);
            this.setValue("bebankf7", null);
            this.setValue("reccountry", null);
            this.setValue("recprovince", null);
            this.setValue("reccity", null);
            return;
        }
        this.isSelectAcctBankF7 = true;
        this.setValue("payeeaccformid", "bd_accountbanks");
        PaymentPayeeInfo paymentPayeeInfo = PaymentPayeeInfo.createByAccountBank((DynamicObject)acctBank);
        this.setValue("payeebanknum", paymentPayeeInfo.getAccountNumber());
        this.setValue("payeebankname", paymentPayeeInfo.getBankName());
        this.setValue("recbanknumber", paymentPayeeInfo.getBankNumber());
        this.setValue("recaccbankname", paymentPayeeInfo.getPayeeRecName());
        this.setValue("reccountry", paymentPayeeInfo.getCountryId());
        this.setValue("recprovince", paymentPayeeInfo.getProvince());
        this.setValue("reccity", paymentPayeeInfo.getCity());
        this.setValue("bebankf7", paymentPayeeInfo.getBebankId());
        if (this.isOther()) {
            this.setValue("payeename", acctBank.getString("openorg.name"));
        }
        Long defaultCurrencyId = (Long)acctBank.get("defaultcurrency.id");
        this.setValue("payeecurrency", defaultCurrencyId);
        String institutioncode = DcepConverHelper.getInstitUtionCode((DynamicObject)acctBank);
        this.setValue("institutioncode", institutioncode);
        String institutionName = DcepConverHelper.getInstitutionName((DynamicObject)acctBank);
        this.setValue("institutionname", institutionName);
    }

    private void payeeAcctCashF7Changed(DynamicObject acctCash) {
        if (acctCash == null) {
            this.setValue("payeename", null);
            this.setValue("payeebankname", null);
            this.setValue("recaccbankname", null);
            this.setValue("recbanknumber", null);
            this.setValue("payeecurrency", null);
            this.setValue("bebankf7", null);
            this.setValue("reccountry", null);
            this.setValue("recprovince", null);
            this.setValue("reccity", null);
            return;
        }
        this.isSelectAcctBankF7 = true;
        this.setValue("payeeaccformid", "cas_accountcash");
        this.setValue("payeebanknum", acctCash.getString("number"));
        Long defaultCurrencyId = (Long)acctCash.get("defaultcurrency.id");
        this.setValue("payeecurrency", defaultCurrencyId);
    }

    private void erPayeeF7Changed(DynamicObject erPayee) {
        QFilter filter;
        DynamicObject[] users;
        if (erPayee == null) {
            this.setValue("payeebanknum", null);
            this.setValue("recaccbankname", null);
            this.setValue("bebankf7", null);
            return;
        }
        this.isSelectAcctBankF7 = true;
        DynamicObject user = this.getDynamicObject("payee");
        if (user == null && (users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, name, number", (QFilter[])new QFilter[]{filter = new QFilter("name", "=", (Object)erPayee.getString("name"))})) != null && users.length > 0) {
            this.isSelectErpayeef7F7 = true;
            this.setValue("payee", users[0]);
        }
        this.setValue("payeebanknum", erPayee.getString("payeraccount"));
        this.setValue("recaccbankname", erPayee.getString("payeraccountname"));
        this.setValue("bebankf7", erPayee.getDynamicObject("payerbank"));
    }

    private void payeeBankNumChanged(String newValue) {
        DynamicObject payeeAccountCash;
        if (this.isSelectAcctBankF7) {
            return;
        }
        if (newValue == null || StringUtils.isBlank((CharSequence)newValue)) {
            this.setValue("payeename", null);
            this.setValue("payeebankname", null);
            this.setValue("recaccbankname", null);
            this.setValue("supplierbankid", null);
        }
        if (Objects.equals("bd_accountbanks", this.getString("payeeaccformid"))) {
            DynamicObject payeeAccountBank = this.getDynamicObject("payeeacctbankf7");
            if (payeeAccountBank == null || !Objects.equals(payeeAccountBank.getString("bankaccountnumber"), newValue)) {
                this.getModel().beginInit();
                this.setValue("payeeaccformid", null);
                this.setValue("payeeacctbankf7", null);
                this.getModel().endInit();
                this.getView().updateView("payeeaccformid");
                this.getView().updateView("payeeacctbankf7");
            }
        } else if (Objects.equals("cas_accountcash", this.getString("payeeaccformid")) && ((payeeAccountCash = this.getDynamicObject("payeeacctcashf7")) == null || !Objects.equals(payeeAccountCash.getString("number"), newValue))) {
            this.getModel().beginInit();
            this.setValue("payeeaccformid", null);
            this.setValue("payeeacctcashf7", null);
            this.getModel().endInit();
            this.getView().updateView("payeeaccformid");
            this.getView().updateView("payeeacctcashf7");
        }
    }

    private void beBankF7Changed(DynamicObject beBank) {
        String payeeBankName = (String)this.getModel().getValue("payeebankname");
        if (beBank != null) {
            this.isSelectBankF7 = true;
            String cityTxt = beBank.getString("citytxt");
            String provinceTxt = beBank.getString("provincetxt");
            this.setValue("payeebankname", CasHelper.getLocalValue((DynamicObject)beBank, (String)"name"));
            this.setValue("recbanknumber", beBank.getString("union_number"));
            this.setValue("reccountry", beBank.get("country"));
            this.setValue("recprovince", provinceTxt);
            this.setValue("reccity", cityTxt);
        } else {
            if (StringUtils.isEmpty((CharSequence)payeeBankName)) {
                this.setValue("payeebankname", null);
            }
            this.setValue("recbanknumber", null);
            this.setValue("reccountry", null);
            this.setValue("recprovince", null);
            this.setValue("reccity", null);
        }
    }

    private void payeeBankNameChanged(String newValue) {
        if (this.isSelectBankF7) {
            return;
        }
        if (newValue != null && StringUtils.isNotBlank((CharSequence)newValue)) {
            QFilter qFilter = new QFilter("name", "=", (Object)newValue);
            qFilter = qFilter.and(new QFilter("enable", "=", (Object)"1"));
            QFilter[] qFilters = new QFilter[]{qFilter = qFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')))};
            DynamicObject[] colls = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id, name, number, basedatafield1", (QFilter[])qFilters);
            if (colls != null && colls.length > 0) {
                this.setValue("bebankf7", colls[0]);
            } else {
                this.setValue("bebankf7", null);
            }
        } else {
            this.setValue("bebankf7", null);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "payeebanknum": {
                if (this.isUser()) {
                    DynamicObject obj = this.getDynamicObject("payee");
                    if (obj == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"PayeeInfoEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    BasedataEdit erpayeef7 = (BasedataEdit)this.getControl("erpayeef7");
                    erpayeef7.click();
                    break;
                }
                if (this.isSupplier()) {
                    this.showBankInfoF7("supplier");
                    break;
                }
                if (this.isCustomer()) {
                    this.showBankInfoF7("customer");
                    break;
                }
                if (this.isCashOut()) {
                    BasedataEdit payeeacctcashf7 = (BasedataEdit)this.getControl("payeeacctcashf7");
                    payeeacctcashf7.click();
                    break;
                }
                BasedataEdit payeeacctbankf7 = (BasedataEdit)this.getControl("payeeacctbankf7");
                payeeacctbankf7.click();
                break;
            }
            case "payeebankname": {
                BasedataEdit bebankf7 = (BasedataEdit)this.getControl("bebankf7");
                bebankf7.click();
                break;
            }
            case "btnok": {
                this.btnOk();
            }
        }
    }

    private void showBankInfoF7(String f7type) {
        DynamicObject obj = this.getDynamicObject("payee");
        if (obj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"PayeeInfoEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)obj);
        int cs126 = BaseDataHelper.getCS126Param((DynamicObject)this.getDynamicObject("org"));
        if (internalOrg != null) {
            if (cs126 == 1) {
                BasedataEdit payeeacctbankf7 = (BasedataEdit)this.getControl("payeeacctbankf7");
                payeeacctbankf7.click();
            } else if (cs126 == 2) {
                this.showOuterBankInfo(obj, f7type);
            } else if (cs126 == 3) {
                FormShowParameter parentForm = this.getView().getFormShowParameter();
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("cas_freechoice");
                boolean isCustomer = "customer".equals(f7type);
                String type = f7type.equalsIgnoreCase("supplier") ? "bd_supplier" : "bd_customer";
                fsp.setCustomParam("sourcebill", (Object)"pay");
                fsp.setCustomParam("type", (Object)type);
                fsp.setCustomParam("isCustomer", (Object)isCustomer);
                fsp.setCustomParam("internalOrg", internalOrg.getPkValue());
                fsp.setCustomParam("payee", obj.getPkValue());
                fsp.setCustomParam("billtype", parentForm.getCustomParam("billtype"));
                fsp.setCustomParam("currency", parentForm.getCustomParam("currency"));
                fsp.setCustomParam("businesstype", parentForm.getCustomParam("businesstype"));
                fsp.setCustomParam("settletype", parentForm.getCustomParam("settletype"));
                fsp.setCustomParam("payeracctbank", parentForm.getCustomParam("payeracctbank"));
                String payeeType = (String)this.getValue("asstacttype");
                fsp.setCustomParam("payeeType", (Object)payeeType);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "freeSelect");
                fsp.setCloseCallBack(closeCallBack);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
            }
        } else {
            this.showOuterBankInfo(obj, f7type);
        }
    }

    private void showOuterBankInfo(DynamicObject obj, String f7type) {
        SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)obj);
        if (defaultBankInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"PayeeInfoEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = null;
        lsp = "supplier".equals(f7type) ? DynamicListHelper.getSupplierBankInfoShowParameter((Object)obj.getPkValue()) : DynamicListHelper.getCustomerBankInfoShowParameter((Object)obj.getPkValue());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeeaccountbank");
        lsp.setCloseCallBack(closeCallBack);
        this.setIFilters(lsp.getListFilterParameter(), this.getModel().getDataEntity());
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            if ("payeeaccountbank".equals(actionId)) {
                ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
                String asstActType = (String)this.getModel().getValue("asstacttype");
                SCAccountInfo scAccountInfo = BaseDataHelper.loadBankInfo((String)asstActType, (Long)((Long)entryKey));
                this.bindBankInfo(scAccountInfo);
            } else if ("freeSelect".equalsIgnoreCase(actionId)) {
                Map returnMap = (Map)returnData;
                Object id = returnMap.get("id");
                Object entity = returnMap.get("entity");
                if (entity.equals("am_accountbank")) {
                    this.getModel().setValue("payeeacctbankf7", id);
                } else {
                    SCAccountInfo scAccountInfo = BaseDataHelper.loadBankInfo((String)entity.toString(), (Long)((Long)id));
                    this.bindBankInfo(scAccountInfo);
                }
            }
        }
    }

    private void bindBankInfo(SCAccountInfo scAccountInfo) {
        if (scAccountInfo == null) {
            this.setValue("payeebanknum", null);
            this.setValue("recaccbankname", null);
            this.setValue("bebankf7", null);
            this.setValue("payeecurrency", null);
            this.setValue("supplierbankid", null);
            return;
        }
        this.setValue("payeebanknum", scAccountInfo.getAccount());
        String accountName = scAccountInfo.getAccountName();
        if (CasHelper.isEmpty((Object)accountName)) {
            String asstactName = null;
            if (this.isCustomer() || this.isSupplier()) {
                asstactName = this.getDynamicObject("payee").getLocaleString("name").getLocaleValue();
            }
            this.setValue("recaccbankname", asstactName);
        } else {
            this.setValue("recaccbankname", accountName);
        }
        this.setValue("bebankf7", scAccountInfo.getBeBank());
        this.setValue("payeecurrency", scAccountInfo.getCurrency() == null ? null : scAccountInfo.getCurrency().getPkValue());
        this.setValue("supplierbankid", scAccountInfo.getSupplierBankId());
    }

    private void btnOk() {
        DynamicObject supplierDO;
        DynamicObject payee;
        DynamicObject finorginfo;
        DynamicObject bank;
        IDataModel model = this.getModel();
        this.storeFields();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(50);
        resultMap.put("payeeformid", model.getValue("asstacttype"));
        DynamicObject object = (DynamicObject)model.getValue("payee");
        resultMap.put("payee", Long.valueOf(Optional.ofNullable(object).map(v -> v.getString("id")).orElse("0")));
        resultMap.put("payeename", model.getValue("payeename"));
        resultMap.put("payeenumber", Optional.ofNullable(object).map(o -> o.getString("number")).orElse(""));
        resultMap.put("payeeaccformid", model.getValue("payeeaccformid"));
        resultMap.put("payeeacctbank", model.getValue("payeeacctbank"));
        resultMap.put("payeeacctcash", model.getValue("payeeacctcash"));
        resultMap.put("payeebanknum", model.getValue("payeebanknum"));
        resultMap.put("institutioncode", model.getValue("institutioncode"));
        resultMap.put("institutionname", model.getValue("institutionname"));
        DynamicObject payeeacctbankf7 = this.getDynamicObject("payeeacctbankf7");
        if (payeeacctbankf7 != null && (bank = payeeacctbankf7.getDynamicObject("bank")) != null && (finorginfo = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)"bd_finorginfo", (String)"swift_code,routingnum,other_code,address_eng")) != null) {
            resultMap.put("swift_code", finorginfo.getString("swift_code"));
            resultMap.put("routingnum", finorginfo.getString("routingnum"));
            resultMap.put("other_code", finorginfo.getString("other_code"));
            resultMap.put("address_eng", finorginfo.getString("address_eng"));
        }
        DynamicObject bebankf7 = this.getDynamicObject("bebankf7");
        resultMap.put("payeebank", bebankf7);
        if (bebankf7 != null) {
            resultMap.put("swift_code", bebankf7.getString("swift_code"));
            resultMap.put("routingnum", bebankf7.getString("routingnum"));
            resultMap.put("other_code", bebankf7.getString("other_code"));
            resultMap.put("address_eng", bebankf7.getString("address_eng"));
        }
        resultMap.put("payeebankname", model.getValue("payeebankname"));
        resultMap.put("recaccbankname", model.getValue("recaccbankname"));
        resultMap.put("recbanknumber", model.getValue("recbanknumber"));
        resultMap.put("reccountry", model.getValue("reccountry"));
        resultMap.put("recprovince", model.getValue("recprovince"));
        resultMap.put("reccity", model.getValue("reccity"));
        resultMap.put("payeeemail", model.getValue("payeeemail"));
        resultMap.put("payeecurrency", model.getValue("payeecurrency"));
        resultMap.put("payeeaddress", model.getValue("payeeaddress"));
        resultMap.put("supplierBankId", model.getValue("supplierBankId"));
        resultMap.put("liquidationparam", "");
        if (this.isSupplier() && !CasHelper.isEmpty((Object)(payee = (DynamicObject)model.getValue("payee"))) && !CasHelper.isEmpty((Object)(supplierDO = BusinessDataServiceHelper.loadSingle((Object)payee.getPkValue(), (String)"bd_supplier", (String)"internal_company.id,entry_bank.bankaccount,entry_bank.settlment,entry_bank.liquidationparam,entry_bank.isdefault_bank")))) {
            FormShowParameter parameter;
            Map paramMap;
            DynamicObjectCollection entry_banks = supplierDO.getDynamicObjectCollection("entry_bank");
            if (!CasHelper.isEmpty((Object)entry_banks)) {
                for (int i = 0; i < entry_banks.size(); ++i) {
                    if (i != 0 && !((DynamicObject)entry_banks.get(i)).getBoolean("isdefault_bank")) continue;
                    DynamicObject entry_bank = (DynamicObject)entry_banks.get(i);
                    DynamicObject settlment = entry_bank.getDynamicObject("settlment");
                    resultMap.put("settlment", settlment);
                }
            }
            if ((paramMap = (parameter = this.getView().getFormShowParameter()).getCustomParams()).containsKey("iscrosspay")) {
                boolean isCrossPay = (Boolean)paramMap.get("iscrosspay");
                String payeeBankNum = (String)model.getValue("payeebanknum");
                String liquidationParam = BaseDataHelper.getSupplierLiquidationParam((Long)payee.getLong("id"), (boolean)isCrossPay, (DynamicObject)this.getDynamicObject("org"), (String)payeeBankNum);
                resultMap.put("liquidationparam", liquidationParam);
            }
        }
        this.getView().returnDataToParent(resultMap);
        this.getView().close();
    }

    private void storeFields() {
        DynamicObject payee = this.getDynamicObject("payee");
        if (!CasHelper.isEmpty((Object)payee)) {
            this.setDefaultAddress(payee);
            this.setValue("payeename", payee.getString("name"));
            if (this.isSupplier() || this.isCustomer()) {
                String entityName = "";
                String addressPropName = "";
                if (this.isSupplier()) {
                    entityName = "bd_supplier";
                    addressPropName = "supplieraddress";
                } else {
                    entityName = "bd_customer";
                    addressPropName = "customeraddress";
                }
                DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)payee.getPkValue(), (String)entityName, (String)("entry_address." + addressPropName));
                DynamicObjectCollection addressls = supplier.getDynamicObjectCollection("entry_address");
                if (addressls != null && addressls.size() > 0) {
                    HashSet<Object> addressIds = new HashSet<Object>();
                    for (DynamicObject a : addressls) {
                        addressIds.add(a.get(addressPropName + "_id"));
                    }
                    DynamicObject[] addresses = BusinessDataServiceHelper.load((String)"bd_address", (String)"default,detailaddress,addemail", (QFilter[])new QFilter[]{new QFilter("id", "in", addressIds)});
                    if (addresses != null) {
                        for (DynamicObject address : addresses) {
                            if (!address.getBoolean("default")) continue;
                            this.setValue("payeeemail", address.getString("addemail"));
                            this.setValue("payeeaddress", address.getString("detailaddress"));
                            break;
                        }
                    }
                }
            } else if (this.isUser()) {
                this.setValue("payeename", payee.getLocaleString("name").getLocaleValue());
                this.setValue("payeeemail", payee.getString("email"));
            } else if (this.isCompany()) {
                this.setValue("payeename", payee.getLocaleString("name").getLocaleValue());
            }
        }
        if (this.isUser()) {
            if (this.getValue("erpayeef7") != null) {
                this.setValue("payeeaccformid", ER_PAYEER);
                DynamicObject erAcctBank = this.getDynamicObject("erpayeef7");
                this.setValue("payeeacctbank", erAcctBank.getPkValue());
            }
        } else if (this.isCashOut() || StringUtils.equals((CharSequence)this.getPageCache().get("isCash"), (CharSequence)"1")) {
            this.setValue("payeeaccformid", "cas_accountcash");
            if (this.getValue("payeeacctcashf7") != null) {
                DynamicObject acctCash = this.getDynamicObject("payeeacctcashf7");
                this.setValue("payeeacctcash", acctCash.getPkValue());
            }
            this.setValue("payeeacctbank", null);
        } else if (this.getValue("payeeacctbankf7") != null) {
            this.setValue("payeeaccformid", "bd_accountbanks");
            DynamicObject acctBank = this.getDynamicObject("payeeacctbankf7");
            this.setValue("payeeacctbank", acctBank.getPkValue());
        } else {
            this.setValue("payeeaccformid", null);
            this.setValue("payeeacctbank", null);
        }
    }

    private void setDefaultAddress(DynamicObject payee) {
        long payeeId = payee.getLong("id");
        if (EmptyUtil.isEmpty((Long)payeeId)) {
            return;
        }
        String payeeType = (String)this.getValue("asstacttype");
        String address = AsstActTypeAddressEnum.getAddressByAsstActType((String)payeeType, (Long)payeeId);
        this.setValue("payeeaddress", address);
    }

    private boolean isOther() {
        return this.isAimType(AsstActTypeEnum.OTHER);
    }

    private boolean isUser() {
        return this.isAimType(AsstActTypeEnum.EMPLOYEE);
    }

    private boolean isCompany() {
        return this.isAimType(AsstActTypeEnum.COMPANY);
    }

    private boolean isSupplier() {
        return this.isAimType(AsstActTypeEnum.SUPPLIER);
    }

    private boolean isCustomer() {
        return this.isAimType(AsstActTypeEnum.CUSTOMER);
    }

    private boolean isAimType(AsstActTypeEnum asstactType) {
        Object payeeType = this.getValue("asstacttype");
        return asstactType.getValue().equals(payeeType);
    }

    private boolean isCashOut() {
        boolean isCashOut = false;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel parentModel = parentView.getModel();
            IDataEntityProperty property = parentModel.getProperty("billtype");
            if (property == null) {
                return isCashOut;
            }
            DynamicObject billtype = (DynamicObject)parentModel.getValue("billtype");
            if (billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
                String businesstype = (String)parentModel.getValue("businesstype");
                if (PayBusinessTypeEnum.CASHOUT.getValue().equals(businesstype)) {
                    isCashOut = true;
                }
            }
        }
        return isCashOut;
    }

    private void setIFilters(ListFilterParameter lfp, DynamicObject payBill) {
        LOGGER.info("\u5f00\u59cb\u8fdb\u884c\u4e8c\u5f00\u6269\u5c55\u5bf9\u5916\u670d\u52a1\u4e1a\u52a1\u57cb\u70b9 - kd.sdk.fi.cas.extpoint.paybill.IPayeeBankInfoFilter");
        PluginProxy pluginProxy = PluginProxy.create(IPayeeBankInfoFilter.class, (String)"fi.cas.filter.paybill.payeebankinfo");
        pluginProxy.callReplace(proxy -> {
            proxy.setIFilters(lfp, payBill);
            return null;
        });
    }
}

