/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;

public class PaymentBillLoggerPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.operateLogFilter();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.operateLogFilter();
    }

    private void operateLogFilter() {
        Object number = this.getModel().getValue("billno");
        QFilter filter = new QFilter("bizobj", "=", (Object)this.getModel().getDataEntityType().getName());
        if (Objects.nonNull(number)) {
            QFilter f1 = new QFilter("opdescription", "like", (Object)String.format("%s%s%s", "%", number, "%"));
            filter.and(f1);
        }
        BillList billList = (BillList)this.getControl("logbilllistap");
        FilterParameter fp = new FilterParameter();
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.addSetFilterListener(event -> event.getQFilters().add(filter));
        billList.refresh();
        billList.clearSelection();
    }
}

