/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicListHelper;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.info.SCAccountInfo;
import kd.fi.cas.util.EmptyUtil;

public class ReceivPayerInfoEdit
extends DynamicFormPlugin {
    public static final String ER_PAYEER = "er_payeer";
    private boolean isSelectAcctBankF7 = false;
    private boolean isSelectBankF7 = false;
    private boolean isSelectErpayeef7F7 = false;

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        this.initF7();
        TextEdit payeracctbanknum = (TextEdit)this.getView().getControl("payeracctbanknum");
        payeracctbanknum.addButtonClickListener((ClickListener)this);
        TextEdit payerbank = (TextEdit)this.getView().getControl("payerbank");
        payerbank.addButtonClickListener((ClickListener)this);
    }

    private void initF7() {
        this.fillPayerAcctBank();
        this.fillErPayeeF7();
        this.fillOrgF7();
    }

    private void fillOrgF7() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("orgf7");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and(new QFilter("fisbankroll", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillErPayeeF7() {
        BasedataEdit erpayeeF7 = (BasedataEdit)this.getControl("erpayeef7");
        erpayeeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject user = this.getDynamicObject("userf7");
            QFilter uFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
            if (user != null) {
                uFilter = uFilter.and(new QFilter("payer", "=", (Object)user.getLong("id")));
            }
            showParameter.getListFilterParameter().setFilter(uFilter);
        });
    }

    private void fillPayerAcctBank() {
        BasedataEdit f7_payeracctbank = (BasedataEdit)this.getControl("payeracctbankf7");
        f7_payeracctbank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            boolean virtual;
            DynamicObject org = null;
            if (this.isSupplier()) {
                DynamicObject supplier = this.getDynamicObject("supplierf7");
                org = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)supplier);
            } else if (this.isCustomer()) {
                DynamicObject customer = this.getDynamicObject("customerf7");
                org = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)customer);
            } else if (this.isCompany()) {
                org = this.getDynamicObject("orgf7");
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
            QFilter[] accountFilter = null;
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String payeeType = (String)this.getValue("asstacttype");
            if (StringUtils.isEmpty((CharSequence)payeeType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"ReceivPayerInfoEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (org != null) {
                parameter.setCustomParam("org", (Object)org.getLong("id"));
                accountFilter = AccountBankHelper.getUnclosedAccountFilter((long)((Long)org.getPkValue()));
                if (parameter instanceof ListShowParameter) {
                    ((ListShowParameter)parameter).setUseOrgId(org.getLong("id"));
                }
            } else if (this.isOther()) {
                accountFilter = AccountBankHelper.getUsableFilter().toArray();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba\u3002", (String)"ReceivPayerInfoEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            filters.addAll(Arrays.asList(accountFilter));
            Map paramMap = parameter.getCustomParams();
            if (paramMap.containsKey("virtual") && (virtual = ((Boolean)paramMap.get("virtual")).booleanValue())) {
                QFilter virtualQFilter = new QFilter("isvirtual", "=", (Object)"1");
                filters.add(virtualQFilter);
            }
            String filterIsElec = "0";
            IDataModel parentModel = this.getView().getParentView().getModel();
            if (parentModel.getDataEntity().containsProperty("businesstype")) {
                DynamicObject settleType = (DynamicObject)parentModel.getValue("settletype");
                boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
                String businessType = (String)parentModel.getValue("businesstype");
                if (isDcep && PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                    filterIsElec = "1";
                }
            }
            filters.add(new QFilter("iselecpayment", "=", (Object)filterIsElec));
            new LspWapper(beforeF7SelectEvent).setFilters(filters.toArray(new QFilter[0]));
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "supplierf7": 
            case "customerf7": {
                if (EmptyUtil.isEmpty((DynamicObject)this.getDynamicObject("org"))) {
                    return;
                }
                int cs126 = BaseDataHelper.getCS126Param((DynamicObject)this.getDynamicObject("org"));
                if (cs126 != 3) {
                    this.supplierOrCustomerChanged((DynamicObject)newValue);
                    break;
                }
                this.setValue("payeracctbanknum", null);
                this.setValue("bebankf7", null);
                this.setValue("payerbank", null);
                this.setValue("payername", "");
                this.setValue("payeracctbank", null);
                break;
            }
            case "userf7": {
                this.userF7Changed((DynamicObject)newValue);
                break;
            }
            case "payeracctbankf7": {
                this.payerAcctBankF7Changed((DynamicObject)newValue);
                break;
            }
            case "payeracctbanknum": {
                this.payeracctbanknumchanged((String)newValue);
                break;
            }
            case "bebankf7": {
                this.beBankF7Changed((DynamicObject)newValue);
                break;
            }
            case "payerbank": {
                this.payerBankNameChanged((String)newValue);
                break;
            }
            case "orgf7": {
                this.orgF7changed((DynamicObject)newValue);
                break;
            }
            case "erpayeef7": {
                this.erPayeeF7Changed((DynamicObject)newValue);
            }
        }
    }

    private void payeracctbanknumchanged(String newValue) {
        DynamicObject payerAccountBank;
        if (this.isSelectAcctBankF7) {
            return;
        }
        if (Objects.equals("bd_accountbanks", this.getString("payeraccformid")) && ((payerAccountBank = this.getDynamicObject("payeracctbankf7")) == null || !Objects.equals(payerAccountBank.getString("bankaccountnumber"), newValue))) {
            this.getModel().beginInit();
            this.setValue("payeraccformid", null);
            this.setValue("payeracctbankf7", null);
            this.setValue("payeracctbank", null);
            this.getModel().endInit();
        }
    }

    private void erPayeeF7Changed(DynamicObject erPayee) {
        if (erPayee != null) {
            this.isSelectAcctBankF7 = true;
            DynamicObject user = this.getDynamicObject("userf7");
            if (user == null) {
                QFilter filter = new QFilter("name", "=", (Object)erPayee.getString("outpayer"));
                DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, name, number", (QFilter[])new QFilter[]{filter});
                if (users != null) {
                    this.isSelectErpayeef7F7 = true;
                    this.setValue("userf7", users[0]);
                }
            }
            this.setValue("payeracctbanknum", erPayee.getString("payeraccount"));
            this.setValue("bebankf7", erPayee.getDynamicObject("payerbank"));
        } else {
            this.setValue("payeracctbanknum", null);
            this.setValue("bebankf7", null);
        }
    }

    private void orgF7changed(DynamicObject newValue) {
        if (this.isSelectAcctBankF7) {
            return;
        }
        DynamicObject org = newValue;
        if (org == null) {
            this.setValue("payeracctbankf7", null);
            this.setValue("payeracctbanknum", null);
            this.setValue("payerbank", null);
            return;
        }
        DynamicObject defaultPayAccount = AccountBankHelper.getDefaultPayAccount((Long)org.getLong("id"));
        if (defaultPayAccount != null) {
            this.setValue("payeracctbankf7", defaultPayAccount);
            this.setValue("payerbank", defaultPayAccount.getString("bank.name"));
        } else {
            this.setValue("payeracctbankf7", null);
            this.setValue("payeracctbanknum", null);
            this.setValue("payerbank", null);
        }
    }

    private void userF7Changed(DynamicObject user) {
        if (this.isSelectErpayeef7F7) {
            return;
        }
        if (user != null) {
            DynamicObject erPayeeInfo = this.getErPayeeInfo(user.getLong("id"), CasHelper.getLocalValue((DynamicObject)user, (String)"name"));
            if (erPayeeInfo != null) {
                this.setValue("erpayeef7", erPayeeInfo);
            } else if (this.getValue("erpayeef7") != null) {
                this.setValue("erpayeef7", null);
            } else {
                this.setValue("payeracctbanknum", null);
                this.setValue("payerbank", null);
            }
        } else {
            this.setValue("erpayeef7", null);
        }
    }

    private DynamicObject getErPayeeInfo(long userId, String name) {
        String orderBys;
        QFilter eFilter;
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("payer", "=", (Object)userId);
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number";
        QFilter[] qFilters = new QFilter[]{uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C'))), eFilter = new QFilter("enable", "=", (Object)"1")};
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)ER_PAYEER, (String)selectFields, (QFilter[])qFilters, (String)(orderBys = "isdefault desc"), (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    private void payerAcctBankF7Changed(DynamicObject acctBank) {
        if (acctBank == null) {
            this.setValue("payername", null);
            this.setValue("payeracctbanknum", null);
            return;
        }
        this.isSelectAcctBankF7 = true;
        if (this.isOther()) {
            this.setValue("payername", acctBank.getString("openorg.name"));
        }
        this.setValue("payeracctbanknum", acctBank.getString("bankaccountnumber"));
        this.setValue("payeraccformid", "bd_accountbanks");
        this.setValue("payerbank", acctBank.getString("bank.name"));
    }

    private void payerBankNameChanged(String newValue) {
        if (this.isSelectBankF7) {
            return;
        }
        if (newValue != null && StringUtils.isNotBlank((CharSequence)newValue)) {
            QFilter qFilter = new QFilter("name", "=", (Object)newValue);
            qFilter = qFilter.and(new QFilter("enable", "=", (Object)"1"));
            QFilter[] qFilters = new QFilter[]{qFilter = qFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')))};
            DynamicObject[] colls = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id, name, number, basedatafield1", (QFilter[])qFilters);
            if (colls != null && colls.length > 0) {
                this.setValue("bebankf7", colls[0]);
            } else {
                this.setValue("bebankf7", null);
            }
        } else {
            this.setValue("bebankf7", null);
        }
    }

    private void supplierOrCustomerChanged(DynamicObject basedata) {
        if (basedata == null) {
            this.setValue("payeracctbanknum", null);
            this.setValue("bebankf7", null);
            this.setValue("payerbank", null);
            this.setValue("payername", "");
            this.setValue("payeracctbank", null);
            return;
        }
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)basedata);
        if (internalOrg != null) {
            DynamicObject defaultPayAccount = AccountBankHelper.getDefaultPayAccount((Long)((Long)internalOrg.getPkValue()));
            if (defaultPayAccount != null) {
                this.setValue("payeracctbankf7", defaultPayAccount);
            } else {
                this.setValue("payeracctbanknum", null);
                this.setValue("bebankf7", null);
                this.setValue("payerbank", null);
            }
        } else {
            SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)basedata);
            if (defaultBankInfo != null) {
                this.setValue("payeracctbanknum", defaultBankInfo.getAccount());
                this.setValue("bebankf7", defaultBankInfo.getBeBank());
            } else {
                this.setValue("payeracctbanknum", null);
                this.setValue("bebankf7", null);
            }
        }
    }

    private void beBankF7Changed(DynamicObject beBank) {
        if (beBank != null) {
            this.isSelectBankF7 = true;
            beBank = BusinessDataServiceHelper.loadSingleFromCache((Object)beBank.getPkValue(), (DynamicObjectType)beBank.getDynamicObjectType());
            this.setValue("payerbank", CasHelper.getLocalValue((DynamicObject)beBank, (String)"name"));
        } else {
            this.setValue("payerbank", null);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "payeracctbanknum": {
                if (this.isUser()) {
                    DynamicObject obj = this.getDynamicObject("userf7");
                    if (obj == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba\u3002", (String)"ReceivPayerInfoEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    BasedataEdit erpayeef7 = (BasedataEdit)this.getControl("erpayeef7");
                    erpayeef7.click();
                    break;
                }
                if (this.isSupplier()) {
                    this.showBankInfoF7("supplier");
                    break;
                }
                if (this.isCustomer()) {
                    this.showBankInfoF7("customer");
                    break;
                }
                BasedataEdit payeeacctbankf7 = (BasedataEdit)this.getControl("payeracctbankf7");
                payeeacctbankf7.click();
                break;
            }
            case "payerbank": {
                BasedataEdit bebankf7 = (BasedataEdit)this.getControl("bebankf7");
                bebankf7.click();
                break;
            }
            case "btnok": {
                this.btnOk();
            }
        }
    }

    private void showBankInfoF7(String f7type) {
        DynamicObject obj = this.getDynamicObject(f7type + "f7");
        if (obj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba\u3002", (String)"ReceivPayerInfoEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)obj);
        int cs126 = BaseDataHelper.getCS126Param((DynamicObject)this.getDynamicObject("org"));
        if (internalOrg != null) {
            if (cs126 == 1) {
                BasedataEdit payeeacctbankf7 = (BasedataEdit)this.getControl("payeracctbankf7");
                payeeacctbankf7.click();
            } else if (cs126 == 2) {
                this.showOuterBankInfo(obj, f7type);
            } else if (cs126 == 3) {
                FormShowParameter parentForm = this.getView().getFormShowParameter();
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("cas_freechoice");
                boolean isCustomer = "customer".equals(f7type);
                String type = f7type.equalsIgnoreCase("supplier") ? "bd_supplier" : "bd_customer";
                fsp.setCustomParam("sourcebill", (Object)"rec");
                fsp.setCustomParam("type", (Object)type);
                fsp.setCustomParam("isCustomer", (Object)isCustomer);
                fsp.setCustomParam("internalOrg", internalOrg.getPkValue());
                fsp.setCustomParam("payee", obj.getPkValue());
                fsp.setCustomParam("billtype", parentForm.getCustomParam("billtype"));
                fsp.setCustomParam("currency", parentForm.getCustomParam("currency"));
                fsp.setCustomParam("businesstype", parentForm.getCustomParam("businesstype"));
                fsp.setCustomParam("settletype", parentForm.getCustomParam("settletype"));
                String payeeType = (String)this.getValue("asstacttype");
                fsp.setCustomParam("payeeType", (Object)payeeType);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "freeSelect");
                fsp.setCloseCallBack(closeCallBack);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
            }
        } else {
            this.showOuterBankInfo(obj, f7type);
        }
    }

    private void showOuterBankInfo(DynamicObject obj, String f7type) {
        SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)obj);
        if (defaultBankInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"ReceivPayerInfoEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = null;
        lsp = "supplier".equals(f7type) ? DynamicListHelper.getSupplierBankInfoShowParameter((Object)obj.getPkValue()) : DynamicListHelper.getCustomerBankInfoShowParameter((Object)obj.getPkValue());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeraccountbank");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            if ("payeraccountbank".equals(actionId)) {
                if (returnData != null) {
                    ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
                    Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
                    String asstActType = (String)this.getModel().getValue("asstacttype");
                    SCAccountInfo scAccountInfo = BaseDataHelper.loadBankInfo((String)asstActType, (Long)((Long)entryKey));
                    this.bindBankInfo(scAccountInfo);
                }
            } else if ("freeSelect".equalsIgnoreCase(actionId)) {
                Map returnMap = (Map)returnData;
                Object id = returnMap.get("id");
                Object entity = returnMap.get("entity");
                if (entity.equals("am_accountbank")) {
                    this.getModel().setValue("payeracctbankf7", id);
                } else {
                    SCAccountInfo scAccountInfo = BaseDataHelper.loadBankInfo((String)entity.toString(), (Long)((Long)id));
                    this.bindBankInfo(scAccountInfo);
                }
            }
        }
    }

    private void bindBankInfo(SCAccountInfo scAccountInfo) {
        if (scAccountInfo == null) {
            this.setValue("payeebanknum", null);
            this.setValue("recaccbankname", null);
            this.setValue("bebankf7", null);
            return;
        }
        this.setValue("payeracctbanknum", scAccountInfo.getAccount());
        this.setValue("bebankf7", scAccountInfo.getBeBank());
    }

    private void btnOk() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String payernumber = this.storeFields();
        resultMap.put("payernumber", payernumber);
        IDataModel model = this.getModel();
        resultMap.put("payerformid", model.getValue("payerformid"));
        resultMap.put("payer", model.getValue("payer"));
        resultMap.put("payername", model.getValue("payername"));
        resultMap.put("payeraccformid", model.getValue("payeraccformid"));
        resultMap.put("payeracctbank", model.getValue("payeracctbank"));
        resultMap.put("payeracctbanknum", model.getValue("payeracctbanknum"));
        resultMap.put("payerbank", model.getValue("bebankf7"));
        resultMap.put("payerbankname", model.getValue("payerbank"));
        this.getView().returnDataToParent(resultMap);
        this.getView().close();
    }

    private void setDefault() {
        this.setValue("payer", 0);
        this.setValue("payername", " ");
    }

    private String storeFields() {
        DynamicObject acctBank;
        String payernumber = "";
        if (this.isSupplier()) {
            this.setValue("payerformid", "bd_supplier");
            this.setDefault();
            if (this.getValue("supplierf7") != null) {
                DynamicObject supplier = this.getDynamicObject("supplierf7");
                this.setValue("payer", supplier.getPkValue());
                this.setValue("payername", supplier.get("name"));
                payernumber = supplier.getString("number");
            }
        } else if (this.isCustomer()) {
            this.setDefault();
            this.setValue("payerformid", "bd_customer");
            if (this.getValue("customerf7") != null) {
                DynamicObject customer = this.getDynamicObject("customerf7");
                this.setValue("payer", customer.getPkValue());
                this.setValue("payername", customer.get("name"));
                payernumber = customer.getString("number");
            }
        } else if (this.isUser()) {
            this.setDefault();
            this.setValue("payerformid", "bos_user");
            if (this.getValue("userf7") != null) {
                DynamicObject user = this.getDynamicObject("userf7");
                this.setValue("payer", user.getPkValue());
                this.setValue("payername", user.get("name"));
                payernumber = user.getString("number");
            }
        } else if (this.isOther()) {
            this.setValue("payerformid", "other");
        } else if (this.isCompany()) {
            this.setDefault();
            this.setValue("payerformid", "bos_org");
            if (this.getValue("orgf7") != null) {
                DynamicObject org = this.getDynamicObject("orgf7");
                this.setValue("payer", org.getPkValue());
                this.setValue("payername", org.get("name"));
                payernumber = org.getString("number");
            }
        }
        if (this.isUser()) {
            if (this.getValue("erpayeef7") != null) {
                this.setValue("payeraccformid", ER_PAYEER);
                DynamicObject erAcctBank = this.getDynamicObject("erpayeef7");
                this.setValue("payeracctbank", erAcctBank.getPkValue());
            }
        } else if (this.getValue("payeracctbankf7") != null) {
            this.setValue("payeraccformid", "bd_accountbanks");
            acctBank = this.getDynamicObject("payeracctbankf7");
            this.setValue("payeracctbank", acctBank.getPkValue());
        } else {
            this.setValue("payeraccformid", "other");
        }
        if (this.getValue("payeracctbankf7") != null) {
            acctBank = this.getDynamicObject("payeracctbankf7");
            this.setValue("payeracctbank", acctBank.getPkValue());
            this.setValue("payeracctbanknum", acctBank.get("bankaccountnumber"));
        }
        return payernumber;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map paramMap = parameter.getCustomParams();
        IDataModel model = this.getModel();
        String asstActType = (String)paramMap.get("asstActType");
        model.setValue("asstacttype", (Object)asstActType);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IDataModel parentModel = parentView.getModel();
        IDataEntityProperty orgProperty = parentModel.getProperty("org");
        if (orgProperty == null) {
            return;
        }
        model.setValue("org", parentModel.getValue("org"));
        this.initPayerF7(asstActType);
        String sourceBillType = (String)parentModel.getValue("sourcebilltype");
        if (parameter.getStatus() != OperationStatus.ADDNEW || "pmct_incomeapply".equals(sourceBillType)) {
            DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propName = property.getName();
                if (parentModel.getProperty(propName) == null) continue;
                this.setValue(propName, parentModel.getValue(propName));
            }
            this.setValue("payerbank", parentModel.getValue("payerbankname"));
            this.setValue("bebankf7", parentModel.getValue("f7_payerbank"));
            this.setValue("payeracctbankf7", parentModel.getValue("payeracctbank"));
            this.loadFields();
            if ("ar_finarbill".equals(sourceBillType) || "sm_salorder".equals(sourceBillType) || "fca_transdownbill".equals(sourceBillType) || "lc_present".equals(sourceBillType) || "pmct_incomeapply".equals(sourceBillType)) {
                if (this.isSupplier()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"supplierf7"});
                } else if (this.isCustomer()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"customerf7"});
                } else if (this.isUser()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"userf7"});
                } else if (this.isCompany()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"orgf7"});
                } else if (this.isOther()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"payername"});
                }
            }
        }
    }

    private void loadFields() {
        Object payer = this.getValue("payer");
        if (StringUtils.isNotBlank((Object)payer)) {
            if (this.isSupplier()) {
                this.setValue("supplierf7", payer);
            } else if (this.isCustomer()) {
                this.setValue("customerf7", payer);
            } else if (this.isUser()) {
                this.setValue("userf7", payer);
            } else if (this.isCompany()) {
                this.setValue("orgf7", payer);
            }
        }
    }

    private void initPayerF7(String asstActType) {
        if (this.isSupplier()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"customerf7", "userf7", "payername", "orgf7"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"supplierf7"});
        }
        if (this.isCustomer()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierf7", "userf7", "payername", "orgf7"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"customerf7"});
        }
        if (this.isUser()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierf7", "customerf7", "payername", "orgf7"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"userf7"});
        }
        if (this.isOther()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierf7", "customerf7", "userf7", "orgf7"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"payername"});
            HashMap map = new HashMap();
            HashMap<String, Boolean> style = new HashMap<String, Boolean>();
            style.put("showEditButton", Boolean.FALSE);
            map.put("item", style);
            this.getView().updateControlMetadata("payeracctbanknum", map);
        }
        if (this.isCompany()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierf7", "customerf7", "userf7", "payername"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"orgf7"});
        }
    }

    private boolean isOther() {
        return this.isAimType(AsstActTypeEnum.OTHER);
    }

    private boolean isCompany() {
        return this.isAimType(AsstActTypeEnum.COMPANY);
    }

    private boolean isSupplier() {
        return this.isAimType(AsstActTypeEnum.SUPPLIER);
    }

    private boolean isCustomer() {
        return this.isAimType(AsstActTypeEnum.CUSTOMER);
    }

    private boolean isUser() {
        return this.isAimType(AsstActTypeEnum.EMPLOYEE);
    }

    private boolean isAimType(AsstActTypeEnum asstactType) {
        Object payeeType = this.getValue("asstacttype");
        return asstactType.getValue().equals(payeeType);
    }
}

