/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.errorcode.ReceivErrorCode;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.RecDraftHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.paywarning.RecWarningHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.enums.OperateTypeEnum;
import kd.fi.cas.enums.RecAmtTypeEnum;
import kd.fi.cas.enums.RecBizTypeEnum;
import kd.fi.cas.enums.RecTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.CasBillEdit;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CasPayeeOrPayerHelper;
import kd.fi.cas.helper.CasPluginHelper;
import kd.fi.cas.helper.CoreBillSettingHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.helper.ViewInputHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;
import kd.sdk.fi.cas.extpoint.recbill.IRecbillFilter;

public class ReceivingBillEdit
extends CasBillEdit
implements ClickListener,
EntryGridBindDataListener {
    private static Log logger = LogFactory.getLog(ReceivingBillEdit.class);
    private static final String CONFIRM_DEL_CALLBACK = "CONFIRM_DEL_CALLBACK";
    private static final String CONFIRM_DELETE_CALLBACK = "CONFIRM_DELETE_CALLBACK";
    private static final String KEY_CLOSECALLBACK_CHARGEBACK = "CALLBACK_SELECTDRAFT";
    private static final String KEY_CLOSECALLBACK_CLEARRECEIVINGTYPECONFIRM = "clearReceivingTypeConfirm";
    private static final String ENTRY = "entry";
    private Set<String> settleTypes = Stream.of(SettleMentTypeEnum.PROMISSORY.getValue(), SettleMentTypeEnum.CHECK.getValue(), SettleMentTypeEnum.DRAFT.getValue(), SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()).collect(Collectors.toSet());
    private static final Set<Object> OPEN_CORE_BILLS = Stream.of("ar_finarbill", "sm_salorder", "er_repaymentbill", "fr_glreim_recbill", "conm_salcontract", "cas_agentpaybill").collect(Collectors.toSet());

    public void initialize() {
        super.initialize();
        Control entryentity = this.getView().getControl(ENTRY);
        EntryGrid entry = (EntryGrid)entryentity;
        entry.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterLoadData(EventObject e) {
        FormShowParameter param;
        OperationStatus status;
        super.afterLoadData(e);
        String payertypeTypeID = this.getString("payertype");
        if (payertypeTypeID.equals(AsstActTypeEnum.EMPLOYEE.getValue()) && CasHelper.isEmpty((Object)this.getValue("f7_payerbank")) && CasHelper.isEmpty((Object)this.getValue("payeracctbanknum"))) {
            this.userF7Changed(null, this.getValue("userf7"));
        }
        if ((status = (param = this.getView().getFormShowParameter()).getStatus()).equals((Object)OperationStatus.VIEW)) {
            this.getModel().setDataChanged(false);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"changepayee", "addpayerlb2", "addpayerlb1", "changepayer", "e_corebillno", "settletnumber"});
        this.fillRecType();
        this.fillEntryRecType();
        this.fillPayeeAcctBank();
        this.fillCurrency();
        this.fillSettleOrg();
        this.fillFundFlow();
        this.expenseItem();
        Object vtual = this.getModel().getValue("isvirtual");
        if (vtual != null) {
            Boolean isvirtual = (Boolean)vtual;
            if (isvirtual.booleanValue()) {
                this.setVirtualSettlementTypeFilter();
            } else {
                this.setSettlementTypeFilter();
            }
        }
    }

    private void fillEntryRecType() {
        BasedataEdit receivabletypeF7 = (BasedataEdit)this.getControl("e_receivingtype");
        receivabletypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and(new QFilter("biztype", "!=", (Object)"110"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    protected void expenseItem() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("e_expenseitem");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object[] objects = BusinessDataServiceHelper.load((String)"er_expenseitembill", (String)"id,expenseitem", (QFilter[])new QFilter[]{new QFilter("billtype.bill_number.number", "=", (Object)"cas_recbill")});
            if (EmptyUtil.isEmpty((Object[])objects)) {
                return;
            }
            List ids = Arrays.stream(objects).map(o -> o.get("expenseitem.id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    private void fillFundFlow() {
    }

    @Override
    protected String getControlBankAcctForSettleType() {
        return "accountbank";
    }

    private void fillPayerType() {
        boolean multireceivingtype = (Boolean)this.getModel().getValue("multireceivingtype");
        DynamicObject receivingtype = (DynamicObject)this.getModel().getValue("receivingtype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        boolean isSelectallpayertype = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            isSelectallpayertype = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"selectallpayertype");
        }
        ComboEdit payertypeCbo = (ComboEdit)this.getView().getControl("payertype");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String rectype = (String)customParams.get("recmentType");
        if (rectype == null) {
            Object type = this.getValue("biztype");
            rectype = type != null ? type.toString() : "";
        }
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
        if (rectype.equals(RecTypeEnum.OtherRec.toString())) {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
            if (multireceivingtype || EmptyUtil.isNoEmpty((DynamicObject)receivingtype) && (!receivingtype.getBoolean("ispartreceivable") || receivingtype.getBoolean("ispartreceivable") && isSelectallpayertype)) {
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.OTHER.getName()), AsstActTypeEnum.OTHER.getValue()));
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue()));
            }
        } else {
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
            comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
            if (multireceivingtype || EmptyUtil.isNoEmpty((DynamicObject)receivingtype) && receivingtype.getBoolean("ispartreceivable") && isSelectallpayertype) {
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.OTHER.getName()), AsstActTypeEnum.OTHER.getValue()));
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue()));
            }
        }
        payertypeCbo.setComboItems(comboItem);
        Object value = this.getModel().getValue("payertype");
        boolean ishave = false;
        for (ComboItem combo : comboItem) {
            if (value == null || !combo.getValue().equals(value)) continue;
            ishave = true;
            break;
        }
        if (!ishave) {
            this.getModel().setValue("payertype", null);
        }
    }

    private void fillCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject settleType = this.getDynamicObject("settletype");
            boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
            Collection currencyPks = new ArrayList();
            if (isCash) {
                DynamicObject accountCash = this.getDynamicObject("accountcash");
                if (accountCash != null) {
                    currencyPks = AccountCashHelper.getCurrencys(Collections.singletonList((Long)accountCash.getPkValue()));
                }
            } else {
                DynamicObject payerAcctBank = this.getDynamicObject("accountbank");
                if (payerAcctBank != null) {
                    currencyPks = AccountBankHelper.getCurrencyPks((long)payerAcctBank.getLong("id"));
                }
            }
            qFilter = qFilter.and(new QFilter("id", "in", currencyPks));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillSettleOrg() {
        BasedataEdit settleorg = (BasedataEdit)this.getControl("e_settleorg");
        settleorg.addBeforeF7SelectListener(select -> {
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            showParam.setCustomParam("orgFuncId", (Object)"10");
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int iRow = changeData[0].getRowIndex();
        if (newValue == oldValue) {
            return;
        }
        switch (key) {
            case "isagent": {
                this.setAgent((Boolean)newValue);
                break;
            }
            case "org": {
                this.setOpenOrg();
                this.controlRecAmt();
                this.fillPayerType();
                this.resetExrateTableWhenSwitchOrg(newValue);
                break;
            }
            case "accountbank": {
                this.payeeAcctBankF7Changed(e, newValue);
                break;
            }
            case "accountcash": {
                this.accountCashChanged();
                break;
            }
            case "currency": {
                this.currencyF7Changed();
                this.updateCoreBill(true, -1);
                break;
            }
            case "bizdate": {
                this.exratedateChanged(newValue);
                this.currencyF7Changed();
                break;
            }
            case "exratetable": {
                this.currencyF7Changed();
                break;
            }
            case "exratedate": {
                this.currencyF7Changed();
                break;
            }
            case "payertype": {
                this.payerTypeChanged(e, newValue, true);
                this.updateCoreBill(true, -1);
                break;
            }
            case "exchangerate": 
            case "quotation": {
                this.calculateAmt();
                break;
            }
            case "userf7": {
                this.userF7Changed(e, newValue);
                break;
            }
            case "billstatus": {
                this.fillToolBar();
                break;
            }
            case "e_actamt": 
            case "e_receivableamt": {
                this.calculateAmt();
                break;
            }
            case "e_discountamt": {
                this.calculateAmt();
                break;
            }
            case "receivingtype": {
                this.receivingTypeChanged(oldValue, newValue);
                this.setSettleOrg(false);
                this.setEcorebilltype();
                this.fillPayerType();
                this.setEntryExpenseitemEnable();
                break;
            }
            case "settletype": {
                this.settleTypeChanged((DynamicObject)newValue);
                this.isClearSettleType((DynamicObject)oldValue, (DynamicObject)newValue);
                break;
            }
            case "fee": {
                this.calculateAmt();
                break;
            }
            case "e_fee": {
                this.calculateFee(iRow);
                break;
            }
            case "e_corebilltype": {
                int index = this.getModel().getEntryCurrentRowIndex(ENTRY);
                this.updateCoreBill(false, index);
                this.getModel().setValue("e_corebillno", null, index);
                this.getModel().setValue("e_corebillentryseq", null, index);
                this.getModel().setValue("conbillentity", null, index);
                this.getModel().setValue("conbillnumber", null, index);
                this.getModel().setValue("conbillrownum", null, index);
                break;
            }
            case "e_corebillno": {
                if (!EmptyUtil.isEmpty((Object)e.getChangeSet()[0].getNewValue())) break;
                int entryIndex = e.getChangeSet()[0].getRowIndex();
                this.updateCoreBill(false, entryIndex);
                break;
            }
            case "multireceivingtype": {
                this.dealMultiReceType(newValue);
                this.setEntryExpenseitemEnable();
                this.setEcorebilltype();
                break;
            }
            case "e_receivingtype": {
                this.dealEntryReceType(newValue, iRow);
                break;
            }
            case "payeracctbank": {
                this.fillInnerAccount(newValue);
                break;
            }
        }
    }

    private void fillInnerAccount(Object newValue) {
        if (newValue == null) {
            return;
        }
        Long payeracctbankId = (Long)newValue;
        DynamicObject accountbank = this.getModel().getDataEntity().getDynamicObject("accountbank");
        DynamicObject receivingtype = this.getModel().getDataEntity().getDynamicObject("receivingtype");
        if (receivingtype == null || accountbank == null) {
            return;
        }
        String biztype = receivingtype.getString("biztype");
        if (!"108".equals(biztype)) {
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("entryentity.e_account", "=", (Object)payeracctbankId);
        qFilter.and("entryentity.e_parentacct", "=", accountbank.getPkValue());
        DynamicObject linkPayRelation = BusinessDataServiceHelper.loadSingle((String)"am_linkpayrelation", (String)"entryentity,entryentity.e_internalacct,entryentity.e_parentacct,entryentity.e_account", (QFilter[])new QFilter[]{qFilter});
        if (linkPayRelation == null) {
            return;
        }
        DynamicObjectCollection entries = linkPayRelation.getDynamicObjectCollection("entryentity");
        for (DynamicObject entrie : entries) {
            DynamicObject e_internalacct;
            DynamicObject e_account = entrie.getDynamicObject("e_account");
            DynamicObject e_parentacct = entrie.getDynamicObject("e_parentacct");
            if (e_account == null || e_parentacct == null || !e_account.getPkValue().equals(payeracctbankId) || !e_parentacct.getPkValue().equals(accountbank.getPkValue()) || (e_internalacct = entrie.getDynamicObject("e_internalacct")) == null) continue;
            this.getModel().setValue("inneraccount", (Object)e_internalacct);
        }
    }

    private void dealEntryReceType(Object newValue, int iRow) {
        DynamicObject e_receivingtype = (DynamicObject)newValue;
        if (EmptyUtil.isEmpty((DynamicObject)e_receivingtype)) {
            return;
        }
        DynamicObject fundflowitem = e_receivingtype.getDynamicObject("fundflowitem");
        if (EmptyUtil.isEmpty((DynamicObject)fundflowitem)) {
            return;
        }
        this.setValue("e_fundflowitem", fundflowitem.getPkValue(), iRow);
    }

    private void setEntryExpenseitemEnable() {
        String rectype = (String)this.getModel().getValue("biztype");
        DynamicObject receivingtype = this.getDynamicObject("receivingtype");
        boolean multireceivingtype = (Boolean)this.getModel().getValue("multireceivingtype");
        if (multireceivingtype || rectype.equals(RecTypeEnum.OtherRec.toString()) && EmptyUtil.isNoEmpty((DynamicObject)receivingtype) && !receivingtype.getBoolean("ispartreceivable")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_material"});
        }
    }

    private void dealMultiReceType(Object newValue) {
        boolean ishave = false;
        boolean multireceivingtype = (Boolean)newValue;
        if (multireceivingtype) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_settleorg"});
            QFilter qFilter = new QFilter("biztype", "=", (Object)"110");
            qFilter.and("default", "=", (Object)Character.valueOf('1'));
            qFilter.and("enable", "=", (Object)"1");
            Object[] payMentBillTypes = BusinessDataServiceHelper.load((String)"cas_receivingbilltype", (String)"id,name,number,ispartpayment,biztype", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isEmpty((Object[])payMentBillTypes)) {
                this.getModel().setValue("receivingtype", null);
            } else {
                this.getModel().setValue("receivingtype", payMentBillTypes[0]);
            }
        } else {
            int count = this.getModel().getEntryRowCount(ENTRY);
            if (count == 0) {
                this.getModel().setValue("receivingtype", null);
                return;
            }
            for (int i = 0; i < count; ++i) {
                DynamicObject e_paymenttype = (DynamicObject)this.getModel().getValue("e_receivingtype", i);
                if (!EmptyUtil.isNoEmpty((DynamicObject)e_paymenttype)) continue;
                ishave = true;
                break;
            }
            if (ishave) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u591a\u6536\u6b3e\u7c7b\u578b\u5c06\u81ea\u52a8\u6e05\u7a7a\u6536\u6b3e\u660e\u7ec6\u6536\u6b3e\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ReceivingBillEdit_35", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_CLOSECALLBACK_CLEARRECEIVINGTYPECONFIRM, (IFormPlugin)this));
            } else {
                this.getModel().setValue("receivingtype", null);
            }
        }
    }

    private void isClearSettleType(DynamicObject oldValue, DynamicObject newValue) {
        String settletnumber = (String)this.getModel().getValue("settletnumber");
        if (EmptyUtil.isNoEmpty((String)settletnumber) && Objects.nonNull(oldValue) && SettleMentTypeEnum.CREDIT.getValue().equals(oldValue.getString("settlementtype")) && Objects.nonNull(newValue) && !SettleMentTypeEnum.CREDIT.getValue().equals(newValue.getString("settlementtype"))) {
            this.getModel().setValue("settletnumber", null);
            this.getModel().setValue("sourcebilltype", null);
            this.getModel().setValue("sourcebillid", null);
            this.getModel().deleteEntryData("billhead_lk");
        }
    }

    private void updateCoreBill(boolean isClearAll, int entryIndex) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            for (int i = 0; i < entrys.size(); ++i) {
                if (!isClearAll && entryIndex != i) continue;
                this.getModel().beginInit();
                this.getModel().setValue("e_corebillno", null, i);
                this.getModel().setValue("e_corebillentryseq", null, i);
                this.getModel().setValue("e_corebillid", null, i);
                this.getModel().setValue("e_corebillentryid", null, i);
                this.getModel().setValue("e_sourcebillentryid", null, i);
                this.getModel().setValue("e_sourcebillid", null, i);
                this.getModel().setValue("conbillentity", null, i);
                this.getModel().setValue("conbillnumber", null, i);
                this.getModel().setValue("conbillrownum", null, i);
                this.getModel().setValue("conbillid", null, i);
                this.getModel().setValue("conbillentryid", null, i);
                this.getModel().endInit();
                this.getView().updateView("e_corebillno", i);
                this.getView().updateView("e_corebillentryseq", i);
                this.getView().updateView("e_corebillid", i);
                this.getView().updateView("e_corebillentryid", i);
                this.getView().updateView("e_sourcebillentryid", i);
                this.getView().updateView("e_sourcebillid", i);
                this.getView().updateView("conbillentity", i);
                this.getView().updateView("conbillnumber", i);
                this.getView().updateView("conbillrownum", i);
                this.getView().updateView("conbillid", i);
                this.getView().updateView("conbillentryid", i);
            }
        }
    }

    private boolean isOpenSelectCorebill(Object corebilltype) {
        return !OPEN_CORE_BILLS.contains(corebilltype);
    }

    private void getCorebilltypeToChange() {
        int iRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
        String corebilltype = (String)this.getModel().getValue("e_corebilltype", iRow);
        if (corebilltype == null || "".equals(corebilltype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"ReceivingBillEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject recPayType = (DynamicObject)this.getModel().getValue("receivingtype");
        boolean isPartReceivable = false;
        if (recPayType != null) {
            isPartReceivable = recPayType.getBoolean("ispartreceivable");
        }
        boolean isMultiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
        List coreBillSettings = CoreBillSettingHelper.loadCoreBillSetting((String)"cas_recbill", (boolean)isMultiReceivingType, (boolean)isPartReceivable);
        Set coreNumbers = CoreBillSettingHelper.getNumberBySetting((List)coreBillSettings);
        if (this.isOpenSelectCorebill(corebilltype) && !coreNumbers.contains(corebilltype)) {
            return;
        }
        DynamicObject coreBillSetting = CoreBillSettingHelper.filterCoreBillSetting((List)coreBillSettings, (String)corebilltype);
        if (corebilltype.equals("er_repaymentbill")) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("cas_repaymentbill");
            para.setCustomParam("openSource", (Object)"cas_recbill");
            Object payertype = this.getValue("payertype");
            if (EmptyUtil.isEmpty((Object)payertype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a\u8fd8\u6b3e\u5355\uff0c\u8bf7\u5148\u6307\u5b9a\u4ed8\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"ReceivingBillEdit_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            para.setCustomParam("payertype", payertype);
            Object payername = null;
            payername = "other".equals(payertype) ? this.getValue("payername") : this.getValue("payer");
            if (CasHelper.isEmpty((Object)payername)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a\u201c\u8fd8\u6b3e\u5355\u201d\uff0c\u8bf7\u5148\u6307\u5b9a\u4ed8\u6b3e\u4eba\u3002", (String)"ReceivingBillEdit_23", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            para.setCustomParam("payername", payername);
            Object accountcurrency = this.getValue("currency");
            if (EmptyUtil.isEmpty((Object)accountcurrency)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a\u8fd8\u6b3e\u5355\uff0c\u8bf7\u5148\u6307\u5b9a\u5e01\u79cd", (String)"ReceivingBillEdit_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            para.setCustomParam("accountcurrency", ((DynamicObject)accountcurrency).getPkValue());
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setShowTitle(true);
            para.setStatus(OperationStatus.ADDNEW);
            StyleCss css = new StyleCss();
            css.setWidth("960");
            css.setHeight("580");
            para.getOpenStyle().setInlineStyleCss(css);
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_corebillno"));
            this.getView().showForm(para);
            return;
        }
        String showFormId = corebilltype;
        if (CasHelper.isNotEmpty((Object)coreBillSetting)) {
            this.getPageCache().put("CORE_BILL_SETTING", SerializeHelper.serializeDynamicObj((Object)coreBillSetting));
            showFormId = coreBillSetting.getString("formid");
        } else {
            this.getPageCache().remove("CORE_BILL_SETTING");
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)showFormId, (boolean)true, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        switch (corebilltype) {
            case "ar_finarbill": {
                Object e_settleorg = this.getModel().getValue("e_settleorg", iRow);
                if (e_settleorg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ReceivingBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object pkValue = ((DynamicObject)e_settleorg).getPkValue();
                lfp.setFilter(new QFilter("org", "=", pkValue));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                lfp.setFilter(new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"}));
                break;
            }
            case "sm_salorder": {
                Object e_settleorg1 = this.getModel().getValue("e_settleorg", iRow);
                if (e_settleorg1 == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ReceivingBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object pkValue1 = ((DynamicObject)e_settleorg1).getPkValue();
                lfp.setFilter(new QFilter("billentry.entrysettleorg", "=", pkValue1));
                Object payer = this.getModel().getValue("payer");
                lfp.setFilter(new QFilter("customer", "=", !ObjectUtils.isEmpty((Object)payer) ? payer : Long.valueOf(0L)));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                lfp.setFilter(new QFilter("changestatus", "<>", (Object)"B"));
                lfp.setFilter(QFilter.of((String)" receiptamount < totalallamount ", (Object[])new Object[0]));
                break;
            }
            case "conm_salcontract": {
                Object e_settleorg2 = this.getModel().getValue("e_settleorg", iRow);
                if (e_settleorg2 == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ReceivingBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object pkValue2 = ((DynamicObject)e_settleorg2).getPkValue();
                lfp.setFilter(new QFilter("billentry.entrysettleorg", "=", pkValue2));
                Object payer1 = this.getModel().getValue("payer");
                lfp.setFilter(new QFilter("customer", "=", !ObjectUtils.isEmpty((Object)payer1) ? payer1 : Long.valueOf(0L)));
                lfp.setFilter(new QFilter("validstatus", "<>", (Object)"A"));
                lfp.setFilter(new QFilter("changestatus", "<>", (Object)"B"));
                lfp.setFilter(QFilter.of((String)" receiptallamount < totalallamount ", (Object[])new Object[0]));
                break;
            }
            case "fr_glreim_recbill": {
                Object org = this.getModel().getValue("org", iRow);
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u7ec4\u7ec7\u3002", (String)"ReceivingBillEdit_16_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object orgPkValue = ((DynamicObject)org).getPkValue();
                lfp.setFilter(new QFilter("accountingorg", "=", orgPkValue));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)"D"));
                lfp.setFilter(new QFilter("castorecamount", ">=", (Object)0));
                break;
            }
            case "cas_agentpaybill": {
                lfp.setSelectEntity(ENTRY);
                lsp.setCustomParam("isEntryMain", (Object)Boolean.TRUE);
                lsp.addCustPlugin("kd.fi.cas.formplugin.agentpay.AgentCoreBillF7ListPlugin");
                IDataModel model = this.getModel();
                lfp.setFilter(new QFilter("payeracctbank", "=", (Object)this.getPk("accountbank")));
                lfp.setFilter(new QFilter("currency", "=", (Object)this.getPk("currency")));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()));
                lfp.setFilter(new QFilter("bizdate", "<=", model.getValue("bizdate")));
                lfp.setFilter(new QFilter("isrepulsed", "=", (Object)"0"));
                lfp.setFilter(new QFilter("entry.e_isrefund", "=", (Object)"0"));
                lfp.setFilter(new QFilter("entry.e_issuccess", "=", (Object)"1"));
                lfp.setFilter(new QFilter("entry.e_isrepaid", "=", (Object)"0"));
            }
        }
        this.setIFilters(lfp, this.getModel().getDataEntity());
        if (CasHelper.isNotEmpty((Object)coreBillSetting)) {
            Map showParams = CoreBillSettingHelper.dealShowF7CustomParams((DynamicObject)coreBillSetting, (IDataModel)this.getModel(), (boolean)false);
            lsp.setCustomParams(showParams);
        }
        if (ClaimCoreBillTypeEnum.SALCONTRACT.getValue().equals(corebilltype)) {
            lfp.setSelectEntity("payentry");
        } else if (ClaimCoreBillTypeEnum.SALORDER.getValue().equals(corebilltype)) {
            lfp.setSelectEntity("recplanentry");
        } else if (ClaimCoreBillTypeEnum.FINARBILL.getValue().equals(corebilltype)) {
            lfp.setSelectEntity(ENTRY);
        }
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.setListFilterParameter(lfp);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "e_corebillno");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void settleNumberClick() {
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleType) && SettleMentTypeEnum.CREDIT.getValue().equals(settleType.getString("settlementtype"))) {
            String appId = AppMetadataCache.getAppInfo((String)"lc").getId();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            AppParam param = new AppParam();
            param.setAppId(appId);
            param.setOrgId(Long.valueOf(org.getLong("id")));
            param.setViewType("08");
            String recmethod = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"recmethod");
            if ("0".equals(recmethod)) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "settletnumber");
                QFilter qFilterSour = new QFilter("arrivalstatus", "=", (Object)"present_confirm");
                qFilterSour.and("arrivalway", "!=", (Object)"protest");
                qFilterSour.and(QFilter.sqlExpress((String)"arrivalamount", (String)">", (String)"flockamount"));
                qFilterSour.and("isforfaiting", "=", (Object)"0");
                qFilterSour.and("ispayconfig", "=", (Object)"0");
                CasBotpHelper.doBeforeDraw((IFormView)this.getView(), (String)"lc_present", (String)this.getModel().getDataEntityType().getName(), (Boolean)false, (QFilter)qFilterSour, (CloseCallBack)closeCallBack);
            }
        }
    }

    private void exratedateChanged(Object newValue) {
        if (newValue == null) {
            return;
        }
        this.setValue("exratedate", newValue);
    }

    private void accountCashChanged() {
        DynamicObject accountCash = this.getDynamicObject("accountcash");
        if (accountCash == null) {
            if (!this.isBotpCreate()) {
                this.setValue("currency", this.getDynamicObject("basecurrency"));
            }
            return;
        }
        DynamicObject currency = this.getDynamicObject("currency");
        boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"cas_accountcash", (Object)accountCash.getPkValue(), (DynamicObject)currency);
        if (!containCurrency) {
            DynamicObject defaultCurrency = accountCash.getDynamicObject("defaultcurrency");
            if (this.isBotpCreate()) {
                this.setValueIfAbsent("currency", defaultCurrency);
            } else {
                this.setValue("currency", defaultCurrency);
            }
        }
        this.setCurrencyEditable();
        this.setValue("openorg", accountCash.getDynamicObject("openorg"));
    }

    private void settleTypeChanged(DynamicObject settleType) {
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            this.getModel().beginInit();
            this.setValue("accountbank", null);
            this.setValue("payeebank", null);
            this.getModel().endInit();
            this.setValue("accountcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payee"));
        } else {
            this.setValue("accountcash", null);
        }
        if (BaseDataHelper.isSettleTypeMatch((DynamicObject)settleType)) {
            this.setValue("matchflag", AutoMatchFlagEnum.NONEED.getValue());
        }
        this.setPayeeInfo4Lb();
    }

    private void receivingTypeChanged(Object oldValue, Object newValue) {
        DynamicObject newobject = (DynamicObject)newValue;
        DynamicObject oldobject = (DynamicObject)oldValue;
        if (newobject != null && oldobject != null && newobject.getBoolean("ispartreceivable") != oldobject.getBoolean("ispartreceivable")) {
            this.addEntryCache();
            this.getModel().deleteEntryData(ENTRY);
            this.getModel().createNewEntryRow(ENTRY);
            this.setValue("actrecamt", BigDecimal.ZERO);
            this.setValue("localamt", BigDecimal.ZERO);
            this.getEntryCache();
            this.calculateAmt();
        }
        this.fillFundflowItem(true);
        this.setEntryAmountCaption();
        boolean multireceivingtype = this.getModel().getDataEntity().getBoolean("multireceivingtype");
        if (!multireceivingtype) {
            for (int i = 0; i < this.getModel().getEntryRowCount(ENTRY); ++i) {
                this.setValue("e_receivingtype", newobject, i);
            }
        }
    }

    private void setEntryAmountCaption() {
        DynamicObject recType = this.getDynamicObject("receivingtype");
        if (recType == null) {
            return;
        }
        boolean isAr = recType.getBoolean("ispartreceivable");
        if (isAr) {
            EntryGrid entryCtr = (EntryGrid)this.getControl(ENTRY);
            entryCtr.setColumnProperty("e_receivableamt", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"ReceivingBillEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            entryCtr.setColumnProperty("e_receivablelocamt", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u6298\u672c\u5e01", (String)"ReceivingBillEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        }
    }

    private void addEntryCache() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRY);
        ArrayList list = new ArrayList();
        for (DynamicObject row : entry) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("e_expenseitem", row.get("e_expenseitem") == null ? null : ((DynamicObject)row.get("e_expenseitem")).getPkValue());
            map.put("e_receivableamt", row.get("e_receivableamt"));
            map.put("project", row.get("project") == null ? null : row.getDynamicObject("project").getPkValue());
            map.put("e_fundflowitem", row.get("e_fundflowitem") == null ? null : row.getDynamicObject("e_fundflowitem").getPkValue());
            map.put("e_remark", row.get("e_remark"));
            map.put("e_receivingtype", row.get("e_receivingtype") == null ? null : row.getDynamicObject("e_receivingtype").getPkValue());
            list.add(map);
        }
        HashMap map = new HashMap();
        map.put(ENTRY, list);
        String mapJson = SerializationUtils.toJsonString(map);
        this.getPageCache().put(ENTRY, mapJson);
    }

    private void getEntryCache() {
        String str_json = this.getPageCache().get(ENTRY);
        if (str_json != null) {
            this.getModel().deleteEntryRow(ENTRY, 0);
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("e_expenseitem", new Object[0]).addField("e_receivableamt", new Object[0]).addField("project", new Object[0]).addField("e_fundflowitem", new Object[0]).addField("e_remark", new Object[0]).addField("e_receivingtype", new Object[0]);
            Map maps = (Map)SerializationUtils.fromJsonString((String)str_json, Map.class);
            ArrayList list = (ArrayList)maps.get(ENTRY);
            for (Map map : list) {
                vs.addRow(new Object[]{map.get("e_expenseitem"), map.get("e_receivableamt"), map.get("project"), map.get("e_fundflowitem"), map.get("e_remark"), map.get("e_receivingtype")});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(ENTRY, vs);
        }
    }

    private void setAgent(boolean newValue) {
        if (!newValue) {
            int count = this.getModel().getEntryRowCount(ENTRY);
            for (int i = 0; i < count; ++i) {
                this.setValue("realreccompany", null, i);
            }
        }
    }

    private void userF7Changed(PropertyChangedArgs e, Object newValue) {
        DynamicObject user = (DynamicObject)newValue;
        if (user != null) {
            DynamicObject erPayeeInfo = this.getErPayeeInfo(user.getLong("id"), user.get("name").toString());
            if (erPayeeInfo != null) {
                this.setValue("f7_payerbank", erPayeeInfo.getDynamicObject("payerbank"));
                this.setValue("payeracctbanknum", erPayeeInfo.getString("payeraccount"));
                this.setValue("payeraccformid", "er_payeer");
                this.setValue("payeracctbank", erPayeeInfo.getLong("id"));
            } else {
                this.setValue("payeracctbanknum", null);
                this.setValue("f7_payerbank", null);
                this.setValue("payeraccformid", null);
                this.setValue("payeracctbank", null);
            }
        } else {
            this.setValue("payeracctbanknum", null);
            this.setValue("f7_payerbank", null);
            this.setValue("payeraccformid", null);
            this.setValue("payeracctbank", null);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "changepayee": {
                this.changePayeePage();
                break;
            }
            case "addpayerlb1": 
            case "addpayerlb2": {
                this.addPayer(OperationStatus.ADDNEW);
                break;
            }
            case "changepayer": {
                this.addPayer(OperationStatus.EDIT);
                break;
            }
            case "e_corebillno": {
                this.getCorebilltypeToChange();
                break;
            }
            case "settletnumber": {
                this.settleNumberClick();
                break;
            }
        }
    }

    private void addPayer(OperationStatus status) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (this.isHwControl()) {
            paramMap.put("hw_payeesiteid", this.getValue("hw_payeesiteid"));
        }
        paramMap.put("org", this.getDynamicObject("org"));
        paramMap.put("asstActType", this.getString("payertype"));
        paramMap.put("currency", this.getPk("currency"));
        paramMap.put("billtype", this.getString("biztype"));
        paramMap.put("businesstype", this.getString("businesstype"));
        paramMap.put("settletype", this.getPk("settletype"));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_recaddpayer");
        parameter.setStatus(status);
        parameter.getCustomParams().putAll(paramMap);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addpayer"));
        this.getView().showForm(parameter);
    }

    private void changePayeePage() {
        DynamicObject settleType = this.getDynamicObject("settletype");
        HashMap<String, Boolean> payerInfo = new HashMap<String, Boolean>();
        payerInfo.put("virtual", BaseDataHelper.isSettleTypeVirtual((DynamicObject)settleType));
        payerInfo.put("ReceivingBill", true);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_changepayee");
        parameter.getCustomParams().putAll(payerInfo);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changepayee"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        Object returnData;
        boolean confirm;
        Map resultMap;
        super.closedCallBack(e);
        if ("changepayee".equals(e.getActionId()) && (resultMap = (Map)e.getReturnData()) != null) {
            this.changePayeeValue(resultMap);
        }
        if ("addpayer".equals(e.getActionId()) && (resultMap = (Map)e.getReturnData()) != null) {
            this.addPayerValue(resultMap);
        }
        if ("beforeSubmit".equals(e.getActionId()) && e != null && e.getReturnData() != null && (confirm = ((Boolean)e.getReturnData()).booleanValue())) {
            this.getView().invokeOperation("submit");
        }
        if ("beforesubmitnew".equals(e.getActionId()) && (confirm = (String)e.getReturnData()) != null && confirm.equals("ok")) {
            this.getView().invokeOperation("submitandnew");
        }
        if ("e_corebillno".equals(e.getActionId()) && !CasHelper.isEmpty((Object)(returnData = e.getReturnData()))) {
            IDataModel model = this.getModel();
            int currentRowIndex = model.getEntryCurrentRowIndex(ENTRY);
            String coreBillType = (String)model.getValue("e_corebilltype", currentRowIndex);
            String coreBillSettingStr = this.getPageCache().get("CORE_BILL_SETTING");
            DynamicObject coreBillSetting = null;
            if (CasHelper.isNotEmpty((Object)coreBillSettingStr)) {
                coreBillSetting = SerializeHelper.deserializeDynamicObj((String)"cas_corebill_setting", (String)coreBillSettingStr);
            }
            if (coreBillSetting != null) {
                this.coreBillSettingClosedCallBack(returnData, model, coreBillType, currentRowIndex, coreBillSetting);
            } else {
                this.srcDealClosedCallBack(returnData, model, coreBillType, currentRowIndex);
            }
        }
        if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)KEY_CLOSECALLBACK_CHARGEBACK)) {
            HashMap returnData2 = (HashMap)e.getReturnData();
            Object draftIdList = null;
            if (!EmptyUtil.isEmpty((Object)returnData2)) {
                draftIdList = returnData2.get("draftBillIdList");
            }
            if (draftIdList != null) {
                this.displayDraftInfo(draftIdList);
                OperateOption option = OperateOption.create();
                option.setVariableValue("draftids", JSON.toJSONString(draftIdList));
                option.setVariableValue("selectdraft", "true");
                this.getView().invokeOperation("receivingrec", option);
            }
        }
        if ("settletnumber".equals(e.getActionId()) && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)e.getReturnData()))) {
            this.getModel().deleteEntryData(ENTRY);
            this.getModel().deleteEntryData("detailinfo_entry");
            this.getModel().deleteEntryData("infoentry");
            CasBotpHelper.doDraw((IFormView)this.getView(), (String)"lc_present", (String)this.getModel().getDataEntityType().getName(), (ListSelectedRowCollection)rows);
        }
    }

    private void coreBillSettingClosedCallBack(Object returnData, IDataModel model, String coreBillType, int currentRowIndex, DynamicObject coreBillSetting) {
        List coreBillCollection = (List)returnData;
        int entryRowCount = model.getEntryRowCount(ENTRY);
        int followingRowCount = entryRowCount - currentRowIndex - 1;
        if (coreBillCollection.size() - 1 > followingRowCount) {
            model.appendEntryRow(ENTRY, entryRowCount - 1, coreBillCollection.size() - 1 - followingRowCount);
        }
        DynamicObject settleorg = (DynamicObject)model.getValue("e_settleorg", currentRowIndex);
        for (int i = 0; i < coreBillCollection.size(); ++i) {
            Map selectedRow = (Map)coreBillCollection.get(i);
            int rowIndex = currentRowIndex + i;
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_settleorg", (Object)settleorg, (int)rowIndex);
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_corebilltype", (Object)coreBillType, (int)rowIndex);
            CoreBillSettingHelper.setClosedCallBackInfo((Map)selectedRow, (DynamicObject)coreBillSetting, (IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIndex);
        }
    }

    private void srcDealClosedCallBack(Object returnData, IDataModel model, String coreBillType, int currentRowIndex) {
        ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)returnData;
        int entryRowCount = model.getEntryRowCount(ENTRY);
        int followingRowCount = entryRowCount - currentRowIndex - 1;
        if (coreBillCollection.size() - 1 > followingRowCount) {
            model.appendEntryRow(ENTRY, entryRowCount - 1, coreBillCollection.size() - 1 - followingRowCount);
        }
        DynamicObject settleorg = (DynamicObject)model.getValue("e_settleorg", currentRowIndex);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam("isSelectCoreBillNo", (Object)"true");
        HashMap<Integer, Long> actMap = new HashMap<Integer, Long>(coreBillCollection.size());
        for (int i = 0; i < coreBillCollection.size(); ++i) {
            ListSelectedRow listSelectedRow = coreBillCollection.get(i);
            model.setValue("e_settleorg", (Object)settleorg, currentRowIndex + i);
            this.getModel().beginInit();
            model.setValue("e_corebilltype", (Object)coreBillType, currentRowIndex + i);
            this.getModel().endInit();
            this.getView().updateView("e_corebilltype", currentRowIndex + i);
            this.getModel().beginInit();
            model.setValue("e_corebillno", (Object)listSelectedRow.getBillNo(), currentRowIndex + i);
            this.getModel().endInit();
            this.getView().updateView("e_corebillno", currentRowIndex + i);
            if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.REPAYMENTBILL.getValue())) {
                model.setValue("e_sourcebillid", listSelectedRow.getPrimaryKeyValue(), currentRowIndex + i);
                model.setValue("e_sourcebillentryid", listSelectedRow.getEntryPrimaryKeyValue(), currentRowIndex + i);
                actMap.put(currentRowIndex + i, (Long)listSelectedRow.getEntryPrimaryKeyValue());
            }
            model.setValue("e_corebillid", listSelectedRow.getPrimaryKeyValue(), currentRowIndex + i);
            String entryEntityKey = listSelectedRow.getEntryEntityKey();
            Object entryPKValue = listSelectedRow.getEntryPrimaryKeyValue();
            if (!kd.fi.cas.util.StringUtils.isEmpty((String)entryEntityKey) && !ObjectUtils.isEmpty((Object)entryPKValue)) {
                QFilter[] filters = new QFilter[]{new QFilter(entryEntityKey + ".id", "=", entryPKValue)};
                DynamicObject coreBill = QueryServiceHelper.queryOne((String)coreBillType, (String)(entryEntityKey + ".seq"), (QFilter[])filters);
                if (coreBill != null) {
                    model.setValue("e_corebillentryseq", (Object)coreBill.getString(entryEntityKey + ".seq"), currentRowIndex + i);
                    model.setValue("e_corebillentryid", entryPKValue, currentRowIndex + i);
                }
            } else {
                model.setValue("e_corebillentryseq", null, currentRowIndex + i);
                model.setValue("e_corebillentryid", null, currentRowIndex + i);
            }
            this.getModel().beginInit();
            if (ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType) || ClaimCoreBillTypeEnum.SALCONTRACT.getValue().equals(coreBillType)) {
                DynamicObject queryInfo;
                List<String> conGroupFields;
                boolean isMaterialEntry;
                boolean isSalOrder = ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType);
                boolean isSelectEntry = !kd.fi.cas.util.StringUtils.isEmpty((String)entryEntityKey) && !ObjectUtils.isEmpty((Object)entryPKValue);
                boolean bl = isMaterialEntry = !kd.fi.cas.util.StringUtils.isEmpty((String)entryEntityKey) && "billentry".equals(entryEntityKey);
                if (isSelectEntry && isMaterialEntry) {
                    conGroupFields = isSalOrder ? Arrays.asList(entryEntityKey + ".conbillnumber", entryEntityKey + ".conbillrownum", entryEntityKey + ".conbillid", entryEntityKey + ".conbillentryid") : Arrays.asList("id", "billno", entryEntityKey + ".lineno", entryEntityKey + ".id");
                    QFilter[] filters = new QFilter[]{new QFilter(entryEntityKey + ".id", "=", entryPKValue)};
                    queryInfo = QueryServiceHelper.queryOne((String)coreBillType, (String)String.join((CharSequence)",", conGroupFields), (QFilter[])filters);
                    if (queryInfo != null) {
                        model.setValue("conbillentity", (Object)"conm_salcontract", currentRowIndex + i);
                        model.setValue("conbillnumber", (Object)(isSalOrder ? queryInfo.getString(entryEntityKey + ".conbillnumber") : queryInfo.getString("billno")), currentRowIndex + i);
                        model.setValue("conbillrownum", (Object)(isSalOrder ? queryInfo.getString(entryEntityKey + ".conbillrownum") : queryInfo.getString(entryEntityKey + ".lineno")), currentRowIndex + i);
                    }
                } else {
                    if (isSalOrder) {
                        conGroupFields = Arrays.asList("billentry.conbillnumber", "billentry.conbillrownum", "billentry.conbillid", "billentry.conbillentryid");
                        QFilter filter = new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue());
                        queryInfo = QueryServiceHelper.queryOne((String)coreBillType, (String)String.join((CharSequence)",", conGroupFields), (QFilter[])new QFilter[]{filter});
                        if (queryInfo != null) {
                            model.setValue("conbillnumber", (Object)queryInfo.getString("billentry.conbillnumber"), currentRowIndex + i);
                        }
                    }
                    model.setValue("conbillentity", (Object)"conm_salcontract", currentRowIndex + i);
                    model.setValue("conbillrownum", (Object)"", currentRowIndex + i);
                }
            }
            this.getModel().endInit();
            this.getView().updateView("conbillentity", currentRowIndex + i);
            this.getView().updateView("conbillnumber", currentRowIndex + i);
            this.getView().updateView("conbillrownum", currentRowIndex + i);
        }
        if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.REPAYMENTBILL.getValue())) {
            QFilter qFilter = new QFilter("er_repaymentbill.repaymententry.id", "in", actMap.values());
            Map<Long, DynamicObject> actpayamt = QueryServiceHelper.query((String)"er_repaymentbill", (String)"er_repaymentbill.repaymententry.id id, er_repaymentbill.repaymententry.orirepayamount orirepayamount, er_repaymentbill.repaymententry.orirecamount orirecamount,er_repaymentbill.repaymententry.remarks remarks,er_repaymentbill.repaymententry.sourceexpenseitem.id expenseitem", (QFilter[])new QFilter[]{qFilter}).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (m1, m2) -> m1));
            DynamicObject repayDy = null;
            for (Map.Entry act : actMap.entrySet()) {
                repayDy = actpayamt.get(act.getValue());
                if (EmptyUtil.isNoEmpty((DynamicObject)repayDy)) {
                    this.getModel().setValue("e_receivableamt", (Object)repayDy.getBigDecimal("orirepayamount").subtract(repayDy.getBigDecimal("orirecamount")), ((Integer)act.getKey()).intValue());
                    this.getModel().setValue("e_actamt", (Object)repayDy.getBigDecimal("orirepayamount").subtract(repayDy.getBigDecimal("orirecamount")), ((Integer)act.getKey()).intValue());
                    this.getModel().setValue("e_remark", repayDy.get("remarks"), ((Integer)act.getKey()).intValue());
                    this.getModel().setValue("e_expenseitem", repayDy.get("expenseitem"), ((Integer)act.getKey()).intValue());
                    continue;
                }
                this.getModel().setValue("e_receivableamt", null, ((Integer)act.getKey()).intValue());
                this.getModel().setValue("e_actamt", null, ((Integer)act.getKey()).intValue());
                this.getModel().setValue("e_remark", null, ((Integer)act.getKey()).intValue());
                this.getModel().setValue("e_expenseitem", null, ((Integer)act.getKey()).intValue());
            }
        }
        formShowParameter.setCustomParam("isSelectCoreBillNo", (Object)"false");
    }

    private void displayDraftInfo(Object draftIdList) {
        if (EmptyUtil.isEmpty((Object)draftIdList)) {
            return;
        }
        List draftIds = (List)draftIdList;
        DynamicObjectCollection draftBills = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,rptype,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)draftIds)});
        Map recNewAvailamountMap = DraftHelper.getNewestAvailamountMap((DynamicObjectCollection)draftBills, (String)"draft");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("draftbillinfo", new Object[0]);
        vs.addField("recbillcurrency", new Object[0]);
        vs.addField("transamount", new Object[0]);
        vs.addField("draftbilllogid", new Object[0]);
        vs.addField("srcbilltype", new Object[0]);
        vs.addField("srcbillindex", new Object[0]);
        for (DynamicObject draftBill : draftBills) {
            long draftId = draftBill.getLong("id");
            vs.addRow(new Object[]{draftId, draftBill.getLong("currency"), recNewAvailamountMap.get(draftId), 0, "cas_recbill", 1});
        }
        model.batchCreateNewEntryRow("cas_draftinfo", vs);
        model.endInit();
        this.getView().updateView("cas_draftinfo");
    }

    private void addPayerValue(Map<String, Object> resultMap) {
        this.setValue("payerformid", resultMap.get("payerformid"));
        this.setValue("payer", resultMap.get("payer"));
        this.setValue("payername", resultMap.get("payername"));
        this.setValue("payernumber", resultMap.get("payernumber"));
        if (this.isHwControl()) {
            this.setValue("hw_payeesiteid", resultMap.get("hw_payeesiteid"));
            this.setValue("scorg", resultMap.get("scorg"));
        }
        this.setValue("payeraccformid", resultMap.get("payeraccformid"));
        this.setValue("payeracctbank", resultMap.get("payeracctbank"));
        this.setValue("payeracctbanknum", resultMap.get("payeracctbanknum"));
        this.setValue("f7_payerbank", resultMap.get("payerbank"));
        this.setValue("payerbankname", resultMap.get("payerbankname"));
        this.setPayerInfo4Lb();
        this.getValue("f7_payerbank");
    }

    private void setPayerInfo4Lb() {
        IBillModel model = (IBillModel)this.getModel();
        String payername = this.getString("payername");
        Image payeePic = (Image)this.getControl("payeepic");
        long payeeId = 0L;
        if (model.getValue("payer") != null) {
            payeeId = Long.parseLong(model.getValue("payer").toString());
        }
        String payertype = this.getString("payertype");
        String defaultUrl = BaseDataHelper.getPictureUrl((Long)payeeId, (String)payertype);
        String string = defaultUrl = defaultUrl == null ? "/kingdee/tmc/images/pc/icon/entrance/sky_fkf_80_80.png" : defaultUrl;
        if (!CasHelper.isEmpty((Object)payeeId)) {
            DynamicObject obj = null;
            if (payertype.equals("bd_supplier") || payertype.equals("bd_customer")) {
                obj = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeId, (String)payertype, (String)"name");
            } else if (payertype.equals("bos_user")) {
                obj = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeId, (String)payertype, (String)"name");
            }
            if (obj != null) {
                payername = CasHelper.getLocalValue((DynamicObject)obj, (String)"name");
            }
        }
        this.setValue("payername", payername);
        this.setValue("payeenamev", payername);
        payeePic.setUrl(defaultUrl);
        ((Label)this.getControl("payerbanknumv")).setText(kd.fi.cas.util.StringUtils.splitString((String)((String)model.getValue("payeracctbanknum")), (int)4, (String)" "));
        ((Label)this.getControl("payerbanknamev")).setText(this.getString("payerbankname"));
        boolean hasPayerInfo = this.hasPayerInfo();
        this.getView().setVisible(Boolean.valueOf(!hasPayerInfo), new String[]{"flex_addpayee"});
        this.getView().setVisible(Boolean.valueOf(hasPayerInfo), new String[]{"flex_payeeinfo"});
    }

    private void changePayeeValue(Map<String, Object> returnMap) {
        DynamicObject old_acctcash;
        DynamicObject new_acctcash;
        DynamicObject old_acctbank;
        DynamicObject new_acctbank;
        DynamicObject old_org;
        DynamicObject new_org = (DynamicObject)returnMap.get("org");
        if (!CasHelper.isEquals((Object)new_org, (Object)(old_org = this.getDynamicObject("org")))) {
            this.setValue("org", new_org);
            DynamicObject cur = OrgHelper.getBaseCurrency((long)((Long)new_org.getPkValue()));
            this.setValue("basecurrency", cur);
            this.setSettleOrg(false);
        }
        if (!CasHelper.isEquals((Object)(new_acctbank = (DynamicObject)returnMap.get("accountbank")), (Object)(old_acctbank = this.getDynamicObject("accountbank")))) {
            this.setValue("accountbank", new_acctbank);
        }
        if (!CasHelper.isEquals((Object)(new_acctcash = (DynamicObject)returnMap.get("accountcash")), (Object)(old_acctcash = this.getDynamicObject("accountcash")))) {
            this.setValue("accountcash", new_acctcash);
        }
        DynamicObject new_bank = (DynamicObject)returnMap.get("payeebank");
        DynamicObject old_bank = this.getDynamicObject("payeebank");
        if (!CasHelper.isEquals((Object)old_bank, (Object)new_bank)) {
            this.setValue("payeebank", new_bank);
        }
        DynamicObject newOpenOrg = (DynamicObject)returnMap.get("openorg");
        DynamicObject oldOpenOrg = this.getDynamicObject("openorg");
        if (!CasHelper.isEquals((Object)oldOpenOrg, (Object)newOpenOrg)) {
            this.setValue("openorg", newOpenOrg);
            for (int i = 0; i < this.getModel().getEntryRowCount(ENTRY); ++i) {
                this.setValue("e_settleorg", CasHelper.isNotEmpty((Object)newOpenOrg) ? newOpenOrg.getPkValue() : null, i);
            }
        }
        this.setPayeeInfo4Lb();
    }

    private DynamicObject getErPayeeInfo(long userId, String name) {
        QFilter uFilter = new QFilter("payer", "=", (Object)userId);
        uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')));
        QFilter eFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{uFilter, eFilter};
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number";
        String orderBys = "isdefault desc";
        DynamicObjectCollection defaultAccounts = QueryServiceHelper.query((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)orderBys, (int)1);
        DynamicObject dynamicObject = null;
        if (defaultAccounts != null && defaultAccounts.size() > 0) {
            dynamicObject = (DynamicObject)defaultAccounts.get(0);
        }
        return dynamicObject;
    }

    private void payeeF7Changed(PropertyChangedArgs e, Object newValue) {
        DynamicObject org = (DynamicObject)newValue;
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)orgId);
        if (defaultRecAccount != null && (BaseDataHelper.isSettleTypeVirtual((DynamicObject)this.getDynamicObject("settletype")) && VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultRecAccount).booleanValue() || !BaseDataHelper.isSettleTypeVirtual((DynamicObject)this.getDynamicObject("settletype")) && !VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultRecAccount).booleanValue())) {
            this.setValue("accountbank", defaultRecAccount);
        }
        DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
        this.setValue("basecurrency", baseCurrency);
    }

    private void payerTypeChanged(PropertyChangedArgs e, Object newValue, boolean isChanged) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_addpayee"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_payeeinfo"});
        Object value = null;
        this.setValue("payerformid", value);
        this.setValue("payer", value);
        this.setValue("payername", value);
        this.setValue("payeraccformid", value);
        this.setValue("payeracctbank", value);
        this.setValue("payeracctbanknum", value);
        this.setValue("f7_payerbank", value);
        this.setValue("payerbankname", value);
    }

    private void currencyF7Changed() {
        this.setExchangerateEditable();
    }

    private void calculateAmtByActamt() {
        DynamicObject currency;
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        String quotation = this.getString("quotation");
        if (null == quotation) {
            quotation = this.quoteType();
        }
        BigDecimal fee = this.getBigDecimal("fee");
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ONE;
        }
        if (fee == null) {
            fee = BigDecimal.ZERO;
        }
        if ((currency = this.getDynamicObject("currency")) == null) {
            return;
        }
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int count = this.getModel().getEntryRowCount(ENTRY);
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumFee = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal actAndDisc = rowInfo.getBigDecimal("e_actamt").add(rowInfo.getBigDecimal("e_discountamt"));
            amount = amount.add(actAndDisc);
        }
        BigDecimal countFee = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            BigDecimal discountAmt;
            this.getModel().beginInit();
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal actAmount = rowInfo.getBigDecimal("e_actamt");
            if (actAmount != null) {
                BigDecimal localAmt = QuotationHelper.callToCurrency((BigDecimal)actAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                this.setValue("e_localamt", localAmt, i);
                sumLocalAmt = sumLocalAmt.add(localAmt);
            }
            if ((discountAmt = rowInfo.getBigDecimal("e_discountamt")) != null) {
                this.setValue("e_discountlocamt", QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            this.setValue("e_unsettledamt", actAmount, i);
            this.setValue("e_unlockamt", actAmount, i);
            if (actAmount != null) {
                BigDecimal actAmtAndDisc = actAmount.add(discountAmt);
                this.setValue("e_fee", BigDecimal.ZERO, i);
                if (amount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal efee = actAmtAndDisc.multiply(fee).divide(amount, currency.getInt("amtprecision"), RoundingMode.DOWN);
                    if (this.getLastRow(i).booleanValue()) {
                        efee = fee.subtract(countFee);
                    }
                    countFee = countFee.add(efee);
                    this.setValue("e_fee", efee, i);
                    sumFee = sumFee.add(efee);
                    actAmtAndDisc = actAmtAndDisc.add(efee);
                }
                this.setValue("e_receivableamt", actAmtAndDisc, i);
                this.setValue("e_receivablelocamt", QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
                this.setValue("e_unsettledamt", actAmtAndDisc, i);
                if (actAmtAndDisc != null) {
                    this.setValue("e_unsettledlocalamt", QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
                }
                this.setValue("e_unlockamt", actAmtAndDisc, i);
            }
            if (actAmount != null) {
                sumAmt = sumAmt.add(actAmount);
            }
            this.getModel().endInit();
            this.getView().updateView("e_fee", i);
            this.getView().updateView("e_receivableamt", i);
            this.getView().updateView("e_receivablelocamt", i);
            this.getView().updateView("e_receivablelocamt", i);
            this.getView().updateView("e_discountlocamt", i);
            this.getView().updateView("e_unsettledamt", i);
            this.getView().updateView("e_unlockamt", i);
            this.getView().updateView("e_localamt", i);
        }
        this.setValue("actrecamt", sumAmt);
        this.setValue("fee", sumFee);
        this.setValue("localamt", sumLocalAmt);
    }

    private String quoteType() {
        Map exchangeRateByRules;
        DynamicObject currency = this.getDynamicObject("currency");
        DynamicObject baseCurrency = this.getDynamicObject("basecurrency");
        DynamicObject exRateTable = this.getDynamicObject("exratetable");
        Date exRateDate = (Date)this.getValue("exratedate");
        String quoteType = "0";
        if (currency != null && baseCurrency != null && exRateTable != null && exRateDate != null && (exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency.getLong("id"), (Long)baseCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exRateDate)).get("quoteType") != null && ((Boolean)exchangeRateByRules.get("quoteType")).booleanValue()) {
            quoteType = "1";
        }
        return quoteType;
    }

    private void calculateAmt() {
        IDataModel model = this.getModel();
        Object org = model.getValue("org");
        if (org != null) {
            int cs = SystemParameterHelper.getParameterInteger((long)((DynamicObject)org).getLong("id"), (String)"cs117");
            if (RecAmtTypeEnum.RECEIVABLEAMT.getValue().equals(String.valueOf(cs))) {
                this.calculateAmtByRecamt();
            } else {
                this.calculateAmtByActamt();
            }
        }
    }

    private void calculateAmtByRecamt() {
        String quotation = this.getString("quotation");
        if (null == quotation) {
            quotation = this.quoteType();
        }
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        BigDecimal fee = this.getBigDecimal("fee");
        DynamicObject currency = this.getDynamicObject("currency");
        if (currency == null) {
            return;
        }
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int count = this.getModel().getEntryRowCount(ENTRY);
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumFee = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal subtract = rowInfo.getBigDecimal("e_receivableamt").subtract(rowInfo.getBigDecimal("e_discountamt"));
            amount = amount.add(subtract);
        }
        BigDecimal countFee = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            BigDecimal discountAmt;
            this.getModel().beginInit();
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal recAmount = rowInfo.getBigDecimal("e_receivableamt");
            if (recAmount != null) {
                this.setValue("e_receivablelocamt", QuotationHelper.callToCurrency((BigDecimal)recAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            if ((discountAmt = rowInfo.getBigDecimal("e_discountamt")) != null) {
                this.setValue("e_discountlocamt", QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            if (recAmount != null) {
                BigDecimal actAmt = recAmount.subtract(discountAmt);
                this.setValue("e_fee", BigDecimal.ZERO, i);
                if (amount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal efee = actAmt.multiply(fee).divide(amount, currency.getInt("amtprecision"), RoundingMode.DOWN);
                    if (this.getLastRow(i).booleanValue()) {
                        efee = fee.subtract(countFee);
                    }
                    countFee = countFee.add(efee);
                    this.setValue("e_fee", efee, i);
                    sumFee = sumFee.add(efee);
                    actAmt = actAmt.subtract(efee);
                }
                sumAmt = sumAmt.add(actAmt);
                this.setValue("e_actamt", actAmt, i);
                BigDecimal localAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                this.setValue("e_localamt", localAmt, i);
                sumLocalAmt = sumLocalAmt.add(localAmt);
            }
            this.setValue("e_unsettledamt", recAmount, i);
            if (recAmount != null) {
                this.setValue("e_unsettledlocalamt", QuotationHelper.callToCurrency((BigDecimal)recAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            this.setValue("e_unlockamt", recAmount, i);
            this.getModel().endInit();
            this.getView().updateView("e_fee", i);
            this.getView().updateView("e_actamt", i);
            this.getView().updateView("e_localamt", i);
            this.getView().updateView("e_receivablelocamt", i);
            this.getView().updateView("e_discountlocamt", i);
            this.getView().updateView("e_unsettledamt", i);
            this.getView().updateView("e_unlockamt", i);
            this.getView().updateView("e_unlockamt", i);
            this.getView().updateView("e_unsettledlocalamt", i);
        }
        this.setValue("actrecamt", sumAmt);
        this.setValue("fee", sumFee);
        this.setValue("localamt", sumLocalAmt);
    }

    private void calculateAmtImport() {
        IDataModel model = this.getModel();
        Object org = model.getValue("org");
        if (org != null) {
            int cs = SystemParameterHelper.getParameterInteger((long)((DynamicObject)org).getLong("id"), (String)"cs117");
            if (RecAmtTypeEnum.RECEIVABLEAMT.getValue().equals(String.valueOf(cs))) {
                this.calculateAmtByRecamtImport();
            } else {
                this.calculateAmtByActamtImport();
            }
        }
    }

    private void calculateAmtByActamtImport() {
        DynamicObject currency;
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        String quotation = this.getString("quotation");
        if (null == quotation) {
            quotation = this.quoteType();
        }
        this.getModel().setValue("quotation", (Object)quotation);
        BigDecimal fee = this.getBigDecimal("fee");
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ONE;
        }
        if (fee == null) {
            fee = BigDecimal.ZERO;
        }
        if ((currency = this.getDynamicObject("currency")) == null) {
            return;
        }
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int count = this.getModel().getEntryRowCount(ENTRY);
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal actAndDisc = rowInfo.getBigDecimal("e_actamt").add(rowInfo.getBigDecimal("e_discountamt"));
            amount = amount.add(actAndDisc);
        }
        boolean feeTemp = false;
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal e_fee = rowInfo.getBigDecimal("e_fee");
            if (!CasHelper.isNotEmpty((Object)e_fee)) continue;
            feeTemp = true;
            break;
        }
        BigDecimal sumFee = BigDecimal.ZERO;
        BigDecimal countFee = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            BigDecimal actAmtAndDisc;
            BigDecimal discountAmt;
            this.getModel().beginInit();
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal actAmount = rowInfo.getBigDecimal("e_actamt");
            if (actAmount != null) {
                BigDecimal localAmt = QuotationHelper.callToCurrency((BigDecimal)actAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                this.setValue("e_localamt", localAmt, i);
                sumLocalAmt = sumLocalAmt.add(localAmt);
            }
            if ((discountAmt = rowInfo.getBigDecimal("e_discountamt")) != null) {
                this.setValue("e_discountlocamt", QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            this.setValue("e_unsettledamt", actAmount, i);
            this.setValue("e_unlockamt", actAmount, i);
            if (actAmount != null && !feeTemp) {
                actAmtAndDisc = actAmount.add(discountAmt);
                this.setValue("e_fee", BigDecimal.ZERO, i);
                if (amount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal efee = actAmtAndDisc.multiply(fee).divide(amount, currency.getInt("amtprecision"), RoundingMode.DOWN);
                    if (this.getLastRow(i).booleanValue()) {
                        efee = fee.subtract(countFee);
                    }
                    countFee = countFee.add(efee);
                    this.setValue("e_fee", efee, i);
                    actAmtAndDisc = actAmtAndDisc.add(efee);
                }
                this.setValue("e_receivableamt", actAmtAndDisc, i);
                this.setValue("e_receivablelocamt", QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
                this.setValue("e_unsettledamt", actAmtAndDisc, i);
                if (actAmtAndDisc != null) {
                    this.setValue("e_unsettledlocalamt", QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
                }
                this.setValue("e_unlockamt", actAmtAndDisc, i);
            }
            if (actAmount != null && feeTemp) {
                actAmtAndDisc = actAmount.add(discountAmt);
                BigDecimal e_fee = rowInfo.getBigDecimal("e_fee");
                if (e_fee != null) {
                    sumFee = e_fee.add(sumFee);
                    actAmtAndDisc = actAmtAndDisc.add(e_fee);
                }
                this.setValue("e_receivableamt", actAmtAndDisc, i);
                this.setValue("e_receivablelocamt", QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
                this.setValue("e_unsettledamt", actAmtAndDisc, i);
                if (actAmtAndDisc != null) {
                    this.setValue("e_unsettledlocalamt", QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
                }
                this.setValue("e_unlockamt", actAmtAndDisc, i);
            }
            if (actAmount != null) {
                sumAmt = sumAmt.add(actAmount);
            }
            this.getModel().endInit();
            this.getView().updateView("e_fee", i);
            this.getView().updateView("e_receivableamt", i);
            this.getView().updateView("e_receivablelocamt", i);
            this.getView().updateView("e_receivablelocamt", i);
            this.getView().updateView("e_discountlocamt", i);
            this.getView().updateView("e_unsettledamt", i);
            this.getView().updateView("e_unlockamt", i);
            this.getView().updateView("e_localamt", i);
        }
        this.setValue("actrecamt", sumAmt);
        this.setValue("localamt", sumLocalAmt);
        if (feeTemp) {
            this.setValue("fee", sumFee);
        }
    }

    private void calculateAmtByRecamtImport() {
        String quotation = this.getString("quotation");
        if (null == quotation) {
            quotation = this.quoteType();
        }
        this.getModel().setValue("quotation", (Object)quotation);
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        BigDecimal fee = this.getBigDecimal("fee");
        DynamicObject currency = this.getDynamicObject("currency");
        if (currency == null) {
            return;
        }
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int count = this.getModel().getEntryRowCount(ENTRY);
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal subtract = rowInfo.getBigDecimal("e_receivableamt").subtract(rowInfo.getBigDecimal("e_discountamt"));
            amount = amount.add(subtract);
        }
        boolean feeTemp = false;
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal e_fee = rowInfo.getBigDecimal("e_fee");
            if (!CasHelper.isNotEmpty((Object)e_fee)) continue;
            feeTemp = true;
            break;
        }
        BigDecimal sumFee = BigDecimal.ZERO;
        BigDecimal countFee = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            BigDecimal actAmt;
            BigDecimal discountAmt;
            this.getModel().beginInit();
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            BigDecimal recAmount = rowInfo.getBigDecimal("e_receivableamt");
            if (recAmount != null) {
                this.setValue("e_receivablelocamt", QuotationHelper.callToCurrency((BigDecimal)recAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            if ((discountAmt = rowInfo.getBigDecimal("e_discountamt")) != null) {
                this.setValue("e_discountlocamt", QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            if (recAmount != null && !feeTemp) {
                actAmt = recAmount.subtract(discountAmt);
                this.setValue("e_fee", BigDecimal.ZERO, i);
                if (amount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal efee = actAmt.multiply(fee).divide(amount, currency.getInt("amtprecision"), RoundingMode.DOWN);
                    if (this.getLastRow(i).booleanValue()) {
                        efee = fee.subtract(countFee);
                    }
                    countFee = countFee.add(efee);
                    this.setValue("e_fee", efee, i);
                    actAmt = actAmt.subtract(efee);
                }
                sumAmt = sumAmt.add(actAmt);
                this.setValue("e_actamt", actAmt, i);
                BigDecimal localAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                this.setValue("e_localamt", localAmt, i);
                sumLocalAmt = sumLocalAmt.add(localAmt);
            }
            if (recAmount != null && feeTemp) {
                actAmt = recAmount.subtract(discountAmt);
                BigDecimal e_fee = rowInfo.getBigDecimal("e_fee");
                if (e_fee != null) {
                    sumFee = e_fee.add(sumFee);
                    actAmt = actAmt.subtract(e_fee);
                }
                sumAmt = sumAmt.add(actAmt);
                this.setValue("e_actamt", actAmt, i);
                BigDecimal localAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                this.setValue("e_localamt", localAmt, i);
                sumLocalAmt = sumLocalAmt.add(localAmt);
            }
            this.setValue("e_unsettledamt", recAmount, i);
            if (recAmount != null) {
                this.setValue("e_unsettledlocalamt", QuotationHelper.callToCurrency((BigDecimal)recAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round), i);
            }
            this.setValue("e_unlockamt", recAmount, i);
            this.getModel().endInit();
            this.getView().updateView("e_fee", i);
            this.getView().updateView("e_actamt", i);
            this.getView().updateView("e_localamt", i);
            this.getView().updateView("e_receivablelocamt", i);
            this.getView().updateView("e_discountlocamt", i);
            this.getView().updateView("e_unsettledamt", i);
            this.getView().updateView("e_unlockamt", i);
            this.getView().updateView("e_unlockamt", i);
            this.getView().updateView("e_unsettledlocalamt", i);
        }
        this.setValue("actrecamt", sumAmt);
        this.setValue("localamt", sumLocalAmt);
        if (feeTemp) {
            this.setValue("fee", sumFee);
        }
    }

    private void calculateFee(int iRow) {
        IDataModel model = this.getModel();
        Object org = model.getValue("org");
        if (org != null) {
            int cs = SystemParameterHelper.getParameterInteger((long)((DynamicObject)org).getLong("id"), (String)"cs117");
            if (RecAmtTypeEnum.RECEIVABLEAMT.getValue().equals(String.valueOf(cs))) {
                this.calculateFeeByRec(iRow);
            } else {
                this.calculateFeeAct(iRow);
            }
        }
    }

    private void calculateFeeByRec(int iRow) {
        IFormView view = this.getView();
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        String quotation = this.getString("quotation");
        DynamicObject currency = this.getDynamicObject("currency");
        if (currency == null) {
            return;
        }
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int count = this.getModel().getEntryRowCount(ENTRY);
        BigDecimal countFee = BigDecimal.ZERO;
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal actAmt = BigDecimal.ZERO;
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        this.getModel().beginInit();
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            if (iRow == i) {
                BigDecimal recAmount = rowInfo.getBigDecimal("e_receivableamt");
                BigDecimal discountAmt = rowInfo.getBigDecimal("e_discountamt");
                actAmt = recAmount.subtract(discountAmt);
                actAmt = actAmt.subtract(rowInfo.getBigDecimal("e_fee"));
                BigDecimal actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                this.setValue("e_actamt", actAmt, i);
                this.setValue("e_localamt", actLocalAmt, i);
                view.updateView("e_actamt", i);
                view.updateView("e_localamt", i);
            } else {
                actAmt = rowInfo.getBigDecimal("e_actamt");
            }
            sumAmt = sumAmt.add(actAmt);
            sumLocalAmt = sumLocalAmt.add(rowInfo.getBigDecimal("e_localamt"));
            fee = rowInfo.getBigDecimal("e_fee");
            countFee = countFee.add(fee);
        }
        this.setValue("actrecamt", sumAmt);
        this.setValue("localamt", sumLocalAmt);
        this.setValue("fee", countFee);
        this.getModel().endInit();
        view.updateView("fee");
        view.updateView("actrecamt");
        view.updateView("localamt");
    }

    private void calculateFeeAct(int iRow) {
        IFormView view = this.getView();
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        String quotation = this.getString("quotation");
        DynamicObject currency = this.getDynamicObject("currency");
        if (currency == null) {
            return;
        }
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int count = this.getModel().getEntryRowCount(ENTRY);
        BigDecimal countFee = BigDecimal.ZERO;
        BigDecimal actAmt = BigDecimal.ZERO;
        BigDecimal fee = BigDecimal.ZERO;
        this.getModel().beginInit();
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity(ENTRY, i);
            if (iRow == i) {
                BigDecimal recAmount = rowInfo.getBigDecimal("e_actamt");
                BigDecimal discountAmt = rowInfo.getBigDecimal("e_discountamt");
                actAmt = recAmount.add(discountAmt);
                actAmt = actAmt.add(rowInfo.getBigDecimal("e_fee"));
                BigDecimal actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                this.setValue("e_receivableamt", actAmt, i);
                this.setValue("e_receivablelocamt", actLocalAmt, i);
                this.setValue("e_unsettledamt", actAmt, i);
                this.setValue("e_unlockamt", actAmt, i);
                view.updateView("e_unsettledamt", i);
                view.updateView("e_unlockamt", i);
                view.updateView("e_receivableamt", i);
                view.updateView("e_receivablelocamt", i);
            }
            fee = rowInfo.getBigDecimal("e_fee");
            countFee = countFee.add(fee);
        }
        this.setValue("fee", countFee);
        this.getModel().endInit();
        view.updateView("fee");
    }

    public Boolean getLastRow(int row) {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRY);
        if (row < entryRowCount - 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void payeeAcctBankF7Changed(PropertyChangedArgs e, Object newValue) {
        DynamicObject payeeAcctBank = (DynamicObject)newValue;
        if (payeeAcctBank != null) {
            DynamicObject currency = this.getDynamicObject("currency");
            boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"bd_accountbanks", (Object)payeeAcctBank.getPkValue(), (DynamicObject)currency);
            if (!containCurrency) {
                Long currencyId = (Long)payeeAcctBank.get("defaultcurrency.id");
                if (this.isBotpCreate()) {
                    this.setValueIfAbsent("currency", currencyId);
                } else {
                    this.setValue("currency", currencyId);
                }
            }
            this.setValue("payeebank", payeeAcctBank.getDynamicObject("bank"));
            this.setCurrencyEditable();
        } else {
            this.setValue("payeebank", null);
            if (!this.isBotpCreate()) {
                this.setValue("currency", this.getDynamicObject("basecurrency"));
            }
        }
        this.setOpenOrg();
        this.setSettleOrg(false);
    }

    private void fillPayeeAcctBank() {
        BasedataEdit payerAcctBankF7 = (BasedataEdit)this.getControl("accountbank");
        payerAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setIsolationOrg(false);
            DynamicObject payee = (DynamicObject)this.getModel().getValue("org");
            if (payee != null) {
                QFilter[] usableAccountFilter = AccountBankHelper.getUsableAccountFilter((long)((Long)payee.getPkValue()));
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(usableAccountFilter));
            } else {
                showParameter.getListFilterParameter().setFilter(AccountBankHelper.getUsableFilter());
            }
        });
    }

    private void fillRecType() {
        BasedataEdit receivabletypeF7 = (BasedataEdit)this.getControl("receivingtype");
        receivabletypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            boolean multireceivingtype = (Boolean)this.getModel().getValue("multireceivingtype");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            String rectype = this.getModel().getValue("biztype").toString();
            if (RecTypeEnum.SalesRec.toString().equals(rectype)) {
                qFilter.and("ispartreceivable", "=", (Object)"1");
            }
            if ("sm_salorder".equals(this.getString("sourcebilltype")) || "conm_salcontract".equals(this.getString("sourcebilltype"))) {
                qFilter.and(new QFilter("biztype", "=", (Object)"101"));
                qFilter.and(new QFilter("ispartreceivable", "=", (Object)"1"));
            }
            if (multireceivingtype) {
                qFilter.and(new QFilter("biztype", "=", (Object)"110"));
            } else {
                qFilter.and(new QFilter("biztype", "!=", (Object)"110"));
            }
            if (multireceivingtype) {
                QFilter multipaymenttypeqFilter = new QFilter("enable", "=", (Object)"1");
                multipaymenttypeqFilter.and(new QFilter("biztype", "=", (Object)"110"));
                qFilter = multipaymenttypeqFilter;
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object obj = this.getModel().getContextVariable("IGNORE_RELOADDATAMODEL");
        if (null != obj && ((Boolean)obj).booleanValue()) {
            return;
        }
        BillModel model = (BillModel)this.getModel();
        if (!model.isFromImport()) {
            this.createNewModel();
        }
    }

    private void createNewModel() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        IBillModel model = (IBillModel)this.getModel();
        Object org = model.getValue("org");
        if (org == null) {
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            List authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_recbill", (String)"47156aff000000ac");
            if (!CollectionUtils.isEmpty((Collection)authorizedBankOrgId)) {
                this.setValue("org", authorizedBankOrgId.get(0));
            }
        }
        DynamicObject receivingtype = this.getDynamicObject("receivingtype");
        DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY);
        for (DynamicObject entry : entrys) {
            entry.set("e_receivingtype", (Object)receivingtype);
        }
        if (customParams != null && customParams.containsKey("recmentType")) {
            Map recbilltypes;
            String bizType = "999";
            String rectype = (String)customParams.get("recmentType");
            boolean multireceivingtype = (Boolean)this.getModel().getValue("multireceivingtype");
            this.getModel().setValue("biztype", (Object)rectype);
            if (rectype.equals(RecTypeEnum.OtherRec.toString())) {
                this.setValue("payertype", AsstActTypeEnum.OTHER.getValue());
                if (!multireceivingtype) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_material"});
                }
            } else {
                bizType = "100";
                this.setValue("payertype", AsstActTypeEnum.CUSTOMER.getValue());
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_material"});
            }
            QFilter filter = new QFilter("biztype", "=", (Object)bizType).and(new QFilter("enable", "=", (Object)"1"));
            if (RecTypeEnum.SalesRec.toString().equals(this.getModel().getValue("biztype"))) {
                filter.and("ispartreceivable", "=", (Object)"1");
            }
            if (EmptyUtil.isNoEmpty((Object)(recbilltypes = BusinessDataServiceHelper.loadFromCache((String)"cas_receivingbilltype", (String)"fid,enable,fundflowitem,number,name,biztype,ispartreceivable,description,predata,default", (QFilter[])new QFilter[]{filter}, (String)"default desc,predata desc")))) {
                Iterator iterator = recbilltypes.entrySet().iterator();
                if (iterator.hasNext()) {
                    DynamicObject receivingType = (DynamicObject)iterator.next().getValue();
                    this.setValue("receivingtype", receivingType);
                    this.setEntryExpenseitemEnable();
                    for (DynamicObject entry : entrys) {
                        entry.set("e_receivingtype", (Object)receivingType);
                    }
                }
            } else {
                this.setValue("receivingtype", null);
            }
        }
        Date currentDate = DateUtils.getCurrentDate();
        this.setValueIfAbsent("bizdate", currentDate);
        this.setValueIfAbsent("exratedate", currentDate);
        org = model.getValue("org");
        if (org != null) {
            Long orgId = (Long)((DynamicObject)org).getPkValue();
            this.setDefaultExratetable(orgId);
            if (!SystemStatusCtrolHelper.isInitEnable((long)orgId)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit"});
                this.getView().showErrorNotification(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)((DynamicObject)org), (String)"name")));
                return;
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"ReceivingBillEdit_34", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"payeebank"});
        this.setValueIfAbsent("settletype", BaseDataHelper.getDefaultSettleType());
        this.payeeF7Changed(null, this.getValue("org"));
        this.payeeAcctBankF7Changed(null, this.getDynamicObject("accountbank"));
        this.currencyF7Changed();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"customerf7"});
        this.setPayeeInfo4Lb();
        this.fillPayerType();
        this.setOpenOrg();
        this.setSettleOrg(false);
        this.setSettleValue(0);
        DynamicObject settleType = this.getDynamicObject("settletype");
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType) && org != null) {
            Long orgId = (Long)((DynamicObject)org).getPkValue();
            this.setValue("accountcash", AccountCashHelper.getDefaultAccountcash((Long)orgId, (String)"payee"));
            this.setValue("accountbank", null);
        }
        this.fillFundflowItem(true);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.isBotpNew()) {
            this.supplePayerInfo();
            DynamicObject settleType = this.getDynamicObject("settletype");
            Object org = this.getModel().getValue("org");
            if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType) && org != null) {
                this.setValue("accountbank", null);
                Long orgId = (Long)((DynamicObject)org).getPkValue();
                this.setValue("accountcash", AccountCashHelper.getDefaultAccountcash((Long)orgId, (String)"payee"));
            }
            if (CasHelper.isEmpty((Object)this.getModel().getValue("exchangerate"))) {
                this.getModel().setValue("exchangerate", (Object)BigDecimal.ONE);
            }
        }
    }

    private void supplePayerInfo() {
        Object sourcebilltype = this.getModel().getValue("sourcebilltype");
        if (!CasHelper.isEmpty((Object)sourcebilltype)) {
            String billName;
            Map resultMap;
            Object payer = this.getModel().getValue("payer");
            Object payeracctbanknumMo = this.getModel().getValue("payeracctbanknum");
            Object payeebankMo = this.getModel().getValue("f7_payerbank");
            Object payertype = this.getValue("payertype");
            if (CasHelper.isEmpty((Object)payeracctbanknumMo) && CasHelper.isEmpty((Object)payeebankMo) && (resultMap = CasPayeeOrPayerHelper.getPayeeOrPayerInfo((Object)payer, (Object)payertype, (String)(billName = this.getModel().getDataEntityType().getName()))).size() > 0) {
                Object payeracctbanknum = resultMap.get("payeracctbanknum");
                DynamicObject f7_payerbank = (DynamicObject)resultMap.get("f7_payerbank");
                this.getModel().setValue("payeracctbanknum", payeracctbanknum);
                if (!CasHelper.isEmpty((Object)f7_payerbank)) {
                    this.getModel().setValue("f7_payerbank", (Object)f7_payerbank);
                    this.getModel().setValue("payerbankname", (Object)CasHelper.getLocalValue((DynamicObject)f7_payerbank, (String)"name"));
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.calculateAmt();
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObject cur = OrgHelper.getBaseCurrency((long)this.getPk("org"));
        this.setValue("basecurrency", cur);
        DynamicObject accountBank = this.getDynamicObject("accountbank");
        if (accountBank != null) {
            this.setValue("payeebank", accountBank.getDynamicObject("bank"));
            Object openorg = this.getValue("openorg");
            if (CasHelper.isEmpty((Object)openorg)) {
                this.setValue("openorg", accountBank.getDynamicObject("openorg"));
            }
            DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRY);
            for (DynamicObject rowInfo : entry) {
                Object rowOpenOrg = rowInfo.get("e_settleorg");
                if (!CasHelper.isEmpty((Object)rowOpenOrg)) continue;
                this.setValueIfAbsent("e_settleorg", accountBank.getDynamicObject("openorg"), rowInfo.getInt("seq") - 1);
            }
        }
        this.calculateAmtImport();
        DynamicObject receivingtype = this.getDynamicObject("receivingtype");
        if (receivingtype != null) {
            receivingtype = BusinessDataServiceHelper.loadSingleFromCache((Object)receivingtype.getPkValue(), (String)"cas_receivingbilltype", (String)"id,fundflowitem");
            this.fillFundflowItem(true);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object operate = parameter.getCustomParam("operate");
        if (operate == null || operate.equals(OperateTypeEnum.COPY.name())) {
            this.create4Copy(false);
        } else if (operate.equals(OperateTypeEnum.OFFSET.name())) {
            this.create4Copy(true);
        }
        this.getModel().setValue("isrefund", (Object)false);
        this.getModel().setValue("isfullrefund", (Object)false);
        this.getModel().setValue("cas_draftinfo", null);
        this.getModel().setValue("logids", (Object)"");
    }

    private void create4Copy(boolean isOffset) {
        DynamicObject payeeAcctBank;
        IBillModel model = (IBillModel)this.getModel();
        int count = model.getEntryRowCount(ENTRY);
        for (int i = 0; i < count; ++i) {
            BigDecimal e_receivableamt = (BigDecimal)model.getValue("e_receivableamt", i);
            model.setValue("e_unlockamt", (Object)e_receivableamt, i);
            model.setValue("e_unsettledamt", (Object)e_receivableamt, i);
        }
        if (isOffset) {
            this.setNegateAmt(model);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        this.setPayerInfo4Lb();
        this.setPayeeInfo4Lb();
        String payeeTypeID = (String)model.getValue("payertype");
        if (AsstActTypeEnum.EMPLOYEE.getValue().equals(payeeTypeID) && CasHelper.isEmpty((Object)this.getModel().getValue("f7_payerbank")) && CasHelper.isEmpty((Object)this.getModel().getValue("payeracctbanknum"))) {
            this.userF7Changed(null, model.getValue("userf7"));
        }
        if ((payeeAcctBank = (DynamicObject)this.getModel().getValue("accountbank")) != null && !((Boolean)payeeAcctBank.get("ismulcurrency")).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        }
    }

    private void setNegateAmt(IBillModel model) {
        int count = model.getEntryRowCount(ENTRY);
        for (int i = 0; i < count; ++i) {
            model.setValue("e_actamt", (Object)((BigDecimal)model.getValue("e_actamt", i)).negate(), i);
            model.setValue("e_localamt", (Object)((BigDecimal)model.getValue("e_localamt", i)).negate(), i);
            model.setValue("e_receivableamt", (Object)((BigDecimal)model.getValue("e_receivableamt", i)).negate(), i);
            model.setValue("e_receivablelocamt", (Object)((BigDecimal)model.getValue("e_receivablelocamt", i)).negate(), i);
            model.setValue("e_discountamt", (Object)((BigDecimal)model.getValue("e_discountamt", i)).negate(), i);
            model.setValue("e_discountlocamt", (Object)((BigDecimal)model.getValue("e_discountlocamt", i)).negate(), i);
            model.setValue("e_unlockamt", (Object)((BigDecimal)model.getValue("e_unlockamt", i)).negate(), i);
        }
        model.setValue("actrecamt", (Object)((BigDecimal)model.getValue("actrecamt")).negate());
        model.setValue("localamt", (Object)((BigDecimal)model.getValue("localamt")).negate());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.afterBindData();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        this.controlRecAmt();
    }

    public void controlRecAmt() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int entryCount = model.getEntryRowCount(ENTRY);
        Object org = model.getValue("org");
        String field = "e_actamt";
        if (org != null) {
            boolean isFinish = SystemStatusCtrolHelper.isInitEnable((long)((DynamicObject)org).getLong("id"));
            this.getView().setEnable(Boolean.valueOf(isFinish), new String[]{"bar_save", "bar_submit"});
            if (!isFinish) {
                this.getView().showErrorNotification(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)((DynamicObject)org), (String)"name")));
            }
            int cs = SystemParameterHelper.getParameterInteger((long)((DynamicObject)org).getLong("id"), (String)"cs117");
            if (RecAmtTypeEnum.ACTAMT.getValue().equals(String.valueOf(cs))) {
                field = "e_receivableamt";
            }
        }
        String enableField = "e_actamt".equals(field) ? "e_receivableamt" : "e_actamt";
        ((FieldEdit)view.getControl(enableField)).setMustInput(true);
        for (int i = 0; i < entryCount; ++i) {
            view.setEnable(Boolean.valueOf(true), i, new String[]{enableField});
            view.setEnable(Boolean.valueOf(false), i, new String[]{field});
        }
    }

    public void afterBindData() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject editData = model.getDataEntity();
        this.fillToolBar();
        String sourcebilltype = editData.getString("sourcebilltype");
        this.fillterEntryReceType();
        if (!CasHelper.isEmpty((Object)sourcebilltype)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"copyentryrow"});
        }
        if ("cas_paybill".equals(sourcebilltype)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayee"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayer"});
        }
        this.fillPayerType();
        if (this.isBotpNew()) {
            DynamicObject cur = OrgHelper.getBaseCurrency((long)this.getPk("org"));
            if (cur == null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit"});
                this.getView().showErrorNotification(SystemStatusCtrolHelper.notFinishInitSetMsg((String)CasHelper.getLocalValue((DynamicObject)this.getDynamicObject("org"), (String)"name")));
                return;
            }
            DynamicObject accountBank = this.getDynamicObject("accountbank");
            if (accountBank != null) {
                this.setValueIfAbsent("payeebank", accountBank.getDynamicObject("bank"));
                this.setValueIfAbsent("openorg", accountBank.getDynamicObject("openorg"));
            }
            this.fillFundflowItem(false);
        }
        this.setSettleOrg(true);
        this.setPayerInfo4Lb();
        this.setPayeeInfo4Lb();
        this.setCurrencyEditable();
        this.setEntryAmountCaption();
        this.setExchangerateEditable();
        this.setEcorebilltype();
        this.showChargeReason();
        if ("cas_recbill".equals(sourcebilltype)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayer"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"e_actamt"});
        }
        this.getModel().setDataChanged(false);
    }

    private void fillterEntryReceType() {
        boolean ishavenull = false;
        DynamicObject defaultPayMentBillType = BusinessDataServiceHelper.loadSingle((Object)1833464176371407872L, (String)"cas_receivingbilltype");
        DynamicObject receivingtype = (DynamicObject)this.getModel().getValue("receivingtype");
        HashSet<DynamicObject> entryReceTypes = new HashSet<DynamicObject>(4);
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue(ENTRY);
        for (DynamicObject entry : entrys) {
            DynamicObject e_paymenttype = entry.getDynamicObject("e_receivingtype");
            if (e_paymenttype != null) {
                entryReceTypes.add(e_paymenttype);
                continue;
            }
            ishavenull = true;
        }
        if (entryReceTypes != null && entryReceTypes.size() > 0) {
            if (entryReceTypes.size() > 1) {
                this.getModel().setValue("multireceivingtype", (Object)true);
                if (receivingtype == null) {
                    this.getModel().setValue("receivingtype", (Object)defaultPayMentBillType);
                }
            } else {
                Iterator iterator;
                if (!ishavenull) {
                    this.getModel().setValue("multireceivingtype", (Object)false);
                }
                if (receivingtype == null && (iterator = entryReceTypes.iterator()).hasNext()) {
                    this.getModel().setValue("receivingtype", iterator.next());
                }
            }
        } else if (receivingtype != null) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("e_receivingtype", (Object)receivingtype, i);
            }
            this.getModel().setValue("multireceivingtype", (Object)false);
        }
    }

    private void showChargeReason() {
        Object chargereason = this.getModel().getValue("reason");
        if (chargereason != null && !"".equals(chargereason) && this.getPageCache().get("chargereason") == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u201c%1$s\u201d\u5df2\u9000\u5355\u3002\u9000\u5355\u539f\u56e0\uff1a%2$s", (String)"ReceivingBillEdit_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), String.valueOf(chargereason));
            this.getView().showMessage(msg);
            this.getPageCache().put("chargereason", "yes");
        }
    }

    private void setEcorebilltype() {
        ArrayList<ComboItem> coreComboItem = new ArrayList<ComboItem>();
        boolean isPartReceivable = false;
        boolean multireceivingtype = (Boolean)this.getModel().getValue("multireceivingtype");
        if (multireceivingtype) {
            ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_recbill").getProperty("settlecorebilltype");
            ComboProp propertyUn = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_recbill").getProperty("unsettlecorebilltype");
            this.getCoreComboItem(coreComboItem, property, false);
            this.getCoreComboItem(coreComboItem, propertyUn, true);
        } else {
            DynamicObject recType = this.getDynamicObject("receivingtype");
            isPartReceivable = recType != null && recType.getBoolean("ispartreceivable");
            String selectType = isPartReceivable ? "settlecorebilltype" : "unsettlecorebilltype";
            ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_recbill").getProperty(selectType);
            this.getCoreComboItem(coreComboItem, property, false);
        }
        CoreBillSettingHelper.setCoreBillTypeComboItem((String)"cas_recbill", (boolean)multireceivingtype, (boolean)isPartReceivable, coreComboItem);
        ComboEdit coreCbo = (ComboEdit)this.getView().getControl("e_corebilltype");
        coreCbo.setComboItems(coreComboItem);
    }

    private void getCoreComboItem(List<ComboItem> coreComboItem, ComboProp property, boolean isRepeat) {
        List comboItems;
        if (EmptyUtil.isNoEmpty((Object)property) && EmptyUtil.isNoEmpty((Object)(comboItems = property.getComboItems()))) {
            for (ValueMapItem valueMapItem : comboItems) {
                if (isRepeat && "mscon_performplanin".equals(valueMapItem.getValue())) continue;
                ComboItem comboItem = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
                coreComboItem.add(comboItem);
            }
        }
    }

    private void setDefaultExratetable(Long orgId) {
        Long exchangeRateTableId = 0L;
        try {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getModel().setValue("exratetable", (Object)exchangeRateTableId);
    }

    private void setSettleOrg(boolean isBindData) {
        IDataModel model = this.getModel();
        DynamicObject receivingtype = (DynamicObject)this.getValue("receivingtype");
        Object openOrg = model.getValue("openorg");
        if (receivingtype != null) {
            boolean multireceivingtype = (Boolean)this.getModel().getValue("multireceivingtype");
            if (multireceivingtype || receivingtype.getBoolean("ispartreceivable")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_settleorg"});
            } else if (!multireceivingtype) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_settleorg"});
            }
            if (!multireceivingtype && RecBizTypeEnum.AGENT_RECEIVING.getValue().equals(receivingtype.getString("biztype"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_settleorg"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_settleorg"});
        }
        Object sourceBillType = model.getValue("sourcebilltype");
        if ("ar_finarbill".equals(sourceBillType)) {
            return;
        }
        if (openOrg != null) {
            DynamicObject accountOrg = (DynamicObject)openOrg;
            for (int i = 0; i < model.getEntryRowCount(ENTRY); ++i) {
                if (isBindData && CasHelper.isEmpty((Object)model.getValue("e_settleorg", i))) {
                    this.setValue("e_settleorg", accountOrg.getPkValue(), i);
                }
                if (isBindData) continue;
                this.setValue("e_settleorg", accountOrg.getPkValue(), i);
            }
        }
    }

    protected void setExchangerateEditable() {
        DynamicObject srcCurrency = this.getDynamicObject("currency");
        DynamicObject destCurrency = this.getDynamicObject("basecurrency");
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"exchangerate"});
        }
    }

    private void setCurrencyEditable() {
        boolean isCurrencyEditable = true;
        if (this.isBotpCreate()) {
            isCurrencyEditable = false;
        } else {
            DynamicObject settleType = this.getDynamicObject("settletype");
            boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
            if (isCash) {
                DynamicObject accountCash = this.getDynamicObject("accountcash");
                if (accountCash != null) {
                    isCurrencyEditable = !accountCash.getBoolean("isbycurrency");
                }
            } else {
                DynamicObject accountBank = this.getDynamicObject("accountbank");
                if (accountBank != null) {
                    isCurrencyEditable = accountBank.getBoolean("ismulcurrency");
                }
            }
        }
        this.getView().setEnable(Boolean.valueOf(isCurrencyEditable), new String[]{"currency"});
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CANCELREC_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            String billno = (String)this.getModel().getValue("billno");
            DynamicObject recObj = BusinessDataServiceHelper.loadSingle((String)"cas_recbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
            if (!CasPluginHelper.cancelCheckSettleForRec((IFormPlugin)this, (IFormView)this.getView(), (DynamicObject)recObj).booleanValue()) {
                this.getView().invokeOperation("cancelrec");
            }
        } else if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CANCELPAY_SETTLE_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("cancelrec");
        } else if (id.equals(CONFIRM_DEL_CALLBACK)) {
            OperateOption option = OperateOption.create();
            if (MessageBoxResult.Yes.equals((Object)res)) {
                option.setVariableValue("delrecpay", "1");
                this.getView().invokeOperation("delete", option);
            }
        } else if (id.equals(CONFIRM_DELETE_CALLBACK) && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().invokeOperation("delete");
        } else if (KEY_CLOSECALLBACK_CLEARRECEIVINGTYPECONFIRM.equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            this.getModel().setValue("receivingtype", null);
            for (int i = 0; i < this.getModel().getEntryRowCount(ENTRY); ++i) {
                this.setValue("e_receivingtype", null, i);
            }
        } else if (KEY_CLOSECALLBACK_CLEARRECEIVINGTYPECONFIRM.equals(id) && MessageBoxResult.Cancel.equals((Object)res)) {
            this.getModel().setValue("multireceivingtype", (Object)true);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject accountBank;
        String settlementtype;
        DynamicObject settleType;
        EntryGrid entry;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("copyentryrow".equals(operateKey) && (entry = (EntryGrid)this.getControl(ENTRY)).getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"ReceivingBillEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("trackdown".equals(operateKey) && (settleType = (DynamicObject)this.getModel().getValue("settletype")) != null && EmptyUtil.isNoEmpty((String)(settlementtype = settleType.getString("settlementtype"))) && this.settleTypes.contains(settlementtype)) {
            op.getOption().setVariableValue("botp_track_edit_status", "true");
        }
        if ("deleteentry".equals(operateKey) && (entry = (EntryGrid)this.getControl(ENTRY)).getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"ReceivingBillEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("recbook".equals(operateKey) && null != (accountBank = this.getDynamicObject("accountbank")) && AccountBankHelper.isClosed((long)accountBank.getLong("id"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), accountBank.getString("number")));
        }
        if ("receivingrec".equals(operateKey)) {
            DynamicObject recdb;
            String billstatus;
            Object recPkValue = this.getModel().getDataEntity().getPkValue();
            if (!CasHelper.isEmpty((Object)recPkValue) && !(billstatus = (recdb = BusinessDataServiceHelper.loadSingle((Object)recPkValue, (String)"cas_recbill", (String)"id,billstatus")).getString("billstatus")).equals(BillStatusEnum.AUDIT.getValue())) {
                throw new KDBizException(new ReceivErrorCode().STATUS_CANNOT_REC(), new Object[0]);
            }
            String sourceBillType = (String)this.getValue("sourcebilltype");
            if ("cas_claimcenterbill".equals(sourceBillType)) {
                return;
            }
            String draftIds = op.getOption().getVariableValue("draftids", "");
            if (StringUtils.isEmpty((CharSequence)draftIds)) {
                List fillDraft = RecDraftHelper.fillDraft((Object[])new Object[]{recPkValue}, (boolean)false);
                if (fillDraft != null && fillDraft.size() > 0) {
                    DynamicObjectCollection draftDataColl = ((DynamicObject)fillDraft.get(0)).getDynamicObjectCollection("draftbill");
                    List draftNoList = draftDataColl.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
                    op.getOption().setVariableValue("draftids", JSON.toJSONString(draftNoList));
                    return;
                }
                DynamicObject orgData = (DynamicObject)this.getValue("org");
                Long pkValue = (Long)orgData.getPkValue();
                boolean selectDraftFlag = SystemParameterHelper.getParameterBoolean((long)pkValue, (String)"cs123");
                DynamicObject data = this.getModel().getDataEntity(true);
                if (selectDraftFlag && PaymentBillPluginHelper.needSelectedDraft((DynamicObject)data)) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setAppId("cas");
                    showParameter.setFormId("cas_receiver_selectdraft");
                    showParameter.setCustomParam("recBillId", data.getPkValue());
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CLOSECALLBACK_CHARGEBACK));
                    this.getView().showForm(showParameter);
                    args.setCancel(true);
                }
            }
        }
        if (Arrays.asList("unaudit", "chargeback", "delete", "receivingrec").contains(operateKey) && PayBillHepler.getViewSettle((DynamicObject)this.getModel().getDataEntity()).size() > 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u5b58\u5728\u7ed3\u7b97\u8bb0\u5f55\uff0c\u5bfc\u81f4\u64cd\u4f5c\u5931\u8d25\u3002\u5982\u9700\u7ee7\u7eed\u6267\u884c\u64cd\u4f5c\uff0c\u8bf7\u5148\u53cd\u7ed3\u7b97\u3002", (String)"PaymentBillList_36", (String)"fi-cas-formplugin", (Object[])new Object[0]), ""));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        String operateKey = arg.getOperateKey();
        OperationResult operationResult = arg.getOperationResult();
        if ("beforesubmit".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            RecWarningHelper.submitValidate((DynamicObject)dataEntity, (AbstractFormPlugin)this);
        }
        if ("receivingrec".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            DynamicObject internal_company;
            QFilter filter;
            this.getView().invokeOperation("refresh", OperateOption.create());
            long payer = (Long)this.getModel().getValue("payer");
            String payerType = (String)this.getModel().getValue("payertype");
            Object companyId = null;
            boolean showSuccess = Boolean.FALSE;
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payerType)) {
                filter = new QFilter("id", "in", (Object)payer);
                DynamicObject supplierDO = BusinessDataServiceHelper.loadSingle((String)AsstActTypeEnum.SUPPLIER.getValue(), (String)"id,internal_company", (QFilter[])filter.toArray());
                if (EmptyUtil.isEmpty((DynamicObject)supplierDO)) {
                    showSuccess = Boolean.TRUE;
                } else {
                    internal_company = supplierDO.getDynamicObject("internal_company");
                    if (CasHelper.isEmpty((Object)internal_company)) {
                        logger.info("====SUPPLIER\u975e\u5185\u90e8\u5ba2\u5546\u3002");
                        showSuccess = Boolean.TRUE;
                    } else {
                        companyId = internal_company.getPkValue();
                    }
                }
            } else if (AsstActTypeEnum.CUSTOMER.getValue().equals(payerType)) {
                filter = new QFilter("id", "in", (Object)payer);
                DynamicObject customerDO = BusinessDataServiceHelper.loadSingle((String)AsstActTypeEnum.CUSTOMER.getValue(), (String)"id,internal_company", (QFilter[])filter.toArray());
                if (EmptyUtil.isEmpty((DynamicObject)customerDO)) {
                    showSuccess = Boolean.TRUE;
                } else {
                    internal_company = customerDO.getDynamicObject("internal_company");
                    if (CasHelper.isEmpty((Object)internal_company)) {
                        showSuccess = Boolean.TRUE;
                    } else {
                        companyId = internal_company.getPkValue();
                    }
                }
            } else if (AsstActTypeEnum.COMPANY.getValue().equals(payerType)) {
                companyId = payer;
            } else {
                showSuccess = Boolean.TRUE;
            }
            if (showSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u6210\u529f\u3002", (String)"ReceivingBillEdit_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (EmptyUtil.isNoEmpty((Object)companyId)) {
                Date bizDate = (Date)this.getModel().getValue("bizdate");
                DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)((Long)companyId));
                if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((DynamicObject)currentPeriod) && bizDate.before(currentPeriod.getDate("begindate"))) {
                    Object CS048 = SystemParameterHelper.getCASParamByOrgIds((Long)((Long)companyId), (String)"cs048");
                    if (EmptyUtil.isNoEmpty((Object)CS048)) {
                        boolean isCheck = (Boolean)CS048;
                        if (isCheck) {
                            Object allowObj = SystemParameterHelper.getCASParamByOrgIds((Long)((Long)companyId), (String)"cs103");
                            if (EmptyUtil.isNoEmpty((Object)allowObj)) {
                                boolean allow = (Boolean)allowObj;
                                if (!allow) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u6210\u529f\u3002\u56e0\u4ed8\u6b3e\u65b9\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u65b0\u589e\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u4ed8\u6b3e\u4e1a\u52a1\uff0c\u56e0\u6b64\u6536\u4ed8\u534f\u540c\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25\u3002", (String)"ReceivingBillEdit_37", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                                } else {
                                    logger.info("CS103\uff1a{}", allowObj);
                                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u6210\u529f\u3002", (String)"ReceivingBillEdit_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                                }
                            }
                        } else {
                            logger.info("CS048\uff1a{}", CS048);
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u6210\u529f\u3002", (String)"ReceivingBillEdit_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        }
                    } else {
                        logger.info("CS048\uff1a{}", CS048);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u6210\u529f\u3002", (String)"ReceivingBillEdit_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    logger.info("currentPeriod\uff1a{}", (Object)currentPeriod);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u6210\u529f\u3002", (String)"ReceivingBillEdit_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if ("copyentryrow".equals(operateKey)) {
            this.calculateAmt();
        }
        if ("newentry".equals(operateKey)) {
            boolean multireceivingtype = this.getModel().getDataEntity().getBoolean("multireceivingtype");
            DynamicObject receivingtype = this.getModel().getDataEntity().getDynamicObject("receivingtype");
            if (!multireceivingtype) {
                int index = this.getModel().getEntryRowCount(ENTRY) - 1;
                this.getModel().setValue("e_receivingtype", (Object)receivingtype, index);
            }
        }
        if (operationResult != null && operationResult.isSuccess()) {
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (!BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayee", "changepayer"});
            } else {
                Object sourceBillType = this.getModel().getValue("sourcebilltype");
                if ("cas_recbill".equals(sourceBillType)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayer"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"changepayee"});
                } else if ("cas_paybill".equals(sourceBillType)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayee", "changepayer"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"changepayee", "changepayer"});
                }
            }
            if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) {
                this.controlRecAmt();
            }
            if ("save".equals(operateKey) || "submit".equals(operateKey)) {
                this.getView().updateView("multireceivingtype");
                this.getView().updateView("receivingtype");
                for (int i = 0; i < this.getModel().getEntryRowCount(ENTRY); ++i) {
                    this.getView().updateView("e_receivingtype", i);
                    this.getView().updateView("e_settleorg", i);
                }
            }
            this.fillToolBar();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey().toLowerCase();
        if ("bar_cancelrec".equals(key)) {
            this.cancelRec();
        } else if ("viewarsettle".equals(key)) {
            this.viewArSettle();
        } else if ("viewdrafbill".equals(key)) {
            this.viewDrafBill();
        }
    }

    private void viewDrafBill() {
        DynamicObjectCollection draftBills = (DynamicObjectCollection)this.getModel().getValue("draftbill");
        if (draftBills == null || draftBills.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7968\u636e\u8bb0\u5f55\u3002", (String)"PaymentBillDraftEditPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject draftBill : draftBills) {
            idSet.add(((DynamicObject)draftBill.get("fbasedataid")).getLong("id"));
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("cdm_payandrecdraft_f7");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setLookUp(true);
        QFilter qFilter = new QFilter("id", "in", idSet);
        parameter.getListFilterParameter().getQFilters().add(qFilter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void cancelRec() {
        String billno = (String)this.getModel().getValue("billno");
        DynamicObject recObj = BusinessDataServiceHelper.loadSingle((String)"cas_recbill", (String)"id,billno,isvoucher,billstatus,receivingtype", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        String billstatus = recObj.getString("billstatus");
        if (!billstatus.equals("D")) {
            this.getView().invokeOperation("cancelrec");
            return;
        }
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        int CS114 = SystemParameterHelper.getParameterInteger((long)((DynamicObject)org).getLong("id"), (String)"cs114");
        Boolean isv = recObj.getBoolean("isvoucher");
        if (3 == CS114 && isv.booleanValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u6536\u6b3e\uff1f", (String)"ReceivingBillEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELREC_CALLBACK", (IFormPlugin)this));
        } else if (!CasPluginHelper.cancelCheckSettleForRec((IFormPlugin)this, (IFormView)this.getView(), (DynamicObject)recObj).booleanValue()) {
            this.getView().invokeOperation("cancelrec");
        }
        this.getView().updateView(ENTRY);
        this.getView().updateView("flex_amountinfo");
    }

    private void fillToolBar() {
        boolean isSuppleContract = (Boolean)this.getModel().getValue("issupplecontract");
        boolean isOrgsDivide = (Boolean)this.getModel().getValue("isorgsdivide");
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if (!(isSuppleContract || isOrgsDivide || "pmct_incomeapply".equals(sourceBillType))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"contractnumber"});
        }
        if (!isSuppleContract && !isOrgsDivide) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_audit", "bar_unaudit", "bar_rec", "bar_cancelrec", "genvoucher", "deletevoucher", "addrow", "copyentryrow", "deleterow", "moveentrydown", "moveentryup"});
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"changepayee", "changepayer"});
                if ("cas_recbill".equals(sourceBillType)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayer"});
                } else if ("cas_paybill".equals(sourceBillType)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayee", "changepayer"});
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit", "bar_del", "addrow", "copyentryrow", "deleterow", "moveentrydown", "moveentryup"});
            } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayee", "changepayer"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_unsubmit", "bar_audit"});
            } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayee", "changepayer"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_unaudit", "bar_rec", "genvoucher", "deletevoucher"});
            } else if (billStatus.equals("D")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayee", "changepayer"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_cancelrec", "genvoucher", "deletevoucher", "baritemap"});
            }
        }
    }

    private void setPayeeInfo4Lb() {
        DynamicObject org = this.getDynamicObject("org");
        ((Label)this.getControl("orgv")).setText(CasHelper.getLocalValue((DynamicObject)org, (String)"name"));
        Image orgPic = (Image)this.getControl("orgpic");
        String defaultUrl = "/kingdee/tmc/images/pc/icon/entrance/sky_skf_80_80.png";
        orgPic.setUrl(defaultUrl);
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)((DynamicObject)this.getModel().getValue("settletype")));
        DynamicObject payerAcctBank = this.getDynamicObject("accountbank");
        DynamicObject accountCash = this.getDynamicObject("accountcash");
        String v_payeebanknum = "";
        if (isCash && accountCash != null) {
            v_payeebanknum = accountCash.getString("number");
        }
        if (!isCash && payerAcctBank != null) {
            v_payeebanknum = kd.fi.cas.util.StringUtils.splitString((String)payerAcctBank.getString("bankaccountnumber"), (int)4, (String)" ");
        }
        ((Label)this.getControl("payeebanknumv")).setText(v_payeebanknum);
        DynamicObject payerBank = this.getDynamicObject("payeebank");
        String v_payerbankname = "";
        if (payerBank != null) {
            v_payerbankname = CasHelper.getLocalValue((DynamicObject)payerBank, (String)"name");
        }
        ((Label)this.getControl("payeebanknamev")).setText(v_payerbankname);
        this.getView().setVisible(Boolean.valueOf(!isCash), new String[]{"payerbanknamelb", "payeebanknamev"});
    }

    @Override
    protected String recPayAccount() {
        return "accountbank";
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        boolean multireceivingtype = (Boolean)this.getModel().getValue("multireceivingtype");
        DynamicObject receivingtype = (DynamicObject)this.getModel().getValue("receivingtype");
        if (ENTRY.equals(entryProp.getName())) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                if (row.getDataEntity().get("e_settleorg") == null) {
                    this.setSettleValue(row.getRowIndex());
                }
                if (multireceivingtype) continue;
                this.getModel().setValue("e_receivingtype", (Object)receivingtype, row.getRowIndex());
            }
        }
        this.controlRecAmt();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String opKey = evt.getOperationKey();
        if ("delete".equals(opKey)) {
            if ("cas_paybill".equals(this.getString("sourcebilltype"))) {
                evt.setCancel(true);
                String billno = this.getString("billno");
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u6536\u6b3e\u5355\u7531\u5185\u90e8\u6536\u4ed8\u534f\u540c\u4e1a\u52a1\u81ea\u52a8\u751f\u6210\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"ReceivingBillEdit_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_DEL_CALLBACK, (IFormPlugin)this));
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            boolean isvirtual = dataEntity.getBoolean("isvirtual");
            if ("cas_recbill".equals(this.getString("sourcebilltype")) && isvirtual) {
                evt.setCancel(true);
                String billno = dataEntity.getString("billno");
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u865a\u62df\u6536\u6b3e\u5355\u7531\u7ec4\u7ec7\u95f4\u6e05\u5206\u4e1a\u52a1\u89e6\u53d1\u81ea\u52a8\u4e0b\u63a8\u7684\u5355\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ReceivingBillEdit_33", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_DELETE_CALLBACK, (IFormPlugin)this));
            }
        }
    }

    private void setSettleValue(int index) {
        DynamicObject recOrg = this.getModel().getDataEntity().getDynamicObject("org");
        if ((recOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting")).getBoolean("fisaccounting")) {
            this.getModel().setValue("e_settleorg", this.getValue("org"), index);
            return;
        }
        DynamicObject recAccount = this.getModel().getDataEntity().getDynamicObject("accountbank");
        if (recAccount != null) {
            this.getModel().setValue("e_settleorg", recAccount.get("openorg"), index);
            return;
        }
    }

    private void viewArSettle() {
        Long billId = (Long)this.getModel().getDataEntity().getPkValue();
        if (billId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ReceivingBillList_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Set mainSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByMain((String)"ar_settlerecord", (String)"cas_recbill", (Object[])new Object[]{billId});
        Set asstSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByAsst((String)"ar_settlerecord", (String)"cas_recbill", (Object[])new Object[]{billId});
        HashSet settleRecordIds = new HashSet();
        settleRecordIds.addAll(mainSettleIds);
        settleRecordIds.addAll(asstSettleIds);
        if (settleRecordIds.size() > 0) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("ar_settlerecord");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter param = new ListFilterParameter();
            param.setFilter(new QFilter("id", "in", settleRecordIds));
            parameter.setListFilterParameter(param);
            parameter.setCustomParam("checkKey", (Object)true);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ReceivingBillList_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isHwControl() {
        return this.getPageCache().getAll().containsKey("isHwControl");
    }

    private void fillFundflowItem(boolean isCover) {
        for (int i = 0; i < this.getModel().getEntryRowCount(ENTRY); ++i) {
            DynamicObject fundflowitem;
            DynamicObject e_receivingtype = (DynamicObject)this.getModel().getValue("e_receivingtype", i);
            if (EmptyUtil.isEmpty((DynamicObject)e_receivingtype) || EmptyUtil.isEmpty((DynamicObject)(fundflowitem = e_receivingtype.getDynamicObject("fundflowitem")))) continue;
            if (isCover) {
                this.setValue("e_fundflowitem", fundflowitem.getPkValue(), i);
                continue;
            }
            this.setValueIfAbsent("e_fundflowitem", fundflowitem.getPkValue(), i);
        }
    }

    private boolean hasPayerInfo() {
        Long payerId = Long.parseLong(this.getValue("payer") == null ? "0" : this.getValue("payer").toString());
        String payertype = this.getString("payertype");
        if (AsstActTypeEnum.OTHER.getValue().equals(payertype)) {
            return !kd.fi.cas.util.StringUtils.isBlank((String)this.getString("payername"));
        }
        return CasHelper.isNotEmpty((Object)payerId);
    }

    private void setIFilters(ListFilterParameter lfp, DynamicObject recBill) {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u4e8c\u5f00\u6269\u5c55\u5b57\u6bb5\u5bf9\u5916\u670d\u52a1\u4e1a\u52a1\u57cb\u70b9 - kd.sdk.fi.cas.extpoint.recbill.IRecbillFilter");
        PluginProxy pluginProxy = PluginProxy.create(IRecbillFilter.class, (String)"fi.cas.filter.recbill");
        pluginProxy.callReplace(proxy -> {
            proxy.setIFilters(lfp, recBill);
            return null;
        });
    }

    private void resetExrateTableWhenSwitchOrg(Object newValue) {
        DynamicObject org;
        long orgId;
        if (EmptyUtil.isNoEmpty((Object)newValue) && EmptyUtil.isNoEmpty((Long)(orgId = (org = (DynamicObject)newValue).getLong("id")))) {
            long exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
            this.getModel().setValue("exratetable", (Object)exchangeRateTableId);
        }
    }
}

