/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.service.BalanceCountService;
import org.apache.commons.lang3.StringUtils;

public class TotalAmountPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final Log logger = LogFactory.getLog(TotalAmountPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        this.getPageData(searchText);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageData(null);
    }

    private void getPageData(String searchText) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long accountbankId = (Long)showParameter.getCustomParam("accountbankId");
        Object currencyObjId = showParameter.getCustomParam("currencyId");
        BigDecimal journalbalance = (BigDecimal)showParameter.getCustomParam("journalbalance");
        BigDecimal journalbalanceadj = (BigDecimal)showParameter.getCustomParam("journalbalanceadj");
        String orgName = (String)showParameter.getCustomParam("orgname");
        Date modifyTime = DateUtils.parseDate((Object)showParameter.getCustomParam("modifytime"));
        Object object = showParameter.getCustomParam("orgId");
        Long orgId = null;
        orgId = object instanceof String ? Long.valueOf((String)showParameter.getCustomParam("orgId")) : (Long)showParameter.getCustomParam("orgId");
        if (accountbankId == null || currencyObjId == null || orgId == null) {
            return;
        }
        Long currencyId = 0L;
        currencyId = currencyObjId instanceof Integer ? Long.valueOf(((Integer)currencyObjId).longValue()) : (Long)currencyObjId;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("accountbank", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("useorg", new Object[0]);
        vs.addField("initdate", new Object[0]);
        vs.addField("journalbalance", new Object[0]);
        vs.addField("journalbalanceadj", new Object[0]);
        vs.addField("balance", new Object[0]);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("entrybank.bank_accountbank", "=", (Object)accountbankId));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            qFilters.add(new QFilter("org.name", "like", (Object)("%" + searchText + "%")));
        }
        DynamicObject[] cashmgtInitDy = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org,isfinishinit,startperiod,currentperiod,entrybank.bank_accountbank,entrybank.bank_currency,entrybank.bank_journalbalance,entrybank.bank_journalbalanceadj,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
        boolean isShowBalance = false;
        for (DynamicObject dyObj : cashmgtInitDy) {
            if (dyObj.getDynamicObject("org").getLong("id") == orgId.longValue()) {
                vs.addRow(new Object[]{accountbankId, currencyId, orgName, modifyTime, journalbalance, journalbalanceadj, journalbalanceadj});
                continue;
            }
            if (!dyObj.getBoolean("isfinishinit")) continue;
            DynamicObjectCollection bankCollection = dyObj.getDynamicObjectCollection("entrybank");
            for (DynamicObject dyObj1 : bankCollection) {
                BigDecimal journalbalanceadj1;
                long accountBankId1 = dyObj1.getDynamicObject("bank_accountbank").getLong("id");
                long currencyId1 = dyObj1.getDynamicObject("bank_currency").getLong("id");
                if (accountBankId1 != accountbankId || currencyId1 != currencyId) continue;
                DynamicObject useorgStartPeriod = dyObj.getDynamicObject("startperiod");
                Date useOrgBeginDate = useorgStartPeriod.getDate("begindate");
                Date createOrgBeginDate = modifyTime;
                BigDecimal journalbalance1 = dyObj1.getBigDecimal("bank_journalbalance");
                BigDecimal balance = journalbalanceadj1 = dyObj1.getBigDecimal("bank_journalbalanceadj");
                if (useOrgBeginDate.compareTo(createOrgBeginDate) < 0) {
                    BigDecimal accountBalance;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(createOrgBeginDate);
                    calendar.add(5, -1);
                    Date endDate = calendar.getTime();
                    BalanceCountService balanceCountService = new BalanceCountService();
                    balance = accountBalance = balanceCountService.getJournalBalance(dyObj, Long.valueOf(dyObj.getDynamicObject("org").getLong("id")), Long.valueOf(accountBankId1), Long.valueOf(currencyId1), endDate);
                    if (!isShowBalance) {
                        isShowBalance = true;
                    }
                }
                vs.addRow(new Object[]{accountbankId, currencyId, dyObj.getDynamicObject("org").getLocaleString("name").getLocaleValue(), useorgStartPeriod.getDate("begindate"), journalbalance1, journalbalanceadj1, balance});
            }
        }
        if (isShowBalance) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"balance"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"balance"});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }
}

