/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TracePaymentBillEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private String targetBillType = null;
    private String sourceBillType = null;

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "tracebankpaymentbill": {
                this.tracePaymentBill();
            }
        }
    }

    private void tracePaymentBill() {
        this.sourceBillType = this.getModel().getDataEntityType().getName();
        if (this.sourceBillType.equalsIgnoreCase("cas_paybill")) {
            this.targetBillType = "bei_bankpaybill";
        } else if (this.sourceBillType.equalsIgnoreCase("cas_agentpaybill")) {
            this.targetBillType = "bei_bankagentpay";
        }
        Long billId = (Long)this.getModel().getDataEntity().getPkValue();
        if (billId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"TracePaymentBillList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] targetBills = BusinessDataServiceHelper.load((String)this.targetBillType, (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billId)}, (String)"createtime desc");
        if (null == targetBills || targetBills.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"TracePaymentBillList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        String curAppId = this.getView().getFormShowParameter().getAppId();
        curAppId = curAppId != null && curAppId.equals("cas") ? "cbei" : (curAppId != null && (curAppId.equals("fs") || curAppId.equals("tr")) ? "bei" : "cbei");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getCustomParams().put("checkRightAppId", curAppId);
        showParameter.setHasRight(true);
        showParameter.setPkId(targetBills[0].get("id"));
        showParameter.setFormId(this.targetBillType);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid bankcheckentity = (EntryGrid)this.getView().getControl("bankcheckentity");
        bankcheckentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String key = hyperLinkClickEvent.getFieldName();
        if ("edetailbillno".equals(key)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            BillShowParameter showForm = new BillShowParameter();
            showForm.setFormId("bei_transdetail_cas");
            showForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showForm.setPkId(this.getModel().getValue("edetailid", rowIndex));
            showForm.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showForm);
        }
    }
}

