/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.F7FilterUtil;

public abstract class UnreachBaseFormRpt
extends AbstractReportFormPlugin {
    protected String sourceEntity;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7(this.sourceEntity);
    }

    private void initF7(String acctEntity) {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("org");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter;
            QFilter uFilter = orgCtrl.getQFilter();
            if (uFilter == null) {
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
                showParameter = F7FilterUtil.bankrollOrgF7QFilter((BeforeF7SelectEvent)beforeF7SelectEvent, (String)appId, (String)this.sourceEntity, (String)"47150e89000000ac", null);
            } else {
                showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(uFilter);
            }
            showParameter.setIsolationOrg(false);
        });
        BasedataEdit accbCtrl = (BasedataEdit)this.getControl("accountbank");
        accbCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
            Collections.addAll(qFilterArrayList, this.getAcctFilter());
            qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            showParameter.setIsolationOrg(false);
            showParameter.getListFilterParameter().setQFilters(qFilterArrayList);
        });
        BasedataEdit currencyCtrl = (BasedataEdit)this.getControl("currency");
        currencyCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection accbColl = (DynamicObjectCollection)this.getModel().getValue("accountbank");
            QFilter qFilter = null;
            if (accbColl.size() > 0) {
                Set currencyIdSet = AccountBankHelper.getCurrencyPks((String)"bd_accountbanks", this.getIdList(accbColl));
                qFilter = new QFilter("id", "in", (Object)currencyIdSet);
            } else {
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountbanks", (String)"currency.fbasedataid.id as currencyid", (QFilter[])this.getAcctFilter());
                if (coll != null && coll.size() > 0) {
                    HashSet<Long> currencyIdSet = new HashSet<Long>();
                    for (DynamicObject dynamicObject : coll) {
                        currencyIdSet.add(dynamicObject.getLong("currencyid"));
                    }
                    qFilter = new QFilter("id", "in", currencyIdSet);
                } else {
                    qFilter = new QFilter("id", "=", null);
                }
            }
            showParameter.setIsolationOrg(false);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        if ("org".equals(name)) {
            this.getModel().setValue("accountbank", null);
            this.getModel().setValue("currency", null);
        }
        if ("accountbank".equals(name)) {
            DynamicObjectCollection accountColl = (DynamicObjectCollection)newValue;
            if (accountColl != null && accountColl.size() == 1) {
                DynamicObject account = (DynamicObject)accountColl.get(0);
                if (!(account = account.getDynamicObject("fbasedataid")).getBoolean("ismulcurrency")) {
                    Object[] arrObj = new Object[]{account.getLong("defaultcurrency.id")};
                    this.getModel().setValue("currency", (Object)arrObj);
                } else {
                    this.getModel().setValue("currency", null);
                }
            } else {
                this.getModel().setValue("currency", null);
            }
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.defaultOrg();
        this.getModel().setValue("enddate", (Object)new Date());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.getValue(this.getOrgControlName());
        if (org == null || org.size() < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UnreachBaseFormRpt_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        int age = filterInfo.getInt("aging");
        if (age < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u9f84\u5929\u6570\u5e94\u4e3a\u975e\u8d1f\u6570\u3002", (String)"UnreachBaseFormRpt_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (age > 3650) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u9f84\u5929\u6570\u5fc5\u987b\u5c0f\u4e8e10\u5e74(3650\u5929)\u3002", (String)"UnreachBaseFormRpt_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.verifyInitRecDecOrg(queryParam).booleanValue()) {
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    protected abstract Boolean verifyInitRecDecOrg(ReportQueryParam var1);

    protected List<Long> getIdList(DynamicObjectCollection coll) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            idList.add((Long)((DynamicObject)coll.get(i)).getDynamicObject("fbasedataid").getPkValue());
        }
        return idList;
    }

    protected QFilter[] getAcctFilter() {
        DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("org");
        QFilter usableAccountFilter = AccountBankHelper.getUseAuthAccountBankFilterByOrg(this.getIdList(orgColl));
        return new QFilter[]{usableAccountFilter};
    }

    protected void defaultOrg() {
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.sourceEntity, (String)"47150e89000000ac");
        if (orgList.size() > 0) {
            long currentOrgId = RequestContext.get().getOrgId();
            long orgId = (Long)orgList.toArray()[0];
            if (orgList.contains(currentOrgId)) {
                orgId = currentOrgId;
            }
            Object[] arrObj = new Object[]{orgId};
            this.getModel().setValue("org", (Object)arrObj);
        }
    }

    protected abstract String getOrgControlName();
}

