/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.agentpay;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CountryHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class AgentPayCrossPlugin
extends BillEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "payerbank": {
                this.payerBankChanged(newValue);
                break;
            }
            case "feeactbank": {
                this.feeActBankF7Changed(newValue);
                break;
            }
            case "paycountry": 
            case "reccountry": {
                this.countryChanged(newValue);
                break;
            }
            case "currency": 
            case "dpcurrency": {
                this.clearEntryField("transtype");
                break;
            }
            case "iscrosspay": {
                this.defaultCrossTranType(this.getDynamicObject("payerbank"));
            }
        }
    }

    private void countryChanged(Object newValue) {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"iscrosspay"});
        if (newValue == null) {
            return;
        }
        DynamicObject country = (DynamicObject)newValue;
        long orgId = (Long)this.getDynamicObject("org").getPkValue();
        boolean autoOpenCrossPay = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"autoopencrosspay");
        if (autoOpenCrossPay) {
            if (!CountryHelper.isChina((DynamicObject)country)) {
                this.setValue("iscrosspay", true);
            } else {
                this.setValue("iscrosspay", false);
            }
        }
    }

    private void payerBankChanged(Object newValue) {
        this.setValue("crosstrantype", null);
        this.setValue("paycountry", null);
        this.clearEntryField("transtype");
        if (newValue == null) {
            return;
        }
        DynamicObject payerBank = (DynamicObject)newValue;
        this.setValue("paycountry", payerBank.getDynamicObject("country"));
        this.defaultCrossTranType(payerBank);
    }

    private void defaultCrossTranType(DynamicObject payerBank) {
        Boolean isCrossPay = (Boolean)this.getValue("iscrosspay");
        if (!isCrossPay.booleanValue()) {
            return;
        }
        if (payerBank == null) {
            return;
        }
        DynamicObject bankCate = payerBank.getDynamicObject("bank_cate");
        if (bankCate == null) {
            return;
        }
        QFilter eFilter = new QFilter("enable", "=", (Object)"1");
        QFilter dFilter = new QFilter("isdefault", "=", (Object)"1");
        QFilter bcFilter = new QFilter("bankcate", "=", bankCate.getPkValue());
        DynamicObject[] crosstrantypes = BusinessDataServiceHelper.load((String)"bei_crosstrantype", (String)"id", (QFilter[])new QFilter[]{eFilter, dFilter, bcFilter});
        if (crosstrantypes != null && crosstrantypes.length > 0) {
            this.setValue("crosstrantype", crosstrantypes[0].getPkValue());
        }
    }

    private void feeActBankF7Changed(Object newValue) {
        DynamicObject feeActBank = (DynamicObject)newValue;
        if (feeActBank == null) {
            return;
        }
        Long defaultCurrencyId = (Long)feeActBank.get("defaultcurrency.id");
        this.setValue("feecurrency", defaultCurrencyId);
        Boolean isCurrencyEditable = feeActBank.getBoolean("ismulcurrency");
        this.getView().setEnable(isCurrencyEditable, new String[]{"feecurrency"});
    }

    private void initF7() {
        this.fillTransType();
        this.fillCrossTranType();
        this.fillFeeCurrency();
        this.fillFeeActBank();
    }

    private void fillFeeActBank() {
        BasedataEdit feeActBank = (BasedataEdit)this.getControl("feeactbank");
        feeActBank.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setIsolationOrg(false);
            DynamicObject org = this.getDynamicObject("org");
            if (org == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba", (String)"AgentPayCrossPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter[] usableAccountFilter = AccountBankHelper.getUsableAccountFilter((long)((Long)org.getPkValue()));
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(usableAccountFilter));
        });
    }

    private void fillFeeCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("feecurrency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject feeActBank = (DynamicObject)this.getModel().getValue("feeactbank");
            if (feeActBank != null) {
                Set currencys = AccountBankHelper.getCurrencyPks((long)((Long)feeActBank.getPkValue()));
                qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillCrossTranType() {
        BasedataEdit crosstrantypeF7 = (BasedataEdit)this.getControl("crosstrantype");
        crosstrantypeF7.addBeforeF7SelectListener(evt -> {
            DynamicObject payerBank = this.getDynamicObject("payerbank");
            if (payerBank == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"AgentPayCrossPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bankCate = payerBank.getDynamicObject("bank_cate");
            if (bankCate == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u5bf9\u5e94\u7684\u94f6\u884c\u7c7b\u522b\u4e3a\u7a7a,\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u94f6\u884c\u8d26\u6237", (String)"AgentPayCrossPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("bankcate", "=", bankCate.getPkValue());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillTransType() {
        BasedataEdit transtypeF7 = (BasedataEdit)this.getControl("transtype");
        transtypeF7.addBeforeF7SelectListener(evt -> {
            DynamicObject[] transtypes;
            DynamicObject payerBank = this.getDynamicObject("payerbank");
            if (payerBank == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"AgentPayCrossPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bankCate = payerBank.getDynamicObject("bank_cate");
            if (bankCate == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u5bf9\u5e94\u7684\u94f6\u884c\u7c7b\u522b\u4e3a\u7a7a,\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u94f6\u884c\u8d26\u6237", (String)"AgentPayCrossPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject currency = this.getDynamicObject("currency");
            if (currency == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u6b3e\u5e01\u79cd\u3002", (String)"AgentPayCrossPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dpCurrency = this.getDynamicObject("dpcurrency");
            if (dpCurrency == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ed8\u6b3e\u5e01\u79cd\u3002", (String)"AgentPayCrossPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Long bankCateId = (Long)bankCate.getPkValue();
            Long currencyId = (Long)currency.getPkValue();
            Long dpCurrencyId = (Long)currency.getPkValue();
            QFilter eFilter = new QFilter("enable", "=", (Object)"1");
            HashSet<Long> pks = new HashSet<Long>();
            for (DynamicObject transtype : transtypes = BusinessDataServiceHelper.load((String)"bei_transtype", (String)"id,bankcategory,currency", (QFilter[])new QFilter[]{eFilter})) {
                DynamicObjectCollection bankcategorys = transtype.getDynamicObjectCollection("bankcategory");
                DynamicObjectCollection currencys = transtype.getDynamicObjectCollection("currency");
                Boolean isBankCMatch = Boolean.TRUE;
                Boolean isCurMatch = Boolean.TRUE;
                Boolean isDpCurMatch = Boolean.TRUE;
                if (bankcategorys != null && bankcategorys.size() > 0) {
                    isBankCMatch = Boolean.FALSE;
                    for (DynamicObject bankcategory : bankcategorys) {
                        Long bankcategoryId = bankcategory.getLong("fbasedataid_id");
                        if (bankCateId.longValue() != bankcategoryId.longValue()) continue;
                        isBankCMatch = Boolean.TRUE;
                        break;
                    }
                }
                if (currencys != null && currencys.size() > 0) {
                    isCurMatch = Boolean.FALSE;
                    isDpCurMatch = Boolean.FALSE;
                    for (DynamicObject c : currencys) {
                        Long cId = c.getLong("fbasedataid_id");
                        if (currencyId.longValue() == cId.longValue()) {
                            isCurMatch = Boolean.TRUE;
                            break;
                        }
                        if (dpCurrencyId.longValue() != cId.longValue()) continue;
                        isDpCurMatch = Boolean.TRUE;
                        break;
                    }
                }
                if (!isBankCMatch.booleanValue() || !isCurMatch.booleanValue() && !isDpCurMatch.booleanValue()) continue;
                pks.add(transtype.getLong("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", pks);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void clearEntryField(String key) {
        DynamicObjectCollection coll = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < coll.size(); ++i) {
            this.setValue(key, null, i);
        }
    }
}

