/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.balance;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.fi.cas.business.balancemodel.calculate.enums.BalanceModelMeta;
import kd.fi.cas.helper.PermissionHelper;

public class BalancePlugin
extends AbstractListPlugin {
    private static final String CHECK = "check";
    private static final String RECAL = "recal";
    private static final String RECOMPUTE_PERMIT_ID = "3JPUK7I/VGBU";
    private static final String CHECK_PERMIT_ID = "3JPUUVHYVP20";

    public void itemClick(ItemClickEvent evt) {
        FormShowParameter showParameter;
        String entityName;
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("recompute".equals(key)) {
            if (!this.isPermission(RECOMPUTE_PERMIT_ID)) {
                return;
            }
            entityName = this.getView().getFormShowParameter().getShowParameter().getIdentifyFormId();
            showParameter = new FormShowParameter();
            showParameter.setFormId("cas_balance_recompute");
            showParameter.getCustomParams().put("balanceFormName", entityName);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().put(RECAL, true);
            this.getView().showForm(showParameter);
        }
        if ("balancecheck".equals(key)) {
            if (!this.isPermission(CHECK_PERMIT_ID)) {
                return;
            }
            entityName = this.getView().getFormShowParameter().getShowParameter().getIdentifyFormId();
            showParameter = new FormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u4f59\u989d\u68c0\u67e5", (String)"BalancePlugin_01", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            showParameter.setFormId("cas_balance_recompute");
            showParameter.getCustomParams().put("balanceFormName", entityName);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().put(CHECK, true);
            this.getView().showForm(showParameter);
        }
    }

    private boolean isPermission(String permissionId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        long orgId = RequestContext.get().getOrgId();
        String formName = this.getView().getFormShowParameter().getShowParameter().getIdentifyFormId();
        String entity = "";
        if (formName.contains(BalanceModelMeta.JOURNAL.getMetaName())) {
            entity = BalanceModelMeta.JOURNAL.getMetaName();
        } else if (formName.contains(BalanceModelMeta.CASH.getMetaName())) {
            entity = BalanceModelMeta.CASH.getMetaName();
        } else if (formName.contains(BalanceModelMeta.STATE.getMetaName())) {
            entity = BalanceModelMeta.STATE.getMetaName();
        }
        return PermissionHelper.checkCurrentUserPermission((String)appId, (long)orgId, (String)entity, (String)permissionId);
    }
}

