/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;

public class DateUtils {
    public static final String YYYY = "yyyy";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_SS = "yyyy-MM-dd HH:mm:ss:ss";
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHH = "yyyyMMddHH";
    public static final String YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMMSSSS = "yyyyMMddHHmmssSS";

    public static int getMonthDiff(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        int day1 = c1.get(5);
        int day2 = c2.get(5);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            --yearInterval;
        }
        int monthInterval = month1 + 12 - month2;
        if (day1 < day2) {
            --monthInterval;
        }
        int monthsDiff = Math.abs(yearInterval * 12 + (monthInterval %= 12));
        return monthsDiff;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String format(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        return df.format(date);
    }

    public static String formatMonth(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM);
        return df.format(date);
    }

    public static Date getLastMaxMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        String strTime = DateUtils.format(calendar.getTime());
        try {
            return new SimpleDateFormat(YYYY_MM_DD).parse(strTime);
        }
        catch (ParseException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002\u6b63\u786e\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd\u3002", (String)"DateUtils_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public static Date getLastDayByDate(String date) {
        int year = Integer.parseInt(date.split("-")[0]);
        int month = Integer.parseInt(date.split("-")[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        String time = DateUtils.format(cal.getTime());
        try {
            return new SimpleDateFormat(YYYY_MM_DD).parse(time);
        }
        catch (ParseException var4) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002\u6b63\u786e\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd\u3002", (String)"DateUtils_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public static Date stringToDate(String datestr) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a%s\u3002", (String)"DateUtils_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), YYYY_MM_DD));
        }
        return date;
    }

    public static Date stringToDate(String datestr, String dateformat) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u201c%1$s\u201d\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a%2$s\u3002", (String)"DateUtils_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), datestr, dateformat));
        }
        return date;
    }

    public static String getLastMonthFirstDateStr(String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, 1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static String getLastMonthLastDateStr(String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, 1);
        calendar.add(5, -1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getMinimum(5);
        cal.set(5, firstDay);
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        return sdf.format(cal.getTime());
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        return sdf.format(cal.getTime());
    }

    public static String getFirstDateOfMonthStr(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = YYYY_MM_DD;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date getLastDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date trunc(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getLastDateOfMonthStr(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = YYYY_MM_DD;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date addDay(Date date, int iday) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(5, iday);
        return cd.getTime();
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date addYear(Date date, int iyear) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(1, iyear);
        return cd.getTime();
    }

    public static int getYearOfDate(Date date) {
        int y = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        y = cd.get(1);
        return y;
    }

    public static int getMonthOfDate(Date date) {
        int m = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        m = cd.get(2);
        return m + 1;
    }

    public static Date trunc(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String s = sdf.format(date);
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a%s\u3002", (String)"DateUtils_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), format));
        }
    }

    public static Date getFirstDateOfSeason(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        int month = cd.get(2);
        if (month < 3) {
            cd.set(2, 0);
        } else if (month >= 3 && month < 6) {
            cd.set(2, 3);
        } else if (month >= 6 && month < 9) {
            cd.set(2, 6);
        } else {
            cd.set(2, 9);
        }
        return DateUtils.getFirstDateOfMonth(cd.getTime());
    }

    public static Date getLastDateOfSeason(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        int month = cd.get(2);
        if (month < 3) {
            cd.set(2, 0);
        } else if (month >= 3 && month < 6) {
            cd.set(2, 3);
        } else if (month >= 6 && month < 9) {
            cd.set(2, 6);
        } else {
            cd.set(2, 9);
        }
        cd.add(2, 2);
        return DateUtils.getLastDateOfMonth(cd.getTime());
    }

    public static Date getFirstDateOfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-01-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getLastDateOfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-12-" + cd.getActualMaximum(5) + " 23:59:59";
        return DateUtils.stringToDate(str, YYYY_MM_DD_HH_MM_SS);
    }

    public static boolean isValidSeasonalDates(Date startdate, Date enddate) {
        int enddateMonth;
        int enddateYear;
        int startdateYear = startdate.getYear();
        if (startdateYear != (enddateYear = enddate.getYear())) {
            return false;
        }
        int startdateMonth = startdate.getMonth();
        if (startdateMonth != (enddateMonth = enddate.getMonth()) - 2) {
            return false;
        }
        if (startdateMonth != 0 && startdateMonth != 3 && startdateMonth != 6 && startdateMonth != 9) {
            return false;
        }
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth(startdate);
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth(enddate);
        return DateUtils.format(firstDateOfMonth).equals(DateUtils.format(startdate)) && DateUtils.format(lastDateOfMonth).equals(DateUtils.format(enddate));
    }
}

