/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.changebill;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.PayInfoChgHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecInfoChgEdit
extends AbstractBillPlugIn {
    private boolean isSelectBankF7 = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"afterrecerbankname"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("afterrecerbankname".equals(key)) {
            this.getModel().setValue("afterrecerbank", null);
            BasedataEdit changeBankF7 = (BasedataEdit)this.getControl("afterrecerbank");
            changeBankF7.click();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPayerAcct();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjects)) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                DynamicObject bank = dynamicObject.getDynamicObject("afterrecerbank");
                String bankName = dynamicObject.getString("afterrecerbankname");
                if (bank == null || !"".equals(bankName)) continue;
                this.getModel().setValue("afterrecerbankname", (Object)bank.getString("name"), i);
            }
            this.setAfterPayerAcctCashVisible(dynamicObjects);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String sourceType = (String)formShowParameter.getCustomParam("sourceType");
        Long sourceId = (Long)formShowParameter.getCustomParam("sourceId");
        String changeCause = (String)formShowParameter.getCustomParam("changeCause");
        if (sourceType != null && sourceId != null) {
            DynamicObject bizBill = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)sourceType);
            BillModel model = (BillModel)this.getModel();
            model.setValue("billstatus", (Object)"A");
            model.setValue("sourcebillno", bizBill.get("billno"));
            model.setValue("payeetype", bizBill.get("payeetype"));
            model.setValue("chgtype", (Object)"recchg");
            model.setValue("sourcetype", (Object)sourceType);
            model.setValue("sourcebilltype", (Object)sourceType);
            model.setValue("sourcebillid", (Object)sourceId);
            model.setValue("org", (Object)bizBill.getDynamicObject("org").getLong("id"));
            model.setValue("sourcecurrency", (Object)bizBill.getDynamicObject("currency").getLong("id"));
            model.setValue("applyuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            DynamicObject settletypeObj = bizBill.getDynamicObject("settletype");
            Object settletypeId = null;
            if (EmptyUtil.isNoEmpty((DynamicObject)settletypeObj)) {
                settletypeId = settletypeObj.getPkValue();
            }
            if ("cas_paybill".equals(sourceType)) {
                model.setValue("usage", (Object)bizBill.getString("usage"), 0);
                model.setValue("actpayamt", bizBill.get("actpayamt"), 0);
                model.setValue("recer", bizBill.get("payeename"), 0);
                model.setValue("recerid", bizBill.get("payee"), 0);
                model.setValue("recername", bizBill.get("recaccbankname"), 0);
                model.setValue("recacctbank", bizBill.get("payeebanknum"), 0);
                model.setValue("recerbank", bizBill.get("payeebank"), 0);
                model.setValue("payeebankname", bizBill.get("payeebankname"), 0);
                model.setValue("recprovince", bizBill.get("recprovince"), 0);
                model.setValue("reccity", bizBill.get("reccity"), 0);
                model.setValue("recbanknumber", bizBill.get("recbanknumber"), 0);
                String businessType = bizBill.getString("businesstype");
                model.setValue("businesstype", (Object)businessType, 0);
                if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
                    model.setValue("institutioncode", bizBill.get("institutioncode"), 0);
                    model.setValue("institutionname", bizBill.get("institutionname"), 0);
                }
                model.setValue("settletype", settletypeId, 0);
            } else if ("cas_agentpaybill".equals(sourceType)) {
                DynamicObjectCollection entry = bizBill.getDynamicObjectCollection("entry");
                Object selectEntryRowStr = formShowParameter.getCustomParam("selectEntryRows");
                List selectEntryRows = new ArrayList(10);
                if (!EmptyUtil.isEmpty((Object)selectEntryRowStr)) {
                    selectEntryRows = JSONArray.parseArray((String)selectEntryRowStr.toString(), Object.class);
                }
                ArrayList<DynamicObject> selectAgtEntryDo = new ArrayList<DynamicObject>();
                for (DynamicObject rowDO : entry) {
                    if (selectEntryRows.size() >= 1 && !selectEntryRows.contains(rowDO.getPkValue())) continue;
                    selectAgtEntryDo.add(rowDO);
                }
                boolean needEncrypVisable = PayInfoChgHelper.isNeedEncrypVisable((DynamicObject)bizBill);
                this.getModel().deleteEntryData("entrys");
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("actpayamt", new Object[0]).addField("recer", new Object[0]).addField("recerid", new Object[0]).addField("recername", new Object[0]).addField("payeetype", new Object[0]).addField("recacctbank", new Object[0]).addField("payeebankname", new Object[0]).addField("usage", new Object[0]).addField("sourceentryid", new Object[0]).addField("recprovince", new Object[0]).addField("reccity", new Object[0]).addField("recbanknumber", new Object[0]).addField("settletype", new Object[0]).addField("businesstype", new Object[0]);
                for (DynamicObject selectAgtEntry : selectAgtEntryDo) {
                    vs.addRow(new Object[]{needEncrypVisable ? new BigDecimal("0") : selectAgtEntry.getBigDecimal("e_amount"), EmptyUtil.isEmpty((Object)selectAgtEntry.get("payee")) ? "" : selectAgtEntry.getDynamicObject("payee").getString("name"), EmptyUtil.isEmpty((Object)selectAgtEntry.get("payee")) ? Integer.valueOf(0) : selectAgtEntry.getDynamicObject("payee").getPkValue(), selectAgtEntry.get("payeename"), bizBill.get("payeetype"), selectAgtEntry.get("payeeacctbank"), selectAgtEntry.get("payeebankname"), selectAgtEntry.get("e_remark"), selectAgtEntry.getPkValue(), selectAgtEntry.get("recprovince"), selectAgtEntry.get("reccity"), selectAgtEntry.get("payeebanknumber"), settletypeId, bizBill.get("businesstype")});
                }
                model.beginInit();
                model.batchCreateNewEntryRow("entrys", vs);
                model.endInit();
            }
            model.setValue("remark", (Object)changeCause);
            model.setValue("alterationuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyname;
        super.propertyChanged(e);
        switch (keyname = e.getProperty().getName()) {
            case "afterrecerbank": {
                DynamicObject newAfterBank = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int index = e.getChangeSet()[0].getRowIndex();
                if (newAfterBank != null) {
                    this.isSelectBankF7 = true;
                    this.getModel().setValue("afterrecerbankname", (Object)newAfterBank.getString("name"), index);
                    this.getModel().setValue("afterrecprovince", (Object)newAfterBank.getString("provincetxt"), index);
                    this.getModel().setValue("afterreccity", (Object)newAfterBank.getString("citytxt"), index);
                    this.getModel().setValue("afterrecbanknumber", (Object)newAfterBank.getString("union_number"), index);
                    break;
                }
                this.getModel().setValue("afterrecprovince", null);
                this.getModel().setValue("afterreccity", null);
                this.getModel().setValue("afterrecbanknumber", null);
                break;
            }
            case "afterrecerbankname": {
                if (this.isSelectBankF7) {
                    return;
                }
                String bankName = (String)e.getChangeSet()[0].getNewValue();
                QFilter qFilterName = new QFilter("name", "=", (Object)bankName);
                DynamicObject beBank = BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (QFilter[])new QFilter[]{qFilterName});
                if (beBank != null) {
                    this.getModel().setValue("afterrecerbank", (Object)beBank);
                    break;
                }
                this.getModel().setValue("afterrecerbank", null);
                this.getModel().setValue("afterrecprovince", null);
                this.getModel().setValue("afterreccity", null);
                this.getModel().setValue("afterrecbanknumber", null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean ischange;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (("save".equals(key) || "submit".equals(key)) && !(ischange = PayInfoChgHelper.payInfoChanged((DynamicObject)this.getModel().getDataEntity(true)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u4ed8\u4fe1\u606f\u65e0\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"RecInfoChgEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setAfterPayerAcctCashVisible(DynamicObjectCollection entrys) {
        boolean isShow = !EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) || !BaseDataHelper.isSettleTypeDcep((DynamicObject)((DynamicObject)entrys.get(0)).getDynamicObject("settletype"));
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"afterpayeracctcash"});
    }

    private void setPayerAcct() {
        String sourcebilltype = (String)this.getModel().getValue("sourcebilltype");
        Long sourcebillid = (Long)this.getModel().getValue("sourcebillid");
        DynamicObject bizBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)sourcebilltype);
        DynamicObject settletype = bizBill.getDynamicObject("settletype");
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settletype)) {
            Long acctCashId = EmptyUtil.isEmpty((DynamicObject)bizBill.getDynamicObject("payeracctcash")) ? 0L : bizBill.getDynamicObject("payeracctcash").getLong("id");
            this.getModel().setValue("payeracctcash", (Object)acctCashId, 0);
        } else {
            Long acctBankId = EmptyUtil.isEmpty((DynamicObject)bizBill.getDynamicObject("payeracctbank")) ? 0L : bizBill.getDynamicObject("payeracctbank").getLong("id");
            this.getModel().setValue("payeracctbank", (Object)acctBankId, 0);
        }
    }
}

