/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.corebil;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.xdb.util.Pair;
import kd.fi.cas.helper.CasHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.StringUtil;

public class CoreBillSettingEdit
extends AbstractBasePlugIn {
    private static final String[] CLERAN_OCCUPY_PROP = new String[]{"occupyshowobject", "occupycloud", "occupyappid", "occupyservicename", "occupymethodname"};
    private static final String[] CLERAN_BACK_PROP = new String[]{"backkdtxnumber", "backcloud", "backappid", "backservicename", "backmethodname"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"reqbillfieldprop", "reqbatchbillfieldprop", "reptag", "repbatchtag"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        if (isPreset) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("repparamname", new Object[0]);
        vs.addField("reptag", new Object[0]);
        vs.addField("repbatchtag", new Object[0]);
        vs.addRow(new Object[]{ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636eID", (String)"CoreBillSettingEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), "e_corebillid", "corebillid"});
        vs.addRow(new Object[]{ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7f16\u53f7", (String)"CoreBillSettingEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), "e_corebillno", "corebillno"});
        vs.addRow(new Object[]{ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u884cID", (String)"CoreBillSettingEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), "e_corebillentryid", null});
        model.batchCreateNewEntryRow("showrepentry", vs);
        model.endInit();
        this.getView().updateView("showrepentry");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        for (int i = 0; i < 3; ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"repparamname", "repqueryfield", "reptag", "repbatchtag"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey)) {
            boolean isWriteBack;
            boolean isClaimOccupy = (Boolean)this.getModel().getValue("claimoccupy");
            if (!isClaimOccupy) {
                this.clearTabInfo("occupytreeentry", CLERAN_OCCUPY_PROP);
            }
            if (!(isWriteBack = ((Boolean)this.getModel().getValue("writeback")).booleanValue())) {
                this.clearTabInfo("rectreeentry", CLERAN_BACK_PROP);
            }
        }
    }

    private void clearTabInfo(String entryProp, String[] cleranProp) {
        this.getModel().getEntryEntity(entryProp).clear();
        for (String prop : cleranProp) {
            this.getModel().setValue(prop, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("backaddprop".equalsIgnoreCase(opKey) || "occupyaddprop".equals(opKey)) {
            String prefix = this.getPreFix(opKey);
            DynamicObject showObject = (DynamicObject)this.getModel().getValue(prefix + "showobject");
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("entityId", showObject.getPkValue());
            params.put("$isBatch", Boolean.TRUE);
            params.put("$type", prefix + "treeentry");
            params.put("$ShowProperty", "REAL_ENTRIES");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("openapi_entity_property");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams(params);
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5bf9\u8c61\u5c5e\u6027", (String)"CoreBillSettingEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opKey));
            this.getView().showForm(showParameter);
        }
    }

    private String getPreFix(String opKey) {
        return "backaddprop".equalsIgnoreCase(opKey) ? "rec" : "occupy";
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "reqbillfieldprop": 
                case "reptag": {
                    String bizType = (String)this.getModel().getValue("biztype");
                    this.showBillInfo(key, bizType);
                    break;
                }
                case "reqbatchbillfieldprop": 
                case "repbatchtag": {
                    this.showBillInfo(key, "cas_batchclaim_info");
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String sourceFldKey = event.getActionId();
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (sourceFldKey) {
            case "reqbillfieldprop": {
                this.receiveSelectField((String)returnData, sourceFldKey, "reqbillfieldname", "showreqentity");
                break;
            }
            case "reqbatchbillfieldprop": {
                this.receiveSelectField((String)returnData, sourceFldKey, null, "showreqentity");
                break;
            }
            case "reptag": 
            case "repbatchtag": {
                this.receiveSelectField((String)returnData, sourceFldKey, null, "showrepentry");
                break;
            }
            case "backaddprop": 
            case "occupyaddprop": {
                this.addPropClosedCallBack(sourceFldKey, (Map)returnData);
            }
        }
    }

    private void showBillInfo(String key, String bizType) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)bizType);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludePKField(false);
        option.setIncludeBDRefProp(true);
        option.setSpecialTreatmentMulBDProp(false);
        option.setOnlyPhysicsField(false);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        this.showSelectFieldForm(treeNode, key);
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveSelectField(String returnPropName, String filedProp, String fieldName, String entryName) {
        if (!StringUtils.isBlank((CharSequence)returnPropName)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
            this.getModel().setValue(filedProp, (Object)returnPropName, rowIndex);
            if (fieldName != null) {
                String bizType = (String)this.getModel().getValue("biztype");
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)bizType);
                String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
                this.getModel().setValue(fieldName, (Object)fieldCaption, rowIndex);
            }
        }
    }

    private void addPropClosedCallBack(String sourceFldKey, Map<String, Object> returnData) {
        List dataList = (List)returnData.get("$data");
        String entryKey = (String)returnData.get("$type");
        this.addTreeEntryProps(sourceFldKey, entryKey, dataList);
    }

    private void addTreeEntryProps(String sourceFldKey, String entryKey, List<Map<String, Object>> dataList) {
        String prefix = this.getPreFix(sourceFldKey);
        DynamicObjectCollection entryList = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
        Set propSet = entryList.stream().map(it -> it.getString(prefix + "objpropname")).collect(Collectors.toSet());
        DynamicObjectType objectType = this.getModel().getEntryEntity(entryKey).getDynamicObjectType();
        HashMap<String, Pair<Long, Integer>> parentPid = new HashMap<String, Pair<Long, Integer>>();
        for (Map<String, Object> data : dataList) {
            Pair<Long, Integer> pair;
            String fullNumber = (String)data.get("full_number");
            if (propSet.contains(fullNumber) || (pair = this.getPid(prefix, entryKey, data, parentPid)) == null) continue;
            DynamicObject entry = new DynamicObject(objectType);
            entry.set(prefix + "paramtag", (Object)this.getParamName(fullNumber, (Integer)pair.getValue(), data));
            entry.set(prefix + "objpropname", (Object)fullNumber);
            String type = this.getParamType((String)data.get("data_type"));
            entry.set(prefix + "paramtype", (Object)type);
            entry.set(prefix + "paramdes", data.get("name"));
            entry.set("pid", pair.getKey());
            entry.set(prefix + "level", pair.getValue());
            this.getModel().createNewEntryRow(entryKey, entry);
        }
    }

    public String getParamType(String type) {
        switch (type) {
            case "ml_string": {
                return "String";
            }
            case "REF": {
                return "Long";
            }
        }
        return type;
    }

    public String getParamName(String name, int level, Map<String, Object> data) {
        String s;
        if (name == null) {
            return null;
        }
        String[] nums = name.split("\\.");
        if (level < 2) {
            return name.replace('.', '_');
        }
        Object obj = data.get("parent_data_type");
        int from = 0;
        if (obj != null && (s = CoreBillSettingEdit.dealS(obj)) != null) {
            String[] dataType = s.split("@");
            String ppDataType = dataType[0];
            String parentDataType = dataType[1];
            from = "Entries".equals(ppDataType) && ("REF".equals(parentDataType) || "ml_string".equals(parentDataType)) ? nums.length - 2 : ("ml_string".equals(parentDataType) ? nums.length - 3 : ("Entries".equals(parentDataType) ? nums.length - 1 : level - 1));
        }
        return String.join((CharSequence)"_", Arrays.copyOfRange(nums, from, nums.length));
    }

    private Pair<Long, Integer> getPid(String prefix, String entryKey, Map<String, Object> map, Map<String, Pair<Long, Integer>> parentPid) {
        String fullNumber = (String)map.get("full_number");
        String obj = CoreBillSettingEdit.dealS(map.get("parent_data_type"));
        if (obj != null) {
            String parentAllType;
            String[] nums;
            String parentDataType;
            Pair<String, String> dataType = CoreBillSettingEdit.getParentDataType(obj);
            String ppDataType = (String)dataType.getKey();
            if (CoreBillSettingEdit.isFirstLevel(ppDataType, parentDataType = (String)dataType.getValue(), nums = fullNumber.split("\\."), parentAllType = CoreBillSettingEdit.dealS(map.get("parent_all_type")))) {
                return new Pair((Object)0L, (Object)1);
            }
            String parentNum = fullNumber.substring(0, fullNumber.lastIndexOf(46));
            Pair<Long, Integer> pair = parentPid.get(parentNum);
            if (pair != null) {
                return pair;
            }
            Supplier<Stream> supplier = () -> this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey).stream();
            if ("Entries".equals(parentDataType)) {
                Optional<DynamicObject> optional = supplier.get().filter(it -> it.getString(prefix + "objpropname").equals(parentNum)).findFirst();
                if (optional.isPresent()) {
                    pair = new Pair((Object)optional.get().getLong("id"), (Object)(optional.get().getInt(prefix + "level") + 1));
                    parentPid.put(parentNum, pair);
                    return pair;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u4e0a\u7ea7\u5c5e\u6027 %1$s\u3002", (String)"CoreBillSettingEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[]{parentNum}));
            }
            int dotCount = CoreBillSettingEdit.getDotCount(ppDataType, parentDataType, parentAllType);
            String upNum = String.join((CharSequence)".", Arrays.copyOfRange(nums, 0, nums.length - dotCount));
            pair = parentPid.get(upNum);
            if (pair != null) {
                return pair;
            }
            Optional<DynamicObject> optional = supplier.get().filter(it -> it.getString(prefix + "objpropname").equals(upNum)).findFirst();
            if (optional.isPresent()) {
                DynamicObject up = optional.get();
                pair = "Entries".equals(up.getString(prefix + "paramtype")) ? new Pair((Object)up.getLong("id"), (Object)(up.getInt(prefix + "level") + 1)) : new Pair((Object)up.getLong("pid"), (Object)up.getInt(prefix + "level"));
                parentPid.put(upNum, pair);
                return pair;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u4e0a\u7ea7\u5c5e\u6027 %1$s\u3002", (String)"CoreBillSettingEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[]{upNum}));
        }
        return null;
    }

    public static int getDotCount(String ppDataType, String parentDataType, String parentAllType) {
        int dotCount;
        if ("ml_string".equals(parentDataType)) {
            dotCount = "REF".equals(ppDataType) ? 3 : 2;
        } else if ("REF".equals(ppDataType) && "REF".equals(parentDataType)) {
            dotCount = StringUtil.countMatches((CharSequence)parentAllType, (char)'@');
            if (parentAllType.startsWith("@Entries@Entries")) {
                --dotCount;
            }
        } else {
            dotCount = "REF".equals(parentDataType) ? 2 : 1;
        }
        return dotCount;
    }

    public static boolean isFirstLevel(String ppDataType, String parentDataType, String[] nums, String parentAllType) {
        if (nums.length == 1) {
            return true;
        }
        List list = Arrays.stream(parentAllType.split("@")).filter(CasHelper::isNotEmpty).distinct().collect(Collectors.toList());
        if (list.size() == 1 && "REF".equals(list.get(0))) {
            return true;
        }
        if ("REF".equals(parentDataType) || "ml_string".equals(parentDataType)) {
            if (nums.length == 2) {
                return true;
            }
            return nums.length == 3 && ("REF".equals(ppDataType) || "ml_string".equals(ppDataType));
        }
        return false;
    }

    public static Pair<String, String> getParentDataType(String parentDataType) {
        String[] dataType = parentDataType.split("@");
        return new Pair((Object)dataType[0], (Object)dataType[1]);
    }

    public static String dealS(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }
}

