/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.ebext;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FieldTip;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.utils.LoginUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.EncryptUtils;
import kd.bos.util.PasswordEncryptUtil;
import kd.fi.cas.helper.ebext.BankPasswordHelper;

public class BankResetPasswordPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button button = (Button)source;
            String key = button.getKey();
            RequestContext requestContext = RequestContext.get();
            Long userId = Long.valueOf(requestContext.getUserId());
            if ("btnok".equals(key)) {
                this.resetPassword(userId);
            }
        }
    }

    private boolean verifyPassword(Long userId, Object loginPassWd) {
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        if (StringUtils.isNotBlank((Object)loginPassWd)) {
            String dbPsw;
            String oldPswStr = EncryptUtils.encryptPSW((String)loginPassWd.toString());
            return oldPswStr.equals(dbPsw = user.getString("password")) || PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt((String)String.valueOf(userId)), (String)loginPassWd.toString(), (String)dbPsw);
        }
        return false;
    }

    private void resetPassword(Long userId) {
        Object loginPassWd = this.getModel().getValue("loginpasswd");
        if (!this.verifyPassword(userId, loginPassWd)) {
            this.showFieldTips("loginpasswd", ResManager.loadKDString((String)"\u767b\u5f55\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BankPasswordSettingPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), false);
            this.showFieldTips("newpsw", "", true);
            this.showFieldTips("newpswrepead", "", true);
            return;
        }
        Object newPsw = this.getModel().getValue("newpsw");
        Object newPswRepead = this.getModel().getValue("newpswrepead");
        if (StringUtils.isNotBlank((Object)newPsw)) {
            String pattern = "\\s{1,}";
            String strNewPsw = newPsw.toString();
            String[] split = strNewPsw.split(pattern);
            if (split.length <= 1 && strNewPsw.equals(strNewPsw.trim())) {
                pattern = "[^\\x00-\\xff]{1,}";
                if (Pattern.matches(pattern, strNewPsw)) {
                    this.showFieldTips("newpsw", ResManager.loadKDString((String)"\u4e0d\u80fd\u542b\u6709\u7a7a\u683c\uff0c\u4e2d\u6587\uff0c\u975e\u6cd5\u7b26\u53f7", (String)"BankPasswordSettingPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), false);
                    this.showFieldTips("newpswrepead", "", true);
                    this.showFieldTips("loginpasswd", "", true);
                } else if (!StringUtils.isNotBlank((Object)newPswRepead)) {
                    this.showFieldTips("newpswrepead", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5bc6\u7801", (String)"BankPasswordSettingPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), false);
                    this.showFieldTips("newpsw", "", true);
                    this.showFieldTips("loginpasswd", "", true);
                } else if (StringUtils.isNotBlank((Object)newPswRepead) && !StringUtils.equals((CharSequence)strNewPsw, (CharSequence)newPswRepead.toString())) {
                    this.showFieldTips("newpswrepead", ResManager.loadKDString((String)"\u4e24\u6b21\u8f93\u5165\u7684\u65b0\u5bc6\u7801\u4e0d\u76f8\u540c", (String)"BankPasswordSettingPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), false);
                    this.showFieldTips("newpsw", "", true);
                    this.showFieldTips("loginpasswd", "", true);
                } else if (newPsw.toString().length() < 6 || newPsw.toString().length() > 20) {
                    this.showFieldTips("newpsw", ResManager.loadKDString((String)"\u5bc6\u7801\u957f\u5ea6\u5e94\u4e3a6~20\u4f4d\u3002", (String)"BankPasswordSettingPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), false);
                    this.showFieldTips("newpswrepead", "", true);
                    this.showFieldTips("loginpasswd", "", true);
                } else {
                    MainEntityType bankEtpPwdEntityType = EntityMetadataCache.getDataEntityType((String)"cas_banketppwd");
                    DynamicObject bankEtpPwd = new DynamicObject((DynamicObjectType)bankEtpPwdEntityType);
                    String newPswStr = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)strNewPsw);
                    DynamicObject[] bankEtpPwdObjs = BankPasswordHelper.getBankPasswordById((Long)userId);
                    bankEtpPwd.set("id", bankEtpPwdObjs[0].getPkValue());
                    bankEtpPwd.set("user", (Object)userId);
                    bankEtpPwd.set("password", (Object)newPswStr);
                    bankEtpPwd.set("modifytime", (Object)new Date());
                    bankEtpPwd.set("modifierid", (Object)userId);
                    SaveServiceHelper.update((DynamicObject)bankEtpPwd);
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("resetsuccess", "1");
                    this.getView().returnDataToParent(resultMap);
                    this.getView().close();
                }
            } else {
                this.showFieldTips("newpsw", ResManager.loadKDString((String)"\u4e0d\u80fd\u542b\u6709\u7a7a\u683c\uff0c\u4e2d\u6587\uff0c\u975e\u6cd5\u7b26\u53f7", (String)"BankPasswordSettingPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), false);
                this.showFieldTips("newpswrepead", "", true);
            }
        } else {
            this.showFieldTips("newpsw", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5bc6\u7801", (String)"BankPasswordSettingPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), false);
            this.showFieldTips("newpswrepead", "", true);
        }
    }

    private void showFieldTips(String field, String tips, boolean isHidden) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(field);
        LocaleString ls = new LocaleString(tips);
        fieldTip.setTip(ls.getLocaleValue());
        fieldTip.setSuccess(isHidden);
        this.getView().showFieldTip(fieldTip);
    }
}

