/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.er.writeback.plugin.agentpay.service;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.cas.formplugin.er.writeback.plugin.agentpay.service.AbstractWriteBackService;

public class TripReimWriteBackService
extends AbstractWriteBackService {
    @Override
    public void addKeys(List<String> keys) {
        super.addKeys(keys);
        keys.add("orireceiveamount");
        keys.add("payamount");
        keys.add("balanceamount");
        keys.add("notpayamount");
    }

    public TripReimWriteBackService(String opType) {
        this.opType = opType;
    }

    @Override
    public boolean validatorBuildAmount(BigDecimal totalBuildAmount, DynamicObject sourceBill) {
        return totalBuildAmount.compareTo(sourceBill.getBigDecimal("orireceiveamount")) <= 0;
    }

    @Override
    public void writeBackEntryAmount(DynamicObject sourceBill, DynamicObject targetBill) {
        super.writeBackEntryAmount(sourceBill, targetBill);
    }

    @Override
    public void writeBackBillAmount(DynamicObject sourceBill) {
        super.writeBackBillAmount(sourceBill);
        BigDecimal billPayedAmount = BigDecimal.ZERO;
        BigDecimal notPayAmount = BigDecimal.ZERO;
        DynamicObjectCollection coll = ((DynamicObject)sourceBill.getParent()).getDynamicObjectCollection("accountentry");
        for (DynamicObject dyObject : coll) {
            if (sourceBill.getPkValue().toString().equals(dyObject.getPkValue().toString())) {
                billPayedAmount = billPayedAmount.add(sourceBill.getBigDecimal("accpayedamount"));
                notPayAmount = notPayAmount.add(sourceBill.getBigDecimal("accnotpayamount"));
                continue;
            }
            billPayedAmount = billPayedAmount.add(dyObject.getBigDecimal("accpayedamount"));
            notPayAmount = notPayAmount.add(dyObject.getBigDecimal("accnotpayamount"));
        }
        DynamicObject sourceParentBill = (DynamicObject)sourceBill.getParent();
        sourceParentBill.set("payamount", (Object)billPayedAmount);
        sourceParentBill.set("balanceamount", (Object)billPayedAmount);
        sourceParentBill.set("notpayamount", (Object)notPayAmount);
    }
}

